/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DigestMD5 {
    private PrintStream debugout;
    private MessageDigest md5;
    private String uri;
    private String clientResponse;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestMD5(PrintStream debugout) {
        this.debugout = debugout;
        if (debugout != null) {
            debugout.println("DEBUG DIGEST-MD5: Loaded");
        }
    }

    public byte[] authClient(String host, String user, String passwd, String realm, String serverChallenge) throws IOException {
        SecureRandom random;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BASE64EncoderStream b64os = new BASE64EncoderStream((OutputStream)bos, Integer.MAX_VALUE);
        try {
            random = new SecureRandom();
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            if (this.debugout != null) {
                this.debugout.println("DEBUG DIGEST-MD5: " + ex);
            }
            throw new IOException(ex.toString());
        }
        StringBuffer result = new StringBuffer();
        this.uri = "smtp/" + host;
        String nc = "00000001";
        String qop = "auth";
        byte[] bytes = new byte[32];
        if (this.debugout != null) {
            this.debugout.println("DEBUG DIGEST-MD5: Begin authentication ...");
        }
        Hashtable map = this.tokenize(serverChallenge);
        if (realm == null) {
            String text = (String)map.get("realm");
            realm = text != null ? new StringTokenizer(text, ",").nextToken() : host;
        }
        String nonce = (String)map.get("nonce");
        random.nextBytes(bytes);
        b64os.write(bytes);
        b64os.flush();
        String cnonce = bos.toString();
        bos.reset();
        this.md5.update(this.md5.digest(ASCIIUtility.getBytes((String)(user + ":" + realm + ":" + passwd))));
        this.md5.update(ASCIIUtility.getBytes((String)(":" + nonce + ":" + cnonce)));
        this.clientResponse = DigestMD5.toHex(this.md5.digest()) + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":";
        this.md5.update(ASCIIUtility.getBytes((String)("AUTHENTICATE:" + this.uri)));
        this.md5.update(ASCIIUtility.getBytes((String)(this.clientResponse + DigestMD5.toHex(this.md5.digest()))));
        result.append("username=\"" + user + "\"");
        result.append(",realm=\"" + realm + "\"");
        result.append(",qop=" + qop);
        result.append(",nc=" + nc);
        result.append(",nonce=\"" + nonce + "\"");
        result.append(",cnonce=\"" + cnonce + "\"");
        result.append(",digest-uri=\"" + this.uri + "\"");
        result.append(",response=" + DigestMD5.toHex(this.md5.digest()));
        if (this.debugout != null) {
            this.debugout.println("DEBUG DIGEST-MD5: Response => " + result.toString());
        }
        b64os.write(ASCIIUtility.getBytes((String)result.toString()));
        b64os.flush();
        return bos.toByteArray();
    }

    public boolean authServer(String serverResponse) throws IOException {
        Hashtable map = this.tokenize(serverResponse);
        this.md5.update(ASCIIUtility.getBytes((String)(":" + this.uri)));
        this.md5.update(ASCIIUtility.getBytes((String)(this.clientResponse + DigestMD5.toHex(this.md5.digest()))));
        String text = DigestMD5.toHex(this.md5.digest());
        if (!text.equals((String)map.get("rspauth"))) {
            if (this.debugout != null) {
                this.debugout.println("DEBUG DIGEST-MD5: Expected => rspauth=" + text);
            }
            return false;
        }
        return true;
    }

    private Hashtable tokenize(String serverResponse) throws IOException {
        int ttype;
        Hashtable<String, String> map = new Hashtable<String, String>();
        byte[] bytes = serverResponse.getBytes();
        String key = null;
        StreamTokenizer tokens = new StreamTokenizer(new InputStreamReader((InputStream)new BASE64DecoderStream((InputStream)new ByteArrayInputStream(bytes, 4, bytes.length - 4))));
        tokens.ordinaryChars(48, 57);
        tokens.wordChars(48, 57);
        while ((ttype = tokens.nextToken()) != -1) {
            switch (ttype) {
                case -3: {
                    if (key == null) {
                        key = tokens.sval;
                        break;
                    }
                }
                case 34: {
                    if (this.debugout != null) {
                        this.debugout.println("DEBUG DIGEST-MD5: Received => " + key + "='" + tokens.sval + "'");
                    }
                    if (map.containsKey(key)) {
                        map.put(key, map.get(key) + "," + tokens.sval);
                    } else {
                        map.put(key, tokens.sval);
                    }
                    key = null;
                }
            }
        }
        return map;
    }

    private static String toHex(byte[] bytes) {
        char[] result = new char[bytes.length * 2];
        int i = 0;
        for (int index = 0; index < bytes.length; ++index) {
            int temp = bytes[index] & 0xFF;
            result[i++] = digits[temp >> 4];
            result[i++] = digits[temp & 0xF];
        }
        return new String(result);
    }
}

