/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.nalogPrijem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.magacin.gui.PzDialogNalogMagacinu;
import rs.pezar.magacin.gui.util.PzMagacinUtil;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class DodavanjeNaloga
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzNumericOnlyTextField tfKalkulacija;
    private JLabel lblKalkulacija;
    private PzButton btnPotvrdi;
    private PzDialog thisDialog;
    private Radnajedinica rj;
    private Nalogprijem nalogprijem;
    private boolean akcija = false;
    private String parameter;

    public DodavanjeNaloga(PzDialog dialog) {
        super(dialog);
        this.thisDialog = this;
        this.parameter = (String)this.getSession().getParameter("dokument");
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equals("kalkulacija")) {
            this.lblKalkulacija.setText("Br. kalkulacije");
        } else if (this.parameter.equals("prijemnica")) {
            this.lblKalkulacija.setText("Br. prijemnice");
        } else if (this.parameter.equals("interniNalog")) {
            this.lblKalkulacija.setText("Br. internog naloga");
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("DODAVANJE NALOGA");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{38, 41, 68, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.0, 0.0, 0.0};
            pnlGlavniLayout.columnWidths = new int[]{10, 7, 118, 175, 41, 10};
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 6, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{58, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{16, 142, 50, 73, 126, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.lblKalkulacija = new JLabel();
            this.pnlFields.add((Component)this.lblKalkulacija, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.lblKalkulacija.setName("lblKalkulacija");
            this.tfKalkulacija = new PzNumericOnlyTextField();
            this.pnlFields.add((Component)this.tfKalkulacija, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfKalkulacija.setVal((Object)0);
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(125, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setPreferredSize(new Dimension(440, 198));
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            this.akcija = true;
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    PzDokument dok = DodavanjeNaloga.this.getDokument(em);
                    if (dok == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)DodavanjeNaloga.this), (String)"Nama podataka za listanje naloga magacinu da primi robu!");
                        DodavanjeNaloga.this.tfKalkulacija.requestFocus();
                        return false;
                    }
                    DodavanjeNaloga.this.nalogprijem = rs.pezar.util.PzMagacinUtil.createNalogPrijem((PzDokument)dok, null, (EntityManager)em);
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            if (DodavanjeNaloga.this.nalogprijem != null) {
                                PzMagacinUtil.showReports(DodavanjeNaloga.this, DodavanjeNaloga.this.nalogprijem);
                            }
                            DodavanjeNaloga.this.dispose();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)DodavanjeNaloga.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                            em.close();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        try {
            if (this.akcija) {
                ((PzDialogNalogMagacinu)((Object)this.getParent())).initializeTable(true);
            }
            super.thisWindowClosing(evt);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public PzDokument getDokument(EntityManager em) {
        Kalkulacija rez = null;
        Query q = null;
        String upit = "";
        if (this.parameter.equals("kalkulacija")) {
            upit = "SELECT k FROM Kalkulacija k where k.radnajedinica=:rj and k.rBroj=:rbroj and k.arhiviran=1 and k.storno=0 and k.tip='" + TipDokumentConfig.get().KALKULACIJA + "'";
        } else if (this.parameter.equals("interniNalog")) {
            upit = "SELECT n FROM Interniracun n where n.izlaznaRJ=:rj and n.rBroj=:rbroj and n.arhiviran=1 and n.storno=0 and n.tip='" + TipDokumentConfig.get().INTERNI_NALOG + "'";
        } else if (this.parameter.equals("prijemnica")) {
            upit = "SELECT k FROM Konsignacija k where k.radnajedinica=:rj and k.rBroj=:rbroj and k.arhiviran=1 and k.storno=0 and k.tip ='KONSIGNACIJA_PRIJEM_V'";
        }
        q = em.createQuery(upit);
        q.setParameter("rj", (Object)this.rj);
        q.setParameter("rbroj", (Object)this.tfKalkulacija.getIntVal());
        try {
            if (this.parameter.equals("kalkulacija")) {
                Kalkulacija dok;
                rez = dok = (Kalkulacija)q.getSingleResult();
            } else if (this.parameter.equals("prijemnica")) {
                Konsignacija kons = (Konsignacija)q.getSingleResult();
                rez = kons;
            } else if (this.parameter.equals("interniNalog")) {
                Interniracun dok = (Interniracun)q.getSingleResult();
                rez = dok;
            }
        }
        catch (Exception exception) {
            rez = null;
        }
        return rez;
    }

    public boolean shouldBeShown() {
        this.rj = this.parameter.equals("prijemnica") ? PzDialogRJ.getRJ((PzDialog)this.thisDialog, (Character[])new Character[]{Character.valueOf('T')}) : PzDialogRJ.getRJ((PzDialog)this.thisDialog, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("VR".charAt(0)), Character.valueOf("VS".charAt(0)), Character.valueOf("T".charAt(0))});
        return this.rj != null;
    }

    public static Object getGUIBuilderInstance() {
        return new DodavanjeNaloga(Boolean.FALSE);
    }

    public DodavanjeNaloga(Boolean initGUI) {
    }
}

