/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.ArtikalfakturaPK;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Artikalobracunkonsignacije;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.ArtikalopstidokumentPK;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Obracunkonsignacije;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.ProizvodfiskalniracunPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.konsignacije.gui.PzDialogDokumentiObracun;
import rs.pezar.konsignacije.gui.PzDialogIzborProvizije;
import rs.pezar.konsignacije.gui.PzKonsignacijaUtility;
import rs.pezar.konsignacije.gui.obracun.PzDialogIzborNacinaStampe;
import rs.pezar.konsignacije.gui.obracun.PzDialogIzmenaProvizije;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzDialogObracunKonsignacije
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzPanel mainPanel;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnSelektiranje;
    private PzToolBarIcon icnIzmena;
    private PzDoubleField iznosField;
    private JLabel jLabel2;
    private PzDoubleField provizijaField;
    private PzDoubleField zaPlacanjeField;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Obracunkonsignacije obracunKonsignacije;
    private boolean izmena;
    private PzToolBarIcon icnProbnoListanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private Stanje stanjeIzlaz;
    private List<Artikalkonsignacija> artkonsigs;
    private PzDialogDokumentiObracun parent;
    private Brojacrj brojac;
    private double iznosProvizije;
    private Date krajnjiDatum;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogObracunKonsignacije inst = new PzDialogObracunKonsignacije(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogObracunKonsignacije(JFrame frame) {
        super(frame);
        this.obracunKonsignacije = new Obracunkonsignacije();
    }

    public PzDialogObracunKonsignacije(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.parent = (PzDialogDokumentiObracun)parent;
        this.tableInterni = (PzTable)data1;
        this.obracunKonsignacije = izmena ? (Obracunkonsignacije)this.tableInterni.getSelectedEntity() : new Obracunkonsignacije();
        this.izmena = izmena;
        this.initGUI();
        if (izmena) {
            this.kreirajTabelu();
        }
        this.refresh();
        this.paintPanel();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogObracunKonsignacije.this.brDok.setText(String.valueOf(PzDialogObracunKonsignacije.this.table.getRowCount()));
            }
        });
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            if (this.izmena) {
                this.setTitle("PREDLOG OBRA\u010cUNA ZA PRODATU ROBU SA KONSIGNACIJE " + this.obracunKonsignacije.getRadnajedinica().getId().getOznRj() + "(" + this.obracunKonsignacije.getRadnajedinica().getgTip() + ") " + this.obracunKonsignacije.getRadnajedinica().getNaziv());
            }
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{100, 48, 110, 20};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnSelektiranje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnSelektiranje);
            this.icnSelektiranje.setText("Selektiranje|(F2)");
            this.icnSelektiranje.setPreferredSize(new Dimension(78, 90));
            this.icnSelektiranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/product_add.png")));
            this.icnSelektiranje.setActionCommand("Selektiranje");
            this.icnSelektiranje.addActionListener((ActionListener)((Object)this));
            this.icnSelektiranje.setShortcut("f2");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena provizije|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/product_edit.png")));
            this.icnIzmena.setPreferredSize(new Dimension(84, 90));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnProbnoListanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnProbnoListanje);
            this.icnProbnoListanje.setText("Probno|listanje(F4)");
            this.icnProbnoListanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/presentation_chart.png")));
            this.icnProbnoListanje.setActionCommand("Probnolistanje");
            this.icnProbnoListanje.addActionListener((ActionListener)((Object)this));
            this.icnProbnoListanje.setShortcut("f4");
            this.icnProbnoListanje.setPreferredSize(new Dimension(80, 80));
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/address_book.png")));
            this.icnArhiva.setPreferredSize(new Dimension(75, 90));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{14.0, 0.0, 14.0};
            pzPanelNLayout.rowHeights = new int[]{7, 25, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{57, 150, 10, 63, 150, 10, 78, 150, 20};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Iznos:");
            this.iznosField = new PzDoubleField();
            this.pzPanelN.add((Component)this.iznosField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.iznosField.setVal((Object)this.obracunKonsignacije.getIznos());
            this.iznosField.setFocusable(false);
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("- provizija:");
            this.provizijaField = new PzDoubleField();
            this.pzPanelN.add((Component)this.provizijaField, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.provizijaField.setVal((Object)this.obracunKonsignacije.getProvizija());
            this.provizijaField.setFocusable(false);
            this.jLabel3 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel3, (Object)new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText("= za pla\u0107anje:");
            this.zaPlacanjeField = new PzDoubleField();
            this.pzPanelN.add((Component)this.zaPlacanjeField, (Object)new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.zaPlacanjeField.setVal((Object)this.obracunKonsignacije.getZaPlacanje());
            this.zaPlacanjeField.setFocusable(false);
            this.pzPanelC = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            pzPanelCLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.rowHeights = new int[]{7, 7, 7, 7};
            pzPanelCLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setMinimumSize(new Dimension(900, 700));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            Class<PzDialogIzmenaProvizije> action = PzDialogIzmenaProvizije.class;
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            this.getSession().putParameter("table", (Object)this.table);
            this.getSession().putParameter("obracun", (Object)this.obracunKonsignacije);
            if (actionCommand.equals("Izmena")) {
                if (this.table.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku.", "Obavestenje", 1);
                    return;
                }
                Artikalobracunkonsignacije artob = (Artikalobracunkonsignacije)this.table.getSelectedEntity();
                artob.getProvizija();
                this.getSession().putParameter("stavka", (Object)artob);
                action = PzDialogIzmenaProvizije.class;
                this.showDialog(action);
                Artikalobracunkonsignacije cfr_ignored_0 = (Artikalobracunkonsignacije)this.table.getSelectedEntity();
                if (this.table.isRowChecked(this.table.getSelectedRow())) {
                    this.provizijaField.setVal((Object)this.obracunKonsignacije.getProvizija());
                    this.zaPlacanjeField.setVal((Object)(this.iznosField.getVal() - this.provizijaField.getVal()));
                }
                this.tableInterni.refreshData();
                return;
            }
            if (actionCommand.equals("Selektiranje")) {
                if (this.table.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku.", "Obavestenje", 1);
                    return;
                }
                this.table.switchIt();
                return;
            }
            if (actionCommand.equals("Probnolistanje")) {
                Vector artikli = (Vector)this.table.getCheckedEntities();
                if (artikli.size() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije bilo selektiranih slogova za obradu.", "Obavestenje", 1);
                    return;
                }
                Vector<Object> lista = new Vector<Object>();
                lista.add(PzFirma.getFirma());
                lista.add(this.obracunKonsignacije);
                lista.add(this.ulaznaRJ);
                HashMap<String, Boolean> hashmap = PzDialogIzborNacinaStampe.getIzbor((PzDialog)this);
                if (hashmap == null) {
                    return;
                }
                String putanjaReporta = "";
                if (hashmap.get("nasa").booleanValue()) {
                    putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_nasasifra.jasper";
                } else if (hashmap.get("tudja").booleanValue()) {
                    putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_tudjasifra.jasper";
                } else if (hashmap.get("obadvije").booleanValue()) {
                    putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_obesifre.jasper";
                }
                Vector<Artikalobracunkonsignacije> artikalobracunkonsignacije = this.sumirajIsteStavke(artikli);
                PzDataSourceExtended ds = new PzDataSourceExtended(lista, artikalobracunkonsignacije);
                ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
                String title = "OBRA\u010cUN broj PROBNI OBRA\u010cUN";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("title", title);
                PzReportManager.createAndShowReport((PzDialog)this.parent, (JRDataSource)ds, (String)putanjaReporta, params, (String)"Obra\u010dun konsignacije");
                return;
            }
            if (!actionCommand.equals("Arhiviranje")) return;
            Vector artikli = (Vector)this.table.getCheckedEntities();
            if (artikli.size() == 0) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije bilo selektiranih slogova za obradu.", "Obavestenje", 1);
                return;
            }
            try {
                if (this.obracunKonsignacije.getRadnajedinica().getgTip().equals("T") || this.obracunKonsignacije.getRadnajedinica().getgTip().equals("V")) {
                    this.arhivirajVeleprodaja();
                    return;
                }
                if (!this.obracunKonsignacije.getRadnajedinica().getgTip().equals("E")) return;
                this.arhivirajMaloprodaja();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            return;
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        this.ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"T", "ET"});
        if (this.ulaznaRJ != null) {
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery("SELECT e.idDok, e.userPoc.pzusername FROM Obracunkonsignacije e WHERE e.radnajedinica =:rj AND e.arhiviran=0 AND e.tip=:tip1");
            q.setParameter("rj", (Object)this.ulaznaRJ);
            q.setParameter("tip1", (Object)"OBRACUN_TUDJA_KONSIGNACIJA");
            Vector obracuni = (Vector)q.getResultList();
            if (obracuni.size() != 0) {
                String ime = (String)((Object[])obracuni.firstElement())[1];
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Ve\u0107 postoji obra\u010dun u pripremi za radnu jedinicu " + this.ulaznaRJ.getPunNaziv() + " kod usera " + ime, "Obave\u0161tenje", 1);
                return false;
            }
            HashMap<String, Object> hm = PzDialogIzborProvizije.getIzbor((PzDialog)this);
            if (hm != null) {
                Vector<Object[]> stavkeObracunaVeleprodaje = null;
                HashMap<String, Vector<Object[]>> hmStavke = null;
                if (this.ulaznaRJ.getgTip().equals("T") || this.ulaznaRJ.getgTip().equals("V")) {
                    stavkeObracunaVeleprodaje = this.pokupiStavkeVeleprodaja(this.ulaznaRJ, (Date)hm.get("datum"), em);
                    if (stavkeObracunaVeleprodaje.size() == 0) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Ne postoje podaci za izradu obra\u010duna.", "Obave\u0161tenje", 1);
                        return false;
                    }
                } else if (this.ulaznaRJ.getgTip().equals("E")) {
                    hmStavke = this.pokupiStavkeMaloprodaja(this.ulaznaRJ, (Date)hm.get("datum"), em);
                    Vector<Object[]> stavkeSaFaktura = hmStavke.get("stavke1");
                    Vector<Object[]> stavkeSaFiskalnihRacuna = hmStavke.get("stavke2");
                    Vector<Object[]> stavkeSaFiskalnihIzvjestaja = hmStavke.get("stavke3");
                    if (!(stavkeSaFaktura != null && stavkeSaFaktura.size() != 0 || stavkeSaFiskalnihRacuna != null && stavkeSaFiskalnihRacuna.size() != 0 || stavkeSaFiskalnihIzvjestaja != null && stavkeSaFiskalnihIzvjestaja.size() != 0)) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Ne postoje podaci za izradu obra\u010duna.", "Obave\u0161tenje", 1);
                        return false;
                    }
                }
                result = true;
                this.setTitle("PREDLOG OBRA\u010cUNA ZA PRODATU ROBU SA KONSIGNACIJE " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
                this.krajnjiDatum = (Date)hm.get("datum");
                try {
                    try {
                        if (this.obracunKonsignacije == null) {
                            this.obracunKonsignacije = new Obracunkonsignacije();
                        }
                        this.obracunKonsignacije.setStorno(0);
                        this.obracunKonsignacije.setArhiviran((short)0);
                        this.obracunKonsignacije.setTip("OBRACUN_TUDJA_KONSIGNACIJA");
                        em.getTransaction().begin();
                        this.obracunKonsignacije.setRadnajedinica(this.ulaznaRJ);
                        this.obracunKonsignacije.setDatum(new Date(new java.util.Date().getTime()));
                        this.obracunKonsignacije.setProknjizen((short)0);
                        this.obracunKonsignacije.setProcenatProvizije(((Double)hm.get("provizija")).doubleValue());
                        this.obracunKonsignacije.setRjUlaz(this.ulaznaRJ.getPunNaziv());
                        this.obracunKonsignacije.setIznos(new BigDecimal(0));
                        this.obracunKonsignacije.setProvizija(new BigDecimal(0));
                        this.obracunKonsignacije.setZaPlacanje(new BigDecimal(0));
                        this.obracunKonsignacije.setKrajnjiDatum((Date)hm.get("datum"));
                        PzDokumentManager.getInstance().snimiDokument((PzDokument)this.obracunKonsignacije, true, null, em);
                        if (this.ulaznaRJ.getgTip().equals("T") || this.ulaznaRJ.getgTip().equals("V")) {
                            this.popuniDokumentStavkamaVeleprodaja(stavkeObracunaVeleprodaje, em);
                        } else if (this.ulaznaRJ.getgTip().equals("E")) {
                            this.popuniDokumentStavkamaMaloprodaja(hmStavke, em);
                        }
                        em.merge((Object)this.obracunKonsignacije);
                        em.getTransaction().commit();
                        this.tableInterni.insert((PzEntity)this.obracunKonsignacije, false);
                        this.kreirajTabelu();
                    }
                    catch (Exception e) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                        em.close();
                    }
                }
                finally {
                    em.close();
                }
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogObracunKonsignacije(Boolean.FALSE);
    }

    public PzDialogObracunKonsignacije(Boolean initGUI) {
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }

    private Vector<Object[]> pokupiStavkeVeleprodaja(Radnajedinica rj, Date krajnjidatum, EntityManager em) {
        Query q = em.createQuery("SELECT e.id.sfrProizvod, e.kolicina, e.cena, e.faktura.oznDokumenta, e.faktura.komitent.sfrKomitent, e.faktura.datPrometa, e.naziv, e.jm, e.faktura.idDok, e.id.rBroj, e.bliziOpis, e.dobSifra, e.faktura.storno FROM Artikalfaktura e WHERE e.faktura.datPrometa <=:dat1 AND e.indk=0 AND (e.faktura.tip=:tip1 OR e.faktura.tip=:tip2) AND e.faktura.radnajedinica=:rj AND e.faktura.arhiviran=1");
        q.setParameter("dat1", (Object)krajnjidatum);
        q.setParameter("tip1", (Object)"FAKTURA");
        q.setParameter("tip2", (Object)"PRENOSNICA_SA_KONSIGNACIJE");
        q.setParameter("rj", (Object)rj);
        Vector stavke = (Vector)q.getResultList();
        return stavke;
    }

    private HashMap<String, Vector<Object[]>> pokupiStavkeMaloprodaja(Radnajedinica rj, Date krajnjidatum, EntityManager em) {
        HashMap<String, Vector<Object[]>> hm = new HashMap<String, Vector<Object[]>>();
        Query q1 = em.createQuery("SELECT e.id.sfrProizvod, e.kolicina, e.cena, e.faktura.oznDokumenta, e.faktura.komitent.sfrKomitent, e.faktura.datPrometa, e.naziv, e.jm, e.faktura.idDok, e.id.rBroj, e.bliziOpis, e.dobSifra, e.faktura.storno, t.stopa FROM Artikalfaktura e, Aftaksa t WHERE e.id.sfrProizvod=t.id.sfrProizvod AND e.id.idDok=t.id.idDok AND e.id.rBroj=t.id.rBroj AND t.oznVrstaTG='PDV' AND e.faktura.datPrometa <=:dat1 AND e.indk=0 AND e.faktura.tip=:tip1  AND e.faktura.radnajedinica=:rj AND e.faktura.arhiviran=1");
        q1.setParameter("dat1", (Object)krajnjidatum);
        q1.setParameter("tip1", (Object)"FAKTURA");
        q1.setParameter("rj", (Object)rj);
        Vector stavke1 = (Vector)q1.getResultList();
        hm.put("stavke1", stavke1);
        Calendar c = Calendar.getInstance();
        c.set(10, 23);
        c.set(12, 59);
        c.set(13, 59);
        Timestamp ts = new Timestamp(c.getTimeInMillis());
        Query q2 = em.createQuery("SELECT e.id.sfrProizvod, e.kolicina, e.cena, e.fiskalniracun.oznDokumenta, e.fiskalniracun.komitent.sfrKomitent, e.fiskalniracun.vreme, e.naziv, e.jm, e.fiskalniracun.idDok, e.id.rBroj, e.bliziOpis, e.dobSifra, e.fiskalniracun.storno, t.stopa FROM Proizvodfiskalniracun e, Pfrtaksa t WHERE e.id.sfrProizvod=t.id.sfrProizvod AND e.id.idDok=t.id.idDok AND e.id.rBroj=t.id.rBroj AND t.oznVrstaTG='PDV' AND e.fiskalniracun.vreme <=:dat1 AND e.indk=0 AND e.fiskalniracun.radnajedinica=:rj AND e.fiskalniracun.arhiviran=1");
        q2.setParameter("dat1", (Object)ts);
        q2.setParameter("rj", (Object)rj);
        Vector stavke2 = (Vector)q2.getResultList();
        hm.put("stavke2", stavke2);
        Query q3 = em.createQuery("SELECT e.id.sfrProizvod, e.kolicina, e.cenaBezPoreza, e.opstidokument.oznDokumenta, e.opstidokument.komitent.sfrKomitent, e.opstidokument.datum, e.naziv, e.jm, e.opstidokument.idDok, e.id.rBroj, e.bliziOpis, e.dobSifra, t.stopa FROM Artikalopstidokument e, Aodtaksa t WHERE e.id.sfrProizvod=t.id.sfrProizvod AND e.id.idDok=t.id.idDok AND e.id.rBroj=t.id.rBroj AND t.oznVrstaTG='PDV' AND e.opstidokument.datum <=:dat1 AND e.indk=0 AND e.opstidokument.tip=:tip1  AND e.opstidokument.radnajedinica=:rj AND e.opstidokument.arhiviran=1");
        q3.setParameter("dat1", (Object)krajnjidatum);
        q3.setParameter("tip1", (Object)"FISKALNI_IZVESTAJ");
        q3.setParameter("rj", (Object)rj);
        Vector stavke3 = (Vector)q3.getResultList();
        hm.put("stavke3", stavke3);
        return hm;
    }

    private void popuniDokumentStavkamaVeleprodaja(Vector<Object[]> stavkeObracuna, EntityManager em) {
        int i = 0;
        BigDecimal ukupnaVrednost = new BigDecimal(0);
        BigDecimal ukupnoProvizije = new BigDecimal(0);
        for (Object[] obj : stavkeObracuna) {
            String sifra = (String)obj[0];
            System.out.println("sifra" + ++i + "  " + sifra);
            double kolicina = (Double)obj[1];
            double cena = (Double)obj[2];
            String oznakaDokumenta = (String)obj[3];
            String sifraKomitenta = (String)obj[4];
            Date datum = (Date)obj[5];
            String nazivArtikla = (String)obj[6];
            String jm = (String)obj[7];
            int idDokumenta = (Integer)obj[8];
            int rBrUKljucu = (Integer)obj[9];
            String bliziopis = (String)obj[10];
            String vasaSifra = (String)obj[11];
            int storno = (Integer)obj[12];
            Artikalobracunkonsignacije artObracun = new Artikalobracunkonsignacije();
            ArtikalopstidokumentPK artPK = new ArtikalopstidokumentPK();
            artPK.setIdDok(this.obracunKonsignacije.getIdDok());
            artPK.setSfrProizvod(sifra);
            artPK.setrBroj(i);
            artObracun.setId(artPK);
            artObracun.setNaziv(nazivArtikla);
            artObracun.setBliziOpis(bliziopis);
            if (storno == 0) {
                artObracun.setKolicina(kolicina);
            } else {
                artObracun.setKolicina(-kolicina);
            }
            artObracun.setProdCena(new BigDecimal(cena));
            artObracun.setCena(cena);
            artObracun.setOznDokumenta(oznakaDokumenta);
            artObracun.setSifraKupca(sifraKomitenta);
            artObracun.setDatum(datum);
            artObracun.setJm(jm);
            artObracun.setIdDokumenta(idDokumenta);
            artObracun.setrBrojUKljucu(rBrUKljucu);
            artObracun.setProvizija(this.obracunKonsignacije.getProcenatProvizije());
            artObracun.setVasaSifra(vasaSifra);
            artObracun.setIndk(0);
            artObracun.setStorniranaStavka(0);
            artObracun.setObracunkonsignacije(this.obracunKonsignacije);
            this.obracunKonsignacije.getArtikalobracunkonsignacijes().add(artObracun);
            ukupnaVrednost = ukupnaVrednost.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena)));
            ukupnoProvizije = ukupnoProvizije.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena * this.obracunKonsignacije.getProcenatProvizije() / 100.0)));
        }
        this.obracunKonsignacije.setIznos(ukupnaVrednost);
        this.obracunKonsignacije.setProvizija(ukupnoProvizije);
        this.obracunKonsignacije.setZaPlacanje(ukupnaVrednost.subtract(ukupnoProvizije));
        this.iznosField.setVal((Object)this.obracunKonsignacije.getIznos());
        this.provizijaField.setVal((Object)this.obracunKonsignacije.getProvizija());
        this.zaPlacanjeField.setVal((Object)this.obracunKonsignacije.getZaPlacanje());
    }

    private void popuniDokumentStavkamaMaloprodaja(HashMap<String, Vector<Object[]>> hmStavke, EntityManager em) {
        Date datum;
        int i = 0;
        Vector<Object[]> stavke1 = hmStavke.get("stavke1");
        BigDecimal ukupnaVrednost = new BigDecimal(0);
        BigDecimal ukupnoProvizije = new BigDecimal(0);
        for (Object[] obj : stavke1) {
            String sifra = (String)obj[0];
            System.out.println("sifra" + ++i + "  " + (String)sifra);
            double kolicina = (Double)obj[1];
            double cena = (Double)obj[2];
            String oznakaDokumenta = (String)obj[3];
            String sifraKomitenta = (String)obj[4];
            Date datum2 = (Date)obj[5];
            String nazivArtikla = (String)obj[6];
            String jm = (String)obj[7];
            int idDokumenta = (Integer)obj[8];
            int rBrUKljucu = (Integer)obj[9];
            String bliziopis = (String)obj[10];
            String vasaSifra = (String)obj[11];
            int storno = (Integer)obj[12];
            double stopaPDV = (Double)obj[13];
            Artikalobracunkonsignacije artObracun = new Artikalobracunkonsignacije();
            ArtikalopstidokumentPK artPK = new ArtikalopstidokumentPK();
            artPK.setIdDok(this.obracunKonsignacije.getIdDok());
            artPK.setSfrProizvod(sifra);
            artPK.setrBroj(i);
            artObracun.setId(artPK);
            artObracun.setNaziv(nazivArtikla);
            artObracun.setBliziOpis(bliziopis);
            artObracun.setVrstaDokSaKogSuPreuzeteStavke(1);
            if (storno == 0) {
                artObracun.setKolicina(kolicina);
            } else {
                artObracun.setKolicina(-kolicina);
            }
            artObracun.setCena(cena / ((stopaPDV + 100.0) / 100.0));
            artObracun.setOznDokumenta(oznakaDokumenta);
            artObracun.setSifraKupca(sifraKomitenta);
            artObracun.setDatum(datum2);
            artObracun.setJm(jm);
            artObracun.setIdDokumenta(idDokumenta);
            artObracun.setrBrojUKljucu(rBrUKljucu);
            artObracun.setProvizija(this.obracunKonsignacije.getProcenatProvizije());
            artObracun.setVasaSifra(vasaSifra);
            artObracun.setIndk(0);
            artObracun.setStorniranaStavka(0);
            artObracun.setObracunkonsignacije(this.obracunKonsignacije);
            this.obracunKonsignacije.getArtikalobracunkonsignacijes().add(artObracun);
            ukupnaVrednost = ukupnaVrednost.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena)));
            ukupnoProvizije = ukupnoProvizije.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena * this.obracunKonsignacije.getProcenatProvizije() / 100.0)));
        }
        Vector<Object[]> stavke2 = hmStavke.get("stavke2");
        for (Object[] obj : stavke2) {
            String sifra = (String)obj[0];
            System.out.println("sifra" + ++i + "  " + sifra);
            double kolicina = (Double)obj[1];
            double cena = (Double)obj[2];
            String oznakaDokumenta = (String)obj[3];
            String sifraKomitenta = (String)obj[4];
            Timestamp tst = (Timestamp)obj[5];
            datum = new Date(tst.getTime());
            String nazivArtikla = (String)obj[6];
            String jm = (String)obj[7];
            int idDokumenta = (Integer)obj[8];
            int rBrUKljucu = (Integer)obj[9];
            String bliziopis = (String)obj[10];
            String vasaSifra = (String)obj[11];
            int storno = (Integer)obj[12];
            double stopaPDV = (Double)obj[13];
            Artikalobracunkonsignacije artObracun = new Artikalobracunkonsignacije();
            ArtikalopstidokumentPK artPK = new ArtikalopstidokumentPK();
            artPK.setIdDok(this.obracunKonsignacije.getIdDok());
            artPK.setSfrProizvod(sifra);
            artPK.setrBroj(i);
            artObracun.setId(artPK);
            artObracun.setNaziv(nazivArtikla);
            artObracun.setBliziOpis(bliziopis);
            artObracun.setVrstaDokSaKogSuPreuzeteStavke(2);
            if (storno == 0) {
                artObracun.setKolicina(kolicina);
            } else {
                artObracun.setKolicina(-kolicina);
            }
            artObracun.setCena(cena / ((stopaPDV + 100.0) / 100.0));
            artObracun.setOznDokumenta(oznakaDokumenta);
            artObracun.setSifraKupca(sifraKomitenta);
            artObracun.setDatum(datum);
            artObracun.setJm(jm);
            artObracun.setIdDokumenta(idDokumenta);
            artObracun.setrBrojUKljucu(rBrUKljucu);
            artObracun.setProvizija(this.obracunKonsignacije.getProcenatProvizije());
            artObracun.setVasaSifra(vasaSifra);
            artObracun.setIndk(0);
            artObracun.setStorniranaStavka(0);
            artObracun.setObracunkonsignacije(this.obracunKonsignacije);
            this.obracunKonsignacije.getArtikalobracunkonsignacijes().add(artObracun);
            ukupnaVrednost = ukupnaVrednost.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena)));
            ukupnoProvizije = ukupnoProvizije.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena * this.obracunKonsignacije.getProcenatProvizije() / 100.0)));
        }
        Vector<Object[]> stavke3 = hmStavke.get("stavke3");
        for (Object[] obj : stavke3) {
            String sifra = (String)obj[0];
            System.out.println("sifra" + ++i + "  " + sifra);
            double kolicina = (Double)obj[1];
            double cena = (Double)obj[2];
            String oznakaDokumenta = (String)obj[3];
            String sifraKomitenta = (String)obj[4];
            datum = (Date)obj[5];
            String nazivArtikla = (String)obj[6];
            String jm = (String)obj[7];
            int idDokumenta = (Integer)obj[8];
            int rBrUKljucu = (Integer)obj[9];
            String bliziopis = (String)obj[10];
            String vasaSifra = (String)obj[11];
            double stopaPDV = (Double)obj[12];
            Artikalobracunkonsignacije artObracun = new Artikalobracunkonsignacije();
            ArtikalopstidokumentPK artPK = new ArtikalopstidokumentPK();
            artPK.setIdDok(this.obracunKonsignacije.getIdDok());
            artPK.setSfrProizvod(sifra);
            artPK.setrBroj(i);
            artObracun.setId(artPK);
            artObracun.setNaziv(nazivArtikla);
            artObracun.setBliziOpis(bliziopis);
            artObracun.setKolicina(kolicina);
            artObracun.setCena(cena / ((stopaPDV + 100.0) / 100.0));
            artObracun.setVrstaDokSaKogSuPreuzeteStavke(3);
            artObracun.setOznDokumenta(oznakaDokumenta);
            artObracun.setSifraKupca(sifraKomitenta);
            artObracun.setDatum(datum);
            artObracun.setJm(jm);
            artObracun.setIdDokumenta(idDokumenta);
            artObracun.setrBrojUKljucu(rBrUKljucu);
            artObracun.setProvizija(this.obracunKonsignacije.getProcenatProvizije());
            artObracun.setVasaSifra(vasaSifra);
            artObracun.setIndk(0);
            artObracun.setStorniranaStavka(0);
            artObracun.setObracunkonsignacije(this.obracunKonsignacije);
            this.obracunKonsignacije.getArtikalobracunkonsignacijes().add(artObracun);
            ukupnaVrednost = ukupnaVrednost.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena)));
            ukupnoProvizije = ukupnoProvizije.add(BDConverter.getIznos((double)(artObracun.getKolicina() * cena * this.obracunKonsignacije.getProcenatProvizije() / 100.0)));
        }
        this.obracunKonsignacije.setIznos(ukupnaVrednost);
        this.obracunKonsignacije.setProvizija(ukupnoProvizije);
        this.obracunKonsignacije.setZaPlacanje(ukupnaVrednost.subtract(ukupnoProvizije));
        this.iznosField.setVal((Object)this.obracunKonsignacije.getIznos());
        this.provizijaField.setVal((Object)this.obracunKonsignacije.getProvizija());
        this.zaPlacanjeField.setVal((Object)this.obracunKonsignacije.getZaPlacanje());
    }

    private void kreirajTabelu() {
        this.table = new PzTable(this.obracunKonsignacije.getArtikalobracunkonsignacijes(), Artikalobracunkonsignacije.class);
        this.table.setCheckboxColumn(0);
        this.table.checkAll();
        this.table.addCheckboxListener(new PzTableCheckboxListener(){

            public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                Artikalobracunkonsignacije artobr = (Artikalobracunkonsignacije)entity;
                if (!newValue) {
                    PzDialogObracunKonsignacije.this.iznosField.setVal((Object)(PzDialogObracunKonsignacije.this.iznosField.getVal() - artobr.getKolicina() * artobr.getCena()));
                    PzDialogObracunKonsignacije.this.provizijaField.setVal((Object)(PzDialogObracunKonsignacije.this.provizijaField.getVal() - PzMathUtility.round((double)(artobr.getKolicina() * artobr.getCena() * artobr.getProvizija() / 100.0))));
                    PzDialogObracunKonsignacije.this.zaPlacanjeField.setVal((Object)(PzDialogObracunKonsignacije.this.iznosField.getVal() - PzDialogObracunKonsignacije.this.provizijaField.getVal()));
                } else {
                    PzDialogObracunKonsignacije.this.iznosField.setVal((Object)(PzDialogObracunKonsignacije.this.iznosField.getVal() + artobr.getKolicina() * artobr.getCena()));
                    PzDialogObracunKonsignacije.this.provizijaField.setVal((Object)(PzDialogObracunKonsignacije.this.provizijaField.getVal() + PzMathUtility.round((double)(artobr.getKolicina() * artobr.getCena() * artobr.getProvizija() / 100.0))));
                    PzDialogObracunKonsignacije.this.zaPlacanjeField.setVal((Object)(PzDialogObracunKonsignacije.this.iznosField.getVal() - PzDialogObracunKonsignacije.this.provizijaField.getVal()));
                }
            }
        });
        this.jScrollPane.setViewportView((Component)this.table);
    }

    private Vector<Artikalobracunkonsignacije> sumirajIsteStavke(Vector<Artikalobracunkonsignacije> stavke) {
        Vector<Artikalobracunkonsignacije> rezultat = new Vector<Artikalobracunkonsignacije>();
        Iterator<Artikalobracunkonsignacije> cur = stavke.iterator();
        Artikalobracunkonsignacije artstavka = cur.next();
        rezultat.add(artstavka);
        while (cur.hasNext()) {
            artstavka = cur.next();
            Artikalobracunkonsignacije pomocni = this.pronadjiUVektoru(rezultat, artstavka);
            if (pomocni == null) {
                rezultat.add(artstavka);
                continue;
            }
            pomocni.setKolicina(pomocni.getKolicina() + artstavka.getKolicina());
            rezultat.setElementAt(pomocni, rezultat.indexOf(pomocni));
        }
        return rezultat;
    }

    private Artikalobracunkonsignacije pronadjiUVektoru(Vector<Artikalobracunkonsignacije> vektor, Artikalobracunkonsignacije stavka) {
        Iterator<Artikalobracunkonsignacije> cur = vektor.iterator();
        boolean found = false;
        Artikalobracunkonsignacije artob = null;
        while (cur.hasNext() && !found) {
            Artikalobracunkonsignacije pomocni = cur.next();
            if (!pomocni.getId().getSfrProizvod().equals(stavka.getId().getSfrProizvod()) || pomocni.getCena() != stavka.getCena() || pomocni.getProvizija() != stavka.getProvizija()) continue;
            found = true;
            artob = pomocni;
        }
        return artob;
    }

    private void arhivirajVeleprodaja() {
        try {
            HashMap<String, Boolean> hashmap = PzDialogIzborNacinaStampe.getIzbor((PzDialog)this);
            if (hashmap == null) {
                return;
            }
            EntityManager em1 = PzEntityManager.getEm();
            em1.getTransaction().begin();
            Vector artikli = (Vector)this.table.getCheckedEntities();
            this.obracunKonsignacije.setArtikalobracunkonsignacijes(new Vector());
            BigDecimal ukupnaVr = new BigDecimal(0);
            BigDecimal ukupnoPr = new BigDecimal(0);
            for (Artikalobracunkonsignacije aob : artikli) {
                aob.setObracunkonsignacije(this.obracunKonsignacije);
                this.obracunKonsignacije.getArtikalobracunkonsignacijes().add(aob);
                ukupnaVr = ukupnaVr.add(BDConverter.getIznos((double)(aob.getKolicina() * aob.getCena())));
                ukupnoPr = ukupnoPr.add(BDConverter.getIznos((double)(aob.getKolicina() * aob.getCena() * aob.getProvizija() / 100.0)));
                Artikalfaktura af = (Artikalfaktura)PzEntityManager.find(Artikalfaktura.class, (Object)new ArtikalfakturaPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                af.setIndk((short)1);
                em1.merge((Object)af);
            }
            this.obracunKonsignacije.setIznos(ukupnaVr);
            this.obracunKonsignacije.setProvizija(ukupnoPr);
            this.obracunKonsignacije.setZaPlacanje(ukupnaVr.subtract(ukupnoPr));
            this.obracunKonsignacije.setArhiviran((short)1);
            this.obracunKonsignacije.setDatArh(new Date(new java.util.Date().getTime()));
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.obracunKonsignacije, true, null, em1);
            em1.merge((Object)this.obracunKonsignacije);
            em1.getTransaction().commit();
            em1.close();
            Vector<Object> lista = new Vector<Object>();
            lista.add(PzFirma.getFirma());
            lista.add(this.obracunKonsignacije);
            lista.add(this.ulaznaRJ);
            String putanjaReporta = "";
            if (hashmap.get("nasa").booleanValue()) {
                putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_nasasifra.jasper";
            } else if (hashmap.get("tudja").booleanValue()) {
                putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_tudjasifra.jasper";
            } else if (hashmap.get("obadvije").booleanValue()) {
                putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_obesifre.jasper";
            }
            Vector<Artikalobracunkonsignacije> artikalobracunkonsignacije = this.sumirajIsteStavke((Vector)this.obracunKonsignacije.getArtikalobracunkonsignacijes());
            PzKonsignacijaUtility.sortiraj(artikalobracunkonsignacije);
            PzDataSourceExtended ds = new PzDataSourceExtended(lista, artikalobracunkonsignacije);
            ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            String title = "OBRA\u010cUN broj " + PzEntityUtil.strZero((String)this.obracunKonsignacije.getRadnajedinica().getId().getOznRj(), (int)3) + "-" + PzEntityUtil.strZero((String)("" + this.obracunKonsignacije.getrBroj()), (int)5) + "/" + PzDateUtility.getCurrentYear();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("title", title);
            PzReportManager.createAndShowReport((PzDialog)this.parent, (JRDataSource)ds, (String)putanjaReporta, params, (String)"Obra\u010dun konsignacije");
            this.parent.finish();
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void arhivirajMaloprodaja() {
        try {
            HashMap<String, Boolean> hashmap = PzDialogIzborNacinaStampe.getIzbor((PzDialog)this);
            if (hashmap == null) {
                return;
            }
            EntityManager em1 = PzEntityManager.getEm();
            em1.getTransaction().begin();
            Vector artikli = (Vector)this.table.getCheckedEntities();
            this.obracunKonsignacije.setArtikalobracunkonsignacijes(new Vector());
            BigDecimal ukupnaVr = new BigDecimal(0);
            BigDecimal ukupnoPr = new BigDecimal(0);
            for (Artikalobracunkonsignacije aob : artikli) {
                aob.setObracunkonsignacije(this.obracunKonsignacije);
                this.obracunKonsignacije.getArtikalobracunkonsignacijes().add(aob);
                ukupnaVr = ukupnaVr.add(BDConverter.getIznos((double)(aob.getKolicina() * aob.getCena())));
                ukupnoPr = ukupnoPr.add(BDConverter.getIznos((double)(aob.getKolicina() * aob.getCena() * aob.getProvizija() / 100.0)));
                if (aob.getVrstaDokSaKogSuPreuzeteStavke() == 1) {
                    Artikalfaktura af = (Artikalfaktura)PzEntityManager.find(Artikalfaktura.class, (Object)new ArtikalfakturaPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                    af.setIndk((short)1);
                    em1.merge((Object)af);
                    continue;
                }
                if (aob.getVrstaDokSaKogSuPreuzeteStavke() == 2) {
                    Proizvodfiskalniracun pfr = (Proizvodfiskalniracun)PzEntityManager.find(Proizvodfiskalniracun.class, (Object)new ProizvodfiskalniracunPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                    pfr.setIndk((short)1);
                    em1.merge((Object)pfr);
                    continue;
                }
                if (aob.getVrstaDokSaKogSuPreuzeteStavke() != 3) continue;
                Artikalopstidokument aod = (Artikalopstidokument)PzEntityManager.find(Artikalopstidokument.class, (Object)new ArtikalopstidokumentPK(aob.getIdDokumenta(), aob.getId().getSfrProizvod(), aob.getrBrojUKljucu()), (EntityManager)em1);
                aod.setIndk(1);
                em1.merge((Object)aod);
            }
            this.obracunKonsignacije.setIznos(ukupnaVr);
            this.obracunKonsignacije.setProvizija(ukupnoPr);
            this.obracunKonsignacije.setZaPlacanje(ukupnaVr.subtract(ukupnoPr));
            this.obracunKonsignacije.setArhiviran((short)1);
            this.obracunKonsignacije.setDatArh(new Date(new java.util.Date().getTime()));
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.obracunKonsignacije, true, null, em1);
            em1.merge((Object)this.obracunKonsignacije);
            em1.getTransaction().commit();
            em1.close();
            Vector<Object> lista = new Vector<Object>();
            lista.add(PzFirma.getFirma());
            lista.add(this.obracunKonsignacije);
            lista.add(this.ulaznaRJ);
            String putanjaReporta = "";
            if (hashmap.get("nasa").booleanValue()) {
                putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_nasasifra.jasper";
            } else if (hashmap.get("tudja").booleanValue()) {
                putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_tudjasifra.jasper";
            } else if (hashmap.get("obadvije").booleanValue()) {
                putanjaReporta = "rs/pezar/reports/compiled/obracun_kons_obesifre.jasper";
            }
            Vector<Artikalobracunkonsignacije> artikalobracunkonsignacije = this.sumirajIsteStavke(artikli);
            PzKonsignacijaUtility.sortiraj(artikalobracunkonsignacije);
            PzDataSourceExtended ds = new PzDataSourceExtended(lista, artikalobracunkonsignacije);
            ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            String title = "OBRA\u010cUN broj " + PzEntityUtil.strZero((String)this.obracunKonsignacije.getRadnajedinica().getId().getOznRj(), (int)3) + "-" + PzEntityUtil.strZero((String)("" + this.obracunKonsignacije.getrBroj()), (int)5) + "/" + PzDateUtility.getCurrentYear();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("title", title);
            PzReportManager.createAndShowReport((PzDialog)this.parent, (JRDataSource)ds, (String)putanjaReporta, params, (String)"Obra\u010dun konsignacije");
            this.parent.finish();
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

