/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.util;

import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.globals.TipDokumentConfig;

public class PzAnalitikaFinalizer
implements PzDokumentFinalizer {
    List<String> tipoviUplKup = new Vector<String>();
    List<String> tipoviUplKupStorno = new Vector<String>();
    List<String> tipoviUplDob = new Vector<String>();
    List<String> tipoviUplDobStorno = new Vector<String>();
    List<String> tipovi = new Vector<String>();

    public PzAnalitikaFinalizer() {
        this.tipoviUplKup.add(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC);
        this.tipoviUplKup.add(TipDokumentConfig.get().PRENOS_NA_FAKTURU_KUPAC);
        this.tipoviUplKupStorno.add(TipDokumentConfig.get().PRENOS_SA_FAKTURE_KUPAC);
        this.tipoviUplDob.add(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC);
        this.tipoviUplDob.add(TipDokumentConfig.get().PRENOS_NA_FAKTURU_DOBAVLJAC);
        this.tipoviUplDobStorno.add(TipDokumentConfig.get().PRENOS_SA_FAKTURE_DOBAVLJAC);
        this.tipovi.addAll(this.tipoviUplDob);
        this.tipovi.addAll(this.tipoviUplDobStorno);
        this.tipovi.addAll(this.tipoviUplKup);
        this.tipovi.addAll(this.tipoviUplKupStorno);
    }

    public boolean appliesTo(PzDokument d) {
        return this.tipovi.contains(d.getTip());
    }

    public void finalize(PzDokument d, EntityManager em) {
        if (this.tipoviUplKup.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UK");
        } else if (this.tipoviUplKupStorno.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UKS");
        } else if (this.tipoviUplDob.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UD");
        } else if (this.tipoviUplDobStorno.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UDS");
        }
    }
}

