/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.util;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.analitike.gui.artikli.kartica.PzDialogPojedinacnaKartica;
import rs.pezar.analitike.gui.komitenti.PzDialogKarticaKomitenata;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Popis;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class AnalitikaUtil {
    public static final String PARAMETER_IZBOR = "IZBOR";
    public static final String PARAMETER_RJ_ULAZ = "ULAZNA_RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";

    public static void karticaArtikla(PzDialog parent, Artikal art, Radnajedinica r, String tipKartice) {
        try {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            PzDialogPojedinacnaKartica.showKarticaArtikla(parent, art, r, tipKartice, em);
            em.close();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaArtikla(PzDialog parent, String sfrProizvod, String oznOgranak, String oznRj, String tipKartice) {
        try {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            PzDialogPojedinacnaKartica.showKarticaArtikla(parent, (Artikal)em.find(Artikal.class, (Object)sfrProizvod), (Radnajedinica)em.find(Radnajedinica.class, (Object)new RadnajedinicaPK(oznOgranak, oznRj)), tipKartice, em);
            em.close();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaArtikla(PzDialog parent, String sfrProizvod, String oznOgranak, String oznRj) {
        try {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            AnalitikaUtil.karticaArtikla(parent, (Artikal)em.find(Artikal.class, (Object)sfrProizvod), (Radnajedinica)em.find(Radnajedinica.class, (Object)new RadnajedinicaPK(oznOgranak, oznRj)), em);
            em.close();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaArtikla(PzDialog parent, Artikal art, Radnajedinica rj, EntityManager em) {
        try {
            Vector<String> skupZaIzbor = new Vector<String>();
            String prodajna = new String("Prodajna");
            String prosNabavna = new String("Prose\u010dna nabavna");
            skupZaIzbor.add(prodajna);
            skupZaIzbor.add(prosNabavna);
            String prosecnaNabavna = rj.getNacinVodjenja().equals("PRODAJNA") ? "true" : "false";
            String tipKartice = null;
            if (prosecnaNabavna.equals("false") && rj.getTip().startsWith("V")) {
                String izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)parent, skupZaIzbor);
                if (izborKartice == null) {
                    return;
                }
                if (izborKartice.equals(prodajna)) {
                    tipKartice = "PRODAJNA";
                } else if (izborKartice.equals(prosNabavna)) {
                    tipKartice = "PROSECNA_NABAVNA";
                }
            } else {
                tipKartice = "PRODAJNA";
            }
            PzDialogPojedinacnaKartica.showKarticaArtikla(parent, art, rj, tipKartice, em);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaKomitenta(PzDialog parent, Komitent komitent, byte kupacDobavljac) {
        try {
            PzDialogKarticaKomitenata.showKarticaKomitenta(parent, komitent, kupacDobavljac);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaKomitenta(PzDialog parent, Komitent komitent) {
        try {
            Vector<String> choices = new Vector<String>();
            choices.add("KUPAC");
            choices.add("DOBAVLJA\u010c");
            String izbor = PzDialogChoice.showPzDialogChoice((PzDialog)parent, choices);
            if (izbor == null) {
                return;
            }
            byte b = izbor.equals("KUPAC") ? PzDialogKarticaKomitenata.KARTICA_KUPCA : PzDialogKarticaKomitenata.KARTICA_DOBAVLJACA;
            PzDialogKarticaKomitenata.showKarticaKomitenta(parent, komitent, b);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaKomitenta(PzDialog parent, String sfrKomitent) {
        try {
            Vector<String> choices = new Vector<String>();
            choices.add("KUPAC");
            choices.add("DOBAVLJA\u010c");
            String izbor = PzDialogChoice.showPzDialogChoice((PzDialog)parent, choices);
            if (izbor == null) {
                return;
            }
            byte b = izbor.equals("KUPAC") ? PzDialogKarticaKomitenata.KARTICA_KUPCA : PzDialogKarticaKomitenata.KARTICA_DOBAVLJACA;
            PzDialogKarticaKomitenata.showKarticaKomitenta(parent, (Komitent)PzEntityManager.find(Komitent.class, (Object)sfrKomitent), b);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void karticaKomitenta(PzDialog parent) {
        parent.showDialog(PzDialogKarticaKomitenata.class);
    }

    public static PzDokument toDokumentPOU(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Radnajedinica rjUlaz = (Radnajedinica)parameters.get(PARAMETER_RJ_ULAZ);
        String cfr_ignored_0 = (String)parameters.get(PARAMETER_IZBOR);
        new String("Prazan popis");
        new String("Popis popunjen svim artiklima iz magacina (koli\u010dina na popisu = 0)");
        new String("Popis popunjen svim artiklima iz magacina (koli\u010dina na popisu = knjigovodstvena koli\u010dina)");
        DefaultDokumentTransformer ddt = new DefaultDokumentTransformer(Popis.class, Artikalopstidokument.class);
        Popis popis = (Popis)ddt.toDokument(l, parameters, em);
        PzEntityUtil.currentType = (String)parameters.get(PARAMETER_TIP);
        popis.setStorno(0);
        popis.setArhiviran((short)0);
        popis.setTip((String)parameters.get(PARAMETER_TIP));
        popis.setRadnajedinica(rjUlaz);
        popis.setDatum(new Date(new java.util.Date().getTime()));
        popis.setProknjizen((short)0);
        popis.setProcRabata(0.0);
        popis.setManjak(new BigDecimal(0));
        popis.setVisak(new BigDecimal(0));
        popis.setPdvIznos(new BigDecimal(0));
        popis.setVrednostPopisa(new BigDecimal(0));
        popis.setRjUlaz(rjUlaz.getPunNaziv());
        return popis;
    }

    public static BigDecimal getLager(String oznRj) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        BigDecimal res = (BigDecimal)em.createNativeQuery("SELECT SUM(ROUND(CAST(a.kolicina*a.prodCena AS NUMERIC), 2)) FROM Stanjeartikal a WHERE a.kolicina<>0 AND a.kolicina IS NOT NULL  AND a.oznRj = '" + oznRj + "'").getSingleResult();
        em.close();
        return res;
    }
}

