/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.tableModels;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.komitenti.PzDialogKarticaKomitenata;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.PzOpisDokumenta;
import rs.pezar.core.format.BDConverter;
import rs.pezar.swing.data.models.PzScrollableTableModel;
import rs.pezar.util.PzDateUtility;

public class PzTableModelKarticaKomitenta
extends PzScrollableTableModel {
    private static final long serialVersionUID = 1L;
    public static final byte FIELD_KASNJENJE = 0;
    public static final byte FIELD_DATUM = 1;
    public static final byte FIELD_OPIS = 2;
    public static final byte FIELD_BR_FAKTURE = 3;
    public static final byte FIELD_DUGUJE = 4;
    public static final byte FIELD_POTRAZUJE = 5;
    public static final byte FIELD_SALDO = 6;
    public static final byte FIELD_DATUM_VALUTE = 7;
    public static final byte FIELD_NZK = 8;
    public static final byte FIELD_DUG_PO_DOKUMENTU = 9;
    public static final byte FIELD_IDDOK = 10;
    public static final byte FIELD_KURS = 11;
    public static final byte FIELD_DUGUJE_STRANA_VALUTA = 12;
    public static final byte FIELD_POTRAZUJE_STRANA_VALUTA = 13;
    public static final byte FIELD_SALDO_STRANA_VALUTA = 14;
    public static final byte FIELD_PODTIP = 15;
    public static final String[] zaglavlje = new String[15];
    public static final String[] kColNames;
    ScrollableCursor cursor;
    private final BigDecimal[] saldo;
    private final BigDecimal[] stranaValutaSaldo;
    private final BigDecimal[] duguje;
    private final BigDecimal[] potrazuje;
    private final Integer[] prikaziSaldo;
    boolean kupac1 = false;
    private final String valuta;
    private boolean preuzetKurs = true;

    static {
        PzTableModelKarticaKomitenta.zaglavlje[0] = "$";
        PzTableModelKarticaKomitenta.zaglavlje[1] = "Datum";
        PzTableModelKarticaKomitenta.zaglavlje[2] = "Opis";
        PzTableModelKarticaKomitenta.zaglavlje[3] = "Oznaka dok.";
        PzTableModelKarticaKomitenta.zaglavlje[4] = "Duguje";
        PzTableModelKarticaKomitenta.zaglavlje[5] = "Potra\u017euje";
        PzTableModelKarticaKomitenta.zaglavlje[6] = "Saldo";
        PzTableModelKarticaKomitenta.zaglavlje[12] = "Duguje";
        PzTableModelKarticaKomitenta.zaglavlje[13] = "Potra\u017euje";
        PzTableModelKarticaKomitenta.zaglavlje[7] = "Datum Valute";
        PzTableModelKarticaKomitenta.zaglavlje[8] = "Proknji\u017een";
        PzTableModelKarticaKomitenta.zaglavlje[9] = "Dug po dok.";
        PzTableModelKarticaKomitenta.zaglavlje[10] = "IdDok";
        PzTableModelKarticaKomitenta.zaglavlje[11] = "Kurs";
        PzTableModelKarticaKomitenta.zaglavlje[14] = "Saldo";
        kColNames = new String[]{zaglavlje[0], zaglavlje[1], zaglavlje[2], zaglavlje[3], zaglavlje[4], zaglavlje[5], zaglavlje[6], zaglavlje[7], zaglavlje[8], zaglavlje[9], zaglavlje[10], zaglavlje[11], zaglavlje[12], zaglavlje[13], zaglavlje[14]};
    }

    public Integer getidDokAt(int pos) {
        return (Integer)this.getValueAt(pos, 10);
    }

    public PzTableModelKarticaKomitenta(ScrollableCursor cursor, PzDialogKarticaKomitenata dialog, boolean kupac) {
        this.cursor = cursor;
        this.saldo = new BigDecimal[cursor.size()];
        this.duguje = new BigDecimal[cursor.size()];
        this.potrazuje = new BigDecimal[cursor.size()];
        this.stranaValutaSaldo = new BigDecimal[cursor.size()];
        this.prikaziSaldo = new Integer[cursor.size()];
        this.kupac1 = kupac;
        this.valuta = dialog.getValuta();
    }

    public synchronized String getColumnName(int columnIndex) {
        if (this.cursor.isClosed()) {
            return null;
        }
        if (columnIndex == 12 || columnIndex == 13 || columnIndex == 11 || columnIndex == 14) {
            return String.valueOf(kColNames[columnIndex]) + "(" + this.valuta + ")";
        }
        return kColNames[columnIndex];
    }

    public synchronized int getColumnCount() {
        return kColNames.length;
    }

    public synchronized int getRowCount() {
        if (this.cursor.isClosed()) {
            return 0;
        }
        return this.cursor.size();
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        ScrollableCursor sc = this.cursor;
        if (sc == null || sc.isClosed()) {
            return null;
        }
        sc.size();
        if (sc.size() > 0) {
            if (sc.absolute(rowIndex)) {
                Object e = sc.next();
                return this.getValueSet((Object[])e, rowIndex, this.kupac1)[columnIndex];
            }
            return null;
        }
        return null;
    }

    private Object[] getValueSet(Object[] dok, int rowindex, boolean kupac) {
        BigDecimal potrazujeStranaValuta;
        BigDecimal dugujeStranaValuta;
        BigDecimal uplata;
        Date datum = (Date)dok[0];
        String tip = dok[1] == null ? "" : dok[1];
        String oznDokumenta = dok[2] == null ? "" : dok[2];
        Date datumValute = (Date)dok[3];
        BigDecimal iznosDok = dok[4] == null ? BigDecimal.ZERO : dok[4];
        Integer storno = (Integer)(dok[5] == null ? Integer.valueOf(0) : dok[5]);
        String sfrKomitenta = dok[6] == null ? "" : dok[6];
        Integer rbroj = (Integer)(dok[7] == null ? Integer.valueOf(0) : dok[7]);
        Integer idDok = (Integer)(dok[8] == null ? Integer.valueOf(0) : dok[8]);
        Integer proknjizen = (Integer)(dok[9] == null ? Integer.valueOf(0) : dok[9]);
        String podTip = dok[10] == null ? "" : dok[10];
        BigDecimal stornoIznos = dok[11] == null ? BigDecimal.ZERO : dok[11];
        BigDecimal bigDecimal = uplata = dok[12] == null ? BigDecimal.ZERO : dok[12];
        BigDecimal kurs = dok[13] == null ? BigDecimal.ZERO : (dok[13] instanceof Double ? new BigDecimal((Double)dok[13]) : dok[13]);
        BigDecimal dugPoDokumentu = BigDecimal.ZERO;
        Date datumKalkulacije = (Date)dok[14];
        Byte dugujepotrazuje = null;
        BigDecimal iznos = BigDecimal.ZERO;
        String proknj = proknjizen == 1 ? "DA" : "NE";
        try {
            dugujepotrazuje = this.getDugujePotrazuje(tip, rowindex, kupac);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        iznos = storno == 1 ? iznosDok.negate() : iznosDok;
        if (dugujepotrazuje == Settings.KPOTRAZUJE) {
            this.duguje[rowindex] = BigDecimal.ZERO;
            this.potrazuje[rowindex] = iznos;
        } else if (dugujepotrazuje == Settings.MINUS_KPOTRAZUJE) {
            this.duguje[rowindex] = BigDecimal.ZERO;
            this.potrazuje[rowindex] = iznos.negate();
        } else if (dugujepotrazuje == Settings.KDUGUJE) {
            this.duguje[rowindex] = iznos;
            this.potrazuje[rowindex] = BigDecimal.ZERO;
        } else if (dugujepotrazuje == Settings.MINUS_KDUGUJE) {
            this.duguje[rowindex] = iznos.negate();
            this.potrazuje[rowindex] = BigDecimal.ZERO;
        }
        this.saldo[rowindex] = this.duguje[rowindex].subtract(this.potrazuje[rowindex]);
        if (rowindex != 0) {
            this.saldo[rowindex] = this.saldo[rowindex].add(this.saldo[rowindex - 1]);
        }
        dugPoDokumentu = Settings.preracunKasnjenjaKupacDobavljac.contains(tip) && storno != 1 ? iznosDok.subtract(stornoIznos).subtract(uplata) : BigDecimal.ZERO;
        Integer osenci = 0;
        Date today = PzDateUtility.getCurrentDate();
        if (datumValute != null && today.after(datumValute) && dugPoDokumentu.doubleValue() != 0.0) {
            osenci = (int)((today.getTime() - datumValute.getTime()) / 86400000L);
        }
        BigDecimal stranaValuta = BigDecimal.ZERO;
        if (kurs != null && kurs.doubleValue() > 0.0) {
            dugujeStranaValuta = BDConverter.getIznos((double)(this.duguje[rowindex].doubleValue() / kurs.doubleValue()));
            potrazujeStranaValuta = BDConverter.getIznos((double)(this.potrazuje[rowindex].doubleValue() / kurs.doubleValue()));
            stranaValuta = dugujeStranaValuta.subtract(potrazujeStranaValuta);
        } else {
            dugujeStranaValuta = BigDecimal.ZERO;
            potrazujeStranaValuta = BigDecimal.ZERO;
        }
        this.prikaziSaldo[rowindex] = kurs != null && !kurs.equals(BigDecimal.ZERO) ? Integer.valueOf(0) : Integer.valueOf(-1);
        this.stranaValutaSaldo[rowindex] = stranaValuta;
        if (rowindex != 0) {
            this.stranaValutaSaldo[rowindex] = this.stranaValutaSaldo[rowindex].add(this.stranaValutaSaldo[rowindex - 1]);
        }
        if (!this.showSaldoOrNot(this.prikaziSaldo, rowindex).booleanValue()) {
            this.preuzetKurs(false);
            this.stranaValutaSaldo[rowindex] = new BigDecimal(-1);
        }
        Object[] results = new Object[]{osenci, datum, PzOpisDokumenta.getOpis(tip, podTip, oznDokumenta, rbroj, sfrKomitenta, storno, datum, datumKalkulacije), oznDokumenta, this.duguje[rowindex], this.potrazuje[rowindex], this.saldo[rowindex], datumValute, proknj, dugPoDokumentu, idDok, kurs, dugujeStranaValuta, potrazujeStranaValuta, this.stranaValutaSaldo[rowindex], podTip};
        return results;
    }

    public synchronized boolean preuzetKurs(boolean b) {
        if (!b) {
            this.preuzetKurs = false;
        }
        return this.preuzetKurs;
    }

    private Byte getDugujePotrazuje(String tipDok, int rowindex, boolean kupac) throws Exception {
        Byte temp = !kupac ? Settings.karticaDobavljaca.get(tipDok) : Settings.karticaKupca.get(tipDok);
        if (temp != null) {
            return temp;
        }
        throw new Exception("Greska : record set sadrzi Dokument koji nije definisan");
    }

    private Boolean showSaldoOrNot(Integer[] data, int rowIndex) {
        Integer temp = 0;
        int i = 0;
        while (i <= rowIndex) {
            temp = temp + data[i];
            ++i;
        }
        if (temp == 0) {
            return true;
        }
        return false;
    }
}

