/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.tableModels;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.komitenti.PzDialogKarticaFakturaUplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.data.models.PzScrollableTableModelEntity;

public class PzTableModelKarticaFakturaIUplata
extends PzScrollableTableModelEntity {
    private static final long serialVersionUID = 1L;
    public static final byte FIELD_DATUM = 0;
    public static final byte FIELD_BR_FAKTURE = 1;
    public static final byte FIELD_IZNOS_FAKTURE = 2;
    public static final byte FIELD_STORNO_IZNOS = 3;
    public static final byte FIELD_KUM_UPLATE = 4;
    public static final byte FIELD_DUG = 5;
    public static final byte FIELD_DATUM_UPLATE = 6;
    public static final byte FIELD_OPIS_UPLATE = 7;
    public static final byte FIELD_IZNOS_UPLATE = 8;
    public static final String[] kColNames = new String[]{"Datum", "Broj Fakture", "Iznos", "Storno iznos", "Kumulativ uplate", "Dug", "Datum Uplate", "Iznos uplate", "Opis uplate"};
    private boolean kupac;

    public PzTableModelKarticaFakturaIUplata(ScrollableCursor cursor, boolean kupac) {
        super(cursor);
        this.kupac = kupac;
    }

    public int getColumnCount() {
        return kColNames.length;
    }

    public synchronized int getRowCount() {
        if (this.getCursor().isClosed()) {
            return 0;
        }
        return this.getCursor().size();
    }

    public String getColumnName(int arg0) {
        return kColNames[arg0];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ScrollableCursor sc = this.getCursor();
        if (sc == null || sc.isClosed()) {
            return null;
        }
        if (sc.size() > 0) {
            if (sc.absolute(rowIndex)) {
                Object[] e = (Object[])sc.next();
                return this.getValueSet(e, this.kupac)[columnIndex];
            }
            return null;
        }
        return null;
    }

    private Object[] getValueSet(Object[] dok, boolean kupac) {
        String tipDokumenta = null;
        String podtipDokumenta = null;
        Date datumDokumenta = null;
        String brojDokumenta = null;
        Object zaSort = null;
        BigDecimal iznosDokumenta = null;
        BigDecimal stornoIznos = null;
        BigDecimal kumulativUplate = null;
        BigDecimal dug = null;
        Date datumUplate = null;
        BigDecimal iznosUplate = null;
        Integer storno = null;
        BigDecimal minusUplata = dok[6] == null ? new BigDecimal(0.0) : (BigDecimal)dok[6];
        BigDecimal minusStorno = dok[10] == null ? new BigDecimal(0.0) : (BigDecimal)dok[10];
        tipDokumenta = (String)dok[1];
        storno = (Integer)dok[7];
        String opisUplate = "";
        podtipDokumenta = (String)dok[9];
        if (kupac && Settings.isIn(Settings.karticaFakturaIUplataKupacUplate, tipDokumenta).booleanValue() || !kupac && Settings.isIn(Settings.karticaFakturaIUplataDobavljacUplate, tipDokumenta).booleanValue()) {
            datumUplate = (Date)dok[2];
            opisUplate = PzDialogKarticaFakturaUplata.getOpis(tipDokumenta, podtipDokumenta, (String)dok[3]);
            iznosUplate = (BigDecimal)dok[4];
            if (tipDokumenta.equals(TipDokumentConfig.get().PRENOS_SA_FAKTURE_DOBAVLJAC) || tipDokumenta.equals(TipDokumentConfig.get().PRENOS_SA_FAKTURE_KUPAC)) {
                iznosUplate = iznosUplate.negate();
            }
        } else {
            datumDokumenta = (Date)dok[2];
            brojDokumenta = (String)dok[3];
            if (storno == 1) {
                iznosDokumenta = new BigDecimal(0.0);
                stornoIznos = (BigDecimal)dok[4];
                stornoIznos = stornoIznos.negate();
            } else {
                iznosDokumenta = (BigDecimal)dok[4];
            }
            stornoIznos = (BigDecimal)(dok[5] == null ? new BigDecimal(0.0) : dok[5]);
            kumulativUplate = dok[8] == null ? new BigDecimal(0.0) : (BigDecimal)dok[8];
            kumulativUplate = kumulativUplate.subtract(minusUplata);
            dug = iznosDokumenta;
            if (stornoIznos == null) {
                stornoIznos = BigDecimal.ZERO;
            }
            if ((stornoIznos = stornoIznos.subtract(minusStorno)) != null) {
                dug = dug.subtract(stornoIznos);
            }
            if (kumulativUplate != null) {
                dug = dug.subtract(kumulativUplate);
            }
        }
        return new Object[]{datumDokumenta, brojDokumenta, iznosDokumenta, stornoIznos, kumulativUplate, dug, datumUplate, opisUplate, iznosUplate, zaSort};
    }
}

