/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledNabavkeDobavljaca
extends PzDialog {
    private static final long serialVersionUID = -6993936210874424791L;
    private static final String SVI_MAGACINI = "Svi magacini";
    private static final String ODREDJENI_MAGACIN = "Odre\u0111eni magacin";
    private static final String DETALJNO = "Detaljni pregled";
    private static final String ZBIRNO = "Zbirni pregled";
    private PzPanel mainPanel;
    private JLabel lblSifra;
    private PzTextField tfSifra;
    private PzTextField tfNaziv;
    private PzTextField tfRj;
    private JLabel lblPocetni;
    private JButton btnPotvrdi;
    private PzRadioGroup<String> panelRbs1;
    private PzDateField dfKrajnji;
    private PzDateField dfPocetni;
    private JLabel lblKrajnji;
    private PzPanel pnlPeriod;
    private PzTextField tfNazivRj;
    private JLabel lblRj;
    private PzFieldIndikator indSifra;
    private PzRadioGroup<String> panelRbs2;
    private PzPanel pnlValute;
    private PzComboBox cbValute;
    private Komitent entKomitent;
    private ScrollableCursor cursor;
    private Radnajedinica rj;

    public PzDialogPregledNabavkeDobavljaca(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValute.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValute.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
        this.tfSifra.requestFocusInWindow();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled nabavke od dobavlja\u010da");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{130, 149, 133, 124, 137, 20};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblSifra = new JLabel();
            this.mainPanel.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 3, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra dobavlja\u010da");
            this.tfSifra = new PzTextField();
            this.mainPanel.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 3, 25), 0, 0));
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.indSifra = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indSifra, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 3, 5), 0, 0));
            this.tfNaziv = new PzTextField();
            this.mainPanel.add((Component)this.tfNaziv, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 3, 0), 0, 0));
            this.tfNaziv.setEditable(false);
            this.tfNaziv.setFocusable(false);
            this.lblRj = new JLabel();
            this.mainPanel.add((Component)this.lblRj, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblRj.setText("Radna jedinica");
            this.tfRj = new PzTextField();
            this.mainPanel.add((Component)this.tfRj, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 25), 0, 0));
            this.tfRj.setEditable(false);
            this.tfRj.setFocusable(false);
            this.tfNazivRj = new PzTextField();
            this.mainPanel.add((Component)this.tfNazivRj, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfNazivRj.setEditable(false);
            this.tfNazivRj.setFocusable(false);
            this.pnlPeriod = new PzPanel();
            GridBagLayout pnlPeriodLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPeriod, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlPeriodLayout.rowWeights = new double[]{0.0, 0.0};
            pnlPeriodLayout.rowHeights = new int[]{7, 7};
            pnlPeriodLayout.columnWeights = new double[]{0.0, 0.1};
            pnlPeriodLayout.columnWidths = new int[]{101, 7};
            this.pnlPeriod.setLayout((LayoutManager)pnlPeriodLayout);
            this.pnlPeriod.setBorder((Border)BorderFactory.createTitledBorder("Period pregleda"));
            this.pnlPeriod.setOpaque(false);
            this.lblPocetni = new JLabel();
            this.pnlPeriod.add((Component)this.lblPocetni, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.lblPocetni.setText("Po\u010detni datum");
            this.lblKrajnji = new JLabel();
            this.pnlPeriod.add((Component)this.lblKrajnji, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.lblKrajnji.setText("Krajnji datum");
            this.dfPocetni = new PzDateField();
            this.pnlPeriod.add((Component)this.dfPocetni, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.dfKrajnji = new PzDateField();
            this.pnlPeriod.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 20), 0, 0));
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{SVI_MAGACINI, ODREDJENI_MAGACIN});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBs2Layout);
            this.mainPanel.add(this.panelRbs1, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder("Poreklo podataka"));
            this.panelRbs1.setSelectedValue((Object)SVI_MAGACINI);
            this.panelRbs1.setOpaque(false);
            this.panelRbs2 = new PzRadioGroup((Object[])new String[]{DETALJNO, ZBIRNO});
            panelRBs2Layout = new BoxLayout((Container)this.panelRbs2, 1);
            this.panelRbs2.setLayout((LayoutManager)panelRBs2Layout);
            this.mainPanel.add(this.panelRbs2, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs2.setBorder((Border)BorderFactory.createTitledBorder("Izgled informacije"));
            this.panelRbs2.setSelectedValue((Object)DETALJNO);
            this.panelRbs2.setOpaque(false);
            this.pnlValute = new PzPanel();
            GridBagLayout pnlValuteLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlValute, (Object)new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.pnlValute.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValute.setOpaque(false);
            pnlValuteLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.rowHeights = new int[]{7, 7, 7};
            pnlValuteLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlValute.setLayout((LayoutManager)pnlValuteLayout);
            this.cbValute = new PzComboBox();
            this.pnlValute.add((Component)this.cbValute, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 150, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(745, 227);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.mainPanel.validateForm(true)) {
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            if (actionCommand.equals("potvrdi")) {
                String listaRj;
                if (((String)this.panelRbs1.getSelectedValue()).equals(ODREDJENI_MAGACIN)) {
                    this.rj = PzDialogRJ.getRJ((PzDialog)this);
                    if (this.rj == null) {
                        return;
                    }
                }
                if ((listaRj = PzDialogRJ.getAvaliableRjString()).equals("")) {
                    throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                }
                final EntityManager em = PzEntityManager.getEm();
                PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        em.getTransaction().begin();
                        if (PzDialogPregledNabavkeDobavljaca.this.cursor != null) {
                            PzDialogPregledNabavkeDobavljaca.this.cursor.close();
                        }
                        String upit = "";
                        Query q = null;
                        String valuta = PzDialogPregledNabavkeDobavljaca.this.cbValute.getSelectedChoice().getValue().toString();
                        if (((String)PzDialogPregledNabavkeDobavljaca.this.panelRbs2.getSelectedValue()).equals(PzDialogPregledNabavkeDobavljaca.DETALJNO)) {
                            upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina),ad1.nabCena%valuta%, ad1.procRabata, d1.oznDokumenta FROM Radnajedinica rj,  (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.nabCena = ad2.nabCena ELSE ad1.prodCena = ad2.prodCena END WHERE %valutaW% d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND d1.tip IN ('%tipK%') AND rj.oznRj IN (%listaRj%) and d1.storno = 0 and d1.arhiviran = 1 AND d1.sfrKomitent =':komitent' AND d1.datum >= ':datumOd' AND d1.datum<= ':datumDo' ";
                            if (((String)PzDialogPregledNabavkeDobavljaca.this.panelRbs1.getSelectedValue()).equals(PzDialogPregledNabavkeDobavljaca.ODREDJENI_MAGACIN)) {
                                upit = String.valueOf(upit) + " and rj.oznRj=':oznRj' and rj.oznOgranak=':ogranakRj' ";
                                upit = upit.replace(":oznRj", PzDialogPregledNabavkeDobavljaca.this.rj.getId().getOznRj());
                                upit = upit.replace(":ogranakRj", PzDialogPregledNabavkeDobavljaca.this.rj.getId().getOznOgranak());
                            }
                            upit = upit.replace(":datumOd", PzDialogPregledNabavkeDobavljaca.this.dfPocetni.getVal().toString());
                            upit = upit.replace(":datumDo", PzDialogPregledNabavkeDobavljaca.this.dfKrajnji.getVal().toString());
                            upit = upit.replace(":komitent", PzDialogPregledNabavkeDobavljaca.this.entKomitent.getSfrKomitent());
                            upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, ad1.kolicina, ad1.nabCena, ad1.procRabata, d1.oznDokumenta %valutaG%  ORDER BY ad1.sfrSort";
                            upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                            upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ", kurs.srednji, kurs.jedinica");
                            upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                            upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                            upit = upit.replace("%listaRj%", listaRj);
                            upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                        } else if (((String)PzDialogPregledNabavkeDobavljaca.this.panelRbs2.getSelectedValue()).equals(PzDialogPregledNabavkeDobavljaca.ZBIRNO)) {
                            upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina), sum(ad1.kolicina*ad1.nabCena)%valuta%, sum(ad2.kolicina*ad2.nabCena)%valuta% FROM Radnajedinica rj,  (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.nabCena = ad2.nabCena ELSE ad1.prodCena = ad2.prodCena END WHERE %valutaW% d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND d1.tip IN ('%tipK%') AND rj.oznRj IN (%listaRj%) and d1.storno = 0 and d1.arhiviran = 1 AND d1.datum>=':datumOd'  AND d1.datum<=':datumDo' AND d1.sfrKomitent = ':komitent'";
                            if (((String)PzDialogPregledNabavkeDobavljaca.this.panelRbs1.getSelectedValue()).equals(PzDialogPregledNabavkeDobavljaca.ODREDJENI_MAGACIN)) {
                                upit = String.valueOf(upit) + " and rj.oznRj=':oznRj' and rj.oznOgranak=':oznOgranak' ";
                                upit = upit.replace(":oznRj", PzDialogPregledNabavkeDobavljaca.this.rj.getId().getOznRj());
                                upit = upit.replace(":oznOgranak", PzDialogPregledNabavkeDobavljaca.this.rj.getId().getOznOgranak());
                            }
                            upit = upit.replace(":datumOd", PzDialogPregledNabavkeDobavljaca.this.dfPocetni.getVal().toString());
                            upit = upit.replace(":datumDo", PzDialogPregledNabavkeDobavljaca.this.dfKrajnji.getVal().toString());
                            upit = upit.replace(":komitent", PzDialogPregledNabavkeDobavljaca.this.entKomitent.getSfrKomitent());
                            upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv ORDER BY ad1.sfrSort";
                            upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                            upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                            upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                            upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                            upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                            upit = upit.replace("%listaRj%", listaRj);
                        }
                        q = em.createNativeQuery(upit);
                        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                        PzDialogPregledNabavkeDobavljaca.this.cursor = (ScrollableCursor)q.getSingleResult();
                        System.out.println("Kursor je nasao faktura" + PzDialogPregledNabavkeDobavljaca.this.cursor.size());
                        em.getTransaction().commit();
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            if (PzDialogPregledNabavkeDobavljaca.this.cursor.size() == 0) {
                                JOptionPane.showMessageDialog(PzDialogPregledNabavkeDobavljaca.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                                return;
                            }
                            try {
                                PzDialogPregledNabavkeDobavljaca.this.showReports();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPregledNabavkeDobavljaca.this), (Throwable)e);
                            }
                        }
                        finally {
                            em.close();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                };
                worker.execute();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "PREGLED NABAVKE ARTIKALA OD DOBAVLJA\u010cA: [ " + this.entKomitent.getSfrKomitent() + " ] " + this.entKomitent.getNaziv();
        String subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnji.getVal());
        String fname = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValute.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValute.getSelectedChoice().getText());
        fname = ((String)this.panelRbs2.getSelectedValue()).equals(DETALJNO) ? "rs/pezar/analitike/resource/reports/compiled/nabavka.dobavljaca.detaljno.jasper" : "rs/pezar/analitike/resource/reports/compiled/prodaja.kupcu.zbirno.jasper";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", subtitle);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            if (this.entKomitent != null) {
                this.tfSifra.setVal((Object)this.entKomitent.getSfrKomitent());
                this.tfNaziv.setVal((Object)this.entKomitent.getNaziv());
            }
        }
    }
}

