/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez.popdv.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rs.pezar.analitike.gui.porez.popdv.form.Red;
import rs.pezar.analitike.gui.porez.popdv.form.Vrednost;

public class Grupa {
    private String id;
    private String naziv;
    private List<Grupa> podgrupe;
    private Grupa nadgrupa;
    private List<Red> redovi;
    private Vrednost vrednost;

    public Grupa(String id, int brRedova, int brKolona) {
        this.id = id;
        this.podgrupe = new ArrayList<Grupa>();
        this.redovi = new ArrayList<Red>();
        int i = 0;
        while (i < brRedova) {
            Red red = new Red(String.valueOf(i + 1));
            int j = 0;
            while (j < brKolona) {
                red.addVrednost(new Vrednost(String.valueOf(j + 1), BigDecimal.ZERO));
                ++j;
            }
            this.addRed(red);
            ++i;
        }
    }

    public Grupa(String id, BigDecimal iznos) {
        this(id, 0, 0);
        this.vrednost = new Vrednost("", iznos);
    }

    public Grupa(String id) {
        this(id, 0, 0);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public List<Red> getRedovi() {
        return this.redovi;
    }

    public void setRedovi(List<Red> redovi) {
        this.redovi = redovi;
    }

    public Vrednost getVrednost() {
        return this.vrednost;
    }

    public void setVrednost(Vrednost vrednost) {
        this.vrednost = vrednost;
    }

    public void addRed(Red red) {
        this.redovi.add(red);
    }

    public void addRed(int redId, BigDecimal ... vrednosti) {
        this.addRed(new Red(redId, vrednosti));
    }

    public void setRed(int redId, BigDecimal ... vrednosti) {
        for (Red red : this.redovi) {
            if (!red.getId().equals(String.valueOf(redId))) continue;
            red.getVrednosti().clear();
            int i = 0;
            while (i < vrednosti.length) {
                red.addVrednost(new Vrednost(String.valueOf(i + 1), vrednosti[i]));
                ++i;
            }
        }
    }

    public void setRed(int redId, Red noviRed) {
        noviRed.setId(String.valueOf(redId));
        int redIndex = 0;
        for (Red red : this.redovi) {
            if (!noviRed.getId().equals(red.getId())) continue;
            redIndex = this.redovi.indexOf(red);
        }
        this.redovi.set(redIndex, noviRed);
    }

    public void setSumarniRed(int redId, Red ... redovi) {
        Red red = this.getRed(redId);
        red.setSumarni(true);
        int i = 0;
        while (i < redovi.length) {
            Vrednost v2;
            if (red.getVrednosti().size() == 1) {
                int j = 0;
                while (j < redovi[i].getVrednosti().size()) {
                    red.getVrednosti().get(0).addAndBind(redovi[i].getVrednosti().get(j));
                    ++j;
                }
            } else if (red.getVrednosti().size() == redovi[i].getVrednosti().size()) {
                int k = 0;
                while (k < red.getVrednosti().size()) {
                    Vrednost v1 = red.getVrednosti().get(k);
                    v2 = redovi[i].getVrednosti().get(k);
                    v1.addAndBind(v2);
                    ++k;
                }
            } else {
                for (Vrednost v1 : redovi[i].getVrednosti()) {
                    v2 = red.getVrednost(v1.getId());
                    if (v2 == null) continue;
                    v2.addAndBind(v1);
                }
            }
            ++i;
        }
    }

    public Red getRed(int redId) {
        Red red = null;
        Iterator<Red> iterator = this.getRedovi().iterator();
        while (iterator.hasNext() && red == null) {
            Red tmp = iterator.next();
            if (!String.valueOf(redId).equals(tmp.getId())) continue;
            red = tmp;
        }
        return red;
    }

    public List<Grupa> getPodgrupe() {
        return this.podgrupe;
    }

    public void setPodgrupe(List<Grupa> podgrupe) {
        this.podgrupe = podgrupe;
    }

    public Grupa getNadgrupa() {
        return this.nadgrupa;
    }

    public void setNadgrupa(Grupa nadgrupa) {
        this.nadgrupa = nadgrupa;
    }

    public void addPodgrupa(Grupa podgrupa) {
        this.podgrupe.add(podgrupa);
        podgrupa.nadgrupa = this;
    }
}

