/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.analitike.gui.porez.PzDialogKnjigaIzdatihRacuna;
import rs.pezar.analitike.gui.porez.core.Porez;
import rs.pezar.analitike.gui.porez.datasources.AdapterKnjigaPrimljenihRacuna;
import rs.pezar.db.PzEntityManager;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogKnjigaPrimljenihRacuna
extends PzDialog {
    private final PzPanel pzPanel = new PzPanel();
    private final PzDateField dfPocetniDatum = new PzDateField();
    private final PzDateField dfKrajnjiDatum = new PzDateField();
    private final JLabel lblPoetniDatum = new JLabel("Po\u010detni datum:");
    private final JLabel lblKrajnjiDatum = new JLabel("Krajnji datum:");
    private final PzButton pzbtnOk = new PzButton();
    private final PzButton pzbtnOdustani = new PzButton();
    private EntityManager em;
    private ScrollableCursor cursor;
    private PzBusyPainterUI layerUI;
    private JXLayer<PzPanel> layer;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setSize(423, 239);
                PzDialogKnjigaIzdatihRacuna inst = new PzDialogKnjigaIzdatihRacuna(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKnjigaPrimljenihRacuna(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Knjiga primljenih ra\u010duna");
        this.getContentPane().add((Component)this.pzPanel, "Center");
        GridBagLayout gbl_pzPanel = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 39;
        nArray[1] = 128;
        nArray[2] = 89;
        nArray[3] = 109;
        nArray[4] = 51;
        gbl_pzPanel.columnWidths = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 80;
        nArray2[1] = 25;
        nArray2[2] = 31;
        nArray2[3] = 25;
        nArray2[4] = 30;
        gbl_pzPanel.rowHeights = nArray2;
        gbl_pzPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pzPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pzPanel.setLayout((LayoutManager)gbl_pzPanel);
        this.pzPanel.setPreferredSize(new Dimension(416, 197));
        GridBagConstraints gbc_lblPoetniDatum = new GridBagConstraints();
        gbc_lblPoetniDatum.fill = 2;
        gbc_lblPoetniDatum.insets = new Insets(0, 0, 5, 5);
        gbc_lblPoetniDatum.gridx = 1;
        gbc_lblPoetniDatum.gridy = 1;
        this.pzPanel.add((Component)this.lblPoetniDatum, (Object)gbc_lblPoetniDatum);
        GridBagConstraints gbc_dfPocetniDatum = new GridBagConstraints();
        gbc_dfPocetniDatum.anchor = 18;
        gbc_dfPocetniDatum.insets = new Insets(0, 0, 5, 5);
        gbc_dfPocetniDatum.gridx = 3;
        gbc_dfPocetniDatum.gridy = 1;
        this.pzPanel.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        GridBagConstraints gbc_lblKrajnjiDatum = new GridBagConstraints();
        gbc_lblKrajnjiDatum.fill = 2;
        gbc_lblKrajnjiDatum.insets = new Insets(0, 0, 5, 5);
        gbc_lblKrajnjiDatum.gridx = 1;
        gbc_lblKrajnjiDatum.gridy = 2;
        this.pzPanel.add((Component)this.lblKrajnjiDatum, (Object)gbc_lblKrajnjiDatum);
        this.pzbtnOk.setText("Ok");
        this.pzbtnOk.addActionListener((ActionListener)((Object)this));
        this.pzbtnOdustani.setText("Odustani");
        this.pzbtnOdustani.addActionListener((ActionListener)((Object)this));
        GridBagConstraints gbc_dfKrajnjiDatum = new GridBagConstraints();
        gbc_dfKrajnjiDatum.anchor = 18;
        gbc_dfKrajnjiDatum.insets = new Insets(0, 0, 5, 5);
        gbc_dfKrajnjiDatum.gridx = 3;
        gbc_dfKrajnjiDatum.gridy = 2;
        this.pzPanel.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        GridBagConstraints gbc_pzbtnOdustani = new GridBagConstraints();
        gbc_pzbtnOdustani.fill = 1;
        gbc_pzbtnOdustani.insets = new Insets(0, 0, 0, 5);
        gbc_pzbtnOdustani.gridx = 3;
        gbc_pzbtnOdustani.gridy = 4;
        this.pzPanel.add((Component)this.pzbtnOdustani, (Object)gbc_pzbtnOdustani);
        GridBagConstraints gbc_pzbtnOk = new GridBagConstraints();
        gbc_pzbtnOk.fill = 1;
        gbc_pzbtnOk.gridx = 4;
        gbc_pzbtnOk.gridy = 4;
        this.pzPanel.add((Component)this.pzbtnOk, (Object)gbc_pzbtnOk);
        this.layerUI = new PzBusyPainterUI();
        this.layer = new JXLayer((Component)this.pzPanel, (LayerUI)this.layerUI);
        this.getContentPane().add((Component)this.layer, "Center");
        this.pack();
    }

    private void showReport() {
        String pregl = "rs/pezar/reports/compiled/pregled.kir.jasper";
        String dokumenta = "'" + TipDokumentConfig.get().KALKULACIJA + "'," + "'" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "'," + "'" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA + "'," + "'" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA + "'," + "'" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "'," + "'" + TipDokumentConfig.get().TROSAK + "'";
        String podtip = "'" + TipDokumentConfig.get().OTPREMNICA + "', 'INTERNI', 'Kupac'";
        String que = String.format(Porez.queueUlazniPorez, dokumenta, podtip, " ", this.dfPocetniDatum.getVal(), this.dfKrajnjiDatum.getVal(), " ", " ");
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        Vector data = new Vector();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, this.cursor);
        datasource.setAdapter((PzDataSourceAdapter)new AdapterKnjigaPrimljenihRacuna(false));
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)pregl, params, (String)"knjigaPrimljenihRacuna");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.pzbtnOk)) {
            SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    PzDialogKnjigaPrimljenihRacuna.this.layerUI.setLocked(true);
                    PzDialogKnjigaPrimljenihRacuna.this.showReport();
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    PzDialogKnjigaPrimljenihRacuna.this.layerUI.setLocked(false);
                }
            };
            sw.execute();
        } else if (e.getSource().equals(this.pzbtnOdustani)) {
            this.dispose();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKnjigaIzdatihRacuna(Boolean.FALSE);
    }

    public PzDialogKnjigaPrimljenihRacuna(Boolean initGUI) {
    }
}

