/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pocetnaStanja;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.pocetnaStanja.pocetnoStanjeAvansa.Dodavanje;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPocetnoStanjeAvansa
extends PzDialog {
    private PzPanel pnlTabela;
    private JToolBar toolbar;
    private PzCalculatedField dfSaldoDobavljaca;
    private PzTable tabelaAvansi;
    private JScrollPane scrollPane;
    private JLabel lblSaldoDobavljaca;
    private PzCalculatedField dfSaldoKupca;
    private JLabel lblSaldoKupca;
    private PzPanel pnlInfo;
    private ScrollableCursor cursor;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnBrisiSve;
    private List<Taksaopstidokument> taksas;
    private PzToolBarIcon icnStampanje;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogPocetnoStanjeAvansa(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initializeTable();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Po\u010detno stanje avansa");
            this.pnlTabela = new PzPanel();
            this.pnlTabela.setPaintGradient(true);
            GridBagLayout pnlTabelaLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlTabela, "Center");
            this.pnlTabela.setPreferredSize(new Dimension(592, 221));
            pnlTabelaLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlTabelaLayout.rowHeights = new int[]{94, 49, 7, 7};
            pnlTabelaLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlTabelaLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlTabela.setLayout((LayoutManager)pnlTabelaLayout);
            this.scrollPane = new JScrollPane();
            this.pnlTabela.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tabelaAvansi = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabelaAvansi);
            this.tabelaAvansi.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Uplata dok = (Uplata)entity;
                    BigDecimal pdv = new BigDecimal(0);
                    Vector taksa = (Vector)dok.getTaksaopstidokuments();
                    if (taksa != null & taksa.size() != 0) {
                        for (Taksaopstidokument to : taksa) {
                            if (!to.getVrsta().equals("PDV")) continue;
                            pdv = pdv.add(to.getIznos());
                        }
                    }
                    BigDecimal kupac = dok.getTip().equals(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS) ? dok.getIznosSaPorezom() : new BigDecimal(0.0);
                    BigDecimal dobavljac = dok.getTip().equals(TipDokumentConfig.get().UPLATA_DAT_AVANS) ? dok.getIznosSaPorezom() : new BigDecimal(0.0);
                    return new Object[]{dok.getKomitent().getSfrKomitent(), dok.getOznDokumenta(), kupac, dobavljac, pdv, dok.getKomitent().getNaziv()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Av.ra\u010dun", "Kupac", "Dobavlja\u010d", "Pdv", "Naziv komitenta"};
                }
            });
            this.pnlInfo = new PzPanel();
            this.pnlTabela.add((Component)this.pnlInfo, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlInfoLayout = new GridBagLayout();
            pnlInfoLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlInfoLayout.rowHeights = new int[]{12, 25, 7};
            pnlInfoLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlInfoLayout.columnWidths = new int[]{104, 130, 134, 130, 7};
            this.pnlInfo.setLayout((LayoutManager)pnlInfoLayout);
            this.pnlInfo.setOpaque(false);
            this.lblSaldoKupca = new JLabel();
            this.pnlInfo.add((Component)this.lblSaldoKupca, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSaldoKupca.setName("lblSaldoKupca");
            this.lblSaldoKupca.setFont(new Font("Tahoma", 1, 12));
            this.dfSaldoKupca = this.tabelaAvansi.createExpresionField("$2$");
            this.pnlInfo.add((Component)this.dfSaldoKupca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSaldoKupca.setFocusable(false);
            this.dfSaldoKupca.setFont(new Font("Tahoma", 1, 12));
            this.dfSaldoKupca.setForeground(new Color(0, 0, 255));
            this.lblSaldoDobavljaca = new JLabel();
            this.pnlInfo.add((Component)this.lblSaldoDobavljaca, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSaldoDobavljaca.setName("lblSaldoDobavljaca");
            this.lblSaldoDobavljaca.setFont(new Font("Tahoma", 1, 12));
            this.dfSaldoDobavljaca = this.tabelaAvansi.createExpresionField("$3$");
            this.pnlInfo.add((Component)this.dfSaldoDobavljaca, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSaldoDobavljaca.setFocusable(false);
            this.dfSaldoDobavljaca.setFont(new Font("Tahoma", 1, 12));
            this.dfSaldoDobavljaca.setForeground(new Color(0, 0, 255));
            this.toolbar = new JToolBar();
            this.pnlTabela.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INSERT)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_new.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnDodavanje.setPreferredSize(new Dimension(70, 80));
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnIzmena.setPreferredSize(new Dimension(70, 80));
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(DELETE)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_delete.png")));
            this.icnBrisanje.setActionCommand("brisi");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(70, 80));
            this.icnStampanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampanje);
            this.icnStampanje.setText("\u0160tampanje|(Alt+S)");
            this.icnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampanje.setActionCommand("stampa");
            this.icnStampanje.addActionListener((ActionListener)((Object)this));
            this.icnStampanje.setShortcut("Alt+s");
            this.icnStampanje.setPreferredSize(new Dimension(90, 80));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(906, 609);
            this.setMinimumSize(new Dimension(906, 609));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            if (actionCommand.equals("dodavanje")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("tabela", (Object)this.tabelaAvansi);
                this.showDialog(Dodavanje.class);
                this.refresh();
            } else if (actionCommand.equals("izmena")) {
                this.getSession().putParameter("tabela", (Object)this.tabelaAvansi);
                if (this.tabelaAvansi.getSelectedRow() != -1) {
                    this.getSession().putParameter("update", (Object)true);
                    this.showDialog(Dodavanje.class);
                }
            } else if (actionCommand.equals("brisi")) {
                this.tabelaAvansi.removeSelectedEntity(true, true);
                this.refresh();
            } else if (actionCommand.equals("stampa")) {
                this.showReport();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void refresh() {
        this.brDok.setText(String.valueOf(this.tabelaAvansi.getRowCount()));
    }

    public void initializeTable() {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"U\u010ditavanje podataka je u toku. Molim sa\u010dekajte.", (PzDialog)this);
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                String upit = "";
                Query q = null;
                FetchGroup grp = new FetchGroup();
                grp.addAttribute("komitent.sfrKomitent");
                grp.addAttribute("oznDokumenta");
                grp.addAttribute("iznos");
                grp.addAttribute("taksaopstidokuments");
                grp.addAttribute("komitent.naziv");
                ArrayList<String> tipovi = new ArrayList<String>();
                tipovi.add(TipDokumentConfig.get().UPLATA_DAT_AVANS);
                tipovi.add(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS);
                upit = "SELECT u FROM Uplata u join fetch u.komitent WHERE  u.arhiviran=1 and u.tip in :tipovi and u.podTip=:podtip ORDER BY u.tip, u.komitent.sfrKomitent";
                q = em.createQuery(upit);
                q.setParameter("tipovi", tipovi);
                q.setParameter("podtip", (Object)"POCETNO");
                List data1 = q.getResultList();
                em.getTransaction().commit();
                return data1;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List data = (List)this.get();
                        if (data.size() != 0) {
                            PzDialogPocetnoStanjeAvansa.this.tabelaAvansi.setData(data, Uplata.class);
                            PzDialogPocetnoStanjeAvansa.this.tabelaAvansi.calculateFields();
                            PzDialogPocetnoStanjeAvansa.this.brDok.setText(String.valueOf(data.size()));
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPocetnoStanjeAvansa.this), (Throwable)e);
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        sw.execute();
    }

    public void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tabelaAvansi, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Date today = PzDateUtility.getCurrentDate();
            params.put("title", "PO\u010cETNO STANJE AVANSA");
            params.put("datum", today);
            params.put("reklama", "");
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/pocetno.stanje.avansa.jasper"), params, (String)"PO\u010cETNO STANJE AVANSA");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPocetnoStanjeAvansa(Boolean.FALSE);
    }

    public PzDialogPocetnoStanjeAvansa(Boolean initGUI) {
    }
}

