/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti.obracunKamate;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import rs.pezar.analitike.gui.komitenti.obracunKamate.ObracunKamateFakturaStavka;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Kamatnastopa;

public class ObracunKamateFaktura {
    private Vector<ObracunKamateFakturaStavka> listaStavkiZaFakturu;
    private Vector<Kamatnastopa> kamStope;
    private PzDokument dokument;
    private Vector<PzDokument> uplate;
    private int krajnjiDan;
    private int krajnjiMesec;
    private int krajnjiGodina;
    private int pocetniDan;
    private int pocetniMesec;
    private int pocetniGodina;
    private Integer metod;
    private boolean kamataNaKamatu = false;
    private BigDecimal ukupnaKamata = BigDecimal.ZERO;
    private SimpleDateFormat simpleDateformatgodina;
    private SimpleDateFormat simpleDateformatMesec;
    private SimpleDateFormat simpleDateformatDan;

    public ObracunKamateFaktura(PzDokument faktura, Vector<PzDokument> uplateZaFakturu, Vector<Kamatnastopa> kamStopa, Date krajnjiDatum, Integer metod, Date pocetniDatum) throws Exception {
        this.dokument = faktura;
        this.kamStope = kamStopa;
        this.uplate = uplateZaFakturu;
        this.simpleDateformatgodina = new SimpleDateFormat("yyyy");
        this.simpleDateformatMesec = new SimpleDateFormat("MM");
        this.simpleDateformatDan = new SimpleDateFormat("dd");
        this.krajnjiDan = Integer.parseInt(this.simpleDateformatDan.format(krajnjiDatum));
        this.krajnjiMesec = Integer.parseInt(this.simpleDateformatMesec.format(krajnjiDatum));
        this.krajnjiGodina = Integer.parseInt(this.simpleDateformatgodina.format(krajnjiDatum));
        if (pocetniDatum == null) {
            this.pocetniDan = Integer.parseInt(this.simpleDateformatDan.format(faktura.getDatValute()));
            this.pocetniMesec = Integer.parseInt(this.simpleDateformatMesec.format(faktura.getDatValute()));
            this.pocetniGodina = Integer.parseInt(this.simpleDateformatgodina.format(faktura.getDatValute()));
        } else if (pocetniDatum.after(faktura.getDatValute())) {
            this.pocetniDan = Integer.parseInt(this.simpleDateformatDan.format(pocetniDatum));
            this.pocetniMesec = Integer.parseInt(this.simpleDateformatMesec.format(pocetniDatum));
            this.pocetniGodina = Integer.parseInt(this.simpleDateformatgodina.format(pocetniDatum));
        } else {
            this.pocetniDan = Integer.parseInt(this.simpleDateformatDan.format(faktura.getDatValute()));
            this.pocetniMesec = Integer.parseInt(this.simpleDateformatMesec.format(faktura.getDatValute()));
            this.pocetniGodina = Integer.parseInt(this.simpleDateformatgodina.format(faktura.getDatValute()));
        }
        this.listaStavkiZaFakturu = new Vector();
        this.stvoriListuStavki();
        this.ubaciUplate(uplateZaFakturu);
        this.preracunajKoeficjente(metod);
        this.preracunajKamatu();
        int i = 0;
        while (i < this.listaStavkiZaFakturu.size()) {
            if (this.listaStavkiZaFakturu.get(i).getBrojDana() == 0) {
                this.listaStavkiZaFakturu.remove(i);
            }
            ++i;
        }
    }

    private boolean stvoriListuStavki() throws Exception {
        ObracunKamateFakturaStavka stavka = null;
        int tempMesec = this.pocetniMesec;
        int tempGodina = this.pocetniGodina;
        GregorianCalendar cal = new GregorianCalendar(this.pocetniGodina, this.pocetniMesec - 1, 1);
        while (true) {
            tempGodina = cal.get(1);
            tempMesec = cal.get(2) + 1;
            Vector<Kamatnastopa> temp = this.uzmiKamatneStopeZaMesec(tempMesec, tempGodina);
            if (temp == null) {
                throw new Exception("Za mesec " + tempMesec + " godina " + tempGodina + " ne postoji definisana kamatna stopa");
            }
            int i = 0;
            while (i < temp.size()) {
                if (!(temp.get(i).getId().getMesec() == this.krajnjiMesec && temp.get(i).getId().getGodina() == this.krajnjiGodina && temp.get(i).getId().getPocetni() > this.krajnjiDan || temp.get(i).getId().getMesec() == this.pocetniMesec && temp.get(i).getId().getGodina() == this.pocetniGodina && temp.get(i).getId().getKrajnji() < this.pocetniDan)) {
                    stavka = new ObracunKamateFakturaStavka(temp.get(i));
                    stavka.setBrojFakture(this.dokument.getOznDokumenta());
                    stavka.setIznosFakture(this.dokument.getIznos().subtract(this.dokument.getStornoIznos()));
                    stavka.setDatumDospeca(this.dokument.getDatum());
                    stavka.setDatumValute(this.dokument.getDatValute());
                    this.listaStavkiZaFakturu.add(stavka);
                }
                ++i;
            }
            if (this.krajnjiGodina == tempGodina && this.krajnjiMesec == tempMesec) break;
            if (tempMesec - 1 == 11) {
                ((Calendar)cal).roll(1, true);
            }
            ((Calendar)cal).roll(2, true);
        }
        if (this.listaStavkiZaFakturu.size() != 0 && this.listaStavkiZaFakturu != null) {
            this.listaStavkiZaFakturu.get(0).setOdDana(this.pocetniDan);
            this.listaStavkiZaFakturu.get(this.listaStavkiZaFakturu.size() - 1).setDoDana(this.krajnjiDan);
        }
        return true;
    }

    private void ubaciUplate(Vector<PzDokument> uplate) {
        int i = 0;
        while (i < uplate.size()) {
            this.ubaciUplatu(uplate.get(i));
            ++i;
        }
    }

    private void ubaciUplatu(PzDokument uplata) {
        int danUplate = Integer.parseInt(this.simpleDateformatDan.format(uplata.getDatum()));
        int mesecUplata = Integer.parseInt(this.simpleDateformatMesec.format(uplata.getDatum()));
        int godinaUplate = Integer.parseInt(this.simpleDateformatgodina.format(uplata.getDatum()));
        int i = 0;
        while (i < this.listaStavkiZaFakturu.size()) {
            ObracunKamateFakturaStavka stavka = this.listaStavkiZaFakturu.get(i);
            if (mesecUplata == stavka.getMesec() && godinaUplate == stavka.getGodina() && stavka.getOdDana() <= danUplate && stavka.getDoDana() >= danUplate) {
                ObracunKamateFakturaStavka stavkaTemp = stavka.clone();
                stavkaTemp.setIznosUplate(uplata.getIznos());
                stavka.setDoDana(danUplate);
                stavkaTemp.setOdDana(danUplate + 1);
                this.listaStavkiZaFakturu.add(i + 1, stavkaTemp);
                break;
            }
            ++i;
        }
    }

    public Vector<Kamatnastopa> uzmiKamatneStopeZaMesec(int mesec, int godina) {
        Vector<Kamatnastopa> temp = new Vector<Kamatnastopa>();
        int i = 0;
        while (i < this.kamStope.size()) {
            Kamatnastopa kamstopa = this.kamStope.get(i);
            if (kamstopa.getId().getMesec() == mesec && kamstopa.getId().getGodina() == godina) {
                temp.add(this.kamStope.get(i));
            }
            ++i;
        }
        if (temp.size() == 0) {
            return null;
        }
        return temp;
    }

    private void preracunajKamatu() {
        BigDecimal kamata = BigDecimal.ZERO;
        if (this.listaStavkiZaFakturu.size() == 0) {
            return;
        }
        BigDecimal osnovica = this.listaStavkiZaFakturu.get(0).getIznosFakture();
        int i = 0;
        while (i < this.listaStavkiZaFakturu.size()) {
            ObracunKamateFakturaStavka stavka = this.listaStavkiZaFakturu.get(i);
            osnovica = osnovica.subtract(stavka.getIznosUplate());
            stavka.setOsnovica(osnovica);
            kamata = osnovica.multiply(stavka.getKoeficijent());
            this.ukupnaKamata = this.ukupnaKamata.add(kamata);
            stavka.setKamata(kamata);
            ++i;
        }
    }

    private void preracunajKoeficjente(Integer metod) {
        int i = 0;
        while (i < this.listaStavkiZaFakturu.size()) {
            ObracunKamateFakturaStavka stavka = this.listaStavkiZaFakturu.get(i);
            stavka.preracunajKoeficijente(metod);
            ++i;
        }
    }

    public Vector<ObracunKamateFakturaStavka> getListaStavki() {
        return this.listaStavkiZaFakturu;
    }

    public void printstatus() {
        if (this.listaStavkiZaFakturu != null && !this.listaStavkiZaFakturu.isEmpty()) {
            this.listaStavkiZaFakturu.get(0).printInfoHeader();
        }
        int i = 0;
        while (i < this.listaStavkiZaFakturu.size()) {
            this.listaStavkiZaFakturu.get(i).printInfo();
            ++i;
        }
    }

    public BigDecimal getUkupnaKamata() {
        return this.ukupnaKamata;
    }

    public void setUkupnaKamata(BigDecimal ukupnaKamata) {
        this.ukupnaKamata = ukupnaKamata;
    }
}

