/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.IzborKomitenta;
import rs.pezar.analitike.tableModels.PzTableModelKarticaFakturaIUplata;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzScrollableTable;

public class PzDialogKarticaFakturaUplata
extends IzborKomitenta {
    private static final long serialVersionUID = 1L;
    private String rtitle;
    private PzScrollableTable table;
    private Komitent komitent;
    private ScrollableCursor cursor;
    private static final String[] uplata = new String[]{"Virman %s", "Upl.ovl.po %s", "Upl. cek po %s", "Upl. komp.po %s", "Mult.komp. %s", "Ces.po %s", "Upl.menicom %s", "Got.upl. po %s", "Upl.av.po %s"};

    public PzDialogKarticaFakturaUplata(Boolean initGUI) {
        super(initGUI);
    }

    public PzDialogKarticaFakturaUplata(JFrame frame) {
        super(frame);
    }

    private int fillInTheInfo() {
        String dokumenta;
        String uplata;
        Query q = null;
        String baseQuery = new String("SELECT \ta.iddok, \ta.tip, \ta.datum, \ta.ozndokumenta, \ta.iznos, \ta.stornoIznos , \t%s ,\ta.storno, \t0.00, \ta.podtip, \t0.00, \tc.datum AS dat FROM \tdokument a, dokument b, dokument c WHERE \t%s AND a.arhiviran = 1 AND a.storno = 0 AND a.sfrkomitent = '" + this.getKomitent().getSfrKomitent() + "' AND a.arhiviran = '1' AND b.ozndokumenta = a.ozndokumenta AND b.sfrKomitent = a.sfrKomitent " + "\tAND (c.ozndokumenta = a.ozndokumenta AND ( %s ) AND c.storno = 0 )  " + " \t%s " + "GROUP BY " + "a.iddok," + "a.iddok," + "a.tip, " + "a.datum, " + "a.ozndokumenta, " + "a.iznos, " + "a.stornoIznos," + "a.storno, " + "a.podtip," + "c.datum " + "ORDER BY " + "\tdat, a.oznDokumenta, a.tip");
        EntityManager em = PzEntityManager.getEm();
        if (this.isDobavljac()) {
            uplata = "SUM( CASE \t\tWHEN b.tip = '" + TipDokumentConfig.get().UPLATA_DOBAVLJACU + "' THEN -b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().PRENOS_NA_FAKTURU_DOBAVLJAC + "' THEN -b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' THEN -b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().UPLATA_DOBAVLJACU_POVRACAJ + "' THEN b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().PRENOS_SA_FAKTURE_DOBAVLJAC + "' THEN b.iznos " + "\t\tELSE 0 " + "\t\tEND)";
            dokumenta = "(a.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "' OR " + "a.tip = '" + TipDokumentConfig.get().TROSAK + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_DOBAVLJACU + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_DOBAVLJACU_POVRACAJ + "' OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_SA_FAKTURE_DOBAVLJAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_NA_FAKTURU_DOBAVLJAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' OR " + "(a.tip = '" + TipDokumentConfig.get().KALKULACIJA + "' AND a.podtip = '" + TipDokumentConfig.get().FAKTURA + "'))";
            String nadjiDatumu = "c.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "' OR " + "(c.tip = '" + TipDokumentConfig.get().KALKULACIJA + "' AND c.podtip = '" + TipDokumentConfig.get().FAKTURA + "') OR " + "c.tip = '" + TipDokumentConfig.get().TROSAK + "'";
            String datumi = this.isPrikazUPeriodu() ? " AND a.datum >= '" + this.getDatePocetni().getVal() + "' AND a.datum <= '" + this.getDateKrajnji().getVal() + "'" : "";
            String query = String.format(baseQuery, uplata, dokumenta, nadjiDatumu, datumi);
            q = em.createNativeQuery(query);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            this.cursor = (ScrollableCursor)q.getSingleResult();
        } else if (this.isKupac()) {
            uplata = "SUM( CASE \t\tWHEN b.tip = '" + TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ + "' THEN b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().PRENOS_SA_FAKTURE_KUPAC + "' THEN b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().UPLATA_KUPCA + "' THEN -b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().PRENOS_NA_FAKTURU_KUPAC + "' THEN -b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' THEN -b.iznos " + "\t\tWHEN  b.tip='" + TipDokumentConfig.get().UPLATA_PAZARA + "' THEN -b.iznos" + "\t\tELSE 0 " + "\t\tEND)";
            dokumenta = "(a.tip = '" + TipDokumentConfig.get().FAKTURA + "' OR " + "a.tip = '" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR " + "a.tip = '" + TipDokumentConfig.get().FAKTURA_USLUGA + "' OR " + "a.tip = '" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR " + "a.tip = '" + TipDokumentConfig.get().OTPIS_POTRAZIVANJA + "' OR " + "a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_KUPCA + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ + "' OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_SA_FAKTURE_KUPAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_NA_FAKTURU_KUPAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().POCETNO_STANJE_UPLATA + "' OR " + "a.tip = '" + TipDokumentConfig.get().RACUN_KUPCA + "' OR " + "a.tip= '" + TipDokumentConfig.get().UPLATA_PAZARA + "')";
            String datumi = this.isPrikazUPeriodu() ? " AND a.datum >= '" + this.getDatePocetni().getVal() + "' AND a.datum <= '" + this.getDateKrajnji().getVal() + "'" : "";
            String nadjiDatumu = "c.tip = '" + TipDokumentConfig.get().FAKTURA + "' OR " + "c.tip = '" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR " + "c.tip = '" + TipDokumentConfig.get().FAKTURA_USLUGA + "'";
            String query = String.format(baseQuery, uplata, dokumenta, nadjiDatumu, datumi);
            q = em.createNativeQuery(query);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            if (this.cursor != null && !this.cursor.isClosed()) {
                this.cursor.close();
            }
            this.cursor = (ScrollableCursor)q.getSingleResult();
        }
        em.clear();
        em.close();
        if (this.cursor.size() == 0 || this.cursor == null) {
            return -1;
        }
        this.table = new PzScrollableTable();
        boolean kupac = this.isKupac();
        PzTableModelKarticaFakturaIUplata model = new PzTableModelKarticaFakturaIUplata(this.cursor, kupac);
        this.table.setModel((TableModel)((Object)model));
        return 0;
    }

    private void showReport() {
        Vector<Object> data = new Vector<Object>();
        String additional = null;
        try {
            data.add(this.komitent);
            data.add(PzFirma.getFirma());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", this.rtitle);
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        if (this.isPrikazUPeriodu()) {
            additional = String.format("U periodu: %s - %s", formatter.format(this.getDatePocetni().getVal()), formatter.format(this.getDateKrajnji().getVal()));
            params.put("additional", additional);
        }
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/karticaFakturaIUplata.jasper", params, (String)("karticaKomitenta_" + this.komitent.getSfrKomitent()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onOKPressed() {
        this.komitent = this.GetKomitentIstance();
        if (this.komitent != null) {
            this.rtitle = this.isKupac() ? "kupca" : "dobavlja\u010da";
        }
        if (this.fillInTheInfo() != 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Nema podataka za prikaz", "Info", 1);
            return;
        }
        this.showReport();
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.thisWindowClosing(evt);
    }

    public static String getOpis(String tip, String podtip, String oznDokumenta) {
        if (tip.equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC)) {
            return String.format(uplata[8], oznDokumenta);
        }
        if (tip.equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC)) {
            return String.format(uplata[8], oznDokumenta);
        }
        if (tip.equals(TipDokumentConfig.get().PRENOS_SA_FAKTURE_DOBAVLJAC) || tip.equals(TipDokumentConfig.get().PRENOS_SA_FAKTURE_KUPAC)) {
            return "Prenos sa " + oznDokumenta;
        }
        if (tip.equals(TipDokumentConfig.get().PRENOS_NA_FAKTURU_DOBAVLJAC) || tip.equals(TipDokumentConfig.get().PRENOS_NA_FAKTURU_KUPAC)) {
            return "Prenos na " + oznDokumenta;
        }
        if (tip.equals(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA) || tip.equals(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA)) {
            return "Odobrenje po" + oznDokumenta;
        }
        if (tip.equals(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA) || tip.equals(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA)) {
            return "Zaduzenje po" + oznDokumenta;
        }
        if (podtip == null) {
            return "Upl. po " + oznDokumenta;
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_VIRMAN)) {
            return String.format(uplata[0], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_OVLASCENJE)) {
            return String.format(uplata[1], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_CEK)) {
            return String.format(uplata[2], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_KOMPENZACIJA)) {
            return String.format(uplata[3], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_MULTIKOMPENZACIJA)) {
            return String.format(uplata[4], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_CESIJA)) {
            return String.format(uplata[5], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_MENICA)) {
            return String.format(uplata[6], oznDokumenta);
        }
        if (podtip.equals(TipDokumentConfig.get().PODTIP_UPLATA_GOTOVINA)) {
            return String.format(uplata[7], oznDokumenta);
        }
        return "Upl. po " + oznDokumenta;
    }
}

