/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.knjiznoZaduzenjeRazduzenje;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.FetchGroup;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.knjigaPrihodaRashoda.PzDialogKnjigaPrihodaRashoda;
import rs.pezar.analitike.gui.knjiznoZaduzenjeRazduzenje.ZaduzenjeOdobrenjeEngine;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.reports.rf.ZaduzenjeOdobrenjeRF;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledZaduzenjaOdobrenja
extends PzDialog {
    private JToolBar toolBar;
    private PzPanel pnlPretraga;
    private PzPanel pnlTable;
    private JScrollPane jScrollPane1;
    private JLabel jLabel4;
    private PzToolBarIcon icoDatum;
    private PzToolBarIcon icoKomitent;
    private PzToolBarIcon icoDokument;
    private PzToolBarIcon icoSlikaDok;
    private PzTextField txtNazivKomitent;
    private PzTextField txtKomitent;
    private PzTextField txtDokument;
    private PzDateField txtKrajDat;
    private PzDateField txtPocDat;
    private PzButton btnTazi;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JRadioButton rbtnDobavljac;
    private JRadioButton rbtnKupac;
    private PzButtonPanel btnPanel;
    private PzPanel mainPanel;
    private JSeparator jSeparator1;
    private PzTable table;
    private String parameter;
    private FetchGroup group;
    private PzToolBarIcon icnUpit;
    private PzToolBarIcon icnStampanje;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPregledZaduzenjaOdobrenja inst = new PzDialogPregledZaduzenjaOdobrenja(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPregledZaduzenjaOdobrenja(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogPregledZaduzenjaOdobrenja(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
        this.parameter = parameter;
        this.txtDokument.setEnabled(false);
        this.txtKomitent.setEnabled(false);
        this.txtNazivKomitent.setEditable(false);
        this.txtNazivKomitent.setFocusable(false);
        this.txtPocDat.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
        if (parameter.equalsIgnoreCase("zaduzenje")) {
            this.setTitle("Zadu\u017eenja iz arhive");
        } else {
            this.setTitle("Odobrenja iz arhive");
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pnlTable = new PzPanel();
            this.mainPanel.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            GridBagLayout pnlTableLayout = new GridBagLayout();
            pnlTableLayout.rowWeights = new double[]{0.1};
            pnlTableLayout.rowHeights = new int[]{7};
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.columnWidths = new int[]{7};
            this.pnlTable.setLayout((LayoutManager)pnlTableLayout);
            this.jScrollPane1 = new JScrollPane();
            this.pnlTable.add((Component)this.jScrollPane1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.table = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.setFilter(new PzEntityFilter(){
                private ZaduzenjeOdobrenje zo;
                private Object[] o;

                public Object[] getValues(PzEntity entity) {
                    this.zo = (ZaduzenjeOdobrenje)entity;
                    BigDecimal pdv = new BigDecimal(0);
                    Vector taksa = (Vector)this.zo.getTaksaopstidokuments();
                    if (taksa != null & taksa.size() != 0) {
                        for (Taksaopstidokument to : taksa) {
                            if (!to.getVrsta().equals("PDV")) continue;
                            pdv = pdv.add(to.getIznos());
                        }
                    }
                    this.o = new Object[]{TipDokumentConfig.getNameByValue((String)this.zo.getTip(), null), this.zo.getrBrDokumenta(), this.zo.getKomitent().getSfrKomitent(), this.zo.getKomitent().getNaziv(), this.zo.getDatum(), pdv, this.zo.getIznosSaPorezom()};
                    return this.o;
                }

                public String[] getColumnNames() {
                    return new String[]{"Tip", "Oznaka", "\u0160ifra komitenta", "Naziv komitenta", "Datum", "PDV", "Iznos"};
                }
            });
            this.pnlPretraga = new PzPanel();
            this.mainPanel.add((Component)this.pnlPretraga, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlPretragaLayout = new GridBagLayout();
            this.pnlPretraga.setBorder((Border)BorderFactory.createTitledBorder("Pretraga"));
            pnlPretragaLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1};
            pnlPretragaLayout.rowHeights = new int[]{7, 7, 7, 7, 7};
            pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.0, 0.0, 0.1};
            pnlPretragaLayout.columnWidths = new int[]{120, 105, 7, 105, 106, 7};
            this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
            this.btnPanel = new PzButtonPanel();
            GridBagLayout btnPanelLayout = new GridBagLayout();
            this.pnlPretraga.add((Component)this.btnPanel, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            btnPanelLayout.rowWeights = new double[]{0.1};
            btnPanelLayout.rowHeights = new int[]{7};
            btnPanelLayout.columnWeights = new double[]{0.1, 0.1};
            btnPanelLayout.columnWidths = new int[]{7, 7};
            this.btnPanel.setLayout((LayoutManager)btnPanelLayout);
            this.rbtnKupac = new JRadioButton();
            this.btnPanel.add((Component)this.rbtnKupac, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnKupac.setName("rbtnKupac");
            this.rbtnKupac.setSelected(true);
            this.rbtnKupac.setOpaque(false);
            this.rbtnDobavljac = new JRadioButton();
            this.btnPanel.add((Component)this.rbtnDobavljac, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnDobavljac.setName("rbtnDobavljac");
            this.rbtnDobavljac.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setName("jLabel2");
            this.jLabel3 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setName("jLabel3");
            this.jLabel4 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel4, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setName("jLabel4");
            this.btnTazi = new PzButton();
            this.pnlPretraga.add((Component)this.btnTazi, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTazi.setName("btnTazi");
            this.btnTazi.addActionListener((ActionListener)((Object)this));
            this.btnTazi.setActionCommand("trazi");
            this.btnTazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find.png")));
            this.txtPocDat = new PzDateField();
            this.pnlPretraga.add((Component)this.txtPocDat, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtPocDat.setName("txtPocDat");
            this.txtKrajDat = new PzDateField();
            this.pnlPretraga.add((Component)this.txtKrajDat, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKrajDat.setName("txtKrajDat");
            this.txtDokument = new PzTextField();
            this.txtDokument.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    String query = PzDialogPregledZaduzenjaOdobrenja.this.rbtnKupac.isSelected() ? "SELECT f FROM Faktura f WHERE f.oznDokumenta= :oznDok" : "SELECT k FROM Kalkulacija k WHERE k.oznDokumenta= :oznDok";
                    EntityManager em = PzEntityManager.getEm();
                    Query q = em.createQuery(query).setParameter("oznDok", (Object)PzDialogPregledZaduzenjaOdobrenja.this.txtDokument.getVal());
                    return (PzEntity)q.getSingleResult();
                }
            });
            this.pnlPretraga.add((Component)this.txtDokument, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKomitent = new PzTextField();
            this.pnlPretraga.add((Component)this.txtKomitent, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.txtNazivKomitent = new PzTextField();
            this.pnlPretraga.add((Component)this.txtNazivKomitent, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.toolBar = new PzToolBar();
            this.mainPanel.add((Component)this.toolBar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.toolBar.setOpaque(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.icoSlikaDok = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoSlikaDok);
            this.icoSlikaDok.setName("icoSlikaDok");
            this.icoSlikaDok.addActionListener((ActionListener)((Object)this));
            this.icoSlikaDok.setActionCommand("slika_dokumenta");
            this.icoSlikaDok.setShortcut("F2");
            this.icoSlikaDok.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/documents.png")));
            this.jSeparator1 = new JSeparator();
            this.toolBar.add(this.jSeparator1);
            this.jSeparator1.setPreferredSize(new Dimension(1, 63));
            this.icoDokument = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoDokument);
            this.icoDokument.setName("icoKalkulacija");
            this.icoDokument.addActionListener((ActionListener)((Object)this));
            this.icoDokument.setActionCommand("trazi_dokument");
            this.icoDokument.setShortcut("F6");
            this.icoDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/documentsearch.png")));
            this.icoKomitent = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoKomitent);
            this.icoKomitent.setName("icoKomitent");
            this.icoKomitent.addActionListener((ActionListener)((Object)this));
            this.icoKomitent.setActionCommand("trazi_komitenta");
            this.icoKomitent.setShortcut("F8");
            this.icoKomitent.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/businessman_search.png")));
            this.icoDatum = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoDatum);
            this.icoDatum.setName("icoDatum");
            this.icoDatum.addActionListener((ActionListener)((Object)this));
            this.icoDatum.setActionCommand("trazi_datum");
            this.icoDatum.setShortcut("F9");
            this.icoDatum.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/date_search.png")));
            this.icnUpit = new PzToolBarIcon();
            this.toolBar.add((Component)this.icnUpit);
            this.icnUpit.setText("Upit u NZK|(F5)");
            this.icnUpit.setPreferredSize(new Dimension(82, 90));
            this.icnUpit.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/nzk.png")));
            this.icnUpit.setShortcut("f5");
            this.icnUpit.setActionCommand("nzk");
            this.icnUpit.addActionListener((ActionListener)((Object)this));
            this.icnStampanje = new PzToolBarIcon();
            this.icnStampanje.setIcon((Icon)new ImageIcon(PzDialogKnjigaPrihodaRashoda.class.getResource("/rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampanje.setText("Stampanje|(ALT+S)");
            this.icnStampanje.setShortcut("ALT+S");
            this.icnStampanje.addActionListener((ActionListener)((Object)this));
            this.icnStampanje.setActionCommand("stampa");
            this.toolBar.add((Component)this.icnStampanje);
            this.pack();
            this.setSize(800, 632);
            this.setMinimumSize(new Dimension(800, 632));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("slika_dokumenta")) {
            if (this.rbtnKupac.isSelected()) {
                ZaduzenjeOdobrenjeRF.showReportKupci((PzDokument)((ZaduzenjeOdobrenje)this.table.getSelectedEntity()), (PzDialog)this, (boolean)false);
            } else if (this.rbtnDobavljac.isSelected()) {
                ZaduzenjeOdobrenjeRF.showReportDobavljaci((PzDokument)((ZaduzenjeOdobrenje)this.table.getSelectedEntity()), (PzDialog)this);
            }
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazi_dokument")) {
            this.txtDokument.setEnabled(true);
            this.txtKomitent.setEnabled(false);
            this.txtKrajDat.setEnabled(false);
            this.txtPocDat.setEnabled(false);
            this.setFirstComponentInFocus((Component)this.txtDokument);
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazi_komitenta")) {
            this.txtDokument.setEnabled(false);
            this.txtKomitent.setEnabled(true);
            this.txtKrajDat.setEnabled(false);
            this.txtPocDat.setEnabled(false);
            this.setFirstComponentInFocus((Component)this.txtKomitent);
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazi_datum")) {
            this.txtDokument.setEnabled(false);
            this.txtKomitent.setEnabled(false);
            this.txtKrajDat.setEnabled(true);
            this.txtPocDat.setEnabled(true);
            this.txtPocDat.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.txtKrajDat.setVal((Object)PzDateUtility.getCurrentDate());
            this.setFirstComponentInFocus((Component)this.txtPocDat);
            return;
        }
        if (actionCommand.equals("nzk")) {
            try {
                if (this.table.getRowCount() == 0) {
                    return;
                }
                PzGenericService gs = PzApplication.getApplication().getGenericServiceRegistry().getService("NZK_SERVICE");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("NZK_DOKUMENT", this.table.getSelectedEntity());
                params.put("NZK_PARENT_DIALOG", (Object)this);
                gs.run(params);
                return;
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                return;
            }
        }
        if (actionCommand.equalsIgnoreCase("trazi")) {
            String query = this.createQuery();
            if (this.parameter.equalsIgnoreCase(ZaduzenjeOdobrenjeEngine.ZADUZENJE) && this.rbtnKupac.isSelected()) {
                query = String.valueOf(query) + " AND z.tip='" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA + "'";
            } else if (this.parameter.equalsIgnoreCase(ZaduzenjeOdobrenjeEngine.ZADUZENJE) && this.rbtnDobavljac.isSelected()) {
                query = String.valueOf(query) + " AND z.tip='" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA + "'";
            } else if (this.parameter.equalsIgnoreCase(ZaduzenjeOdobrenjeEngine.ODOBRENJE) && this.rbtnKupac.isSelected()) {
                query = String.valueOf(query) + " AND z.tip='" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA + "'";
            } else if (this.parameter.equalsIgnoreCase(ZaduzenjeOdobrenjeEngine.ODOBRENJE) && this.rbtnDobavljac.isSelected()) {
                query = String.valueOf(query) + " AND z.tip='" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA + "'";
            }
            if (this.txtDokument.isEnabled() && !this.txtDokument.getText().equals("")) {
                query = String.valueOf(query) + " AND z.idDok = " + this.txtDokument.getVal();
            }
            if (this.txtKomitent.isEnabled() && !this.txtKomitent.getVal().equals("")) {
                query = String.valueOf(query) + " AND z.komitent.sfrKomitent = '" + this.txtKomitent.getVal() + "'";
            }
            if (this.txtPocDat.isEnabled()) {
                query = String.valueOf(query) + " AND z.datum>='" + this.txtPocDat.getVal() + "' AND z.datum<='" + this.txtKrajDat.getVal() + "'";
            }
            if (this.group == null) {
                this.group = new FetchGroup();
            }
            this.group.addAttribute("tip");
            this.group.addAttribute("oznDokumenta");
            this.group.addAttribute("komitent.sfrKomitent");
            this.group.addAttribute("komitent.naziv");
            this.group.addAttribute("datum");
            this.group.addAttribute("iznosSaPorezom");
            this.group.addAttribute("oznKomitenta");
            this.group.addAttribute("taksaopstidokuments");
            this.group.addAttribute("arhiviran");
            this.group.addAttribute("storno");
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery(query);
            q.setHint("eclipselink.fetch-group", (Object)this.group);
            Vector tableData = (Vector)q.getResultList();
            if (this.rbtnKupac.isSelected()) {
                this.table.setData(tableData, ZaduzenjeOdobrenje.class);
            } else {
                this.table.setData(tableData, ZaduzenjeOdobrenje.class);
            }
            return;
        }
        if (actionCommand.equals("stampa") && this.table.getRowCount() != 0) {
            this.showReport();
        }
    }

    private void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", PzDateUtility.getCurrentDate());
            String title = null;
            String subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.txtPocDat.getVal()) + " do " + PzDateUtility.formatDate((Date)this.txtKrajDat.getVal());
            String fname = null;
            title = this.parameter.equalsIgnoreCase("zaduzenje") ? "PREGLED URA\u0110ENIH ZADU\u017dENJA" : "PREGLED URA\u0110ENIH ODOBRENJA";
            fname = "rs/pezar/reports/compiled/knjizno.zaduzenje.odobrenje.stampa.jasper";
            params.put("title", title);
            params.put("reklama", "");
            params.put("subtitle", subtitle);
            try {
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private String createQuery() {
        String query = "Select z FROM ZaduzenjeOdobrenje z join fetch z.komitent WHERE z.arhiviran=1 AND z.storno=0 AND";
        query = this.rbtnKupac.isSelected() ? String.valueOf(query) + " z.oznKomitenta = '" + ZaduzenjeOdobrenjeEngine.ZADUZENJE_ODOBRENJE_KUPCI + "'" : String.valueOf(query) + " z.oznKomitenta = '" + ZaduzenjeOdobrenjeEngine.ZADUZENJE_ODOBRENJE_DOBAVLJACI + "'";
        return query;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity != null) {
            Komitent k = (Komitent)entity;
            ((PzTextField)component).setVal((Object)k.getSfrKomitent());
            this.txtNazivKomitent.setVal((Object)k.getNaziv());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPregledZaduzenjaOdobrenja(Boolean.FALSE);
    }

    public PzDialogPregledZaduzenjaOdobrenja(Boolean initGUI) {
    }
}

