/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.avansi;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;

public class PzDialogPrometAvansa
extends PzDialog {
    private PzToolBar toolbar;
    private PzToolBarIcon icoFilter;
    private PzPanel pnlPretragaTop;
    private PzButtonPanel btnPanelSaldo;
    private JScrollPane jScrollPane1;
    private PzDoubleField txtRazlika;
    private PzDoubleField txtIsplate;
    private PzDoubleField txtUplate;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel pnlData;
    private JRadioButton rbtnSALDOje;
    private JRadioButton rbtnSaldoNije;
    private JRadioButton rbtnDobavljac;
    private JRadioButton rbtnKupac;
    private PzButton btnTrazi;
    private PzButtonPanel btnPanel;
    private PzToolBarIcon icoStampajDok;
    private PzScrollableTable table;
    private int filterMarker;
    private ScrollableCursor cursor;
    private EntityManager em;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPrometAvansa inst = new PzDialogPrometAvansa(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPrometAvansa(JFrame frame) {
        super(frame);
        this.initGUI();
        this.rbtnSALDOje.setEnabled(false);
        this.rbtnSaldoNije.setEnabled(false);
        this.rbtnSALDOje.setVisible(false);
        this.rbtnSaldoNije.setVisible(false);
        this.filterMarker = 0;
    }

    private void initGUI() {
        try {
            this.setTitle("Pregled prometa avansa");
            AnchorLayout thisLayout = new AnchorLayout();
            this.getContentPane().setLayout(thisLayout);
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, new AnchorConstraint(179, 990, 56, 6, 2, 1, 2, 2));
            this.jScrollPane1.setPreferredSize(new Dimension(671, 227));
            this.table = new PzScrollableTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            this.pnlData = new PzPanel();
            GridBagLayout pnlDataLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlData, new AnchorConstraint(877, 997, 1001, 0, 0, 0, 1, 2));
            this.pnlData.setPreferredSize(new Dimension(682, 56));
            pnlDataLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
            pnlDataLayout.rowHeights = new int[]{7, 7, 7};
            pnlDataLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            pnlDataLayout.columnWidths = new int[]{7, 7, 7, 7, 7, 7};
            this.pnlData.setLayout((LayoutManager)pnlDataLayout);
            this.jLabel1 = new JLabel();
            this.pnlData.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel1.setText("Uplate:");
            this.jLabel2 = new JLabel();
            this.pnlData.add((Component)this.jLabel2, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setName("jLabel2");
            this.jLabel2.setText("Isplate:");
            this.jLabel3 = new JLabel();
            this.pnlData.add((Component)this.jLabel3, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setName("jLabel3");
            this.jLabel3.setText("Razlika:");
            this.txtUplate = this.table.createExpresionField("$2$");
            this.pnlData.add((Component)this.txtUplate, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtUplate.setEnabled(false);
            this.txtIsplate = this.table.createExpresionField("$3$");
            this.pnlData.add((Component)this.txtIsplate, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtIsplate.setEnabled(false);
            this.txtRazlika = this.table.createExpresionField("$2$-$3$");
            this.pnlData.add((Component)this.txtRazlika, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtRazlika.setEnabled(false);
            this.pnlPretragaTop = new PzPanel();
            AnchorLayout pnlPretragaTopLayout = new AnchorLayout();
            this.pnlPretragaTop.setLayout((LayoutManager)pnlPretragaTopLayout);
            this.getContentPane().add((Component)this.pnlPretragaTop, new AnchorConstraint(86, 1000, 336, 0, 2, 1, 0, 1));
            this.pnlPretragaTop.setPreferredSize(new Dimension(684, 93));
            this.pnlPretragaTop.setBorder((Border)BorderFactory.createTitledBorder("Pretraga"));
            this.btnPanelSaldo = new PzButtonPanel();
            GridBagLayout btnPanelSaldoLayout = new GridBagLayout();
            this.pnlPretragaTop.add((Component)this.btnPanelSaldo, (Object)new AnchorConstraint(262, 946, 519, 380, 1, 0, 0, 2));
            this.btnPanelSaldo.setPreferredSize(new Dimension(266, 26));
            btnPanelSaldoLayout.rowWeights = new double[]{0.1};
            btnPanelSaldoLayout.rowHeights = new int[]{7};
            btnPanelSaldoLayout.columnWeights = new double[]{0.1, 0.1};
            btnPanelSaldoLayout.columnWidths = new int[]{7, 7};
            this.btnPanelSaldo.setLayout((LayoutManager)btnPanelSaldoLayout);
            this.rbtnSaldoNije = new JRadioButton();
            this.btnPanelSaldo.add((Component)this.rbtnSaldoNije, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnSaldoNije.setName("rbtnSaldoNije");
            this.rbtnSALDOje = new JRadioButton();
            this.btnPanelSaldo.add((Component)this.rbtnSALDOje, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnSALDOje.setName("rbtnSaldoJe");
            this.rbtnSALDOje.setText("Samo: SALDO = 0");
            this.btnTrazi = new PzButton();
            this.pnlPretragaTop.add((Component)this.btnTrazi, (Object)new AnchorConstraint(360, 437, 361, 174, 1, 0, 0, 2));
            this.btnTrazi.setPreferredSize(new Dimension(126, 36));
            this.btnTrazi.setName("btnTrazi");
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.setText("Tra\u017ei");
            this.btnTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find.png")));
            this.btnPanel = new PzButtonPanel();
            GridBagLayout btnPanelLayout = new GridBagLayout();
            this.pnlPretragaTop.add((Component)this.btnPanel, (Object)new AnchorConstraint(212, 225, 915, 10, 1, 0, 1, 2));
            btnPanelLayout.rowWeights = new double[]{0.1, 0.1};
            btnPanelLayout.rowHeights = new int[]{7, 7};
            btnPanelLayout.columnWeights = new double[]{0.1};
            btnPanelLayout.columnWidths = new int[]{7};
            this.btnPanel.setLayout((LayoutManager)btnPanelLayout);
            this.btnPanel.setPreferredSize(new Dimension(143, 71));
            this.btnPanel.setName("btnPanel");
            this.rbtnKupac = new JRadioButton();
            this.btnPanel.add((Component)this.rbtnKupac, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnKupac.setName("rbtnKupac");
            this.rbtnKupac.setText("Kupac");
            this.rbtnKupac.setActionCommand("Kupac");
            this.rbtnDobavljac = new JRadioButton();
            this.btnPanel.add((Component)this.rbtnDobavljac, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnDobavljac.setName("rbtnDobavljac");
            this.rbtnDobavljac.setText("Dobavlja\u010d");
            this.rbtnDobavljac.setActionCommand("Dobavljac");
            this.toolbar = new PzToolBar();
            this.getContentPane().add((Component)this.toolbar, new AnchorConstraint(0, 0, 174, 0, 2, 2, 0, 2));
            this.toolbar.setPreferredSize(new Dimension(684, 80));
            this.icoStampajDok = new PzToolBarIcon();
            this.toolbar.add((Component)this.icoStampajDok);
            this.icoStampajDok.setName("icoStampajDok");
            this.icoStampajDok.addActionListener((ActionListener)((Object)this));
            this.icoStampajDok.setActionCommand("slika_dokumenta");
            this.icoStampajDok.setShortcut("ALT+S");
            this.icoStampajDok.setText("\u0160tampaj | (ALT+S)");
            this.icoStampajDok.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icoFilter = new PzToolBarIcon();
            this.toolbar.add((Component)this.icoFilter);
            this.icoFilter.setName("icoFilter");
            this.icoFilter.addActionListener((ActionListener)((Object)this));
            this.icoFilter.setActionCommand("filter");
            this.icoFilter.setShortcut("F10");
            this.icoFilter.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/funnel.png")));
            this.setSize(700, 500);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("slika_dokumenta")) {
            if (this.table.getRowCount() == 0) {
                return;
            }
            this.showReport();
            return;
        }
        if (actionCommand.equalsIgnoreCase("filter")) {
            if (this.filterMarker == 0) {
                this.rbtnSALDOje.setEnabled(true);
                this.rbtnSaldoNije.setEnabled(true);
                this.rbtnSALDOje.setVisible(true);
                this.rbtnSaldoNije.setVisible(true);
                this.filterMarker = 1;
            } else {
                this.rbtnSALDOje.setEnabled(false);
                this.rbtnSaldoNije.setEnabled(false);
                this.rbtnSALDOje.setVisible(false);
                this.rbtnSaldoNije.setVisible(false);
                this.filterMarker = 0;
            }
        } else if (actionCommand.equalsIgnoreCase("trazi")) {
            String upit = this.createNativeQuery();
            if (this.rbtnSALDOje.isEnabled() && this.rbtnSALDOje.isSelected()) {
                upit = String.valueOf(upit) + this.upitPomocni() + "=0";
            }
            if (this.rbtnSaldoNije.isEnabled() && this.rbtnSaldoNije.isSelected()) {
                upit = String.valueOf(upit) + this.upitPomocni() + "<>0";
            }
            this.em = PzEntityManager.getEm();
            Query q = this.em.createNativeQuery(upit);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.cursor = (ScrollableCursor)q.getSingleResult();
            this.table.read(this.cursor, Uplata.getColumnNamesAvansi());
            if (this.cursor.size() == 0) {
                return;
            }
            this.table.insertColumn(4, "$2$-$3$", "Saldo");
            this.table.calculateFields();
            return;
        }
    }

    public void tableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                return null;
            }

            public String[] getColumnNames() {
                return new String[]{"\u0160ifra komitenta", "Naziv komitenta", "Uplata", "Isplata", "Saldo"};
            }
        });
    }

    private String createNativeQuery() {
        String upit = null;
        upit = this.rbtnKupac.isSelected() ? "SELECT k.sfrKomitent, k.naziv, COALESCE(SUM(CASE WHEN u.tip='UPA' THEN u.iznosSaPorezom ELSE 0 END)) - COALESCE(SUM(CASE WHEN u.tip='PAP' THEN u.iznosSaPorezom ELSE 0 END)), COALESCE(SUM(CASE WHEN u.tip='ZAK' THEN u.iznosSaPorezom ELSE 0 END)) FROM Komitent k INNER JOIN Opstidokument u ON u.sfrKomitent=k.sfrKomitent and u.arhiviran != -1 GROUP BY k.sfrKomitent, k.naziv HAVING (SUM(CASE WHEN u.tip='UPA' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)<>0 OR SUM(CASE WHEN u.tip='ZAK' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)<>0)" : "SELECT k.sfrKomitent, k.naziv, COALESCE(SUM(CASE WHEN u.tip='UDA' THEN u.iznosSaPorezom ELSE 0 END)) - COALESCE(SUM(CASE WHEN u.tip='DAP' THEN u.iznosSaPorezom ELSE 0 END)), COALESCE(SUM(CASE WHEN u.tip='ZAD' THEN u.iznosSaPorezom ELSE 0 END)) FROM Komitent k INNER JOIN Opstidokument u ON u.sfrKomitent=k.sfrKomitent and u.arhiviran != -1 GROUP BY k.sfrKomitent, k.naziv HAVING (SUM(CASE WHEN u.tip='UDA' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)<>0 OR SUM(CASE WHEN u.tip='ZAD' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)<>0)";
        upit = upit.replaceAll("UPA", TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS).replaceAll("PAP", TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ).replaceAll("ZAK", TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC).replaceAll("UDA", TipDokumentConfig.get().UPLATA_DAT_AVANS).replaceAll("DAP", TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ).replaceAll("ZAD", TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC);
        return upit;
    }

    private String upitPomocni() {
        String upit = null;
        upit = this.rbtnKupac.isSelected() ? " AND (COALESCE(SUM(CASE WHEN u.tip='UPA' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)) - COALESCE(SUM(CASE WHEN u.tip='PAP' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)) - COALESCE(SUM(CASE WHEN u.tip='ZAK' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)))" : " AND (COALESCE(SUM(CASE WHEN u.tip='UDA' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)) - COALESCE(SUM(CASE WHEN u.tip='DAP' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)) - COALESCE(SUM(CASE WHEN u.tip='ZAD' AND u.sfrKomitent=k.sfrKomitent THEN u.iznosSaPorezom ELSE 0 END)))";
        upit = upit.replaceAll("UPA", TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS).replaceAll("ZAK", TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC).replaceAll("PAP", TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ).replaceAll("UDA", TipDokumentConfig.get().UPLATA_DAT_AVANS).replaceAll("DAP", TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ).replaceAll("ZAD", TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC);
        return upit;
    }

    public void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", new Date(new java.util.Date().getTime()));
            String title = null;
            String fname = null;
            title = this.rbtnKupac.isSelected() ? "UKUPAN PROMET AVANSA KOD KUPACA" : "UKUPAN PROMET AVANSA KOD DOBAVLJA\u010cA";
            fname = "rs/pezar/reports/compiled/promet.avansa.jasper";
            params.put("title", title);
            params.put("reklama", "");
            try {
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null && this.em != null) {
            this.cursor.close();
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPrometAvansa(Boolean.FALSE);
    }

    public PzDialogPrometAvansa(Boolean initGUI) {
    }
}

