/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.popis;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.analitike.gui.artikli.popis.DodavanjeMaloprodaja;
import rs.pezar.analitike.gui.artikli.popis.PzDialogDokumentiMaloprodaja;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Popis;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.reports.rf.PopisRF;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogPopisMaloprodaja
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzPanel mainPanel;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzDateField datumIzrade;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Popis popis;
    private boolean izmena;
    private PzToolBarIcon icnBrisanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private Stanje stanjeIzlaz;
    private PzDialogDokumentiMaloprodaja parent;
    private List<Taksaopstidokument> taksapopiss;
    private Brojacrj brojac;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPopisMaloprodaja inst = new PzDialogPopisMaloprodaja(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPopisMaloprodaja(JFrame frame) {
        super(frame);
        this.popis = new Popis();
    }

    public PzDialogPopisMaloprodaja(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.parent = (PzDialogDokumentiMaloprodaja)parent;
        this.tableInterni = (PzTable)data1;
        this.popis = izmena ? (Popis)this.tableInterni.getSelectedEntity() : new Popis();
        this.izmena = izmena;
        this.initGUI();
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogPopisMaloprodaja.this.brDok.setText(String.valueOf(PzDialogPopisMaloprodaja.this.table.getRowCount()));
            }
        });
    }

    protected void initGUI() {
        try {
            if (this.izmena) {
                this.setTitle("POPIS ROBE U: " + this.popis.getRadnajedinica().getId().getOznRj() + "(" + this.popis.getRadnajedinica().getgTip() + ") " + this.popis.getRadnajedinica().getNaziv());
            }
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{109, 57, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pzPanelN = new PzPanel();
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelN.setOpaque(false);
            pzPanelNLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pzPanelNLayout.rowHeights = new int[]{14, 25, 5};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pzPanelNLayout.columnWidths = new int[]{102, 120, 7, 7};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel1.setText("Datum izrade:");
            this.datumIzrade = new PzDateField();
            this.pzPanelN.add((Component)this.datumIzrade, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(ins)");
            this.icnDodavanje.setPreferredSize(new Dimension(90, 90));
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_edit.png")));
            this.icnIzmena.setPreferredSize(new Dimension(90, 90));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(del)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/box_delete.png")));
            this.icnBrisanje.setActionCommand("Brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(77, 80));
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/address_book.png")));
            this.icnArhiva.setPreferredSize(new Dimension(90, 90));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            pzPanelCLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.rowHeights = new int[]{7, 7, 7, 7};
            pzPanelCLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pzPanelC.setOpaque(false);
            this.pzPanelC.setPreferredSize(new Dimension(1016, 568));
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            if (this.popis.getTaksaopstidokuments() == null) {
                this.popis.setTaksaopstidokuments((List)new IndirectList());
            }
            this.table = new PzTable(this.popis.getTaksaopstidokuments(), Taksaopstidokument.class);
            this.jScrollPane.setViewportView((Component)this.table);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki na popisu: ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(989, 666);
            this.setMinimumSize(new Dimension(989, 666));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            boolean izmena1 = false;
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("Brisanje")) {
                if (this.table.getSelectedEntity() == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku za brisanje.", "Obave\u0161tenje", 1);
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)true);
                if (rez != 0) {
                    return;
                }
                Taksaopstidokument taksaod = (Taksaopstidokument)this.table.getSelectedEntity();
                this.popis.setManjak(this.popis.getManjak().subtract(taksaod.getOsnovica()));
                this.popis.setVisak(this.popis.getVisak().subtract(taksaod.getIznos()));
                this.taksapopiss = this.popis.getTaksaopstidokuments();
                this.taksapopiss.remove(taksaod);
                this.popis.setTaksadokuments(this.taksapopiss);
                em.getTransaction().begin();
                em.remove(em.find(Taksaopstidokument.class, (Object)taksaod.getId()));
                em.merge((Object)this.popis);
                em.getTransaction().commit();
                this.table.refreshData();
                return;
            }
            if (actionCommand.equals("Izmena")) {
                izmena1 = true;
                actionCommand = "DodavanjeMaloprodaja";
            } else if (actionCommand.equals("Arhiviranje")) {
                if (this.table.getRowCount() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije uneta nijedna stavka.", "Obave\u0161tenje", 1);
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?", (String)"Arhiviranje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                this.arhiviraj();
                return;
            }
            try {
                this.getSession().putParameter("table", (Object)this.table);
                this.getSession().putParameter("popis", (Object)this.popis);
                this.getSession().putParameter("update", (Object)izmena1);
                this.showDialog(DodavanjeMaloprodaja.class);
                this.refresh();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            return;
        }
        finally {
            em.close();
        }
    }

    private void arhiviraj() {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            this.popis.setDatum(this.datumIzrade.getVal());
            this.popis.setDatArh(new Date(new java.util.Date().getTime()));
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.popis, true, null, em);
            em.getTransaction().commit();
            PopisRF.showReport((PzDialog)this, (PzDokument)this.popis, (String)"rs/pezar/reports/compiled/popisna_lista_vred_maloprodaja.jasper");
            this.finish();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        this.ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"EV", "EW"});
        if (this.ulaznaRJ != null) {
            result = true;
            this.setTitle("POPIS ROBE U: " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    if (this.popis == null) {
                        this.popis = new Popis();
                    }
                    this.popis.setStorno(0);
                    this.popis.setArhiviran((short)0);
                    this.popis.setTip("POPIS");
                    em.getTransaction().begin();
                    this.popis.setRadnajedinica(this.ulaznaRJ);
                    this.popis.setDatum(new Date(new java.util.Date().getTime()));
                    this.popis.setProknjizen((short)0);
                    this.popis.setProcRabata(0.0);
                    this.popis.setManjak(new BigDecimal(0));
                    this.popis.setVisak(new BigDecimal(0));
                    this.popis.setPdvIznos(new BigDecimal(0));
                    this.popis.setVrednostPopisa(new BigDecimal(0));
                    this.popis.setRjUlaz(this.ulaznaRJ.getPunNaziv());
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.popis, true, null, em);
                    em.getTransaction().commit();
                    this.tableInterni.insert((PzEntity)this.popis, false);
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPopisMaloprodaja(Boolean.FALSE);
    }

    public PzDialogPopisMaloprodaja(Boolean initGUI) {
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }
}

