/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.popis;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.artikli.popis.DBF;
import rs.pezar.analitike.gui.artikli.popis.PzDialogPopis;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Popis;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumenti
extends PzDialog {
    private static final long serialVersionUID = 1L;
    protected static Popis selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKalkulacije;
    private PzToolBarIcon icnIzmenaKalk;
    private PzToolBarIcon icnDodKalk;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private Popis popisBrisanje;
    private String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon icnSpoji;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogDokumenti inst = new PzDialogDokumenti(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogDokumenti(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumenti(PzDialog dialog, String parameter) {
        super(dialog);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    public PzDialogDokumenti(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        this.table = new PzTable(DBF.getPopis(PzExtensionLoader.getLoggedUser(), this.parameter, 0, 0, "POPIS"), Popis.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumenti.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogDokumenti.this.getSession().putParameter("update", (Object)true);
                PzDialogDokumenti.this.getSession().putParameter("tabela", (Object)PzDialogDokumenti.this.table);
                PzDialogDokumenti.this.showDialog(PzDialogPopis.class);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDokumenti.this.brDok.setText(String.valueOf(PzDialogDokumenti.this.table.getRowCount()));
            }
        });
    }

    private void initGUI() {
        try {
            this.setTitle("Popisi u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getPzusername() + " (" + PzExtensionLoader.getLoggedUser().getIme() + " " + PzExtensionLoader.getLoggedUser().getPrezime() + ")");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{98, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodKalk);
            this.toolbar.add((Component)this.icnDodKalk);
            this.icnDodKalk.setText("Novi popis|(ins)");
            this.icnDodKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_add.png")));
            this.icnDodKalk.addActionListener((ActionListener)((Object)this));
            this.icnDodKalk.setActionCommand("insert_popis");
            this.icnDodKalk.setShortcut("insert");
            this.icnIzmenaKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKalk);
            this.toolbar.add((Component)this.icnIzmenaKalk);
            this.icnIzmenaKalk.setText("Izmena popisa|(f3)");
            this.icnIzmenaKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.icnIzmenaKalk.setActionCommand("update_popis");
            this.icnIzmenaKalk.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKalk.setShortcut("f3");
            this.icnBrisanjeKalkulacije = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKalkulacije);
            this.toolbar.add((Component)this.icnBrisanjeKalkulacije);
            this.icnBrisanjeKalkulacije.setText("Brisanje popisa |(del)");
            this.icnBrisanjeKalkulacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_delete.png")));
            this.icnBrisanjeKalkulacije.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKalkulacije.setActionCommand("delete_popis");
            this.icnBrisanjeKalkulacije.setShortcut("delete");
            this.icnSpoji = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnSpoji);
            this.toolbar.add((Component)this.icnSpoji);
            this.icnSpoji.setText("Spoji popise");
            this.icnSpoji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.icnSpoji.addActionListener((ActionListener)((Object)this));
            this.icnSpoji.setActionCommand("spoji");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(985, 665);
            this.setMinimumSize(new Dimension(985, 665));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        if (actionCommand.equals("insert_popis")) {
            this.getSession().putParameter("update", (Object)false);
            this.getSession().putParameter("tabela", (Object)this.table);
            this.showDialog(PzDialogPopis.class);
        } else if (actionCommand.equals("update_popis")) {
            this.getSession().putParameter("update", (Object)true);
            this.getSession().putParameter("tabela", (Object)this.table);
            this.showDialog(PzDialogPopis.class);
        } else if (actionCommand.equals("delete_popis")) {
            EntityManager em = PzEntityManager.getEm();
            this.popisBrisanje = (Popis)this.table.getSelectedEntity();
            if (this.popisBrisanje == null) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali popis za brisanje.", "Obave\u0161tenje", 1);
                return;
            }
            int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)true);
            if (rez != 0) {
                return;
            }
            try {
                em.getTransaction().begin();
                PzDokumentManager.getInstance().deleteDokument((PzDokument)this.popisBrisanje, null, em);
                em.getTransaction().commit();
                this.table.removeSelectedEntity(false, false);
                this.refresh();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            finally {
                em.close();
            }
        } else if (actionCommand.equals("spoji")) {
            this.spojiPopise();
        }
        this.table.refreshData();
        this.refresh();
    }

    private void spojiPopise() {
        final Radnajedinica rjSpoji = PzDialogRJ.getRJ((PzDialog)this);
        if (rjSpoji == null) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Spajanje popisa u toku.", (PzDialog)this);
        SwingWorker<List<Popis>, Object> sw = new SwingWorker<List<Popis>, Object>(){
            private EntityManager em = PzEntityManagerFactory.getInstance().createEm();

            @Override
            protected List<Popis> doInBackground() throws Exception {
                ArrayList<Popis> listSpoji = new ArrayList<Popis>();
                for (PzEntity e : PzDialogDokumenti.this.table.getAllEntities()) {
                    Popis p = (Popis)e;
                    if (!p.getRadnajedinica().getId().getOznRj().equals(rjSpoji.getId().getOznRj())) continue;
                    listSpoji.add(p);
                }
                this.em.getTransaction().begin();
                int i = 1;
                while (i < listSpoji.size()) {
                    this.em.createNativeQuery("INSERT INTO Artikalopstidokument (iddok, sfrproizvod, rbroj, naziv, bliziopis, jm, kolicina, cenabezporeza, procrabata, cenasaporezom, kolicinabaza, discriminator, prodcena, prosnabcena, indk, sort) SELECT " + ((Popis)listSpoji.get(0)).getIdDok() + ", sfrproizvod, " + i + "*10000+rbroj, naziv, bliziopis, jm, kolicina, cenabezporeza, procrabata, cenasaporezom, kolicinabaza, discriminator, prodcena, prosnabcena, indk, sort FROM Artikalopstidokument WHERE iddok = " + ((Popis)listSpoji.get(i)).getIdDok() + " and sfrProizvod not in (SELECT sfrProizvod FROM Artikalopstidokument WHERE iddok = " + ((Popis)listSpoji.get(0)).getIdDok() + ")").executeUpdate();
                    this.em.createNativeQuery("UPDATE Artikalopstidokument SET kolicina = kolicina + (SELECT coalesce(sum(kolicina), 0) FROM Artikalopstidokument a2 WHERE Artikalopstidokument.sfrProizvod = a2.sfrProizvod and a2.idDok = " + ((Popis)listSpoji.get(i)).getIdDok() + ") WHERE idDok = " + ((Popis)listSpoji.get(0)).getIdDok() + " ");
                    this.em.createNativeQuery("INSERT INTO Aodtaksa (iddok, sfrproizvod, rbroj, ozntargr, oznvrstatg, stopa, opis)  SELECT " + ((Popis)listSpoji.get(0)).getIdDok() + ", sfrproizvod, " + i + "*10000+rbroj, ozntargr, oznvrstatg, stopa, opis FROM Aodtaksa WHERE iddok = " + ((Popis)listSpoji.get(i)).getIdDok() + " and exists (SELECT * FROM Artikalopstidokument a WHERE a.iddok = " + ((Popis)listSpoji.get(0)).getIdDok() + " and a.sfrProizvod = Aodtaksa.sfrProizvod and a.rBroj = " + i + "*10000+Aodtaksa.rbroj )").executeUpdate();
                    this.em.createNativeQuery("UPDATE Opstidokument SET arhiviran = -1 WHERE iddok = " + ((Popis)listSpoji.get(i)).getIdDok()).executeUpdate();
                    this.em.createNativeQuery("UPDATE Dokument SET arhiviran = -1 WHERE iddok = " + ((Popis)listSpoji.get(i)).getIdDok()).executeUpdate();
                    ++i;
                }
                this.em.getTransaction().commit();
                return listSpoji;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List listSpoji = (List)this.get();
                        int i = 1;
                        while (i < listSpoji.size()) {
                            PzDialogDokumenti.this.table.remove(i, Popis.class, (Object)((Popis)listSpoji.get(i)).getIdDok(), false);
                            ++i;
                        }
                        PzSwingUtility.showInformationMessage((Component)((Object)PzDialogDokumenti.this), (String)"Popisi su uspesno spojeni");
                        PzDialogDokumenti.this.dispose();
                    }
                    catch (Exception exception) {
                        if (this.em.getTransaction().isActive()) {
                            this.em.getTransaction().rollback();
                        }
                        this.em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    this.em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        sw.execute();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumenti(Boolean.FALSE);
    }

    public PzDialogDokumenti(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public static Popis getPopis(PzDialog parent, String parameter) {
        PzDialogDokumenti dlg = new PzDialogDokumenti(parent, parameter);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Popis)PzDialogDokumenti.this.table.getSelectedEntity();
                PzDialogDokumenti.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Popis res = selected;
        selected = null;
        return res;
    }
}

