/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogFilter;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogKriterijum;
import rs.pezar.analitike.util.AnalitikaUtil;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.rf.LagerListaRF;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.artikli.Upit;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusDialog;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.renderers.PzDoubleCellRenderer;
import rs.pezar.util.PzDateUtility;

public class PzDialogLagerListaNew
extends PzDialog {
    private static final long serialVersionUID = 1824157487300032779L;
    private Radnajedinica rj;
    private ScrollableCursor cursor;
    private PzTextField tfKolicina;
    private JLabel lblBrojSifara;
    private PzScrollableTable tblLagerLista;
    private JScrollPane scPane;
    private PzPanel plTabela;
    private PzNumericOnlyTextField nfBrojSifara;
    private JLabel lblCena;
    private JLabel lblKolicina;
    private PzDoubleField dfUkupnaVrednost;
    private JLabel lblUkupnaVrednost;
    private JLabel jLabel1;
    private PzTextField tfCena;
    private PzTextField tfRj;
    private PzPanel plLabeleDugmici;
    private JToolBar toolbar;
    private PzToolBarIcon btnStampanje;
    private PzToolBarIcon btnNadjiArtikal;
    private PzToolBarIcon btnFilter;
    private PzToolBarIcon btnUpitURJ;
    private PzToolBarIcon btnKartica;
    private EntityManager em;
    private String qFilter = "";
    private String kriterijum;
    private PzPanel pnlContent;
    private Firma firma;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogLagerListaNew inst = new PzDialogLagerListaNew(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogLagerListaNew(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogLagerListaNew() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Lager lista");
            this.pnlContent = new PzPanel();
            this.pnlContent.setPaintGradient(true);
            GridBagLayout pnlContentLayout = new GridBagLayout();
            pnlContentLayout.columnWidths = new int[]{7};
            pnlContentLayout.rowHeights = new int[]{91, 75, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 1.0};
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(20);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnKartica = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnKartica);
            this.btnKartica.setText("Kartica|(F2)");
            this.btnKartica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_header.png")));
            this.btnKartica.addActionListener((ActionListener)((Object)this));
            this.btnKartica.setShortcut("f2");
            this.btnUpitURJ = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnUpitURJ);
            this.btnUpitURJ.setText("Upit u RJ|(F3)");
            this.btnUpitURJ.addActionListener((ActionListener)((Object)this));
            this.btnUpitURJ.setShortcut("F3");
            this.btnUpitURJ.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/message.png")));
            this.btnFilter = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnFilter);
            this.btnFilter.setText("Filter|(F4)");
            this.btnFilter.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/funnel.png")));
            this.btnFilter.addActionListener((ActionListener)((Object)this));
            this.btnFilter.setShortcut("f4");
            this.btnNadjiArtikal = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnNadjiArtikal);
            this.btnNadjiArtikal.setText("Na\u0111i artikal|(F8)");
            this.btnNadjiArtikal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find_text.png")));
            this.btnStampanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnStampanje);
            this.btnStampanje.setText("\u0160tampanje|(Alt+S)");
            this.btnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnStampanje.addActionListener((ActionListener)((Object)this));
            this.btnStampanje.setShortcut("alt+s");
            this.plLabeleDugmici = new PzPanel();
            this.pnlContent.add((Component)this.plLabeleDugmici, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout plLabeleDugmiciLayout = new GridBagLayout();
            this.plLabeleDugmici.setBorder((Border)BorderFactory.createTitledBorder(null, "LAGER LISTA", 2, 0, new Font("Tahoma", 1, 18)));
            this.plLabeleDugmici.setLayout((LayoutManager)plLabeleDugmiciLayout);
            plLabeleDugmiciLayout.rowWeights = new double[]{0.1, 0.1};
            plLabeleDugmiciLayout.rowHeights = new int[]{7, 7};
            plLabeleDugmiciLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0, 0.1};
            plLabeleDugmiciLayout.columnWidths = new int[]{7, 124, 7, 7, 7, 20};
            this.plLabeleDugmici.setOpaque(false);
            this.tfRj = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfRj, (Object)new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.tfRj.setName("tfRj");
            this.tfRj.setEditable(false);
            this.tfRj.setFocusable(false);
            this.tfRj.setFont(new Font("Tahoma", 1, 14));
            this.tfCena = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfCena, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.tfCena.setName("tfCena");
            this.tfCena.setFont(new Font("Tahoma", 1, 14));
            this.tfCena.setEditable(false);
            this.tfCena.setFocusable(false);
            this.tfKolicina = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfKolicina, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.tfKolicina.setName("tfKolicina");
            this.tfKolicina.setFocusable(false);
            this.tfKolicina.setEditable(false);
            this.tfKolicina.setFont(new Font("Tahoma", 1, 14));
            this.jLabel1 = new JLabel();
            this.plLabeleDugmici.add((Component)this.jLabel1, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel1.setText("Radna jedinica:");
            this.jLabel1.setFont(new Font("Tahoma", 1, 14));
            this.jLabel1.setForeground(new Color(0, 0, 255));
            this.lblUkupnaVrednost = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblUkupnaVrednost, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.lblUkupnaVrednost.setText("Ukupna vrednost:");
            this.lblUkupnaVrednost.setFont(new Font("Tahoma", 1, 14));
            this.lblUkupnaVrednost.setForeground(new Color(0, 0, 255));
            this.dfUkupnaVrednost = new PzDoubleField();
            this.plLabeleDugmici.add((Component)this.dfUkupnaVrednost, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.dfUkupnaVrednost.setFont(new Font("Tahoma", 1, 14));
            this.dfUkupnaVrednost.setEditable(false);
            this.dfUkupnaVrednost.setFocusable(false);
            this.lblKolicina = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblKolicina, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.lblKolicina.setText("Koli\u010dina:");
            this.lblKolicina.setFont(new Font("Tahoma", 1, 14));
            this.lblKolicina.setForeground(new Color(0, 0, 255));
            this.lblCena = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.lblCena.setText("Cena:");
            this.lblCena.setFont(new Font("Tahoma", 1, 14));
            this.lblCena.setForeground(new Color(0, 0, 255));
            this.lblBrojSifara = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblBrojSifara, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.lblBrojSifara.setText("Broj \u0161ifara:");
            this.lblBrojSifara.setFont(new Font("Tahoma", 1, 14));
            this.lblBrojSifara.setForeground(new Color(0, 0, 255));
            this.nfBrojSifara = new PzNumericOnlyTextField();
            this.plLabeleDugmici.add((Component)this.nfBrojSifara, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.nfBrojSifara.setFont(new Font("Tahoma", 1, 14));
            this.nfBrojSifara.setEditable(false);
            this.nfBrojSifara.setFocusable(false);
            this.plTabela = new PzPanel();
            this.pnlContent.add((Component)this.plTabela, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            AnchorLayout plTabelaLayout = new AnchorLayout();
            this.plTabela.setLayout((LayoutManager)plTabelaLayout);
            this.plTabela.setOpaque(false);
            this.scPane = new JScrollPane();
            this.plTabela.add((Component)this.scPane, (Object)new AnchorConstraint(37, 987, 976, 14, 1, 1, 1, 1));
            this.setSize(922, 634);
            this.setMinimumSize(new Dimension(922, 634));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.btnFilter) {
                this.tblLagerLista = new PzScrollableTable();
                this.qFilter = PzDialogFilter.getQuery(this);
                if (this.qFilter == null) {
                    return;
                }
                final PzDialogLagerListaNew instance = this;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PzStatusDialog.showStatus((String)"Filtriranje lager liste je u toku. Molim, sa\u010dekajte.", (PzDialog)instance);
                        PzDialogLagerListaNew.this.query(PzDialogLagerListaNew.this.createQuery(PzDialogLagerListaNew.this.kriterijum), PzDialogLagerListaNew.this.getVrednostQuery(PzDialogLagerListaNew.this.kriterijum));
                        PzStatusDialog.hideStatus();
                    }
                });
                t.start();
            } else if (e.getSource() == this.btnStampanje) {
                String kolKrit = (String)this.getSession().getParameter("kolicina");
                String filKrit = (String)this.getSession().getParameter("filter");
                String kolicina = "";
                String filter = "";
                if (kolKrit != null && filKrit != null) {
                    if (kolKrit.equals("manja")) {
                        kolicina = "Koli\u010dina je manja od 0";
                    } else if (kolKrit.equals("veca")) {
                        kolicina = "Koli\u010dina je va\u0107a od 0";
                    }
                    if (!filKrit.equals("")) {
                        String[] fk = filKrit.split(";");
                        if (fk[0].equals("R")) {
                            filter = "Robna grupa je: " + fk[1];
                        } else if (fk[0].equals("P")) {
                            filter = "Proizvo\u0111a\u010d je:" + fk[1];
                        } else if (fk[0].equals("M")) {
                            filter = "Model je:" + fk[1];
                        } else if (fk[0].equals("T")) {
                            filter = "Tarifna grupa je:" + fk[1];
                        }
                    }
                }
                String kriterijum = "";
                kriterijum = !kolicina.equals("") && !filter.equals("") ? String.valueOf(kolicina) + ";" + filter : String.valueOf(kolicina) + filter;
                Vector<Object> eData = new Vector<Object>();
                eData.add(this.rj);
                eData.add(this.firma);
                HashMap<String, String> paramsSR = new HashMap<String, String>();
                paramsSR.put("title", ((TitledBorder)this.plLabeleDugmici.getBorder()).getTitle());
                paramsSR.put("datum", PzDateUtility.formatDate((Date)PzDateUtility.getCurrentDate()).toString());
                paramsSR.put("krit", kriterijum);
                LagerListaRF.showReport((PzScrollableTable)this.tblLagerLista, eData, (PzDialog)this, (String)((TitledBorder)this.plLabeleDugmici.getBorder()).getTitle(), (String)"rs/pezar/reports/compiled/lager_lista.jasper", paramsSR);
            } else if (e.getSource() == this.btnKartica) {
                int selectedRow = this.tblLagerLista.getRealSelectedRowIndex();
                if (selectedRow == -1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Morate obele\u017eiti artikal u tabeli.");
                } else {
                    String a = this.tblLagerLista.getModel().getValueAt(selectedRow, 0).toString();
                    Artikal artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)a);
                    AnalitikaUtil.karticaArtikla((PzDialog)this, artikal, this.rj, null);
                }
            } else if (e.getSource() == this.btnUpitURJ) {
                System.out.println("Selektovan je red:" + this.tblLagerLista.getSelectedRow());
                int selectedRow = this.tblLagerLista.getRealSelectedRowIndex();
                if (selectedRow == -1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Morate obele\u017eiti artikal u tabeli.");
                } else {
                    Upit.upit((PzDialog)this, (Artikal)((Artikal)this.em.find(Artikal.class, this.tblLagerLista.getValueAt(this.tblLagerLista.convertRowIndexToModel(this.tblLagerLista.getSelectedRow()), 0))));
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public boolean shouldBeShown() {
        try {
            this.rj = PzDialogRJ.getRJ((PzDialog)this);
            if (this.rj != null) {
                this.kriterijum = PzDialogKriterijum.getKriterijum(this, this.rj);
                if (this.kriterijum != null) {
                    this.firma = PzFirma.getFirma();
                    PzStatusDialog.showStatus((String)"Sastavljanje lager liste u toku. Ova operacija mo\u017ee da potraje. Molim, sa\u010dekajte", (PzDialog)this);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogLagerListaNew.this.query(PzDialogLagerListaNew.this.createQuery(PzDialogLagerListaNew.this.kriterijum), PzDialogLagerListaNew.this.getVrednostQuery(PzDialogLagerListaNew.this.kriterijum));
                            PzStatusDialog.hideStatus();
                        }
                    });
                    t.start();
                    String[] krit = this.kriterijum.split("\\|");
                    if (krit[1].equals("po_prnc")) {
                        this.tfCena.setVal((Object)"PROS. NABAVNA");
                    } else {
                        this.tfCena.setVal((Object)"PRODAJNA");
                    }
                    if (krit[2].equals("raspoloziva")) {
                        this.tfKolicina.setVal((Object)"RASPOLO\u017dIVA");
                    } else if (krit[2].equals("ukupna")) {
                        this.tfKolicina.setVal((Object)"UKUPNA");
                    } else {
                        this.tfKolicina.setVal((Object)"ALOCIRANA");
                    }
                    this.tfRj.setVal((Object)("[" + this.rj.getId().getOznRj() + "] " + this.rj.getNaziv()));
                    return true;
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            PzStatusDialog.hideStatus();
        }
        return false;
    }

    private String createQuery(String kriterijum) {
        String[] fk;
        String[] krit = kriterijum.split("\\|");
        String filKrit = (String)this.getSession().getParameter("filter");
        String query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, %kolicina%, %cena%, %kolicina%*%cena%, a.oznRobGr, a.oznModel, a.proizvodjac, a.dobSifra FROM StanjeArtikal a %kritFrom% WHERE %kritWhere% %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% ";
        query = query.replaceAll("%filter%", this.qFilter);
        boolean saKolicinom = true;
        if (krit[0].equals("trenutna")) {
            if ("V".equals(this.rj.getpTip()) && !PzParameter.getBoolean((String)"KOLICINE_U_VRED_PROD", (boolean)Boolean.FALSE).booleanValue() || krit[2].equals("bez_kolicine")) {
                query = query.replace("%kolicina%<>0 AND %kolicina% IS NOT NULL", "");
                query = query.replace("%kolicina%*%cena%", "0.0::double precision");
                query = query.replace("%kolicina%", "0.0::double precision");
                query = query.replace("%cena%", "0.0");
                saKolicinom = false;
            }
            query = query.replaceAll("%kolicina%", krit[2].equals("raspoloziva") ? "(a.kolicina - a.alocKolicina)" : (krit[2].equals("ukupna") ? "a.kolicina" : "a.alocKolicina"));
            query = query.replaceAll("%cena%", krit[1].equals("po_prnc") ? "a.prosNabCena" : "a.prodCena");
        } else {
            query = query.replaceAll("%kolicina%", "a.kolPop").replaceAll("%cena%", "a.cenaNaPs");
        }
        query = String.valueOf(query) + (saKolicinom ? " AND " : "") + " a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak% ORDER BY " + (krit[3].equals("sifra") ? "lpad(a.sfrProizvod, 9, '0')" : "a.naziv");
        query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        query = filKrit != null && !filKrit.equals("") ? ((fk = filKrit.split(";"))[0].equals("T") ? query.replaceAll("%kritFrom%", ",Tarifnagrupa t, TGArtikal c ").replaceAll("%kritWhere%", "t.oznVrstaTG='PDV' and t.oznTarGr=c.oznTarGr and c.sfrProizvod=a.sfrProizvod and ") : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "")) : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "");
        return query;
    }

    private String getVrednostQuery(String kriterijum) {
        String[] fk;
        String[] krit = kriterijum.split("\\|");
        String filKrit = (String)this.getSession().getParameter("filter");
        String query = "SELECT SUM(ROUND(CAST(%kolicina%*%cena% AS NUMERIC), 2)) FROM Stanjeartikal a %kritFrom% WHERE %kritWhere% %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%";
        query = query.replaceAll("%filter%", this.qFilter);
        if (krit[0].equals("trenutna")) {
            query = query.replaceAll("%kolicina%", krit[2].equals("raspoloziva") ? "(a.kolicina - a.alocKolicina)" : (krit[2].equals("ukupna") ? "a.kolicina" : "a.alocKolicina"));
            query = query.replaceAll("%cena%", krit[1].equals("po_prnc") ? "a.prosNabCena" : "a.prodCena");
        } else {
            query = query.replaceAll("%kolicina%", "a.kolPop").replaceAll("%cena%", "a.cenaNaPs");
        }
        query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        query = filKrit != null && !filKrit.equals("") ? ((fk = filKrit.split(";"))[0].equals("T") ? query.replaceAll("%kritFrom%", ", Tarifnagrupa t, TGArtikal c ").replaceAll("%kritWhere%", "t.oznVrstaTG='PDV' and t.oznTarGr=c.oznTarGr and c.sfrProizvod=a.sfrProizvod and ") : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "")) : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "");
        return query;
    }

    private void query(String queryGlavni, String queryVrednost) {
        if ((this.em != null && this.em.isOpen()) & (this.cursor != null && !this.cursor.isClosed())) {
            this.cursor.close();
            this.em.close();
        }
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(queryVrednost);
        this.dfUkupnaVrednost.setVal(q.getSingleResult());
        q = this.em.createNativeQuery(queryGlavni);
        q.setHint("eclipselink.cursor.scrollable", (Object)true);
        this.cursor = (ScrollableCursor)q.getSingleResult();
        this.nfBrojSifara.setVal((Object)this.cursor.size());
        String[] columnNames = new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Koli\u010dina", "Cena", "Vrednost", "Robna grupa", "Model", "Proizvo\u0111a\u010d", "Katalo\u0161ki br."};
        if (this.tblLagerLista == null) {
            this.tblLagerLista = new PzScrollableTable(this.cursor, columnNames);
        } else {
            this.tblLagerLista.read(this.cursor, columnNames);
        }
        this.tblLagerLista.getColumnByName("Koli\u010dina").setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKolicinaFormat()));
        this.scPane.setViewportView((Component)this.tblLagerLista);
        if (this.cursor.size() > 0) {
            this.tblLagerLista.setRowSelectionInterval(0, 0);
            this.tblLagerLista.requestFocusInWindow();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

