/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import rs.pezar.analitike.gui.artikli.kartica.PzDialogPojedinacnaKartica;
import rs.pezar.analitike.podesavanja.PnlKarticaArtikala;
import rs.pezar.analitike.util.AnalitikaUtil;
import rs.pezar.analitike.util.PzAnalitikaFinalizer;
import rs.pezar.analitike.widget.duznici.WidgetDuznici;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzExtension;
import rs.pezar.core.gui.defaultWidgets.mainView.MainViewWidget;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.swing.PzDialog;
import rs.pezar.util.PzFileUtility;
import rs.pezar.util.PzFinansijeHelper;

public class PzExtensionLoader
implements PzExtension {
    private TreeElement element;
    private PzApplication application;
    private PzFinansijeHelper finansijeHelper;
    private static PzExtensionLoader instance;
    private WidgetDuznici widgetDuznici;

    public void initExtension(PzApplication application) {
        try {
            instance = this;
            this.application = application;
            application.getTreeElementRegistry().add(this.element);
            application.getSettingsManager().getPanelIntList().add(new PnlKarticaArtikala());
            application.getShortcutRegistry().addShortcut("KARTICA_KOMITENTA", "Kartica komitenta", "ctrl+shift+K", this.createKarticaKomitentaAction());
            application.getShortcutRegistry().addShortcut("KARTICA_ARTIKLA", "Kartica artikla", "ctrl+shift+A", this.createKarticaArtiklaAction());
            application.getDokumentFinalizerRegistry().add(new PzAnalitikaFinalizer());
            this.widgetDuznici = new WidgetDuznici();
            this.application.getWidgetRegistry().add(this.widgetDuznici);
            PzLogger.getInstance().logInfo("rs.pezar.analitike.ExtensionLoader.initExtension(): Dodat duznici widget");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AbstractAction createKarticaArtiklaAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = -5665409469672004922L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = FocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (window instanceof PzDialog) {
                    ((PzDialog)window).showDialog(PzDialogPojedinacnaKartica.class);
                }
            }
        };
    }

    private AbstractAction createKarticaKomitentaAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = -5665409469672004922L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = FocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (window instanceof PzDialog) {
                    AnalitikaUtil.karticaKomitenta((PzDialog)window);
                }
            }
        };
    }

    public void load() {
        try {
            Document dok = PzFileUtility.loadXML((String)"rs/pezar/analitike/resource/view.xml", (ClassLoader)this.getClass().getClassLoader());
            this.element = new TreeElement((Node)dok.getDocumentElement(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unload() {
        ((MainViewWidget)this.application.getWorkbench().getWorkArea().getWidgetById(MainViewWidget.ID)).removeElement(this.element);
        this.element = null;
    }

    public PzApplication getApplication() {
        return this.application;
    }

    public static Pzuser getLoggedUser() {
        return instance.getApplication().getSession().getLoggedUser();
    }

    public static PzExtensionLoader getInstance() {
        return instance;
    }
}

