/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import rs.pezar.analitike.gui.artikli.nivelacije.IzmenaCena;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksanivelacija;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class NivelacijaManager {
    public static void arhivirajNivelaciju(final Nivelacija n, final IzmenaCena dlg) {
        final EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        PzWorkerDialog.showStatus((String)"Arhiviranje dokumenta je u toku. Molim, sa\u010dekajte.", (PzDialog)dlg);
        SwingWorker<Nivelacija, Object> worker = new SwingWorker<Nivelacija, Object>(){

            @Override
            protected Nivelacija doInBackground() throws Exception {
                em.getTransaction().begin();
                System.out.println("################# POCINJEM ARHIVIRANJE NIVELACIJE");
                List duplikati = em.createQuery("SELECT an.id.sfrProizvod, COUNT(an.id.sfrProizvod) FROM Artikalnivelacija an WHERE an.id.idDok = " + n.getIdDok() + " GROUP BY an.id.sfrProizvod HAVING COUNT(an.id.sfrProizvod) > 1").getResultList();
                if (duplikati.size() > 0) {
                    throw new TransformationException("Gre\u0161ka! Artikal " + (String)((Object[])duplikati.get(0))[0] + " se javlja vi\u0161e od jedanput na nivelaciji!");
                }
                duplikati = null;
                List cene = em.createQuery("SELECT an.id.sfrProizvod, an.cenaNova FROM Artikalnivelacija an WHERE an.id.idDok=" + n.getIdDok()).getResultList();
                List sfrList = em.createQuery("SELECT s.id.sfrProizvod FROM Stanje s WHERE s.id.sfrProizvod IN (SELECT an.id.sfrProizvod FROM Artikalnivelacija an WHERE an.id.idDok=:iddok) AND s.radnajedinica=:rj").setParameter("iddok", (Object)n.getIdDok()).setParameter("rj", (Object)n.getRadnajedinica()).getResultList();
                for (Object[] c : cene) {
                    if (!sfrList.contains(c[0])) {
                        Stanje s = new Stanje();
                        s.setId(new StanjePK((String)c[0], n.getRadnajedinica()));
                        s.setRadnajedinica(n.getRadnajedinica());
                        s.setProdCena(((Double)c[1]).doubleValue());
                        em.persist((Object)s);
                        continue;
                    }
                    em.createQuery("UPDATE Stanje s SET s.prodCena=" + c[1] + " WHERE s.id.sfrProizvod='" + c[0] + "' AND s.id.oznRj=" + n.getRadnajedinica().getId().getOznRj() + " AND s.id.oznOgranak=" + n.getRadnajedinica().getId().getOznOgranak()).executeUpdate();
                }
                cene = null;
                if (!n.getRadnajedinica().getTip().equals("EV")) {
                    em.createQuery("DELETE FROM Antaksa t WHERE t.artikalnivelacija.kolicina<=0 AND t.artikalnivelacija.id.idDok=" + n.getIdDok()).executeUpdate();
                    em.createQuery("DELETE FROM Artikalnivelacija a WHERE a.kolicina<=0 AND a.id.idDok=" + n.getIdDok()).executeUpdate();
                    em.createNativeQuery("UPDATE Artikalnivelacija SET vrednost = ROUND(CAST(kolicina*(cenaNova-cenaStara) AS NUMERIC), 2) WHERE idDok=" + n.getIdDok()).executeUpdate();
                    em.flush();
                }
                if ((Long)em.createQuery("SELECT COUNT(an) FROM Artikalnivelacija an WHERE an.id.idDok=" + n.getIdDok()).getSingleResult() == 0L) {
                    em.remove(em.find(Nivelacija.class, (Object)n.getIdDok()));
                    em.getTransaction().commit();
                    return null;
                }
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)n, false, null, em);
                String query = "INSERT INTO ArtikalDokument (idDok, sfrProizvod, rBroj, naziv, bliziOpis, jm, kolicina, cena, vrsta, vrednost) (SELECT an.idDok, an.sfrProizvod, an.rBroj, an.naziv, an.bliziOpis, an.jm, an.kolicina, an.cenaNova, 'L', an.vrednost " + "FROM ArtikalNivelacija an WHERE an.idDok=:idDok)".replace(":idDok", String.valueOf(n.getIdDok()));
                Query q = em.createNativeQuery(query);
                q.executeUpdate();
                query = "INSERT INTO ADTaksa (oznTarGr, idDok, sfrProizvod, rBroj, oznVrstaTG, stopa, opis) " + "(SELECT at.oznTarGr, at.idDok, at.sfrProizvod, at.rBroj, at.oznVrstaTG, at.stopa, at.opis FROM ANTaksa at WHERE at.idDok=:idDok)".replace(":idDok", String.valueOf(n.getIdDok()));
                query = query.replaceAll(":idDok", "" + n.getIdDok());
                q = em.createNativeQuery(query);
                q.executeUpdate();
                query = "SELECT an.cenaStara*an.kolicina, an.cenaNova*an.kolicina FROM Artikalnivelacija an WHERE an.id.idDok=" + n.getIdDok();
                List res = em.createQuery(query).getResultList();
                BigDecimal bdStara = new BigDecimal(0.0);
                BigDecimal bdNova = new BigDecimal(0.0);
                double stara = 0.0;
                double nova = 0.0;
                for (Object[] val : res) {
                    bdStara = bdStara.add(new BigDecimal((Double)val[0])).setScale(2, 4);
                    bdNova = bdNova.add(new BigDecimal((Double)val[1])).setScale(2, 4);
                }
                stara = bdStara.doubleValue();
                nova = bdNova.doubleValue();
                q = em.createQuery("UPDATE Nivelacija n SET n.staraVrednost=:stara, n.novaVrednost=:nova WHERE n.idDok=" + n.getIdDok());
                q.setParameter("stara", (Object)stara);
                q.setParameter("nova", (Object)nova);
                q.executeUpdate();
                q = em.createQuery("SELECT DISTINCT t.id.oznTarGr, t.oznVrstaTG FROM Antaksa t WHERE t.id.idDok=" + n.getIdDok());
                List tarGrupe = q.getResultList();
                for (Object[] tgr : tarGrupe) {
                    Tarifnagrupa tGrupa = (Tarifnagrupa)em.find(Tarifnagrupa.class, tgr[0]);
                    q = em.createQuery("SELECT a.kolicina, a.cenaStara, a.cenaNova, t.stopa FROM Artikalnivelacija a JOIN a.antaksas t WHERE t.id.oznTarGr='" + tgr[0] + "' AND t.id.idDok=" + n.getIdDok());
                    List values = q.getResultList();
                    String tip = n.getRadnajedinica().getgTip().equals("V") || n.getRadnajedinica().getgTip().equals("T") ? PzTaksaDokument.TIP_IZRACUNATI : PzTaksaDokument.TIP_UKALKULISANI;
                    Taksanivelacija tn = new Taksanivelacija(n.getIdDok(), tip, (String)tgr[0]);
                    BigDecimal osnovicaNova = new BigDecimal(0.0);
                    BigDecimal osnovicaStara = new BigDecimal(0.0);
                    BigDecimal iznosNovi = new BigDecimal(0.0);
                    BigDecimal iznosStari = new BigDecimal(0.0);
                    for (Object[] value : values) {
                        osnovicaStara = osnovicaStara.add(NivelacijaManager.calculateOsnovica((Double)value[0], (Double)value[1], (Double)value[3], n));
                        iznosStari = iznosStari.add(NivelacijaManager.calculateTaksa((Double)value[0], (Double)value[1], (Double)value[3], n));
                        osnovicaNova = osnovicaNova.add(NivelacijaManager.calculateOsnovica((Double)value[0], (Double)value[2], (Double)value[3], n));
                        iznosNovi = iznosNovi.add(NivelacijaManager.calculateTaksa((Double)value[0], (Double)value[2], (Double)value[3], n));
                    }
                    if (tn.getTip().equals(PzTaksaDokument.TIP_IZRACUNATI)) {
                        tn.setOsnovica(osnovicaNova.subtract(osnovicaStara));
                        tn.setIznos(tn.getOsnovica().multiply(BDConverter.getStopaPDVProc((double)tGrupa.getStopa())));
                    } else {
                        tn.setOsnovica(osnovicaNova.subtract(osnovicaStara));
                        tn.setIznos(iznosNovi.subtract(iznosStari));
                    }
                    tn.setNivelacija(n);
                    tn.setTarifnagrupa(tGrupa);
                    tn.setVrsta((String)tgr[1]);
                    em.persist((Object)tn);
                    Dtaksa dt = new Dtaksa((PzTaksaDokument)tn, n.getDokument());
                    em.persist((Object)dt);
                    if (n.getTaksanivelacijas() == null) {
                        n.setTaksanivelacijas(new Vector());
                    }
                    n.getTaksanivelacijas().add(tn);
                }
                System.out.println("################# ZAVRSAVAM ARHIVIRANJE NIVELACIJE");
                em.getTransaction().commit();
                return n;
            }

            @Override
            protected void done() {
                try {
                    try {
                        if (this.get() == null) {
                            JOptionPane.showMessageDialog((Component)((Object)dlg), "Ne postoje uslovi za izradu nivelacije, ali su cene izmenjene.");
                        } else {
                            PzReportManager.createAndShowReport((PzDialog)dlg, (PzDokument)((PzDokument)this.get()));
                        }
                        dlg.dispose();
                    }
                    catch (Exception e) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                        em.close();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                    em.close();
                }
            }
        };
        worker.execute();
    }

    private static BigDecimal calculateOsnovica(double kolicina, double cena, double stopa, Nivelacija n) {
        BigDecimal kolicinaBD = BDConverter.getKolicina((double)kolicina);
        BigDecimal cenaBD = BDConverter.getProdCena((double)cena);
        if (n.getRadnajedinica().getgTip().equals("V") || n.getRadnajedinica().getgTip().equals("T")) {
            return BDConverter.getIznos((BigDecimal)kolicinaBD.multiply(cenaBD));
        }
        return BDConverter.getIznos((BigDecimal)kolicinaBD.multiply(cenaBD));
    }

    private static BigDecimal calculateTaksa(double kolicina, double cena, double stopa, Nivelacija n) {
        BigDecimal kolicinaBD = BDConverter.getKolicina((double)kolicina);
        BigDecimal cenaBD = BDConverter.getProdCena((double)cena);
        BigDecimal stopaBD = BDConverter.getStopaPDVProc((double)stopa);
        if (n.getRadnajedinica().getgTip().equals("V") || n.getRadnajedinica().getgTip().equals("T")) {
            return BDConverter.getIznos((BigDecimal)BDConverter.getIznos((BigDecimal)stopaBD.multiply(cenaBD)).multiply(kolicinaBD));
        }
        return BDConverter.getIznos((BigDecimal)kolicinaBD.multiply(BDConverter.getProdCena((double)(cena * stopa / (100.0 + stopa)))));
    }

    public static boolean postojiDokumentUPripremi(EntityManager em, String sfrProizvod, Nivelacija n) throws PzInfoException {
        List ids = em.createQuery("SELECT d.idDok, d.tip FROM Dokument d WHERE d.arhiviran=0 AND d.radnajedinica=:rj").setParameter("rj", (Object)n.getRadnajedinica()).getResultList();
        if (ids.size() > 0) {
            for (Object[] o : ids) {
                Integer idDok = (Integer)o[0];
                String tip = (String)o[1];
                if (tip.equals(TipDokumentConfig.get().NIVELACIJA)) continue;
                Class c = TipDokumentConfig.getClassByValue((String)tip);
                PzDokument d = (PzDokument)em.find(c, (Object)idDok);
                for (PzArtikalDokument ad : d.getArtikalDocuments()) {
                    if (!ad.getId().getSfrProizvod().equals(sfrProizvod)) continue;
                    throw new PzInfoException("Postoji dokument u pripremi tipa " + TipDokumentConfig.getNameByValue((String)d.getTip(), null) + " kod korisnika " + d.getUserKraj().getFullName() + " koji sadrzi ovaj artikal i zbog toga vam je ova akcija zabranjena");
                }
            }
        }
        return false;
    }
}

