/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.util;

import java.io.OutputStream;
import java.math.BigInteger;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String intToString(int n) {
        char[] buf = new char[8];
        int i = 7;
        while (i >= 0) {
            buf[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --i;
        }
        return new String(buf);
    }

    public static String toString(byte[] ba) {
        return HexDump.toString(ba, 0, ba.length);
    }

    public static String toString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String formatHex(int i, int sz) {
        String str = Integer.toHexString(i);
        while (str.length() < sz) {
            str = "0" + str;
        }
        return str;
    }

    public static void print(byte[] buf, int off, int len) {
        HexDump.print(System.err, null, true, buf, off, len);
    }

    public static void print(OutputStream out, byte[] buf, int off, int len) {
        HexDump.print(out, null, true, buf, off, len);
    }

    public static void print(String header, boolean showAddr, byte[] buf, int off, int len) {
        HexDump.print(System.err, header, showAddr, buf, off, len);
    }

    public static synchronized void print(OutputStream out, String header, boolean showAddr, byte[] buf, int off, int len) {
        if (header != null) {
            try {
                out.write(header.getBytes());
                out.write("\r\n".getBytes());
            }
            catch (Exception exception) {}
        }
        int i = 0;
        while (i < len) {
            int c;
            int jmax;
            StringBuffer line = new StringBuffer();
            if (showAddr) {
                line.append(HexDump.formatHex(i + off, 8));
                line.append(": ");
            }
            jmax = (jmax = len - i) > 16 ? 16 : jmax;
            int j = 0;
            while (j < jmax) {
                c = (buf[off + i + j] + 256) % 256;
                line.append(HexDump.formatHex(c, 2));
                if (j % 2 == 1) {
                    line.append(" ");
                }
                ++j;
            }
            while (j < 16) {
                line.append("  ");
                if (j % 2 == 1) {
                    line.append(" ");
                }
                ++j;
            }
            line.append(" ");
            j = 0;
            while (j < jmax) {
                c = (buf[off + i + j] + 256) % 256;
                c = c < 32 || c >= 127 ? 46 : c;
                line.append((char)c);
                ++j;
            }
            try {
                out.write(line.toString().getBytes());
                out.write("\r\n".getBytes());
            }
            catch (Exception exception) {}
            i += 16;
        }
    }

    public static void print(byte[] buf) {
        if (buf == null) {
            System.err.println("<null>");
            return;
        }
        HexDump.print(buf, 0, buf.length);
    }

    public static void print(BigInteger bi) {
        byte[] raw = bi.toByteArray();
        if (raw.length == 1 && raw[0] == 0) {
            raw = new byte[]{};
        }
        HexDump.print(raw);
    }
}

