/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.commporthandler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JDialog;
import rs.pezar.kasa.util.FileTool;
import rs.pezar.kasa.util.OSTool;
import rs.pezar.kasa.util.PzFileUtility;

public class DriverInstaller {
    private static String javaJarPath;
    private static String javaSharedObjectPath;

    static {
        if (OSTool.isWindows()) {
            javaJarPath = String.valueOf(System.getProperties().getProperty("java.home")) + "\\lib\\ext\\";
            javaSharedObjectPath = String.valueOf(System.getProperties().getProperty("java.home")) + "\\bin\\";
        } else if (OSTool.isUnix()) {
            javaJarPath = String.valueOf(System.getProperties().getProperty("java.home")) + "/lib/ext/";
            javaSharedObjectPath = String.valueOf(System.getProperties().getProperty("java.home")) + "/lib/" + System.getProperties().getProperty("os.arch") + "/";
        }
    }

    public static void install() throws IOException {
        if (OSTool.isWindows()) {
            DriverInstaller.fromResourceToFile("rs/pezar/kasa/res/drivers/win/rxtxSerial.dll", String.valueOf(javaSharedObjectPath) + "rxtxSerial.dll");
        } else if (OSTool.isUnix()) {
            DriverInstaller.fromResourceToFile("rs/pezar/kasa/res/drivers/lin/librxtxSerial.so", String.valueOf(javaSharedObjectPath) + "librxtxSerial.so");
        }
    }

    public static void install(JDialog parent) throws IOException {
        String dirName = PzFileUtility.selectDirectory("Izaberi jre direktorijum", parent).getCanonicalPath();
        if (dirName == null) {
            return;
        }
        if (OSTool.isWindows()) {
            File dir1;
            File dir = new File(String.valueOf(dirName) + "\\lib\\ext");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(dir1 = new File(String.valueOf(dirName) + "\\bin")).exists()) {
                dir1.mkdirs();
            }
            DriverInstaller.fromResourceToFile("rs/pezar/kasa/res/drivers/win/rxtxSerial.dll", String.valueOf(dirName) + "\\bin\\rxtxSerial.dll");
        } else if (OSTool.isUnix()) {
            File dir1;
            File dir = new File(String.valueOf(dirName) + "/lib/ext/");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(dir1 = new File(String.valueOf(dirName) + "/lib/" + System.getProperties().getProperty("os.arch") + "/")).exists()) {
                dir1.mkdirs();
            }
            DriverInstaller.fromResourceToFile("rs/pezar/kasa/res/drivers/lin/librxtxSerial.so", String.valueOf(dirName) + "/lib/" + System.getProperties().getProperty("os.arch") + "/librxtxSerial.so");
        }
    }

    private static void copyDirectoryContents(String fromDirectory, String toDirectory) throws IOException {
        File[] list = DriverInstaller.listFiles(fromDirectory);
        int i = 0;
        while (i < list.length) {
            if (list[i].isFile()) {
                FileTool.copy(String.valueOf(fromDirectory) + list[i].getName(), toDirectory);
            }
            ++i;
        }
    }

    public static Boolean isInstalled() throws Exception {
        File file;
        if (OSTool.isWindows() ? !(file = new File(String.valueOf(javaSharedObjectPath) + "rxtxSerial.dll")).exists() : OSTool.isUnix() && !(file = new File(String.valueOf(javaSharedObjectPath) + "librxtxSerial.so")).exists()) {
            return false;
        }
        return true;
    }

    private static Boolean folderContainsAllFiles(String driverDirectory, String systemDirectory) {
        File[] list = DriverInstaller.listFiles(driverDirectory);
        int i = 0;
        while (i < list.length) {
            File f;
            if (list[i].isFile() && !(f = new File(String.valueOf(systemDirectory) + list[i].getName())).exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static File[] listFiles(String driverDirectory) {
        File folder = new File(driverDirectory);
        File[] listOfFiles = folder.listFiles();
        return listOfFiles;
    }

    public static void fromResourceToFile(String resourcePath, String filePath) throws IOException {
        int length;
        File f = new File(filePath);
        InputStream is = DriverInstaller.class.getClassLoader().getResource(resourcePath).openStream();
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buffer = new byte[4096];
        while ((length = is.read(buffer)) > 0) {
            fos.write(buffer, 0, length);
        }
        fos.close();
        is.close();
    }

    public static void main(String[] args) {
        try {
            DriverInstaller.isInstalled();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DriverInstaller.isInstalled().booleanValue();
            DriverInstaller.install(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("aaa");
    }
}

