/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.liste.ListaUtil;
import rs.pezar.liste.RManager;
import rs.pezar.liste.tipovi.TipListe;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class UzmiDrugu
extends PzDialog {
    private JToolBar toolbar;
    private PzToolBarIcon btnSlika;
    private PzPanel plGlavni;
    private Lista lista;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private String tipDokumenta;
    private Lista selektovanaLista;
    private String tableID = "";

    public UzmiDrugu(PzDialog dialog) {
        super(dialog);
        this.preInit();
        this.initGUI();
    }

    private void preInit() {
        this.lista = (Lista)this.getSession().getParameter("lista");
        this.tipDokumenta = this.getSession().getParameter("tipDokumenta").toString();
        this.setTitle("Izaberite narud\u017ebenicu");
        this.tableID = "TABLE_NARUDZBENICA";
        this.setId("NARUDZBENICA");
        if (this.tipDokumenta.equals(ListaUtil.getTipListe("PONUDA"))) {
            this.setTitle("Izaberite ponudu");
            this.tableID = "TABLE_PONUDA";
            this.setId("PONUDA");
        }
    }

    private void initGUI() {
        try {
            this.plGlavni = new PzPanel();
            this.plGlavni.setPaintGradient(true);
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlika);
            this.btnSlika.setText("Slika|narud\u017ebenice|(F2)");
            this.btnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/presentation_chart.png")));
            this.btnSlika.setActionCommand("slika");
            this.btnSlika.addActionListener((ActionListener)((Object)this));
            this.btnSlika.setShortcut("F2");
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.jPanel1.setOpaque(false);
            this.plTabela = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.plTabela.setOpaque(false);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Lista dok = (Lista)entity;
                    return new Object[]{dok.getrBroj(), dok.getDatum(), dok.getKomitent().getNaziv()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka", "Datum", "Komitent"};
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT l FROM Lista l where l.tip=:tip and l.arhiviran = 1 order by l.datum asc");
            q.setParameter("tip", (Object)this.tipDokumenta);
            Vector data = (Vector)q.getResultList();
            this.tblTabela.setData(data, Faktura.class);
            em.close();
            this.tblTabela.setId(this.tableID);
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UzmiDrugu.this.selektovanaLista = null;
                    if (UzmiDrugu.this.tblTabela.getDataSize() > 0) {
                        EntityManager em = PzEntityManager.getEm();
                        try {
                            try {
                                Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)UzmiDrugu.this.getParentDialog());
                                em.getTransaction().begin();
                                UzmiDrugu.this.selektovanaLista = (Lista)UzmiDrugu.this.tblTabela.getSelectedEntity();
                                UzmiDrugu.this.lista.kopirajArtikleSaListe(UzmiDrugu.this.selektovanaLista, rj);
                                em.merge((Object)UzmiDrugu.this.lista);
                                em.getTransaction().commit();
                                UzmiDrugu.this.dispose();
                                ((PzTable)UzmiDrugu.this.getSession().getParameter("tabela")).refreshData();
                            }
                            catch (Exception ex) {
                                PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                                if (em.getTransaction().isActive()) {
                                    em.getTransaction().rollback();
                                }
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            });
            this.setSize(900, 450);
            this.setMinimumSize(new Dimension(900, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                try {
                    Lista selektovanaLista = (Lista)this.tblTabela.getSelectedEntity();
                    TipListe tip = RManager.getInstance().getTipListe(this.lista.getTip());
                    Vector<Lista> liste = new Vector<Lista>();
                    liste.add(selektovanaLista);
                    TipListe.IzvestajDescriptor.IzvestajHeader[] headers = tip.getIzvestaji()[0].getHeaders();
                    RManager.showReports(liste, tip.getIzvestaji()[0].getIzvestaj(), headers[0].getReport().toString(), null);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UzmiDrugu(Boolean.FALSE);
    }

    public UzmiDrugu(Boolean initGUI) {
    }
}

