/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Lista;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;

public class PovecanjeCena
extends PzDialog {
    private JLabel lblGenPovCena;
    private PzDoubleField dfProcenatGPC;
    private PzButton btnPotvrdi;
    private PzPanel plGlavni;
    private Lista narudzbenica;

    public PovecanjeCena(PzDialog dialog) {
        super(dialog);
        this.narudzbenica = (Lista)this.getSession().getParameter("lista");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Pove\u0107anje cena");
            this.plGlavni = new PzPanel();
            this.plGlavni.setPaintGradient(true);
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavni, "Center");
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{42, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{130, 100, 20};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.lblGenPovCena = new JLabel();
            this.plGlavni.add((Component)this.lblGenPovCena, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblGenPovCena.setText("Procenat pove\u0107anja");
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(120, 30));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.dfProcenatGPC = new PzDoubleField();
            this.plGlavni.add((Component)this.dfProcenatGPC, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfProcenatGPC.setPreferredSize(new Dimension(60, 24));
            this.dfProcenatGPC.setFont(new Font("Tahoma", 0, 14));
            this.dfProcenatGPC.setDecimalFormat(PzFormatFactory.getStopaPDVFormat());
            this.dfProcenatGPC.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    return !(PovecanjeCena.this.dfProcenatGPC.getVal() <= 0.0);
                }
            });
            this.pack();
            this.setSize(300, 108);
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dfProcenatGPC.getVal() > 0.0) {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    em.getTransaction().begin();
                    for (Artikallista aLista : this.narudzbenica.getArtikallistas()) {
                        Double cena = aLista.getCena().doubleValue() + aLista.getCena().doubleValue() / 100.0 * this.dfProcenatGPC.getVal();
                        aLista.setCena(BDConverter.getFakturnaCena((double)cena));
                        PzEntityManager.update((Object)aLista, (EntityManager)em);
                    }
                    em.getTransaction().commit();
                    ((PzTable)this.getSession().getParameter("tabela")).refreshData();
                    this.dispose();
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PovecanjeCena(Boolean.FALSE);
    }

    public PovecanjeCena(Boolean initGUI) {
    }
}

