/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Model;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.liste.ListaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogModeli;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class DopunaPoLageru
extends PzDialog {
    private PzPanelHeader header;
    private PzPanel panel;
    private PzTextField tfTip;
    private JLabel jlTarifa;
    private PzTextField tfTarifa;
    private PzTextField tfRGR;
    private PzTextField tfProizvodjac;
    private PzRadioGroup radioGroup;
    private PzPanel panelButtons;
    private PzButton btnOk;
    private final Lista narudzbenica = (Lista)this.getSession().getParameter("lista");
    private final PzTable table;
    private JLabel jlTip;
    private final Radnajedinica rj = (Radnajedinica)this.getSession().getParameter("rj");
    private JLabel jlRGR;
    private Tarifnagrupa tarGrupa;
    private JLabel jlProizv;
    private Komitent proizvodjac;
    private Robnagrupa robnaGrupa;
    private Model model;
    private EntityManager em;

    public DopunaPoLageru(PzDialog dialog) {
        super(dialog);
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.initGUI();
    }

    protected void initGUI() {
        BorderLayout blayout = new BorderLayout();
        this.setLayout(blayout);
        this.setTitle("Dopuna dokumenta po lageru");
        this.panel = new PzPanel();
        this.panel.setPaintGradient(true);
        GridBagLayout panelLayout1 = new GridBagLayout();
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int[] nArray = new int[6];
        nArray[1] = 25;
        nArray[2] = 24;
        nArray[3] = 25;
        nArray[5] = 49;
        panelLayout.rowHeights = nArray;
        panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        int[] nArray2 = new int[6];
        nArray2[0] = 31;
        nArray2[1] = 185;
        nArray2[2] = 20;
        nArray2[4] = 100;
        nArray2[5] = 20;
        panelLayout.columnWidths = nArray2;
        this.getContentPane().add((Component)this.panel, "Center");
        panelLayout1.rowWeights = new double[]{0.1, 0.1, 0.1, 0.0, 0.1, 0.1};
        panelLayout1.rowHeights = new int[]{7, 7, 7, 7, 7, 7};
        panelLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
        panelLayout1.columnWidths = new int[]{7, 7, 7, 7, 20, 7};
        this.panel.setLayout((LayoutManager)panelLayout1);
        this.radioGroup = DopunaPoLageru.createRadioGroup();
        this.radioGroup.setSelectedIndex(0);
        this.radioGroup.setOpaque(false);
        GridBagConstraints gbc_pzRadioGroupIntervalKonta = new GridBagConstraints();
        gbc_pzRadioGroupIntervalKonta.gridheight = 4;
        gbc_pzRadioGroupIntervalKonta.insets = new Insets(0, 5, 5, 5);
        gbc_pzRadioGroupIntervalKonta.fill = 1;
        gbc_pzRadioGroupIntervalKonta.gridx = 1;
        gbc_pzRadioGroupIntervalKonta.gridy = 1;
        this.panel.add((Component)this.radioGroup, (Object)new GridBagConstraints(0, 1, 3, 3, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.radioGroup.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                if (evt.getValue().equals("Klasi\u010dna")) {
                    DopunaPoLageru.this.jlProizv.setVisible(false);
                    DopunaPoLageru.this.jlRGR.setVisible(false);
                    DopunaPoLageru.this.jlTarifa.setVisible(false);
                    DopunaPoLageru.this.jlTip.setVisible(false);
                    DopunaPoLageru.this.tfProizvodjac.setVisible(false);
                    DopunaPoLageru.this.tfRGR.setVisible(false);
                    DopunaPoLageru.this.tfTarifa.setVisible(false);
                    DopunaPoLageru.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Za odredjeni tip")) {
                    DopunaPoLageru.this.jlProizv.setVisible(false);
                    DopunaPoLageru.this.jlRGR.setVisible(false);
                    DopunaPoLageru.this.jlTarifa.setVisible(false);
                    DopunaPoLageru.this.jlTip.setVisible(true);
                    DopunaPoLageru.this.tfProizvodjac.setVisible(false);
                    DopunaPoLageru.this.tfRGR.setVisible(false);
                    DopunaPoLageru.this.tfTarifa.setVisible(false);
                    DopunaPoLageru.this.tfTip.setVisible(true);
                } else if (evt.getValue().equals("Ista tarifa")) {
                    DopunaPoLageru.this.jlProizv.setVisible(false);
                    DopunaPoLageru.this.jlRGR.setVisible(false);
                    DopunaPoLageru.this.jlTarifa.setVisible(true);
                    DopunaPoLageru.this.jlTip.setVisible(false);
                    DopunaPoLageru.this.tfProizvodjac.setVisible(false);
                    DopunaPoLageru.this.tfRGR.setVisible(false);
                    DopunaPoLageru.this.tfTarifa.setVisible(true);
                    DopunaPoLageru.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Ista robna grupa")) {
                    DopunaPoLageru.this.jlProizv.setVisible(false);
                    DopunaPoLageru.this.jlRGR.setVisible(true);
                    DopunaPoLageru.this.jlTarifa.setVisible(false);
                    DopunaPoLageru.this.jlTip.setVisible(false);
                    DopunaPoLageru.this.tfProizvodjac.setVisible(false);
                    DopunaPoLageru.this.tfRGR.setVisible(true);
                    DopunaPoLageru.this.tfTarifa.setVisible(false);
                    DopunaPoLageru.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Isti proizvodjac")) {
                    DopunaPoLageru.this.jlProizv.setVisible(true);
                    DopunaPoLageru.this.jlRGR.setVisible(false);
                    DopunaPoLageru.this.jlTarifa.setVisible(false);
                    DopunaPoLageru.this.jlTip.setVisible(false);
                    DopunaPoLageru.this.tfProizvodjac.setVisible(true);
                    DopunaPoLageru.this.tfRGR.setVisible(false);
                    DopunaPoLageru.this.tfTarifa.setVisible(false);
                    DopunaPoLageru.this.tfTip.setVisible(false);
                }
            }
        });
        this.jlTip = new JLabel();
        this.jlTip.setText("Tip");
        GridBagConstraints gbc_lblP = new GridBagConstraints();
        gbc_lblP.anchor = 13;
        gbc_lblP.insets = new Insets(0, 0, 5, 5);
        gbc_lblP.gridx = 3;
        gbc_lblP.gridy = 1;
        this.panel.add((Component)this.jlTip, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jlTip.setVisible(false);
        this.tfTip = new PzTextField();
        this.panel.add((Component)this.tfTip, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.tfTip.setVisible(false);
        this.tfTip.setMaxLength(5);
        this.tfTip.setFKField(Model.class, PzDialogModeli.class, true, "Neispravna oznaka modela!");
        this.jlTarifa = new JLabel();
        this.panel.add((Component)this.jlTarifa, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.jlTarifa.setText("Tarifa");
        this.jlTarifa.setVisible(false);
        this.tfTarifa = new PzTextField();
        this.panel.add((Component)this.tfTarifa, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.tfTarifa.setVisible(false);
        this.tfTarifa.setMaxLength(3);
        this.tfTarifa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, "Uneta tarifna grupa nije na\u0111ena!");
        this.jlRGR = new JLabel("Robna grupa");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 3;
        gbc_label.gridy = 3;
        this.panel.add((Component)this.jlRGR, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.jlRGR.setVisible(false);
        this.tfRGR = new PzTextField();
        this.panel.add((Component)this.tfRGR, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.tfRGR.setVisible(false);
        this.tfRGR.setMaxLength(3);
        this.tfRGR.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, "Uneta robna grupa nije na\u0111ena!");
        this.jlProizv = new JLabel("Proizvodjac");
        gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 3;
        gbc_label.gridy = 4;
        this.panel.add((Component)this.jlProizv, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jlProizv.setVisible(false);
        this.tfProizvodjac = new PzTextField();
        this.panel.add((Component)this.tfProizvodjac, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.tfProizvodjac.setVisible(false);
        this.tfProizvodjac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        this.panelButtons = new PzPanel();
        this.panel.add((Component)this.panelButtons, (Object)new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.btnOk = new PzButton();
        this.panelButtons.add((Component)this.btnOk);
        this.btnOk.setText("Potvrdi");
        this.btnOk.setActionCommand("potvrdi");
        this.btnOk.setPreferredSize(new Dimension(80, 30));
        this.btnOk.addActionListener((ActionListener)((Object)this));
        this.header = new PzPanelHeader();
        this.panel.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.header.setTitle("Dopuna po lageru");
        this.pack();
        this.setSize(414, 264);
        this.setResizable(false);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            this.em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molimo sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    DopunaPoLageru.this.em.getTransaction().begin();
                    DopunaPoLageru.this.dopuniti(DopunaPoLageru.this.em);
                    DopunaPoLageru.this.em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            DopunaPoLageru.this.table.commitInsert();
                            DopunaPoLageru.this.dispose();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Throwable)e);
                            PzWorkerDialog.hideStatus();
                            DopunaPoLageru.this.em.close();
                        }
                    }
                    finally {
                        DopunaPoLageru.this.em.close();
                    }
                }
            };
            sw.execute();
        }
    }

    private void dopuniti(EntityManager em) {
        Query q = null;
        if (this.radioGroup.getSelectedIndex() == 0) {
            q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and s.kolicina-s.alocKolicina != 0 AND s.oznRj='" + this.rj.getId().getOznRj() + "'");
        } else if (this.radioGroup.getSelectedIndex() == 1) {
            q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and s.kolicina-s.alocKolicina != 0 AND s.oznRj='" + this.rj.getId().getOznRj() + "' and a.oznModel='" + this.model.getOznModel() + "'");
        } else if (this.radioGroup.getSelectedIndex() == 2) {
            q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, m.oznModel, m.naziv FROM Stanje s, Tarifnagrupa t, TGArtikal c, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and s.kolicina-s.alocKolicina != 0 and s.oznRj='" + this.rj.getId().getOznRj() + "' " + "and t.oznVrstaTG='PDV' and t.oznTarGr=c.oznTarGr and c.sfrProizvod=a.sfrProizvod and t.oznTarGr='" + this.tarGrupa.getOznTarGr() + "'");
        } else if (this.radioGroup.getSelectedIndex() == 3) {
            q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and s.kolicina-s.alocKolicina != 0 and s.oznRj='" + this.rj.getId().getOznRj() + "' AND a.oznRobGr='" + this.robnaGrupa.getOznRobGr() + "'");
        } else if (this.radioGroup.getSelectedIndex() == 4) {
            q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and s.kolicina-s.alocKolicina != 0 and s.oznRj='" + this.rj.getId().getOznRj() + "' AND a.proizvodjac='" + this.proizvodjac.getSfrKomitent() + "'");
        }
        Vector stavke = (Vector)q.getResultList();
        for (Object[] obj : stavke) {
            String sifra = (String)obj[0];
            String sifraDob = (String)obj[1];
            String naziv = (String)obj[2];
            String bliziOpis = (String)obj[3];
            String jm = (String)obj[4];
            BigDecimal cena = (BigDecimal)obj[5];
            double kolicina = (Double)obj[6];
            String model = (String)obj[7];
            String nazivModela = (String)obj[8];
            this.narudzbenica.setCounter(this.narudzbenica.getNextRBrojArtikli());
            Artikallista artLista = new Artikallista();
            ArtikallistaPK artPK = new ArtikallistaPK(this.narudzbenica.getIdLista(), Integer.valueOf(this.narudzbenica.getCounter()));
            artLista.setId(artPK);
            artLista.setSfrProizvod(sifra);
            artLista.setDobSifra(sifraDob);
            artLista.setNaziv(naziv);
            artLista.setBliziOpis(bliziOpis);
            artLista.setJm(jm);
            artLista.setCena(BDConverter.getProdCena((double)cena.doubleValue()));
            artLista.setKolicina(kolicina);
            artLista.setPomKolicina(kolicina);
            artLista.setOznModel(model);
            artLista.setNazivModel(nazivModela);
            if (this.narudzbenica.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                artLista.setPomKolicina(0.0);
                artLista.setTip("1");
            }
            artLista.setLista(this.narudzbenica);
            this.narudzbenica.getArtikallistas().add(artLista);
            this.table.insert((PzEntity)artLista, em);
        }
        em.merge((Object)this.narudzbenica);
    }

    public static PzRadioGroup createRadioGroup() {
        PzRadioGroup radiogroup = PzRadioGroup.create((Object[])new String[]{"Klasi\u010dna", "Za odredjeni tip", "Ista tarifa", "Ista robna grupa", "Isti proizvodjac"});
        radiogroup.setLayoutAxis(1);
        return radiogroup;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        if (entity instanceof Tarifnagrupa) {
            this.tarGrupa = (Tarifnagrupa)entity;
            this.tfTarifa.setVal((Object)this.tarGrupa.getOznTarGr());
        } else if (entity instanceof Robnagrupa) {
            this.robnaGrupa = (Robnagrupa)entity;
            this.tfRGR.setVal((Object)this.robnaGrupa.getOznRobGr());
        } else if (entity instanceof Komitent) {
            this.proizvodjac = (Komitent)entity;
            this.tfProizvodjac.setVal((Object)this.proizvodjac.getSfrKomitent());
        } else if (entity instanceof Model) {
            this.model = (Model)entity;
            this.tfTip.setVal((Object)this.model.getOznModel());
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

