/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.importLista;

import au.com.bytecode.opencsv.CSVReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Lista;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.liste.gui.PzDialogIzradaListe;
import rs.pezar.liste.gui.importLista.component.CriteriaComponent;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PlanImporta
extends PzDialog {
    private static int PARAMETER_OD = -1;
    private static int PARAMETER_DO = -1;
    private static int PARAMETER_STR = -1;
    private JLabel lblStranica;
    private JLabel lblDo;
    private PzPanel pnlPlan;
    private JLabel lblUputstvo;
    private JLabel lblOd;
    private PzPanel pnlGlavni;
    private PzPanel pnlButton;
    private JComboBox cbStranica;
    private PzNumericOnlyTextField tfDo;
    private PzNumericOnlyTextField tfOd;
    private PzButton btnPotvrdi;
    boolean comboBox1 = false;
    boolean comboBox2 = false;
    boolean comboBox3 = false;
    boolean comboBox4 = false;
    boolean comboBox5 = false;
    private JScrollPane jspPlanImporta;
    private static PzPanel pnlPlanImporta;
    private PzPanel pnlRang;
    private final PzScrollableTableEntity tableLista;
    private final Lista l;
    private final String izbor;
    private CriteriaComponent criteriaPlanImporta;
    private FileInputStream inp;
    private File file;
    private POIFSFileSystem fsFileSystem;
    private PzPanel pnlUputstvo;
    private PzTextField tfSeparator;
    private JLabel lblSeparator;
    private Workbook workBook;
    private Artikallista al = null;
    private final PzDialogIzradaListe dlg;
    private static Object[][] niz;

    public PlanImporta(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.tableLista = (PzScrollableTableEntity)this.getSession().getParameter("table_lista");
        this.l = (Lista)this.getSession().getParameter("lista");
        this.izbor = (String)this.getSession().getParameter("izbor");
        this.dlg = (PzDialogIzradaListe)((Object)this.getSession().getParameter("dlg"));
        niz = this.createCriteriasOpsti();
        this.postInit();
    }

    private void postInit() {
        try {
            int i;
            this.initParameters();
            this.file = (File)this.getSession().getParameter("file");
            if (this.izbor.equals("csv")) {
                this.lblStranica.setEnabled(false);
                this.cbStranica.setEditable(false);
                this.cbStranica.setFocusable(false);
            } else {
                this.workBook = Workbook.getWorkbook((File)this.file);
                i = 0;
                while (i <= this.workBook.getNumberOfSheets()) {
                    if (i == 0) {
                        this.cbStranica.addItem(new PzChoice("", (Object)i));
                    } else {
                        this.cbStranica.addItem(new PzChoice(Integer.toString(i), (Object)i));
                    }
                    ++i;
                }
                this.tfSeparator.setEnabled(false);
                this.lblSeparator.setEnabled(false);
                this.tfSeparator.setFocusable(false);
            }
            i = 1;
            while (i < niz.length) {
                this.criteriaPlanImporta = new CriteriaComponent();
                this.criteriaPlanImporta.setCriterias(this.getCriteriaOpsti(0));
                pnlPlanImporta.add((Component)((Object)this.criteriaPlanImporta));
                this.criteriaPlanImporta.setPreferredSize(new Dimension(287, 35));
                this.criteriaPlanImporta.setName("criteriaPlanImporta");
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BiffException e1) {
            e1.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Plan importa");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{74, 7};
            pnlGlavniLayout1.columnWeights = new double[]{0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.pnlUputstvo = new PzPanel();
            GridBagLayout pnlUputstvoLayout = new GridBagLayout();
            pnlUputstvoLayout.rowWeights = new double[]{0.1};
            pnlUputstvoLayout.rowHeights = new int[]{7};
            pnlUputstvoLayout.columnWeights = new double[]{0.1};
            pnlUputstvoLayout.columnWidths = new int[]{7};
            this.pnlGlavni.add((Component)this.pnlUputstvo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            TitledBorder border = BorderFactory.createTitledBorder("Uputstvo:");
            border.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlUputstvo.setBorder((Border)border);
            this.pnlUputstvo.setLayout((LayoutManager)pnlUputstvoLayout);
            this.lblUputstvo = new JLabel();
            this.pnlUputstvo.add((Component)this.lblUputstvo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUputstvo.setText("<Html>Dijalog slu\u017ei za definisanje importa podataka iz excela.<br>Korisnik iz padaju\u0107e liste bira polje a zatim unosi slovo ili broj kolone u kojoj se podaci za izabrano polje nalaze.<br>Korisnik tako\u0111e bira list i red od kog \u0107e po\u010deti \u010ditanje podataka. Red do kog se podaci \u010ditaju je opcioni.</html>");
            this.lblUputstvo.setForeground(new Color(0, 0, 255));
            this.lblUputstvo.setFont(new Font("Tahoma", 0, 12));
            this.pnlPlan = new PzPanel();
            GridBagLayout pnlPlanLayout = new GridBagLayout();
            pnlPlanLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlPlanLayout.rowHeights = new int[]{108, 31, 20};
            pnlPlanLayout.columnWeights = new double[]{0.1, 0.0};
            pnlPlanLayout.columnWidths = new int[]{7, 7};
            this.pnlGlavni.add((Component)this.pnlPlan, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.pnlPlan.setLayout((LayoutManager)pnlPlanLayout);
            this.jspPlanImporta = new JScrollPane();
            this.pnlPlan.add((Component)this.jspPlanImporta, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            border = BorderFactory.createTitledBorder("Izbor polja i kolona");
            border.setTitleFont(new Font("Tahoma", 0, 12));
            this.jspPlanImporta.setBorder(border);
            this.jspPlanImporta.setOpaque(false);
            this.jspPlanImporta.setBackground(Color.WHITE);
            pnlPlanImporta = new PzPanel();
            this.jspPlanImporta.setViewportView((Component)pnlPlanImporta);
            pnlPlanImporta.setLayout((LayoutManager)new VerticalLayout());
            pnlPlanImporta.setName("pnlPlanImporta");
            this.pnlRang = new PzPanel();
            GridBagLayout pnlRangLayout = new GridBagLayout();
            this.pnlPlan.add((Component)this.pnlRang, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            pnlRangLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlRangLayout.rowHeights = new int[]{25, 25, 25};
            pnlRangLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlRangLayout.columnWidths = new int[]{58, 40, 44, 45};
            this.pnlRang.setLayout((LayoutManager)pnlRangLayout);
            TitledBorder border2 = BorderFactory.createTitledBorder("Izbor lista i rang redova");
            border2.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlRang.setBorder((Border)border2);
            this.pnlRang.setOpaque(false);
            this.lblOd = new JLabel();
            this.pnlRang.add((Component)this.lblOd, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblOd.setText("Od reda");
            this.tfOd = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfOd, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfOd.setVerifyInput(true);
            this.tfOd.setMaxLength(4);
            this.tfOd.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PlanImporta.this.tfOd.getIntVal() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)PlanImporta.this), "Niste unijeli po\u010detni red podataka", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.lblDo = new JLabel();
            this.pnlRang.add((Component)this.lblDo, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblDo.setText("Do reda");
            this.tfDo = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfDo, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 5), 0, 0));
            this.tfDo.setMaxLength(4);
            this.tfDo.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    return true;
                }
            });
            this.lblStranica = new JLabel();
            this.pnlRang.add((Component)this.lblStranica, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblStranica.setText("List");
            this.cbStranica = new JComboBox();
            this.pnlRang.add((Component)this.cbStranica, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.cbStranica.setVerifyInputWhenFocusTarget(true);
            this.cbStranica.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PlanImporta.this.cbStranica.getSelectedItem().toString().equals("")) {
                        JOptionPane.showMessageDialog((Component)((Object)PlanImporta.this), "Molim izaberite stranicu!", "Informacija", 1);
                        return false;
                    }
                    PlanImporta.this.cbItemStateChanged();
                    return true;
                }
            });
            this.lblSeparator = new JLabel();
            this.pnlRang.add((Component)this.lblSeparator, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.lblSeparator.setName("lblSeparator");
            this.tfSeparator = new PzTextField();
            this.pnlRang.add((Component)this.tfSeparator, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSeparator.setMaxLength(1);
            this.pnlButton = new PzPanel();
            BorderLayout pnlButtonLayout = new BorderLayout();
            this.pnlButton.setLayout((LayoutManager)pnlButtonLayout);
            this.pnlPlan.add((Component)this.pnlButton, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 2, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, (Object)"Center");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(128, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(630, 317);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equals("potvrdi") && this.checkAllFields()) {
            this.setColumnValue(2);
            PzWorkerDialog.showStatus((String)"Import liste je u toku. Molim sa\u010dekajte.", (PzDialog)this);
            SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected Object doInBackground() throws Exception {
                    int i = 0;
                    try {
                        em.getTransaction().begin();
                        if (PlanImporta.this.izbor.equals("xls")) {
                            Sheet sheet = PlanImporta.this.workBook.getSheet(PARAMETER_STR);
                            if (sheet.getRows() == 0) throw new PzInfoException("Informacija! List je prazan!");
                            if (PARAMETER_DO == -1) {
                                PARAMETER_DO = sheet.getRows();
                            }
                            System.out.println("Parametar do je:" + PARAMETER_DO);
                            int j = PARAMETER_OD;
                            while (j <= PARAMETER_DO) {
                                if (j != sheet.getRows()) {
                                    Cell[] row = sheet.getRow(j);
                                    if (row.length != 0) {
                                        PlanImporta.this.createArtikalLista(row, PlanImporta.this.l, em);
                                        ++i;
                                    } else {
                                        int red = j + 1;
                                        throw new PzInfoException("Informacija! Red " + red + " je prazan");
                                    }
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            char separator = ((Character)(PlanImporta.this.tfSeparator.getVal().equals("") ? Character.valueOf(';') : PlanImporta.this.tfSeparator.getVal())).charValue();
                            CSVReader reader = new CSVReader((Reader)new FileReader(PlanImporta.this.file), separator);
                            List nextLine = reader.readAll();
                            if (nextLine.size() == 0) throw new PzInfoException("Informacija! List je prazan!");
                            if (PARAMETER_DO == -1) {
                                PARAMETER_DO = nextLine.size();
                            }
                            int j = PARAMETER_OD;
                            while (j <= PARAMETER_DO) {
                                if (j != nextLine.size()) {
                                    String[] row = separator == ';' ? (String[])nextLine.get(j) : ((String[])nextLine.get(j))[0].split(";");
                                    if (row.length != 0) {
                                        PlanImporta.this.createArtikalLista(row, PlanImporta.this.l, j + 1, em);
                                        ++i;
                                    } else {
                                        int red = j + 1;
                                        throw new PzInfoException("Informacija! Red " + red + " je prazan");
                                    }
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        }
                        em.merge((Object)PlanImporta.this.l);
                        em.getTransaction().commit();
                        return i;
                    }
                    catch (Exception e1) {
                        if (!em.getTransaction().isActive()) throw e1;
                        em.getTransaction().rollback();
                        throw e1;
                    }
                }

                @Override
                protected void done() {
                    try {
                        try {
                            int i = (Integer)this.get();
                            PlanImporta.this.dlg.reloadTable();
                            ((PzNumericOnlyTextField)PlanImporta.this.getSession().getParameter("brojStavki")).setVal((Object)("" + (((PzNumericOnlyTextField)PlanImporta.this.getSession().getParameter("brojStavki")).getIntVal() + i)));
                            PlanImporta.this.dispose();
                        }
                        catch (InterruptedException e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PlanImporta.this), (Throwable)e);
                            em.close();
                            PlanImporta.this.initParameters();
                            PzWorkerDialog.hideStatus();
                        }
                        catch (ExecutionException e) {
                            block9: {
                                if (e.getCause() instanceof PzInfoException) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)PlanImporta.this), (String)e.getMessage());
                                    break block9;
                                }
                                PzMysqlExceptionHandler.handle((Component)((Object)PlanImporta.this), (Throwable)e);
                            }
                            em.close();
                            PlanImporta.this.initParameters();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PlanImporta.this.initParameters();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            sw.execute();
        }
    }

    private void createArtikalLista(Cell[] row, Lista lista, EntityManager em) throws PzInfoException, IllegalAccessException, InvocationTargetException {
        this.al = new Artikallista();
        lista.setCounter(lista.getCounter() + 1);
        this.al.setId(new ArtikallistaPK(lista.getIdLista(), Integer.valueOf(lista.getCounter())));
        int j = 1;
        while (j < niz.length) {
            if (this.getCriteriaOpstiInt(2)[j] != -1) {
                if (this.getCriteriaOpstiInt(2)[j] > row.length) {
                    throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " nije dobro definisana! ");
                }
                int red = row[this.getCriteriaOpstiInt(2)[j]].getRow() + 1;
                if (row[this.getCriteriaOpstiInt(2)[j]].getType() == CellType.EMPTY) {
                    throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " je prazna. Red " + red + ".");
                }
                if (this.getCriteriaOpsti(3)[j].equals("STRING")) {
                    if (row[this.getCriteriaOpstiInt(2)[j]].getContents().length() > this.getCriteriaOpstiInt(4)[j]) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[j] + " ima " + this.getCriteriaOpstiInt(4)[j] + " karaktera");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)row[this.getCriteriaOpstiInt(2)[j]].getContents());
                } else if (this.getCriteriaOpsti(3)[j].equals("DOUBLE") || this.getCriteriaOpsti(3)[j].equals("BIG_DECIMAL")) {
                    double broj = this.getDouble(row[this.getCriteriaOpstiInt(2)[j]].getContents());
                    if (broj == -1.0) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu nije broj. ");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)broj);
                } else if (this.getCriteriaOpsti(3)[j].equals("INTEGER")) {
                    int broj = this.getInteger(row[this.getCriteriaOpstiInt(2)[j]].getContents());
                    if (broj == -1) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu nije broj. ");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)broj);
                }
            }
            ++j;
        }
        em.persist((Object)this.al);
    }

    private void createArtikalLista(String[] row, Lista lista, int red, EntityManager em) throws Exception {
        this.al = new Artikallista();
        lista.setCounter(lista.getCounter() + 1);
        this.al.setId(new ArtikallistaPK(lista.getIdLista(), Integer.valueOf(lista.getCounter())));
        int j = 1;
        while (j < niz.length) {
            if (this.getCriteriaOpstiInt(2)[j] != -1) {
                if (this.getCriteriaOpstiInt(2)[j] > row.length) {
                    throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " nije dobro definisana! ");
                }
                if (row[this.getCriteriaOpstiInt(2)[j]] == null) {
                    throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " je prazna");
                }
                if (this.getCriteriaOpsti(3)[j].equals("STRING")) {
                    if (row[this.getCriteriaOpstiInt(2)[j]].length() > this.getCriteriaOpstiInt(4)[j]) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[j] + " ima " + this.getCriteriaOpstiInt(4)[j] + " karaktera");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)row[this.getCriteriaOpstiInt(2)[j]]);
                } else if (this.getCriteriaOpsti(3)[j].equals("DOUBLE") || this.getCriteriaOpsti(3)[j].equals("BIG_DECIMAL")) {
                    double broj = this.getDouble(row[this.getCriteriaOpstiInt(2)[j]]);
                    if (broj == -1.0) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu nije broj. ");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)broj);
                } else if (this.getCriteriaOpsti(3)[j].equals("INTEGER")) {
                    int broj = this.getInteger(row[this.getCriteriaOpstiInt(2)[j]]);
                    if (broj == -1) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu nije broj. ");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)broj);
                }
            }
            ++j;
        }
        em.persist((Object)this.al);
    }

    public static boolean chackComboBox(int index) {
        boolean rez = false;
        boolean prvi = false;
        int len = pnlPlanImporta.getComponents().length;
        CriteriaComponent[] komponente = new CriteriaComponent[len + 1];
        int i = 1;
        while (i <= len) {
            komponente[i] = (CriteriaComponent)((Object)pnlPlanImporta.getComponents()[i - 1]);
            ++i;
        }
        i = 1;
        while (i < komponente.length) {
            System.out.println(komponente[i].getChoice());
            System.out.println(komponente[i].getText());
            if (komponente[i].getChoice() == index) {
                if (prvi) {
                    rez = true;
                } else {
                    prvi = true;
                }
            }
            ++i;
        }
        return rez;
    }

    public static boolean chackTextField(int val, int index) {
        boolean rez = false;
        boolean prvi = false;
        int len = pnlPlanImporta.getComponents().length;
        CriteriaComponent[] komponente = new CriteriaComponent[len + 1];
        int i = 1;
        while (i <= len) {
            komponente[i] = (CriteriaComponent)((Object)pnlPlanImporta.getComponents()[i - 1]);
            ++i;
        }
        i = 1;
        while (i < komponente.length) {
            if (komponente[i].getFieldValue() == val) {
                if (prvi) {
                    rez = true;
                } else {
                    prvi = true;
                }
            }
            ++i;
        }
        return rez;
    }

    private void setColumnValue(int kolona) {
        this.cbItemStateChanged();
        PARAMETER_DO += this.tfDo.getIntVal();
        PARAMETER_OD += this.tfOd.getIntVal();
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            PlanImporta.niz[((CriteriaComponent)((Object)komponente[i])).getChoice()][kolona] = ((CriteriaComponent)((Object)komponente[i])).getFieldValue();
            ++i;
        }
    }

    private boolean checkAllFields() {
        boolean rez = true;
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            if (!((CriteriaComponent)((Object)komponente[i])).isValidComponent()) {
                rez = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Niste uneli sva polja", "Informacija", 1);
                break;
            }
            ++i;
        }
        if (rez && this.tfOd.getIntVal() == 0) {
            rez = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Niste uneli po\u010detni red podataka", "Informacija", 1);
        }
        return rez;
    }

    public String[] getCriteriaOpsti(int x) {
        int len = niz.length;
        Object[][] array = niz;
        String[] criterias = new String[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (String)array[i][x];
            ++i;
        }
        return criterias;
    }

    public int[] getCriteriaOpstiInt(int x) {
        int len = niz.length;
        Object[][] array = niz;
        int[] criterias = new int[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (Integer)array[i][x];
            ++i;
        }
        return criterias;
    }

    private Object[][] createCriteriasOpsti() {
        return new Object[][]{{"", "", -1, "", 0}, {"\u0160ifra", "sfrProizvod", -1, "STRING", 30}, {"Naziv", "naziv", -1, "STRING", 255}, {"Bli\u017ei opis", "bliziOpis", -1, "STRING", 255}, {"\u0160ifra dobavlja\u010da", "sfrDobavljac", -1, "STRING", 30}, {"Jedinica mere", "jm", -1, "STRING", 10}, {"Koli\u010dina", "kolicina", -1, "BIG_DECIMAL", 0}, {"Cena", "cena", -1, "BIG_DECIMAL", 0}};
    }

    public static void setChoice(int index, int kolona, int val) {
        PlanImporta.niz[index][kolona] = val;
    }

    private void initParameters() {
        PARAMETER_OD = -1;
        PARAMETER_DO = -1;
        PARAMETER_STR = -1;
        int i = 0;
        while (i < niz.length) {
            PlanImporta.setChoice(i, 2, -1);
            ++i;
        }
    }

    private void cbItemStateChanged() {
        PARAMETER_STR = -1;
        if (this.izbor.equals("xls")) {
            PARAMETER_STR += Integer.parseInt(this.cbStranica.getSelectedItem().toString());
        }
    }

    public double getDouble(String input) {
        try {
            double broj = new DecimalFormat("###,###.##").parse(input).doubleValue();
            return broj;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public int getInteger(String input) {
        try {
            int broj = Integer.parseInt(input);
            return broj;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static class Type {
        public static final String T_DOUBLE = "DOUBLE";
        public static final String T_BIG_DECIMAL = "BIG_DECIMAL";
        public static final String T_STRING = "STRING";
        public static final String T_DATE = "DATE";
        public static final String T_INTEGER = "INTEGER";
        public static final String T_BOOLEAN = "BOOLEAN";
    }
}

