/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.util.AnalitikaUtil;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.liste.DBManager;
import rs.pezar.liste.gui.IzborKolicine;
import rs.pezar.liste.gui.PzDialogListe;
import rs.pezar.liste.gui.importLista.UnosPutanje;
import rs.pezar.liste.gui.izrada.Arhiviranje;
import rs.pezar.liste.gui.izrada.AzuriranjeKolicine;
import rs.pezar.liste.gui.izrada.DodavanjeExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.artikli.NaprednaPretraga;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;

public class PzDialogIzradaListe
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnPreuzmiCenu;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private PzNumericOnlyTextField brojStavki;
    private JLabel lblBroj;
    private PzButton icnBrisiSifre;
    private PzButton icnBrisiNazive;
    private PzButton icnSelektuj;
    private PzButton icnInverznaSelekcija;
    private PzButton icnSelektujSve;
    private PzButton icnDeselektujSve;
    private PzButton icnBrisiKolicine;
    private PzButton icnBrisiCene;
    private JPanel pnlBrisanje;
    private JPanel pnlSelect;
    private PzToolBarIcon icnPreuzimanjeKolicine;
    private JScrollPane scrollPane;
    private PzScrollableTableEntity table;
    private PzPanel mainPanel;
    private EntityManager em;
    private Lista lista;
    private ScrollableCursor cursor;
    private final String NAB_CENA = "Poslednja nabavna cena";
    private final String PROD_CENA = "Prodajna cena";
    private final String PRNC = "Prose\u010dna nabavnu cena";
    private PzToolBarIcon icnGrupnoDodavanje;
    private PzPanel pnlContent;
    private PzToolBarIcon icnAzurirajKolicinu;
    private PzToolBarIcon icnKarticaArtikla;
    private PzToolBarIcon icnArhiviranje;
    private PzToolBarIcon icnPreuzmiPomocnuCenu;
    private PzToolBarIcon icnImportListe;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzradaListe inst = new PzDialogIzradaListe(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzradaListe(JFrame frame) {
        super(frame);
    }

    public boolean shouldBeShown() {
        this.lista = (Lista)((PzTable)this.getSession().getParameter("table")).getSelectedEntity();
        this.em = (EntityManager)this.getSession().getParameter("em");
        this.setTitle("Lista: " + this.lista.getNaslov());
        this.initGUI();
        this.instantiateTable();
        return true;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (!this.cursor.isClosed()) {
            this.cursor.close();
        }
    }

    public PzDialogIzradaListe(PzDialog parent) {
        super(parent);
    }

    public PzDialogIzradaListe() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.pnlContent = new PzPanel();
            this.pnlContent.setPaintGradient(true);
            this.pnlContent.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.pnlContent.add((Component)this.toolbar, (Object)"North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Pojedina\u010dno|dodavanje| (ins)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/dodavanje_artikla.png")));
            this.icnDodavanje.setShortcut("insert");
            this.icnDodavanje.setPreferredSize(new Dimension(77, 101));
            this.icnDodavanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.icnDodavanjeActionPerformed(evt);
                }
            });
            this.icnGrupnoDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnGrupnoDodavanje);
            this.icnGrupnoDodavanje.setText("Grupno|dodavanje| (alt+ins)");
            this.icnGrupnoDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/grupno_dodavanje.png")));
            this.icnGrupnoDodavanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.grupnoDodavanjeAction(evt);
                }
            });
            this.icnGrupnoDodavanje.setShortcut("alt+insert");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("A\u017euriranje|(alt+f3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/edit.png")));
            this.icnIzmena.setShortcut("alt+f3");
            this.icnIzmena.setBounds(-43, 7, 93, 80);
            this.icnIzmena.setPreferredSize(new Dimension(53, 98));
            this.icnIzmena.setSize(53, 100);
            this.icnIzmena.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.icnIzmenaActionPerformed(evt);
                }
            });
            this.icnAzurirajKolicinu = new PzToolBarIcon();
            this.icnAzurirajKolicinu.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 5139017486353318775L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaListe.this.icnAzurirajKolicinuactionPerformed(arg0);
                }
            });
            this.icnAzurirajKolicinu.setActionCommand("azuriraj_kolicinu");
            this.icnAzurirajKolicinu.setShortcut("f3");
            this.icnAzurirajKolicinu.setIcon((Icon)new ImageIcon(PzDialogIzradaListe.class.getResource("/rs/pezar/liste/resource/img/edit.png")));
            this.icnAzurirajKolicinu.setText("A\u017euriranje|koli\u010dine|i cene (f3)");
            this.toolbar.add((Component)this.icnAzurirajKolicinu);
            this.icnPreuzmiCenu = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPreuzmiCenu);
            this.icnPreuzmiCenu.setText("Popuni cenu|iz RJ (f4)");
            this.icnPreuzmiCenu.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/preuzmi_cenu.png")));
            this.icnPreuzmiCenu.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.preuzmiCenuAction(evt);
                }
            });
            this.icnPreuzmiCenu.setShortcut("f4");
            this.icnPreuzmiCenu.setSize(72, 100);
            this.icnPreuzmiCenu.setPreferredSize(new Dimension(72, 97));
            this.icnPreuzimanjeKolicine = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPreuzimanjeKolicine);
            this.icnPreuzimanjeKolicine.setText("Preuzmi koli\u010dinu|iz RJ (f5)");
            this.icnPreuzimanjeKolicine.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/preuzimanje_kolicine.png")));
            this.icnPreuzimanjeKolicine.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 3374174074372158252L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.icnPreuzimanjeKolicineActionPerformed(evt);
                }
            });
            this.icnPreuzimanjeKolicine.setShortcut("f5");
            this.icnPreuzimanjeKolicine.setSize(88, 100);
            this.icnPreuzimanjeKolicine.setPreferredSize(new Dimension(85, 101));
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|ozna\u010denih |(del)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/brisanje_artikla.png")));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(70, 100));
            this.icnBrisanje.setSize(73, 100);
            this.icnBrisanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.icnBrisanjeActionPerformed(evt);
                }
            });
            this.icnKarticaArtikla = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnKarticaArtikla);
            this.icnKarticaArtikla.setText("Kartica|artikla|(f6)");
            this.icnKarticaArtikla.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/address_book2.png")));
            this.icnKarticaArtikla.setActionCommand("kartica");
            this.icnKarticaArtikla.setShortcut("f6");
            this.icnKarticaArtikla.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.icnKarticaArtiklaActionPerformed(evt);
                }
            });
            this.icnArhiviranje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiviranje);
            this.icnArhiviranje.setText("Arhiviranje|(CTRL+W)");
            this.icnArhiviranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/printer_preferences.png")));
            this.icnArhiviranje.setShortcut("ctrl+w");
            this.icnArhiviranje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.arhivirajListe();
                }
            });
            this.icnImportListe = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnImportListe);
            this.icnImportListe.setText("Import|(f7)");
            this.icnImportListe.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/import1.png")));
            this.icnImportListe.setActionCommand("Import");
            this.icnImportListe.setShortcut("f7");
            this.icnImportListe.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzDialogIzradaListe.this.icnImportListeActionPerformed(evt);
                }
            });
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.pnlBrisanje = new JPanel();
            FlowLayout pnlBrisanjeLayout = new FlowLayout();
            pnlBrisanjeLayout.setVgap(2);
            pnlBrisanjeLayout.setAlignment(0);
            this.pnlBrisanje.setLayout(pnlBrisanjeLayout);
            this.toolbar.add(this.pnlBrisanje);
            this.pnlBrisanje.setPreferredSize(new Dimension(212, 113));
            this.pnlBrisanje.setOpaque(false);
            this.icnBrisiKolicine = new PzButton();
            this.pnlBrisanje.add((Component)this.icnBrisiKolicine);
            this.icnBrisiKolicine.setText("Bri\u0161i koli\u010dine(ctrl+del)");
            this.icnBrisiKolicine.setFocusable(false);
            this.icnBrisiKolicine.setPreferredSize(new Dimension(184, 26));
            this.icnBrisiKolicine.setHorizontalAlignment(10);
            this.icnBrisiKolicine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnBrisiKolicine.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/brisi_kolicine.png")));
            this.icnBrisiKolicine.addActionListener((ActionListener)((Object)this));
            this.icnBrisiKolicine.setShortcut("ctrl+delete");
            this.icnBrisiCene = new PzButton();
            this.pnlBrisanje.add((Component)this.icnBrisiCene);
            this.icnBrisiCene.setText("Bri\u0161i cene (alt+delete)");
            this.icnBrisiCene.setFocusable(false);
            this.icnBrisiCene.setPreferredSize(new Dimension(184, 26));
            this.icnBrisiCene.setHorizontalAlignment(10);
            this.icnBrisiCene.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnBrisiCene.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/brisi_cene.png")));
            this.icnBrisiCene.addActionListener((ActionListener)((Object)this));
            this.icnBrisiCene.setShortcut("alt+delete");
            this.icnBrisiNazive = new PzButton();
            this.pnlBrisanje.add((Component)this.icnBrisiNazive);
            this.icnBrisiNazive.setText("Bri\u0161i nazive (shift+ctrl+del)");
            this.icnBrisiNazive.setFocusable(false);
            this.icnBrisiNazive.setPreferredSize(new Dimension(184, 26));
            this.icnBrisiNazive.setHorizontalAlignment(10);
            this.icnBrisiNazive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnBrisiNazive.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/brisi_nazive.png")));
            this.icnBrisiNazive.addActionListener((ActionListener)((Object)this));
            this.icnBrisiNazive.setShortcut("shift+ctrl+delete");
            this.icnBrisiSifre = new PzButton();
            this.pnlBrisanje.add((Component)this.icnBrisiSifre);
            this.icnBrisiSifre.setText("Bri\u0161i \u0161ifre (shift+alt+del)");
            this.icnBrisiSifre.setFocusable(false);
            this.icnBrisiSifre.setPreferredSize(new Dimension(185, 26));
            this.icnBrisiSifre.setHorizontalAlignment(10);
            this.icnBrisiSifre.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnBrisiSifre.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/brisi_sifre.png")));
            this.icnBrisiSifre.addActionListener((ActionListener)((Object)this));
            this.icnBrisiSifre.setShortcut("shift+alt+delete");
            this.mainPanel = new PzPanel();
            AnchorLayout mainPanelLayout = new AnchorLayout();
            this.pnlContent.add((Component)this.mainPanel, (Object)"Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setOpaque(false);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new AnchorConstraint(12, 11, 38, 10, 2, 2, 2, 2));
            this.scrollPane.setPreferredSize(new Dimension(1137, 569));
            this.lblBroj = new JLabel();
            this.mainPanel.add((Component)this.lblBroj, (Object)new AnchorConstraint(957, 904, 983, 821, 1, 1, 1, 1));
            this.lblBroj.setText("Broj stavki u listi:");
            this.lblBroj.setPreferredSize(new Dimension(96, 16));
            this.brojStavki = new PzNumericOnlyTextField();
            this.mainPanel.add((Component)this.brojStavki, (Object)new AnchorConstraint(949, 990, 991, 920, 1, 1, 1, 1));
            this.brojStavki.setPreferredSize(new Dimension(81, 26));
            this.brojStavki.setEditable(false);
            this.brojStavki.setFocusable(false);
            this.setSize(1265, 767);
            this.setMinimumSize(new Dimension(1265, 767));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void icnKarticaArtiklaActionPerformed(ActionEvent evt) {
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)this);
        if (rj == null) {
            return;
        }
        try {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            AnalitikaUtil.karticaArtikla((PzDialog)this, (Artikal)((Artikal)em.find(Artikal.class, (Object)((Artikallista)this.table.getSelectedEntity()).getSfrProizvod())), (Radnajedinica)rj, (EntityManager)em);
            em.close();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void icnImportListeActionPerformed(ActionEvent evt) {
        this.getSession().putParameter("lista", (Object)this.lista);
        this.getSession().putParameter("brojStavki", (Object)this.brojStavki);
        this.getSession().putParameter("dlg", (Object)this);
        Vector<String> skupZaIzbor = new Vector<String>();
        String xls = new String("Import iz xls fajla");
        String csv = new String("Import iz csv fajla");
        skupZaIzbor.add(xls);
        skupZaIzbor.add(csv);
        String izborKartice = "";
        izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
        if (izborKartice == null) {
            return;
        }
        if (izborKartice.equals(xls)) {
            this.getSession().putParameter("izbor", (Object)"xls");
            this.showDialog(UnosPutanje.class);
        } else {
            this.getSession().putParameter("izbor", (Object)"csv");
            this.showDialog(UnosPutanje.class);
        }
    }

    public void instantiateTable() {
        this.table = new PzScrollableTableEntity(Artikallista.class);
        this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
        this.reloadTable();
        this.getSession().putParameter("table_lista", (Object)this.table);
        this.scrollPane.setViewportView((Component)this.table);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.icnSelektujSve) {
            this.table.checkAll();
        } else if (e.getSource() == this.icnDeselektujSve) {
            this.table.unCheckAll();
        } else if (e.getSource() == this.icnInverznaSelekcija) {
            this.table.inverseCheck();
        } else if (e.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else if (e.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else {
            boolean rez;
            if (this.table.getCheckedEntities().size() == 0) {
                return;
            }
            boolean bl = rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0) == 0;
            if (!rez) {
                return;
            }
            if (e.getSource() == this.icnBrisiCene) {
                PzWorkerDialog.showStatus((String)"Brisanje cena je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
                DBManager.brisiCeneIliKolicine(this.table.getCheckedEntities(), this.lista.getIdLista(), this.em, 2, this);
            } else if (e.getSource() == this.icnBrisiKolicine) {
                PzWorkerDialog.showStatus((String)"Brisanje koli\u010dina je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
                DBManager.brisiCeneIliKolicine(this.table.getCheckedEntities(), this.lista.getIdLista(), this.em, 1, this);
            } else if (e.getSource() == this.icnBrisiNazive) {
                PzWorkerDialog.showStatus((String)"Brisanje naziva je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
                DBManager.brisiNaziveIliSifre(this.table.getCheckedEntities(), this.lista.getIdLista(), this.em, 3, this);
            } else if (e.getSource() == this.icnBrisiSifre) {
                PzWorkerDialog.showStatus((String)"Brisanje \u0161ifara je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
                DBManager.brisiNaziveIliSifre(this.table.getCheckedEntities(), this.lista.getIdLista(), this.em, 4, this);
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzradaListe(Boolean.FALSE);
    }

    public PzDialogIzradaListe(Boolean initGUI) {
    }

    private void icnDodavanjeActionPerformed(ActionEvent evt) {
        this.getSession().putParameter("update", (Object)false);
        this.getSession().putParameter("brojStavki", (Object)this.brojStavki);
        this.showDialog(DodavanjeExtended.class);
    }

    private void grupnoDodavanjeAction(ActionEvent evt) {
        String query = NaprednaPretraga.getQuery((PzDialog)this, null, (int)2);
        if (query != null) {
            PzWorkerDialog.showStatus((String)"Sastavljanje liste je u toku. Molim sa\u010dekajte.", (PzDialog)this);
            this.getScrollableCursor().close();
            DBManager.loadTable(query, this.em, this, this.lista);
        }
    }

    private void icnIzmenaActionPerformed(ActionEvent evt) {
        this.getSession().putParameter("update", (Object)true);
        this.showDialog(DodavanjeExtended.class);
    }

    private void icnBrisanjeActionPerformed(ActionEvent evt) {
        try {
            boolean svi = false;
            if (this.table.getModel().getRowCount() == this.table.getCheckedEntities().size()) {
                svi = true;
            }
            if (this.table.getCheckedEntities().size() == 0) {
                return;
            }
            Object[] options = new Object[]{"Da", "Ne"};
            int rez = JOptionPane.showOptionDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0, 3, null, options, options[0]);
            if (rez == 0) {
                DBManager.brisiStavke(this.table.getCheckedEntities(), this.lista.getIdLista(), this.em, this, svi);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void reloadTable() {
        this.table.setVisible(false);
        PzWorkerDialog.showStatus((String)"U\u010ditavanje liste je u toku. Molim sa\u010dekajte.", (PzDialog)this);
        SwingWorker<ScrollableCursor, Integer> task = new SwingWorker<ScrollableCursor, Integer>(){

            @Override
            protected ScrollableCursor doInBackground() throws Exception {
                if (PzDialogIzradaListe.this.getScrollableCursor() != null) {
                    PzDialogIzradaListe.this.getScrollableCursor().close();
                }
                return DBManager.getArtikalsCursor(PzDialogIzradaListe.this.em, PzDialogIzradaListe.this.lista);
            }

            @Override
            protected void done() {
                try {
                    try {
                        PzDialogIzradaListe.this.setScrollableCursor((ScrollableCursor)this.get());
                        PzDialogIzradaListe.this.table.read(PzDialogIzradaListe.this.getScrollableCursor());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        PzDialogIzradaListe.this.table.setVisible(true);
                        PzWorkerDialog.hideStatus();
                        PzDialogIzradaListe.this.table.requestFocus();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        PzDialogIzradaListe.this.table.setVisible(true);
                        PzWorkerDialog.hideStatus();
                        PzDialogIzradaListe.this.table.requestFocus();
                    }
                }
                finally {
                    PzDialogIzradaListe.this.table.setVisible(true);
                    PzWorkerDialog.hideStatus();
                    PzDialogIzradaListe.this.table.requestFocus();
                }
            }
        };
        task.execute();
    }

    private void setScrollableCursor(ScrollableCursor cursor) {
        this.cursor = cursor;
        if (cursor != null) {
            this.brojStavki.setVal((Object)cursor.size());
        }
    }

    private ScrollableCursor getScrollableCursor() {
        return this.cursor;
    }

    private void icnPreuzimanjeKolicineActionPerformed(ActionEvent evt) {
        if (this.table.getCheckedEntities().size() == 0) {
            return;
        }
        try {
            this.preuzmiKolicinu(this.table.getCheckedEntities());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void preuzmiKolicinu(List<PzEntity> artikals) throws Exception {
        List rj = PzGenericTableDialog.showDialog((PzDialog)this, Radnajedinica.class, (List)PzEntityManager.selectAll(Radnajedinica.class), (String)"Izbor radnih jedinica", (String)"Izaberite radne jedinice iz kojih se uzimaju kolicine", (int)0, null);
        if (rj == null || rj.size() == 0) {
            return;
        }
        String query = IzborKolicine.getQuery(this, rj, this.lista, artikals);
        if (query == null) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Dobavljanje koli\u010dina je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
        DBManager.executeNativeQuery(query, this.em, this);
    }

    private void preuzmiCenuAction(ActionEvent e) {
        if (this.table.getCheckedEntities().size() == 0) {
            return;
        }
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)this);
        if (rj == null) {
            return;
        }
        String choice = this.getCenaStanje();
        if (choice == null) {
            return;
        }
        String cena = "";
        if (choice.equals("Poslednja nabavna cena")) {
            cena = "s.zadNabCena";
        } else if (choice.equals("Prodajna cena")) {
            cena = "s.prodCena";
        } else if (choice.equals("Prose\u010dna nabavnu cena")) {
            cena = "s.prosNabCena";
        }
        String cenaLista = this.getCenaLista();
        if (cenaLista == null) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Preuzimanje cena je u toku. Molim, sa\u010dekajte.", (PzDialog)this);
        DBManager.preuzmiCene(this.table.getCheckedEntities(), rj, cena, cenaLista, this.lista.getIdLista(), this.em, this);
    }

    private String getCenaStanje() {
        Vector<String> v = new Vector<String>();
        v.add("Poslednja nabavna cena");
        v.add("Prodajna cena");
        v.add("Prose\u010dna nabavnu cena");
        return PzDialogChoice.showPzDialogChoice((PzDialog)this, v);
    }

    private String getCenaLista() {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Cena", (Object)"a.cena"), new PzChoice("Pomo\u0107na cena", (Object)"a.pomCena")};
        return (String)PzDialogChoice.showPzDialogChoice((PzDialog)this, (PzChoice[])choices, (String)"Izaberite koja se koli\u010dina popunjava");
    }

    protected void icnAzurirajKolicinuactionPerformed(ActionEvent arg0) {
        if (this.table.getSelectedRow() == -1) {
            return;
        }
        this.getSession().putParameter("table_artikli", (Object)this.table);
        this.showDialog(AzuriranjeKolicine.class);
    }

    private void arhivirajListe() {
        boolean rez;
        boolean bl = rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nakon arhiviranja, vi\u0161e Vam ne\u0107e biti omogu\u0107eno da a\u017eurirate listu. Ova operacija je uvedena radi Va\u0161e evidencije. Da li ste sigurni da \u017eelite da nastavite?", "Arhiviranje liste", 0) == 0;
        if (!rez) {
            return;
        }
        this.getSession().putParameter("lista", (Object)this.lista);
        this.showDialog(Arhiviranje.class);
    }

    public void finish() {
        ((PzDialogListe)this.getParentDialog()).ukloniListu();
        this.dispose();
    }
}

