/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste;

import java.io.IOException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.service.msg.chat.textComponent.notification.NotificationText;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class ListaUtil {
    private static Properties properties = new Properties();
    public static final String TIP_NARUDZBENICA = "NARUDZBENICA";
    public static final String TIP_STANDARDNA = "STANDARDNA";
    public static final String TIP_PONUDA = "PONUDA";

    static {
        try {
            properties.load(ListaUtil.class.getClassLoader().getResourceAsStream("rs/pezar/liste/resource/tip.properties"));
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static String getTipListe(PzDialog parent) {
        Properties props = new Properties();
        try {
            props.load(ListaUtil.class.getClassLoader().getResourceAsStream("rs/pezar/liste/resource/tip.properties"));
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        Object[] tipovi = props.keySet().toArray();
        PzChoice[] choices = new PzChoice[tipovi.length];
        int i = 0;
        while (i < tipovi.length) {
            choices[i] = new PzChoice((String)tipovi[i], props.get(tipovi[i]));
            ++i;
        }
        return (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izaberite tip liste koja se kreira");
    }

    public static String getTipListe(String tip) {
        return properties.get(tip).toString();
    }

    public static void sendMessage(Pzuser user, String poruka) {
        try {
            String text = NotificationText.codeNotification((String)poruka);
            String queueName = MsgProtocol.getQueueNameFromUserName((String)user.getPzusername(), (String)user.getIme(), (String)user.getPrezime());
            if (MsgProtocol.getInstance() != null) {
                MsgProtocol.getInstance().sendChatTextMessageToQueue(queueName, text);
            }
        }
        catch (JMSException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static void sendNotification(Pzuser user, String poruka) {
        try {
            String queueName = MsgProtocol.getQueueNameFromUserName((String)user.getPzusername(), (String)user.getIme(), (String)user.getPrezime());
            if (MsgProtocol.getInstance() != null) {
                MsgProtocol.getInstance().sendActionMessageToDestination((Destination)MsgProtocol.getInstance().createDestinationFromQueueName(queueName), "ID:3;CORNER:DD;MESSAGE:" + poruka);
            }
        }
        catch (JMSException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }
}

