/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste;

import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.liste.PzExtensionLoader;
import rs.pezar.liste.gui.PzDialogIzradaListe;
import rs.pezar.liste.gui.PzDialogListe;
import rs.pezar.liste.gui.izrada.Arhiviranje;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class DBManager {
    public static final int BRISANJE_KOLICINA = 1;
    public static final int BRISANJE_CENA = 2;
    public static final int BRISANJE_NAZIVA = 3;
    public static final int BRISANJE_SIFARA = 4;

    public static List<Lista> getListe(EntityManager em) {
        Pzuser user = PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser();
        Query q = em.createQuery("SELECT l FROM Lista l WHERE l.pzuser = :user AND l.arhiviran=0");
        q.setParameter("user", (Object)user);
        return q.getResultList();
    }

    public static void insertOrUpdateLista(Lista lista, EntityManager em, PzTable table, boolean update, String tip, String naziv, String komentar, Komitent komitent) throws Exception {
        em.getTransaction().begin();
        if (!update) {
            lista = new Lista();
            lista.setIdLista(Integer.valueOf(PzIdGen.getNextId((String)"LISTA_ID", (int)1, (EntityManager)em).getIdVal()));
            lista.setArhiviran(Integer.valueOf(0));
            lista.setDatum(new Date(new java.util.Date().getTime()));
            lista.setNaslov(naziv);
            lista.setKomentar(komentar);
            lista.setPzuser((Pzuser)em.find(Pzuser.class, (Object)PzExtensionLoader.getLoggedUser().getPzusername()));
            lista.setKomitent(komitent);
            lista.setTip(tip);
            lista.setIdLista(Integer.valueOf(PzIdGen.getNextId((String)"LISTA_ID", (int)0, (EntityManager)em).getIdVal()));
            table.insert((PzEntity)lista, em);
            em.getTransaction().commit();
            table.commitInsert();
        } else {
            lista.setNaslov(naziv);
            lista.setKomentar(komentar);
            lista.setTip(tip);
            lista.setKomitent(komitent);
            em.merge((Object)lista);
            em.getTransaction().commit();
            table.updateSelectedEntityGUI((PzEntity)lista);
        }
    }

    public static List<Artikallista> getArtikals(EntityManager em, Lista lista) {
        String sort = PzParameter.getParameterValue((String)"SORT_NARUDZBENICE", (String)"sifra");
        String upit = "SELECT a FROM Artikallista a WHERE a.id.idLista=" + lista.getIdLista() + " ORDER BY %sort%";
        upit = sort.equals("sifra") ? upit.replace("%sort%", "a.sfrProizvod") : upit.replace("%sort%", "a.naziv");
        Query q = em.createQuery(upit);
        return q.getResultList();
    }

    public static ScrollableCursor getArtikalsCursor(EntityManager em, Lista lista) {
        String sort = PzParameter.getParameterValue((String)"SORT_NARUDZBENICE", (String)"sifra");
        String upit = "SELECT a FROM Artikallista a WHERE a.id.idLista=" + lista.getIdLista() + " ORDER BY %sort%";
        upit = sort.equals("sifra") ? upit.replace("%sort%", "a.id.rBroj") : upit.replace("%sort%", "a.naziv");
        Query q = em.createQuery(upit);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        q.setHint("eclipselink.read-only", (Object)"True");
        q.setHint("eclipselink.jdbc.fetch-size", (Object)"256");
        return (ScrollableCursor)q.getSingleResult();
    }

    public static void loadTable(final String query, final EntityManager emGlavni, final PzDialogIzradaListe dlg, final Lista l) {
        SwingWorker<Object, Integer> task = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                EntityManager emTemp = PzExtensionLoader.getInstance().getApplication().getEmf().createEm();
                try {
                    if (this.getBrojPogodaka(query, emGlavni) > 5000L && JOptionPane.showConfirmDialog((Component)((Object)dlg), "Rezultat pretrage sadr\u017ei suvi\u0161e mnogo pogodaka (>5000). Sastavljanje listi sa velikim brojem stavki moze da dovede do usporavanja rada sistema. Da li ste sigurni da \u017eelite da nastavite?", "Suvi\u0161e mnogo pogodaka", 0) != 0) {
                        return null;
                    }
                    try {
                        Query q = emGlavni.createQuery(query);
                        q.setHint("eclipselink.read-only", (Object)"True");
                        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                        q.setHint("eclipselink.jdbc.fetch-size", (Object)"256");
                        ScrollableCursor cursor = (ScrollableCursor)q.getSingleResult();
                        emTemp.getTransaction().begin();
                        Lista lista = (Lista)emTemp.find(Lista.class, (Object)l.getIdLista());
                        int i = 0;
                        while (cursor.hasNext()) {
                            Stanjeartikal a = (Stanjeartikal)cursor.next();
                            Artikallista al = new Artikallista();
                            lista.setCounter(lista.getCounter() + 1);
                            l.setCounter(lista.getCounter());
                            al.setId(new ArtikallistaPK(lista.getIdLista(), Integer.valueOf(lista.getCounter())));
                            al.setSfrProizvod(a.getId().getSfrProizvod());
                            al.setNaziv(a.getNaziv());
                            al.setBliziOpis(a.getBliziOpis());
                            al.setDobSifra(a.getDobSifra());
                            al.setDuzina(a.getDuzina());
                            al.setFi(a.getFi());
                            al.setJm(a.getJedMere());
                            al.setNazivDobavljac(a.getNazivDobavljac());
                            al.setNazivModel(a.getNazivModela());
                            al.setNazivProizvodjac(a.getNazivProizvodjac());
                            al.setNazivRobGr(a.getNazivRobGr());
                            al.setNivo(a.getNivo());
                            al.setOpis(a.getOpis());
                            al.setOznModel(a.getOznModel());
                            al.setOznRobGr(a.getOznRobGr());
                            al.setPaleta(a.getPaleta());
                            al.setPrSifra(a.getPrSifra());
                            al.setSfrDobavljac(a.getSfrDobavljac());
                            al.setSfrProizvodjac(a.getSfrProizvodjac());
                            al.setSirina(a.getSirina());
                            al.setStalaza(a.getStalaza());
                            al.setStokMax(a.getStokMax());
                            al.setStokMin(a.getStokMin());
                            al.setTezina(a.getTezina());
                            al.setVisina(a.getVisina());
                            emTemp.persist((Object)al);
                            this.publish(i++);
                        }
                        cursor.close();
                        cursor = null;
                        emTemp.getTransaction().commit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (emTemp.getTransaction().isActive()) {
                            emTemp.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                    }
                }
                finally {
                    emTemp.close();
                }
                return null;
            }

            @Override
            protected void process(List<Integer> chunks) {
                if (PzWorkerDialog.getDialogInstance() == null) {
                    return;
                }
                for (int n : chunks) {
                    PzWorkerDialog.getDialogInstance().getProgressBar().setValue(n);
                }
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }

            private long getBrojPogodaka(String query2, EntityManager em) {
                return (Long)em.createQuery(query2.replace("SELECT a", "SELECT COUNT(a.naziv)")).getSingleResult();
            }
        };
        task.execute();
    }

    public static void deleteAll(Lista lista, EntityManager em) {
        em.createQuery("DELETE FROM Artikallista a WHERE a.id.idLista=" + lista.getIdLista()).executeUpdate();
    }

    public static void updateKolicina(final String field, final Radnajedinica rj, final ScrollableCursor cursor, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                EntityManager em = PzExtensionLoader.getInstance().getApplication().getEmf().createEm();
                try {
                    try {
                        em.getTransaction().begin();
                        Query q = em.createQuery("SELECT s.id.sfrProizvod, " + field + " FROM Stanje s WHERE s.radnajedinica = :rj");
                        q.setParameter("rj", (Object)rj);
                        List values = q.getResultList();
                        cursor.absolute(0);
                        Artikallista al = null;
                        while (cursor.hasNext()) {
                            al = (Artikallista)cursor.next();
                            al.setKolicina(DBManager.getKolicina(values, al.getSfrProizvod()));
                            em.merge((Object)al);
                        }
                        em.getTransaction().commit();
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                        em.clear();
                        em.close();
                    }
                }
                finally {
                    em.clear();
                    em.close();
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    private static double getKolicina(List<Object[]> values, String sfrProizvod) {
        double val = 0.0;
        for (Object[] value : values) {
            if (!value[0].equals(sfrProizvod)) continue;
            val = (Double)value[1];
            break;
        }
        return val;
    }

    public static void updateKolicina1(final String field, final Radnajedinica rj, final EntityManager em, final Lista l, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    String query = "UPDATE ArtikalLista SET kolicina = (SELECT " + field + " FROM Stanje  WHERE Stanje.sfrProizvod = ArtikalLista.sfrProizvod AND Stanje.oznRj=':rj' AND Stanje.oznOgranak=':ogranak') WHERE idLista=" + l.getIdLista();
                    query = query.replace(":rj", rj.getId().getOznRj()).replace(":ogranak", rj.getId().getOznOgranak());
                    Query q = em.createNativeQuery(query);
                    em.getTransaction().begin();
                    q.executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void updateCena(final String field, final Radnajedinica rj, final EntityManager em, final Lista l, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    String query = "UPDATE ArtikalLista SET cena = (SELECT " + field + " FROM Stanje  WHERE Stanje.sfrProizvod = ArtikalLista.sfrProizvod AND Stanje.oznRj=':rj' AND Stanje.oznOgranak=':ogranak') WHERE idLista=" + l.getIdLista();
                    query = query.replace(":rj", rj.getId().getOznRj()).replace(":ogranak", rj.getId().getOznOgranak());
                    Query q = em.createNativeQuery(query);
                    em.getTransaction().begin();
                    q.executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void preuzmiKolicine(final List<PzEntity> checkedEntities, final Radnajedinica rj, final String kolicina, final int idLista, final EntityManager em, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    em.getTransaction().begin();
                    ArrayList<String> temp = new ArrayList<String>();
                    for (PzEntity e : checkedEntities) {
                        temp.add(((Artikallista)e).getSfrProizvod());
                    }
                    Query q = em.createQuery("SELECT s.id.sfrProizvod, " + kolicina + " FROM Stanje s WHERE s.id.sfrProizvod IN :sifre AND s.radnajedinica=:rj");
                    q.setParameter("sifre", temp);
                    q.setParameter("rj", (Object)rj);
                    List kolicine = q.getResultList();
                    for (Object[] kol : kolicine) {
                        q = em.createQuery("UPDATE Artikallista a SET a.kolicina = :kolicina WHERE a.sfrProizvod = :sfrProizvod AND a.id.idLista = :idLista");
                        q.setParameter("kolicina", kol[1]);
                        q.setParameter("sfrProizvod", kol[0]);
                        q.setParameter("idLista", (Object)idLista);
                        q.executeUpdate();
                    }
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void preuzmiCene(final List<PzEntity> checkedEntities, final Radnajedinica rj, final String cenaStanje, final String cenaLista, final int idLista, final EntityManager em, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    em.getTransaction().begin();
                    ArrayList<String> temp = new ArrayList<String>();
                    for (PzEntity e : checkedEntities) {
                        temp.add(((Artikallista)e).getSfrProizvod());
                    }
                    Query q = em.createQuery("SELECT s.id.sfrProizvod, " + cenaStanje + " FROM Stanje s WHERE s.id.sfrProizvod IN :sifre AND s.radnajedinica=:rj");
                    q.setParameter("sifre", temp);
                    q.setParameter("rj", (Object)rj);
                    List kolicine = q.getResultList();
                    for (Object[] kol : kolicine) {
                        q = em.createQuery("UPDATE Artikallista a SET " + cenaLista + " = :cena WHERE a.sfrProizvod = :sfrProizvod AND a.id.idLista = :idLista");
                        q.setParameter("cena", kol[1]);
                        q.setParameter("sfrProizvod", kol[0]);
                        q.setParameter("idLista", (Object)idLista);
                        q.executeUpdate();
                    }
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void executeNativeQuery(final String query, final EntityManager em, final PzDialogIzradaListe dlg) {
        if (query == null) {
            return;
        }
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    em.getTransaction().begin();
                    em.createNativeQuery(query).executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void brisiStavke(final List<PzEntity> checkedEntities, Integer idLista, final EntityManager em, final PzDialogIzradaListe dlg, final boolean svi) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    ArrayList<String> sifre = new ArrayList<String>();
                    ArrayList<Integer> brojevi = new ArrayList<Integer>();
                    for (PzEntity entity : checkedEntities) {
                        sifre.add(((Artikallista)entity).getSfrProizvod());
                        brojevi.add(((Artikallista)entity).getId().getrBroj());
                    }
                    Query q = em.createQuery("DELETE FROM Artikallista a WHERE a.id.rBroj IN :brojevi");
                    q.setParameter("brojevi", brojevi);
                    em.getTransaction().begin();
                    q.executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                if (svi) {
                    dlg.instantiateTable();
                } else {
                    dlg.reloadTable();
                }
            }
        };
        sw.execute();
    }

    public static void brisiCeneIliKolicine(final List<PzEntity> checkedEntities, final Integer idLista, final EntityManager em, final int izbor, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    ArrayList<Integer> brojevi = new ArrayList<Integer>();
                    for (PzEntity entity : checkedEntities) {
                        brojevi.add(((Artikallista)entity).getId().getrBroj());
                    }
                    String name = "";
                    name = izbor == 1 ? "a.kolicina" : "a.cena";
                    Query q = em.createQuery("UPDATE Artikallista a SET " + name + " = 0 WHERE a.id.rBroj IN :brojevi AND a.id.idLista=" + idLista);
                    q.setParameter("brojevi", brojevi);
                    em.getTransaction().begin();
                    q.executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void brisiNaziveIliSifre(final List<PzEntity> checkedEntities, final Integer idLista, final EntityManager em, final int izbor, final PzDialogIzradaListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    ArrayList<Integer> brojevi = new ArrayList<Integer>();
                    for (PzEntity entity : checkedEntities) {
                        brojevi.add(((Artikallista)entity).getId().getrBroj());
                    }
                    String name = "";
                    name = izbor == 3 ? "a.naziv" : "a.sfrProizvod";
                    Query q = em.createQuery("UPDATE Artikallista a SET " + name + " = NULL WHERE a.id.rBroj IN :brojevi AND a.id.idLista=" + idLista);
                    q.setParameter("brojevi", brojevi);
                    em.getTransaction().begin();
                    q.executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e1);
                }
                return null;
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                dlg.reloadTable();
            }
        };
        sw.execute();
    }

    public static void spojiListe(final List<PzEntity> liste, final EntityManager em, final PzTable table, final PzDialogListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    String brojevi = "";
                    int i = 0;
                    while (i < liste.size()) {
                        brojevi = String.valueOf(brojevi) + (i > 0 ? "," : "") + ((Lista)liste.get(i)).getIdLista();
                        ++i;
                    }
                    Lista nova = new Lista();
                    nova.setArhiviran(Integer.valueOf(0));
                    nova.setCounter(0);
                    nova.setDatum(new Date(new java.util.Date().getTime()));
                    nova.setNaslov("");
                    nova.setTip("STANDARDNA");
                    nova.setPzuser(PzExtensionLoader.getLoggedUser());
                    em.getTransaction().begin();
                    em.persist((Object)nova);
                    em.flush();
                    Query q = em.createNativeQuery("INSERT INTO ArtikalLista (idLista, rBroj, sfrProizvod, naziv, bliziOpis, kolicina, jm, cena, dobSifra, prSifra, sfrDobavljac, nazivDobavljac, sfrProizvodjac, nazivProizvodjac, oznModel, nazivModel, oznRobGr, nazivRobGr, opis, standPak, stokMin, stokMax, stalaza, nivo, paleta, tip, tezina, duzina, sirina, visina, fi)(SELECT " + nova.getIdLista() + ", ROW_NUMBER() OVER(), sfrProizvod, naziv, bliziOpis, kolicina, jm, " + "cena, dobSifra, prSifra, sfrDobavljac, nazivDobavljac, sfrProizvodjac, " + "nazivProizvodjac, oznModel, nazivModel, oznRobGr, nazivRobGr, " + "opis, standPak, stokMin, stokMax, stalaza, nivo, paleta, tip, " + "tezina, duzina, sirina, visina, fi FROM ArtikalLista WHERE idLista IN (" + brojevi + "));");
                    q.executeUpdate();
                    q = em.createQuery("DELETE FROM Artikallista a WHERE a.id.idLista IN (" + brojevi + ")");
                    q.executeUpdate();
                    q = em.createQuery("DELETE FROM Lista l WHERE l.idLista IN (" + brojevi + ")");
                    q.executeUpdate();
                    long rbr = (Long)em.createQuery("SELECT COUNT(a) FROM Artikallista a WHERE a.id.idLista=" + nova.getIdLista()).getSingleResult();
                    nova.setCounter((int)rbr);
                    em.getTransaction().commit();
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                }
                return null;
            }

            @Override
            protected void done() {
                table.setData(DBManager.getListe(em), Lista.class);
                PzWorkerDialog.hideStatus();
            }
        };
        sw.execute();
    }

    public static void brisiListe(final List<PzEntity> liste, final EntityManager em, final PzTable table, final PzDialogListe dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    ArrayList<Integer> sifre = new ArrayList<Integer>();
                    for (PzEntity l : liste) {
                        sifre.add(((Lista)l).getIdLista());
                    }
                    em.getTransaction().begin();
                    Query q = em.createQuery("DELETE FROM Artikallista a WHERE a.id.idLista IN :sifre");
                    q.setParameter("sifre", sifre);
                    q.executeUpdate();
                    q = em.createQuery("DELETE FROM Lista l WHERE l.idLista IN :sifre");
                    q.setParameter("sifre", sifre);
                    q.executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                }
                return null;
            }

            @Override
            protected void done() {
                table.setData(DBManager.getListe(em), Lista.class);
                PzWorkerDialog.hideStatus();
            }
        };
        sw.execute();
    }

    public static void arhivirajListe(final Lista l, final String komentar, final Date datum, final Arhiviranje dlg) {
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){
            EntityManager em = null;

            @Override
            protected Object doInBackground() throws Exception {
                this.em = PzEntityManagerFactory.getInstance().createEm();
                this.em.getTransaction().begin();
                l.setArhiviran(Integer.valueOf(1));
                l.setKomentar(komentar);
                l.setDatum(datum);
                Brojac br = (Brojac)this.em.find(Brojac.class, (Object)l.getTip());
                if (br == null) {
                    br = new Brojac(l.getTip());
                    br.setrBroj(0);
                    this.em.persist((Object)br);
                }
                br.setrBroj(br.getrBroj() + 1);
                l.setrBroj(br.getrBroj());
                this.em.merge((Object)l);
                this.em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        dlg.showReports();
                    }
                    catch (Exception e) {
                        if (this.em.getTransaction().isActive()) {
                            this.em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                        this.em.close();
                    }
                }
                finally {
                    this.em.close();
                }
            }
        };
        sw.execute();
    }
}

