/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import java.beans.DefaultPersistenceDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class XProperties {
    public void registerPersistenceDelegates(LocalStorage lst) {
        lst.addPersistenceDelegateConfiguration(SortKeyState.class, new DefaultPersistenceDelegate(new String[]{"state", "modelIndex"}));
        lst.addPersistenceDelegateConfiguration(ColumnState.class, new DefaultPersistenceDelegate(new String[]{"width", "preferredWidth", "modelIndex", "visible", "viewIndex"}));
        lst.addPersistenceDelegateConfiguration(XTableState.class, new DefaultPersistenceDelegate(new String[]{"columnStates", "sortKeyState", "horizontalScrollEnabled"}));
    }

    public static class ColumnState {
        private int width;
        private int preferredWidth;
        private int modelIndex;
        private boolean visible;
        private int viewIndex;

        public ColumnState(int width, int preferredWidth, int modelColumn, boolean visible, int viewIndex) {
            this.width = width;
            this.preferredWidth = preferredWidth;
            this.modelIndex = modelColumn;
            this.visible = visible;
            this.viewIndex = viewIndex;
        }

        public ColumnState(TableColumnExt columnExt, int viewIndex) {
            this(columnExt.getWidth(), columnExt.getPreferredWidth(), columnExt.getModelIndex(), columnExt.isVisible(), viewIndex);
        }

        public void configureColumn(TableColumnExt columnExt) {
            if (this.modelIndex != columnExt.getModelIndex()) {
                return;
            }
            columnExt.setPreferredWidth(this.preferredWidth);
            columnExt.setWidth(this.width);
            columnExt.setVisible(this.visible);
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public int getViewIndex() {
            return this.viewIndex;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public int getWidth() {
            return this.width;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }
    }

    public static class SortKeyState {
        int modelIndex;
        private int state;

        public SortKeyState(boolean ascending, int modelIndex) {
            this.state = ascending ? 1 : -1;
            this.modelIndex = modelIndex;
        }

        public SortKeyState(int state, int modelIndex) {
            this.state = state;
            this.modelIndex = modelIndex;
        }

        public SortKeyState(RowSorter.SortKey sortKey) {
            int s = 0;
            if (sortKey.getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                s = 1;
            } else if (sortKey.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                s = -1;
            }
            this.state = s;
            this.modelIndex = sortKey.getColumn();
        }

        protected RowSorter.SortKey getSortKey() {
            SortOrder sortOrder;
            switch (this.state) {
                case 1: {
                    sortOrder = SortOrder.ASCENDING;
                    break;
                }
                case -1: {
                    sortOrder = SortOrder.DESCENDING;
                    break;
                }
                default: {
                    sortOrder = SortOrder.UNSORTED;
                }
            }
            return new RowSorter.SortKey(this.getModelIndex(), sortOrder);
        }

        public int getState() {
            return this.state;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }
    }

    public static class VisibleColumnIndexComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((ColumnState)o1).getViewIndex() - ((ColumnState)o2).getViewIndex();
        }
    }

    public static class XTableProperty
    implements PropertySupport {
        @Override
        public Object getSessionState(Component c) {
            this.checkComponent(c);
            JXTable table = (JXTable)c;
            ArrayList<ColumnState> columnStates = new ArrayList<ColumnState>();
            List columns = table.getColumns(true);
            List visibleColumns = table.getColumns();
            for (TableColumn column : columns) {
                columnStates.add(new ColumnState((TableColumnExt)column, visibleColumns.indexOf(column)));
            }
            XTableState tableState = new XTableState(columnStates.toArray(new ColumnState[columnStates.size()]));
            tableState.setHorizontalScrollEnabled(table.isHorizontalScrollEnabled());
            List<RowSorter.SortKey> sortKeys = null;
            if (table.getRowSorter() != null) {
                sortKeys = table.getRowSorter().getSortKeys();
            }
            if (sortKeys != null && sortKeys.size() > 0) {
                tableState.setSortKey(sortKeys.get(0));
            }
            return tableState;
        }

        @Override
        public void setSessionState(Component c, Object state) {
            this.checkComponent(c);
            JXTable table = (JXTable)c;
            XTableState tableState = (XTableState)state;
            ColumnState[] columnState = tableState.getColumnStates();
            List columns = table.getColumns(true);
            if (this.canRestore(columnState, columns)) {
                int i = 0;
                while (i < columnState.length) {
                    columnState[i].configureColumn((TableColumnExt)columns.get(i));
                    ++i;
                }
                this.restoreVisibleSequence(columnState, table.getColumnModel());
            }
            table.setHorizontalScrollEnabled(tableState.getHorizontalScrollEnabled());
            if (tableState.getSortKey() != null) {
                table.getRowSorter().setSortKeys(Collections.singletonList(tableState.getSortKey()));
            }
        }

        private void restoreVisibleSequence(ColumnState[] columnStates, TableColumnModel model) {
            List<ColumnState> visibleStates = this.getSortedVisibleColumnStates(columnStates);
            int i = 0;
            while (i < visibleStates.size()) {
                TableColumn column = model.getColumn(i);
                int modelIndex = visibleStates.get(i).getModelIndex();
                if (modelIndex != column.getModelIndex()) {
                    int currentIndex = -1;
                    int j = i + 1;
                    while (j < model.getColumnCount()) {
                        TableColumn current = model.getColumn(j);
                        if (current.getModelIndex() == modelIndex) {
                            currentIndex = j;
                            break;
                        }
                        ++j;
                    }
                    model.moveColumn(currentIndex, i);
                }
                ++i;
            }
        }

        private List<ColumnState> getSortedVisibleColumnStates(ColumnState[] columnStates) {
            ArrayList<ColumnState> visibleStates = new ArrayList<ColumnState>();
            ColumnState[] columnStateArray = columnStates;
            int n = columnStates.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnState columnState = columnStateArray[n2];
                if (columnState.getVisible()) {
                    visibleStates.add(columnState);
                }
                ++n2;
            }
            Collections.sort(visibleStates, new VisibleColumnIndexComparator());
            return visibleStates;
        }

        private boolean canRestore(ColumnState[] columnState, List<TableColumn> columns) {
            if (columnState == null || columnState.length != columns.size()) {
                return false;
            }
            int i = 0;
            while (i < columnState.length) {
                if (columnState[i].getModelIndex() != columns.get(i).getModelIndex()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JXTable)) {
                throw new IllegalArgumentException("invalid component - expected JXTable");
            }
        }
    }

    public static class XTableState {
        ColumnState[] columnStates = new ColumnState[0];
        boolean horizontalScrollEnabled;
        SortKeyState sortKeyState;

        public XTableState(ColumnState[] columnStates, SortKeyState sortKeyState, boolean horizontalScrollEnabled) {
            this.columnStates = this.copyColumnStates(columnStates);
            this.sortKeyState = sortKeyState;
            this.setHorizontalScrollEnabled(horizontalScrollEnabled);
        }

        public void setSortKey(RowSorter.SortKey sortKey) {
            this.sortKeyState = new SortKeyState(sortKey);
        }

        private RowSorter.SortKey getSortKey() {
            if (this.sortKeyState != null) {
                return this.sortKeyState.getSortKey();
            }
            return null;
        }

        public XTableState(ColumnState[] columnStates) {
            this.columnStates = this.copyColumnStates(columnStates);
        }

        public ColumnState[] getColumnStates() {
            return this.copyColumnStates(this.columnStates);
        }

        public boolean getHorizontalScrollEnabled() {
            return this.horizontalScrollEnabled;
        }

        public void setHorizontalScrollEnabled(boolean horizontalScrollEnabled) {
            this.horizontalScrollEnabled = horizontalScrollEnabled;
        }

        private ColumnState[] copyColumnStates(ColumnState[] states) {
            if (states == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            ColumnState[] copy = new ColumnState[states.length];
            System.arraycopy(states, 0, copy, 0, states.length);
            return copy;
        }

        public SortKeyState getSortKeyState() {
            return this.sortKeyState;
        }
    }
}

