/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;

class TextActions
extends AbstractBean {
    private static final String MARKER_ACTION_KEY = "TextActions.markerAction";
    private final ApplicationContext context;
    private final CaretListener textComponentCaretListener;
    private final PropertyChangeListener textComponentPCL;
    private final javax.swing.Action markerAction;
    private boolean copyEnabled = false;
    private boolean cutEnabled = false;
    private boolean pasteEnabled = false;
    private boolean deleteEnabled = false;
    private boolean selectAllEnabled = false;

    public TextActions(ApplicationContext context) {
        this.context = context;
        this.markerAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.textComponentCaretListener = new TextComponentCaretListener();
        this.textComponentPCL = new TextComponentPCL();
        this.getClipboard().addFlavorListener(new ClipboardListener());
    }

    private ApplicationContext getContext() {
        return this.context;
    }

    private JComponent getFocusOwner() {
        return this.getContext().getFocusOwner();
    }

    private Clipboard getClipboard() {
        return this.getContext().getClipboard();
    }

    void updateFocusOwner(JComponent oldOwner, JComponent newOwner) {
        JTextComponent text;
        if (oldOwner instanceof JTextComponent) {
            text = (JTextComponent)oldOwner;
            text.removeCaretListener(this.textComponentCaretListener);
            text.removePropertyChangeListener(this.textComponentPCL);
        }
        if (newOwner instanceof JTextComponent) {
            text = (JTextComponent)newOwner;
            this.maybeInstallTextActions(text);
            this.updateTextActions(text);
            text.addCaretListener(this.textComponentCaretListener);
            text.addPropertyChangeListener(this.textComponentPCL);
        } else if (newOwner == null) {
            this.setCopyEnabled(false);
            this.setCutEnabled(false);
            this.setPasteEnabled(false);
            this.setDeleteEnabled(false);
            this.setSelectAllEnabled(false);
        }
    }

    private void updateTextActions(JTextComponent text) {
        int mark;
        Caret caret = text.getCaret();
        int dot = caret.getDot();
        boolean selection = dot != (mark = caret.getMark());
        boolean editable = text.isEditable();
        this.setCopyEnabled(selection);
        this.setCutEnabled(editable && selection);
        this.setDeleteEnabled(editable && selection);
        int length = text.getDocument().getLength();
        this.setSelectAllEnabled(editable && Math.abs(mark - dot) != length);
        try {
            boolean data = this.getClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
            this.setPasteEnabled(editable && data);
        }
        catch (IllegalStateException illegalStateException) {
            this.setPasteEnabled(editable);
        }
    }

    private void maybeInstallTextActions(JTextComponent text) {
        ActionMap actionMap = text.getActionMap();
        if (actionMap.get(MARKER_ACTION_KEY) == null) {
            actionMap.put(MARKER_ACTION_KEY, this.markerAction);
            ApplicationActionMap textActions = this.getContext().getActionMap(this.getClass(), this);
            Object[] objectArray = textActions.keys();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                actionMap.put(key, textActions.get(key));
                ++n2;
            }
        }
    }

    private int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    private void invokeTextAction(JTextComponent text, String actionName) {
        ActionMap actionMap = text.getActionMap().getParent();
        long eventTime = EventQueue.getMostRecentEventTime();
        int eventMods = this.getCurrentEventModifiers();
        ActionEvent actionEvent = new ActionEvent(text, 1001, actionName, eventTime, eventMods);
        actionMap.get(actionName).actionPerformed(actionEvent);
    }

    @Action(enabledProperty="cutEnabled")
    public void cut(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "cut");
        }
    }

    public boolean isCutEnabled() {
        return this.cutEnabled;
    }

    public void setCutEnabled(boolean cutEnabled) {
        boolean oldValue = this.cutEnabled;
        this.cutEnabled = cutEnabled;
        this.firePropertyChange("cutEnabled", oldValue, this.cutEnabled);
    }

    @Action(enabledProperty="copyEnabled")
    public void copy(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "copy");
        }
    }

    public boolean isCopyEnabled() {
        return this.copyEnabled;
    }

    public void setCopyEnabled(boolean copyEnabled) {
        boolean oldValue = this.copyEnabled;
        this.copyEnabled = copyEnabled;
        this.firePropertyChange("copyEnabled", oldValue, this.copyEnabled);
    }

    @Action(enabledProperty="pasteEnabled")
    public void paste(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "paste");
        }
    }

    public boolean isPasteEnabled() {
        return this.pasteEnabled;
    }

    public void setPasteEnabled(boolean pasteEnabled) {
        boolean oldValue = this.pasteEnabled;
        this.pasteEnabled = pasteEnabled;
        this.firePropertyChange("pasteEnabled", oldValue, this.pasteEnabled);
    }

    @Action(enabledProperty="deleteEnabled")
    public void delete(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "delete-next");
        }
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public void setDeleteEnabled(boolean deleteEnabled) {
        boolean oldValue = this.deleteEnabled;
        this.deleteEnabled = deleteEnabled;
        this.firePropertyChange("deleteEnabled", oldValue, this.deleteEnabled);
    }

    @Action(enabledProperty="selectAllEnabled", name="select-all")
    public void selectAll(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "select-all");
        }
    }

    public boolean isSelectAllEnabled() {
        return this.selectAllEnabled;
    }

    public void setSelectAllEnabled(boolean selectAllEnabled) {
        boolean oldValue = this.selectAllEnabled;
        this.selectAllEnabled = selectAllEnabled;
        this.firePropertyChange("selectAllEnabled", oldValue, this.selectAllEnabled);
    }

    private final class ClipboardListener
    implements FlavorListener {
        private ClipboardListener() {
        }

        @Override
        public void flavorsChanged(FlavorEvent e) {
            JComponent c = TextActions.this.getFocusOwner();
            if (c instanceof JTextComponent) {
                TextActions.this.updateTextActions((JTextComponent)c);
            }
        }
    }

    private final class TextComponentCaretListener
    implements CaretListener {
        private TextComponentCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            TextActions.this.updateTextActions((JTextComponent)e.getSource());
        }
    }

    private final class TextComponentPCL
    implements PropertyChangeListener {
        private TextComponentPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == null || "editable".equals(propertyName)) {
                TextActions.this.updateTextActions((JTextComponent)e.getSource());
            }
        }
    }
}

