/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class FileTool {
    public static void copy(String fromFileName, String toFileName) throws IOException {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + fromFileName);
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFileName);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists()) {
            if (!toFile.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + toFileName);
            }
            System.out.print("Overwrite existing file " + toFile.getName() + "? (Y/N): ");
            System.out.flush();
            new BufferedReader(new InputStreamReader(System.in));
            String response = "Y";
            if (!response.equals("Y") && !response.equals("y")) {
                throw new IOException("FileCopy: existing file was not overwritten.");
            }
        } else {
            File dir;
            String parent = toFile.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
            }
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (from != null) {
            try {
                from.close();
            }
            catch (IOException iOException) {}
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Vector<String> getFileNamesInDirectory(String fullPathDirectory, Vector<String> filter) {
        Vector<String> files = new Vector<String>();
        File folder = new File(fullPathDirectory);
        File[] listOfFiles = folder.listFiles();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile()) {
                files.add(listOfFiles[i].getName());
            }
            ++i;
        }
        FileTool.filterFiles(files, filter);
        return files;
    }

    public static Vector<String> filterFiles(Vector<String> files, Vector<String> filter) {
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < files.size()) {
            String fileExtension = files.get(i).substring(files.get(i).lastIndexOf("."), files.get(i).length());
            if (filter.contains(fileExtension.toUpperCase())) {
                temp.add(files.get(i));
            }
            ++i;
        }
        return temp;
    }

    public static Vector<File> filterFiles(File[] files, Vector<String> filter) {
        Vector<File> temp = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            String fileExtension = files[i].getName().substring(files[i].getName().lastIndexOf("."), files[i].getName().length());
            if (filter.contains(fileExtension.toUpperCase())) {
                temp.add(files[i]);
            }
            ++i;
        }
        return temp;
    }

    public static String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static boolean deleteAllFilesFromDirectory(String directoryFullPath, Vector<String> extensionFilter) {
        File directory = new File(directoryFullPath);
        File[] files = directory.listFiles();
        Vector<File> temp = FileTool.filterFiles(files, extensionFilter);
        int i = 0;
        while (i < temp.size()) {
            if (!temp.get(i).delete()) {
                System.out.println("Failed to delete file: " + directoryFullPath + "\\" + temp.get(i).getName());
                return false;
            }
            ++i;
        }
        return true;
    }
}

