/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.article;

import java.util.HashMap;
import rs.pezar.msg.device.cashregister.data.Article;

public class CtArticle {
    static HashMap<String, String> taxRates = new HashMap();

    static {
        taxRates.put("A", "0");
        taxRates.put("G", "1");
        taxRates.put("D", "2");
        taxRates.put("d", "3");
        taxRates.put("E", "4");
        taxRates.put("Z", "5");
        taxRates.put("I", "6");
        taxRates.put("J", "7");
        taxRates.put("K", "8");
    }

    public static String getHcpArticleDefineFormat(Article article) throws Exception {
        String temp = "";
        String.valueOf(article.getPLU());
        String code = article.getSifra();
        String taxRate = taxRates.get(String.valueOf(article.getTaxRate()));
        String name = String.format("%s                                ", article.getName());
        name = name.substring(0, 28);
        String price = String.valueOf(article.getPrice());
        String quantity = String.valueOf(article.getQuantity());
        String.valueOf(article.getUnit());
        if (taxRate == null || taxRate.length() == 0) {
            throw new Exception("Artikal " + code + " nema podesenu stopu poreza.");
        }
        if (name == null || name.length() == 0) {
            throw new Exception("Artikal " + code + " ne moze imati prazan naziv.");
        }
        if (price == null) {
            throw new Exception("Artikal " + code + " nema definisanu cenu.");
        }
        if (quantity == null || quantity.equals("0")) {
            throw new Exception("Artikal " + code + " ne moze imati cenu 0 ili cena nije definisana.");
        }
        if (code == null || code.length() == 0) {
            throw new Exception("Na racunu je detektovan artikal sa nedefinisanom sifrom.");
        }
        code = CtArticle.transformCode(code);
        name = name.replaceAll("\u00c5\u00a0", "S");
        name = name.replaceAll("\u00c5\u00a1", "s");
        name = name.replaceAll("\u00c4\u2018", "d");
        name = name.replaceAll("\u00c4\ufffd", "D");
        name = name.replaceAll("\u00c5\u00be", "z");
        name = name.replaceAll("\u00c5\u00bd", "Z");
        name = name.replaceAll("\u00c4\ufffd", "c");
        name = name.replaceAll("\u00c4\u0152", "C");
        name = name.replaceAll("\u00c4\u2021", "c");
        name = name.replaceAll("\u00c4\u2020", "C");
        name = name.replaceAll(",", " ");
        name = name.replaceAll("'", " ");
        name = name.replaceAll("\"", " ");
        name = name.replaceAll("`", " ");
        name = name.replaceAll("&", " ");
        name = name.replaceAll(">", " ");
        name = name.replaceAll("<", " ");
        temp = " <Plu Des=\"" + name + "\" Price=\"" + price + "\" Vat=\"" + taxRate + "\" Dep =\"0\" Mes=\"0\">" + code + "</Plu> ";
        return temp;
    }

    private static String transformCode(String code) {
        String tempCode = code.replaceAll("A", "1");
        tempCode = tempCode.replaceAll("a", "2");
        tempCode = tempCode.replaceAll("B", "3");
        tempCode = tempCode.replaceAll("b", "4");
        tempCode = tempCode.replaceAll("C", "5");
        tempCode = tempCode.replaceAll("c", "6");
        tempCode = tempCode.replaceAll("D", "7");
        tempCode = tempCode.replaceAll("d", "8");
        tempCode = tempCode.replaceAll("E", "9");
        tempCode = tempCode.replaceAll("e", "10");
        tempCode = tempCode.replaceAll("F", "11");
        tempCode = tempCode.replaceAll("f", "12");
        tempCode = tempCode.replaceAll("G", "13");
        tempCode = tempCode.replaceAll("g", "14");
        tempCode = tempCode.replaceAll("H", "15");
        tempCode = tempCode.replaceAll("h", "16");
        tempCode = tempCode.replaceAll("I", "17");
        tempCode = tempCode.replaceAll("i", "18");
        tempCode = tempCode.replaceAll("J", "19");
        tempCode = tempCode.replaceAll("j", "20");
        tempCode = tempCode.replaceAll("K", "21");
        tempCode = tempCode.replaceAll("k", "22");
        tempCode = tempCode.replaceAll("L", "23");
        tempCode = tempCode.replaceAll("l", "24");
        tempCode = tempCode.replaceAll("M", "25");
        tempCode = tempCode.replaceAll("m", "26");
        tempCode = tempCode.replaceAll("N", "27");
        tempCode = tempCode.replaceAll("n", "28");
        tempCode = tempCode.replaceAll("O", "29");
        tempCode = tempCode.replaceAll("o", "30");
        tempCode = tempCode.replaceAll("P", "31");
        tempCode = tempCode.replaceAll("p", "32");
        tempCode = tempCode.replaceAll("Q", "33");
        tempCode = tempCode.replaceAll("q", "34");
        tempCode = tempCode.replaceAll("R", "35");
        tempCode = tempCode.replaceAll("r", "36");
        tempCode = tempCode.replaceAll("S", "37");
        tempCode = tempCode.replaceAll("s", "38");
        tempCode = tempCode.replaceAll("T", "39");
        tempCode = tempCode.replaceAll("t", "40");
        tempCode = tempCode.replaceAll("U", "41");
        tempCode = tempCode.replaceAll("u", "42");
        tempCode = tempCode.replaceAll("V", "43");
        tempCode = tempCode.replaceAll("v", "44");
        tempCode = tempCode.replaceAll("W", "45");
        tempCode = tempCode.replaceAll("w", "46");
        tempCode = tempCode.replaceAll("X", "47");
        tempCode = tempCode.replaceAll("x", "48");
        tempCode = tempCode.replaceAll("Y", "49");
        tempCode = tempCode.replaceAll("y", "50");
        tempCode = tempCode.replaceAll("Z", "51");
        tempCode = tempCode.replaceAll("z", "52");
        return tempCode;
    }

    public static String getHcpArticleBillFormat(Article article) throws Exception {
        String temp = "";
        String code = article.getSifra();
        String taxRate = taxRates.get(String.valueOf(article.getTaxRate()));
        String price = String.valueOf(article.getPrice());
        String quantity = article.getQuantity().stripTrailingZeros().toPlainString();
        code = CtArticle.transformCode(code);
        if (taxRate == null || taxRate.length() == 0) {
            throw new Exception("Artikal " + code + " nema podesenu stopu poreza.");
        }
        if (price == null) {
            throw new Exception("Artikal " + code + " nema definisanu cenu.");
        }
        if (quantity == null || quantity.equals("0")) {
            throw new Exception("Artikal " + code + " ne moze imati cenu 0 ili cena nije definisana.");
        }
        if (code == null || code.length() == 0) {
            throw new Exception("Na racunu je detektovan artikal sa nedefinisanom sifrom.");
        }
        temp = " <Plu kol=\"" + quantity + "\">" + code + "</Plu> ";
        return temp;
    }
}

