/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class Client {
    static JFrame frame = new JFrame();
    static JTextArea text = new JTextArea();
    static JButton send = new JButton("SEND TEXT");
    static JButton reset = new JButton("RESET TEXT");
    static JButton sendXml = new JButton("SEND XML");
    static JButton zReport = new JButton("Z report");
    static JButton xReport = new JButton("X report");
    static JButton dayStarted = new JButton("fisc.day started");
    static JButton readVats = new JButton("read vats");
    static JButton readJournal = new JButton("read journal");
    static JButton stateZ = new JButton("read Z state");
    static JButton stateBill = new JButton("read Bill state");
    static JButton PLUall = new JButton("read all PLU");
    static JButton PLUsold = new JButton("read sold PLU");
    private static byte[] buffer = new byte[0x100000];
    InputStream Sinput;
    OutputStream Soutput;
    Socket socket;

    static {
        JPanel pp = new JPanel(new BorderLayout(10, 10));
        pp.setBorder(new TitledBorder("testing panel"));
        pp.setPreferredSize(new Dimension(800, 600));
        frame.setContentPane(pp);
        text.setLineWrap(true);
        pp.add((Component)new JScrollPane(text), "Center");
        frame.pack();
        JPanel bp = new JPanel(new GridLayout(15, 1, 5, 5));
        bp.add(send);
        bp.add(reset);
        bp.add(new JLabel());
        bp.add(sendXml);
        JPanel ert = new JPanel(new BorderLayout());
        ert.add((Component)bp, "North");
        ert.add((Component)new JPanel(), "Center");
        pp.add((Component)ert, "West");
        JPanel commPanel = new JPanel(new GridLayout(15, 1, 5, 5));
        commPanel.add(zReport);
        commPanel.add(xReport);
        commPanel.add(new JLabel());
        commPanel.add(dayStarted);
        commPanel.add(new JLabel());
        commPanel.add(readVats);
        commPanel.add(readJournal);
        commPanel.add(new JLabel());
        commPanel.add(stateZ);
        commPanel.add(stateBill);
        commPanel.add(new JLabel());
        commPanel.add(PLUall);
        commPanel.add(PLUsold);
        JPanel ppp = new JPanel(new BorderLayout());
        ppp.setBorder(new TitledBorder("commands"));
        ppp.add((Component)commPanel, "North");
        ppp.add((Component)new JPanel(), "Center");
        pp.add((Component)ppp, "East");
        frame.setTitle("RS CLIENT");
        frame.setLocationRelativeTo(null);
        frame.setAlwaysOnTop(true);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void main(String[] arg) {
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        new Client(3535, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><NEFISKALNI_TEKST><DATA TXT=\"" + text.getText() + "\"/></NEFISKALNI_TEKST>");
                    }
                }.start();
            }
        });
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                text.setText("");
            }
        });
        sendXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String readString;
                try {
                    JFileChooser fc = new JFileChooser();
                    fc = new JFileChooser(".");
                    fc.setAcceptAllFileFilterUsed(true);
                    int retVal = fc.showOpenDialog(frame);
                    if (retVal != 0) {
                        return;
                    }
                    File f = fc.getSelectedFile();
                    if (f == null) {
                        return;
                    }
                    String str = "";
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    try {
                        String in;
                        while ((in = br.readLine()) != null) {
                            str = String.valueOf(str) + in;
                        }
                    }
                    finally {
                        br.close();
                    }
                    readString = str;
                }
                catch (Exception e1) {
                    text.append("Exception reading file: " + e1);
                    text.append("\r\n");
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        new Client(3535, readString);
                    }
                }.start();
            }
        });
        zReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("DNEVNI_IZVESTAJ");
            }
        });
        xReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("PRESEK_STANJA");
            }
        });
        dayStarted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("PROVERI_FISKALNI_DAN");
            }
        });
        readVats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.readVats();
            }
        });
        readJournal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("ZURNAL");
            }
        });
        stateZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("STANJE_KASE");
            }
        });
        stateBill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("STANJE_RACUNA");
            }
        });
        PLUall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("ARTIKLI");
            }
        });
        PLUsold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client.sendCommand("PRODATI_ARTIKLI");
            }
        });
        frame.setVisible(true);
    }

    protected static void readVats() {
        new Thread(){

            @Override
            public void run() {
                new Client(3535, "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><KOMANDE><DATA CMD='USER_COMMAND' COMMAND_BYTE='32'> </DATA></KOMANDE>");
            }
        }.start();
    }

    private static void sendCommand(final String cmd) {
        new Thread(){

            @Override
            public void run() {
                new Client(3535, "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><KOMANDE><DATA CMD='" + cmd + "'/></KOMANDE>");
            }
        }.start();
    }

    Client(int port, String txt) {
        text.setText(">>>");
        try {
            this.socket = new Socket("localhost", port);
        }
        catch (Exception e) {
            text.setText("Error connectiong to server:" + e);
            text.append("\r\n");
            return;
        }
        text.setText("Connection accepted " + this.socket.getInetAddress() + ":" + this.socket.getPort());
        text.append("\r\n");
        try {
            this.Soutput = this.socket.getOutputStream();
            this.Sinput = this.socket.getInputStream();
        }
        catch (IOException e) {
            text.append("Exception creating new Input/output Streams: " + e);
            text.append("\r\n");
            return;
        }
        text.append("\r\n");
        text.append("SENDING:\"" + txt);
        text.append("\r\n");
        try {
            this.Soutput.write(txt.getBytes());
            this.Soutput.flush();
            this.socket.shutdownOutput();
        }
        catch (IOException e) {
            text.append("Error writting to the socket: " + e);
            text.append("\r\n");
            return;
        }
        try {
            int pos = 0;
            int t = 0;
            long time = System.currentTimeMillis();
            while ((t = this.Sinput.read(buffer, pos, buffer.length - pos)) >= 0) {
                pos += t;
                if (System.currentTimeMillis() - time <= 60000L) continue;
                throw new Exception("TIMEOUT!");
            }
            String reply = new String(buffer, 0, pos);
            text.append("\r\n");
            text.append("RECEIVED: " + reply);
            text.append("\r\n");
        }
        catch (Exception e) {
            text.append("Exception reading error: " + e);
            text.append("\r\n");
            return;
        }
    }
}

