/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.util.HashMap;
import java.util.Vector;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.Transformer.CTTransformer;
import rs.pezar.kasa.databaseEngine.DatabaseEngine;
import rs.pezar.kasa.databaseEngine.DatabaseFunctions;
import rs.pezar.kasa.putGetEngine.DataGetter;
import rs.pezar.kasa.putGetEngine.PutGetEngine;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegisterControlInterface;

public class CTResidentialService {
    public static final String BILL_TYPE = "BILL_TYPE";
    public static final String CONTROL_TYPE = "CONTROL_TYPE";
    public static final String ARTICLE_TYPE = "ARTICLE_TYPE";
    public static final String PAYMENT_TYPE = "PAYMENT_TYPE";
    public static final String BASE_NAME = "CTDB";
    public static final String WORKING_SUBFOLDER = "CT";
    public static final String REQUIRED_VERSION = "xxx";
    public static final String OUT_TYPE = "OUT_TYPE";
    private PutGetEngine putGetEngine;
    private DatabaseEngine databaseEngine;
    private static CTResidentialService instance;

    public CTResidentialService(HashMap<String, String> params) {
        this.putGetEngine = new PutGetEngine(params);
        instance = this;
    }

    public void run() throws Exception {
        String workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        this.databaseEngine = new DatabaseEngine(workingFolder, WORKING_SUBFOLDER, BASE_NAME);
    }

    public HashMap<String, String> runWithTheBill(DeviceDataInterface data) {
        Vector returnData = new Vector();
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        try {
            if (bill.isPreBill()) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Nije dozvoljeno stampanje predracuna.");
            } else {
                String hcpArt = CTTransformer.transformArticle(data);
                System.out.println(hcpArt);
                this.putGetEngine.put(hcpArt, ARTICLE_TYPE);
                String pay = CTTransformer.transformPayment(data);
                System.out.println(pay);
                this.putGetEngine.put(pay, PAYMENT_TYPE);
                String hcpBill = CTTransformer.transformBill(data);
                System.out.println(hcpBill);
                this.putGetEngine.put(hcpBill, BILL_TYPE);
                restemp = this.putGetEngine.putGet("1", CONTROL_TYPE);
                result = this.formatReturnedData(restemp, result);
                Thread.sleep(1000L);
                restemp = this.putGetEngine.putGet("2", CONTROL_TYPE);
                result = this.formatReturnedData(restemp, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("MESSAGE", e.getMessage());
            result.put("CODE", "ERROR");
        }
        if (result.get("CODE") == null) {
            result.put("CODE", "SUCCESS");
            int i = 0;
            while (i < returnData.size()) {
                result.put("MESSAGE", (String)returnData.elementAt(i));
                ++i;
            }
        }
        String error1 = restemp.get(DataGetter.INFO_COMM_ERROR) == null ? "" : (String)restemp.get(DataGetter.INFO_COMM_ERROR);
        String error2 = restemp.get(DataGetter.INFO_NOPAPER) == null ? "" : (String)restemp.get(DataGetter.INFO_NOPAPER);
        result.put("INFO", "L|" + error1 + ";" + error2);
        return result;
    }

    public DatabaseEngine getDatabaseEngine() {
        return this.databaseEngine;
    }

    public HashMap<String, String> runWithTheControl(DeviceDataInterface data) {
        CashRegisterControl cntrl = (CashRegisterControl)data.getData();
        HashMap<String, String> result = cntrl.getControlCode() == "CODE_DELETE_ALL_ART" ? this.deleteAllArticles(cntrl) : this.executeControl(cntrl);
        return result;
    }

    public HashMap<String, String> executeControl(CashRegisterControl cntrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        try {
            String tempControl = CTTransformer.transformControl((CashRegisterControlInterface)cntrl);
            System.out.println(tempControl);
            restemp = this.putGetEngine.putGet(tempControl, CONTROL_TYPE);
            result = this.formatReturnedData(restemp, result);
        }
        catch (Exception e) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", e.getMessage());
        }
        String info = "L|OK.";
        info = String.valueOf(info) + result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    public HashMap<String, String> deleteAllArticles(CashRegisterControl cntrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        try {
            this.putGetEngine.extendWaitTime(300000);
            DatabaseFunctions.dropTable(this.databaseEngine.getConnection(), BASE_NAME);
            restemp = this.putGetEngine.putGet("7", CONTROL_TYPE);
            result = this.formatReturnedData(restemp, result);
        }
        catch (Exception e) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", e.getMessage());
        }
        String info = "L|OK.";
        info = String.valueOf(info) + result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    private HashMap<String, String> formatReturnedData(HashMap<String, String> returnedData, HashMap<String, String> appender) {
        if (appender == null) {
            appender = new HashMap();
        }
        if (returnedData.containsKey(DataGetter.INFO_ERROR)) {
            String error1 = returnedData.get(DataGetter.INFO_COMM_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_COMM_ERROR);
            String error3 = returnedData.get(DataGetter.INFO_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_ERROR);
            appender.put("CODE", "ERROR");
            appender.put("MESSAGE", error1 + "." + error3);
        }
        if (returnedData.containsKey(DataGetter.INFO_OK)) {
            returnedData.get(DataGetter.INFO_OK);
            appender.put("CODE", "SUCCESS");
            appender.put("MESSAGE", "OK");
        }
        if (returnedData.size() == 0) {
            appender.put("CODE", "ERROR");
            appender.put("MESSAGE", "CT Middleware (Fiscal28.jar) ne vraca podatke, proverite da li ste upalili CT-ov usluzni program i dobro podesili foldere za komunikaciju sa njim. Za podesavanje pogledajte uputstvo za fiscal28.jar!");
        }
        return appender;
    }

    public static CTResidentialService getInstance() {
        return instance;
    }

    public static void setInstance(CTResidentialService instance) {
        CTResidentialService.instance = instance;
    }

    public PutGetEngine getPutGetEngine() {
        return this.putGetEngine;
    }
}

