/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat.textComponent;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import rs.pezar.core.PzApplication;
import rs.pezar.service.msg.chat.textComponent.chatText.ChatText;
import rs.pezar.service.msg.chat.textComponent.hyperlink.HyperlinkText;
import rs.pezar.service.msg.chat.textComponent.hyperlink.HyperlinkTextWorker;
import rs.pezar.service.msg.chat.textComponent.notification.NotificationText;
import rs.pezar.service.msg.chat.textComponent.userText.UserText;
import rs.pezar.service.msg.chat.textComponentActions.TextActionInterface;
import rs.pezar.service.msg.chat.textComponentActions.TextActionShowDialog;
import rs.pezar.service.msg.chat.textComponentActions.TextActionShowDocument;

public class PzChatTextComponent
extends JTextPane {
    private Integer fontSize = 13;
    private SimpleAttributeSet userAttributeSet;
    private StyledDocument doc = (StyledDocument)this.getDocument();
    private SimpleAttributeSet chatTextAttributeSet;
    private SimpleAttributeSet hyperLinkAttributeSet;
    private SimpleAttributeSet notificationAttributeSet;
    private Vector<TextActionInterface> textActions;

    public PzChatTextComponent() {
        this.userAttributeSet = UserText.getTextAttributes();
        this.chatTextAttributeSet = ChatText.getTextAttributes();
        this.hyperLinkAttributeSet = HyperlinkText.getTextAttributes();
        this.notificationAttributeSet = NotificationText.getTextAttributes();
        this.addMouseListener(this.getMouseAdapter());
        this.addMouseMotionListener(this.getMouseMotionAdapter());
        this.textActions = new Vector();
        this.textActions.add(new TextActionShowDocument());
        this.textActions.add(new TextActionShowDialog());
        String fontsize = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty("CHAT_FONT_SIZE");
        if (fontsize != null) {
            this.fontSize = Integer.parseInt(fontsize);
        } else {
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty("CHAT_FONT_SIZE", (Object)String.valueOf(this.fontSize));
        }
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.chatTextAttributeSet, false);
    }

    public void addText(String user, String text) throws BadLocationException {
        if (NotificationText.hasNotification(text)) {
            this.addNotificationText(text);
        } else {
            this.addHyperLinkedChatText(user, text);
        }
    }

    private void addHyperLinkedChatText(String user, String text) throws BadLocationException {
        UserText.addUserText(this.doc, user, this.userAttributeSet);
        String message1 = String.valueOf(text) + "\n";
        HyperlinkTextWorker hlComp = new HyperlinkTextWorker();
        hlComp.addHyperlinkedText(this.doc, message1, this.hyperLinkAttributeSet, this.chatTextAttributeSet);
    }

    private void addNotificationText(String text) {
        String message1 = String.valueOf(text) + "\n";
        NotificationText.addNotoficationText(this.doc, message1, this.hyperLinkAttributeSet, this.notificationAttributeSet);
    }

    public void increaseFontSize() {
        this.fontSize = this.fontSize + 1;
        StyleConstants.setFontSize(this.userAttributeSet, this.fontSize);
        StyleConstants.setFontSize(this.hyperLinkAttributeSet, this.fontSize);
        StyleConstants.setFontSize(this.chatTextAttributeSet, this.fontSize);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.chatTextAttributeSet, false);
        PzApplication.getApplication().getLocalMachineUserSettings().setProperty("CHAT_FONT_SIZE", (Object)String.valueOf(this.fontSize));
    }

    public void decreaseFontSize() {
        this.fontSize = this.fontSize - 1;
        StyleConstants.setFontSize(this.userAttributeSet, this.fontSize);
        StyleConstants.setFontSize(this.hyperLinkAttributeSet, this.fontSize);
        StyleConstants.setFontSize(this.chatTextAttributeSet, this.fontSize);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.chatTextAttributeSet, false);
        PzApplication.getApplication().getLocalMachineUserSettings().setProperty("CHAT_FONT_SIZE", (Object)String.valueOf(this.fontSize));
    }

    private MouseMotionAdapter getMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
                Point pt = new Point(arg0.getPoint());
                int pos = PzChatTextComponent.this.viewToModel(pt);
                String a = (String)PzChatTextComponent.this.doc.getCharacterElement(pos).getAttributes().getAttribute("TYPE");
                if (a == null) {
                    PzChatTextComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (a != null) {
                    PzChatTextComponent.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        };
    }

    private MouseListener getMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Point pt = new Point(arg0.getPoint());
                int pos = PzChatTextComponent.this.viewToModel(pt);
                String a = (String)PzChatTextComponent.this.doc.getCharacterElement(pos).getAttributes().getAttribute("TYPE");
                if (a != null) {
                    int i = 0;
                    while (i < PzChatTextComponent.this.textActions.size()) {
                        if (((TextActionInterface)PzChatTextComponent.this.textActions.get(i)).getType().equals(a)) {
                            String param1 = (String)PzChatTextComponent.this.doc.getCharacterElement(pos).getAttributes().getAttribute("P1");
                            String param2 = (String)PzChatTextComponent.this.doc.getCharacterElement(pos).getAttributes().getAttribute("P2");
                            String param3 = (String)PzChatTextComponent.this.doc.getCharacterElement(pos).getAttributes().getAttribute("P3");
                            ((TextActionInterface)PzChatTextComponent.this.textActions.get(i)).run(param1, param2, param3);
                        }
                        ++i;
                    }
                }
            }
        };
    }
}

