/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.chat.interfaces.SetupPanelInterface;
import rs.pezar.msg.chat.interfaces.TextMessageReceiverInterface;
import rs.pezar.service.msg.chat.DefaultTextMessageReceiver;
import rs.pezar.service.msg.chat.TopicWindow;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkbench;
import rs.pezar.swing.fields.PzTextField;

public class SetupPanel
extends PzPanel
implements SetupPanelInterface,
ActionListener {
    PzExtensionLoader loader;
    private static final String DEFAULT_CHAT_ROOM = "DEFAULT_CHAT_ROOM";
    private static final String ICON_SUCCESS = "rs/pezar/service/msg/chat/resource/img/check_small.png";
    private static final String ICON_FAIL = "rs/pezar/service/msg/chat/resource/img/warning_small.png";
    private PzButton pzPrikazi;
    private JScrollPane jScrollPane1;
    private JXTable table;
    private static final String ICON_DISCONNECTED = "rs/pezar/service/msg/chat/resource/img/forbidden_small.png";
    private static final String DEFAULT_CHAT_ROOM_NAME = "topic.GrupnaRazmenaPoruka";
    private PzPanel panelChat;
    private JLabel lbPprijavljeno;
    private PzButton btnOdjava;
    private PzButton btnPristupi;
    private PzTextField textNazivTopica;
    private JLabel lblText;
    private TopicWindow defaultChatRoom;
    private String chatRoom;
    private PzWorkbench workbench;
    private Vector<TopicWindow> topics;
    private int pos;
    private DefaultTextMessageReceiver textMessageReceiver;

    public SetupPanel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pos = 0;
        this.topics = new Vector();
        this.initGUI();
    }

    public void activate() {
    }

    public void init() {
        if (this.loader.getMsgProtocol() == null) {
            this.lbPprijavljeno.setText("Konekcija sa serverom za razmenu poruka nije uspostavljena.");
            this.lbPprijavljeno.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_FAIL)));
        } else {
            try {
                this.chatRoom = PzParameter.getParameterValue((String)DEFAULT_CHAT_ROOM);
            }
            catch (Exception exception) {}
        }
        if (this.loader.getMsgProtocol() != null) {
            if (this.textMessageReceiver == null) {
                this.textMessageReceiver = new DefaultTextMessageReceiver(this.loader.getMsgProtocol());
            }
            this.loader.getMsgProtocol().setMessageReceiver((TextMessageReceiverInterface)this.textMessageReceiver);
        }
    }

    private void initGUI() {
        try {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(686, 423));
            this.panelChat = new PzPanel();
            this.add((Component)this.panelChat);
            this.panelChat.setBounds(12, 5, 648, 398);
            this.panelChat.setBorder((Border)BorderFactory.createTitledBorder("Razmena poruka"));
            this.panelChat.setLayout(null);
            this.lblText = new JLabel();
            this.panelChat.add((Component)this.lblText);
            this.lblText.setText("Standardna grupa za razmenu poruka:");
            this.lblText.setBounds(17, 21, 615, 14);
            this.textNazivTopica = new PzTextField(DEFAULT_CHAT_ROOM_NAME);
            this.panelChat.add((Component)this.textNazivTopica);
            this.textNazivTopica.setBounds(17, 41, 615, 19);
            this.textNazivTopica.setFont(new Font("Tahoma", 0, 11));
            this.textNazivTopica.setHorizontalAlignment(10);
            this.btnPristupi = new PzButton();
            this.panelChat.add((Component)this.btnPristupi);
            this.btnPristupi.setText("Prijavi se");
            this.btnPristupi.setBounds(510, 66, 120, 23);
            this.btnPristupi.addActionListener((ActionListener)this);
            this.btnOdjava = new PzButton();
            this.panelChat.add((Component)this.btnOdjava);
            this.btnOdjava.setText("Odjavi se");
            this.btnOdjava.setBounds(510, 322, 120, 23);
            this.btnOdjava.addActionListener((ActionListener)this);
            this.lbPprijavljeno = new JLabel();
            this.panelChat.add((Component)this.lbPprijavljeno);
            this.lbPprijavljeno.setText("Prijavljeno za grupnu razmenu");
            this.lbPprijavljeno.setBounds(16, 358, 614, 20);
            this.lbPprijavljeno.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_SUCCESS)));
            this.jScrollPane1 = new JScrollPane();
            this.panelChat.add((Component)this.jScrollPane1);
            this.jScrollPane1.setBounds(18, 100, 612, 213);
            DefaultTableModel tableModel = new DefaultTableModel(null, new String[]{"Prijavljene Grupe"});
            this.table = new JXTable((TableModel)tableModel);
            this.table.setEditable(false);
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.setBounds(18, 105, 612, 213);
            this.pzPrikazi = new PzButton();
            this.panelChat.add((Component)this.pzPrikazi);
            this.pzPrikazi.setText("Prika\u017ei");
            this.pzPrikazi.setBounds(393, 322, 107, 23);
            this.pzPrikazi.addActionListener((ActionListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.btnPristupi)) {
            this.onButtonPristupiPressed();
        } else if (arg0.getSource().equals(this.btnOdjava)) {
            this.onButtonOdjavaPressed();
        } else if (arg0.getSource().equals(this.pzPrikazi)) {
            this.onButtonPrikaziPressed();
        }
    }

    private void onButtonOdjavaPressed() {
        int i = 0;
        while (i < this.topics.size()) {
            if (this.table.getSelectedRow() == -1 || this.topics.get(i).getTopicName().equals(this.table.getModel().getValueAt(this.table.getSelectedRow(), 0))) {
                // empty if block
            }
            this.topics.get(i).setVisible(false);
            ++i;
        }
        this.refreshTable();
    }

    private void onButtonPrikaziPressed() {
        int i = 0;
        while (i < this.topics.size()) {
            if (this.table.getSelectedRow() == -1 || this.topics.get(i).getTopicName().equals(this.table.getModel().getValueAt(this.table.getSelectedRow(), 0))) {
                // empty if block
            }
            this.topics.get(i).setVisible(true);
            ++i;
        }
        this.refreshTable();
    }

    private void refreshTable() {
        DefaultTableModel tableModel = new DefaultTableModel(null, new String[]{"Prijavljene Grupe"});
        int i = 0;
        while (i < this.topics.size()) {
            Object[] all = new String[]{this.topics.get(i).getTopicName()};
            tableModel.insertRow(i, all);
            ++i;
        }
        this.table.setModel((TableModel)tableModel);
        this.table.getTableHeader().setEnabled(false);
        this.table.repaint();
    }

    private void onButtonPristupiPressed() {
        if (this.loader.getMsgProtocol() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate biti konektovani na server za razmenu poruka.", "Gre\u0161ka", 0);
            this.setLabelFailed();
            return;
        }
        this.chatRoom = this.textNazivTopica.getText();
        if (this.checkIfTopicAlreadyExists(this.chatRoom)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Grupa sa ovim imenom ve\u0107 postoji.", "Gre\u0161ka", 0);
            return;
        }
        try {
            this.loader.getMsgProtocol().registerTopic(this.chatRoom);
        }
        catch (Exception exception) {
            this.setLabelFailed();
            return;
        }
        this.setLabelSuccess();
        TopicWindow defaultChatRoom = new TopicWindow(this.loader.getMsgProtocol(), this.chatRoom);
        this.topics.add(defaultChatRoom);
        this.textMessageReceiver.addTopicWindow(defaultChatRoom);
        defaultChatRoom.setVisible(true);
        this.refreshTable();
        if (this.chatRoom != null) {
            try {
                PzParameter.setParameter((String)DEFAULT_CHAT_ROOM, (String)this.chatRoom);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Gre\u0161ka, parametar za razmenu poruka ne mo\u017ee biti upisan u bazu.", "Gre\u0161ka", 0);
            }
        }
    }

    public void destroyAllChatWindows() {
        for (TopicWindow topic : this.topics) {
            this.textMessageReceiver.removeTopicWindow(topic);
            topic.dispose();
        }
        this.topics.removeAllElements();
        ((DefaultTableModel)this.table.getModel()).getDataVector().removeAllElements();
        this.refreshTable();
    }

    public boolean checkIfTopicAlreadyExists(String topicName) {
        int i = 0;
        while (i < this.topics.size()) {
            if (this.topics.get(i).getTopicName().equals(topicName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PzExtensionLoader getExtensionLoader() {
        return this.loader;
    }

    public void setExtensionLoader(PzExtensionLoader loader) {
        this.loader = loader;
    }

    public void setWorkbench(PzWorkbench workbench) {
        this.workbench = workbench;
    }

    private void setLabelSuccess() {
        this.lbPprijavljeno.setText("Konekcija sa serverom za razmenu poruka uspe\u0161no uspostavljena.");
        this.lbPprijavljeno.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_SUCCESS)));
    }

    private void setLabelFailed() {
        this.lbPprijavljeno.setText("Konekcija sa serverom za razmenu poruka nije uspostavljena.");
        this.lbPprijavljeno.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_DISCONNECTED)));
    }
}

