/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.kasa.gui.IzborDokumenta;
import rs.pezar.kasa.gui.util.KasaGradientUtil;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class StampaFakture
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private JLabel lbNazivKupca;
    private PzTextField tfBrFisIsecka;
    private JLabel lbBrFisIsecka;
    private PzTextField tfPib;
    private PzFieldIndikator indikator;
    private PzButton btnStampac;
    private PzButton btnNbs;
    private JLabel lbAdresa;
    private JLabel lblPIB;
    private PzTextField tfGrad;
    private JLabel lbGrad;
    private PzTextField tfAdresa;
    private PzTextField tfNazivKupca;
    private PzTextField tfBrojMRacuna;
    private JButton btnKupac;
    private JLabel lbBrojMRacuna;
    private PzButton btnFiskal;
    private PzDialog thisDialog = null;
    private Komitent komitent;
    private String paremetar;
    private Radnajedinica rj;
    private JLabel lblMBR;
    private PzTextField tfMbr;
    private static Fiskalniracun fRacun;

    public StampaFakture(JFrame frame, String paremetar) {
        super(frame);
        this.thisDialog = this;
        this.paremetar = paremetar;
        this.initGUI();
    }

    public StampaFakture(PzDialog dialog) {
        super(dialog);
        this.thisDialog = this;
        this.paremetar = "gotovinski";
        this.initGUI();
        this.tfBrojMRacuna.setVal((Object)fRacun.getOznDokumenta());
        this.tfBrojMRacuna.setFocusable(false);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("\u0160TAMPA FAKTURE PO RA\u010cUNU MALOPRODAJE");
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{7, 231, 8, 61, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 159, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlFieldsLayout.rowHeights = new int[]{25, 5, 25, 5, 25, 25, 25, 25, 25};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{19, 154, 45, 131, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lbBrojMRacuna = new JLabel();
            this.pnlFields.add((Component)this.lbBrojMRacuna, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lbBrojMRacuna.setText("Broj maloprodajnog ra\u010duna");
            this.btnKupac = new PzButton();
            this.pnlFields.add((Component)this.btnKupac, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnKupac.setText("Na\u0111i kupca|u bazi");
            this.btnKupac.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/businessmen.png")));
            this.btnKupac.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StampaFakture.this.emptyFields();
                    StampaFakture.this.komitent = PzDialogKomintenti.getKomitent((PzDialog)StampaFakture.this.thisDialog);
                    if (StampaFakture.this.komitent != null) {
                        StampaFakture.this.setKupac();
                        StampaFakture.this.tfBrFisIsecka.requestFocus();
                    }
                }
            });
            this.lbNazivKupca = new JLabel();
            this.pnlFields.add((Component)this.lbNazivKupca, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lbNazivKupca.setText("Naziv kupca");
            this.tfBrojMRacuna = new PzTextField();
            this.pnlFields.add((Component)this.tfBrojMRacuna, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfBrojMRacuna.setVerifyInput(true);
            this.tfBrojMRacuna.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (StampaFakture.this.tfBrojMRacuna.getVal().equals("")) {
                        fRacun = IzborDokumenta.getFiskalniracun(StampaFakture.this.thisDialog, StampaFakture.this.rj);
                        if (fRacun == null) {
                            return false;
                        }
                        StampaFakture.this.tfBrojMRacuna.setVal((Object)fRacun.getOznDokumenta());
                        StampaFakture.this.btnKupac.requestFocus();
                    } else {
                        fRacun = StampaFakture.this.getRacun(StampaFakture.this.tfBrojMRacuna.getVal());
                        if (fRacun == null) {
                            PzSwingUtility.showInformationMessage(null, (String)"Nije prona\u0111en maloprodajni ra\u010dun, poku\u0161ajte ponovo!");
                            StampaFakture.this.tfBrojMRacuna.setText("");
                            return false;
                        }
                        StampaFakture.this.tfBrojMRacuna.setVal((Object)fRacun.getOznDokumenta());
                        StampaFakture.this.btnKupac.requestFocus();
                    }
                    return true;
                }
            });
            this.tfNazivKupca = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivKupca, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.lbAdresa = new JLabel();
            this.pnlFields.add((Component)this.lbAdresa, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lbAdresa.setText("Adresa");
            this.tfAdresa = new PzTextField();
            this.pnlFields.add((Component)this.tfAdresa, (Object)new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.lbGrad = new JLabel();
            this.pnlFields.add((Component)this.lbGrad, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lbGrad.setText("Grad");
            this.tfGrad = new PzTextField();
            this.pnlFields.add((Component)this.tfGrad, (Object)new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.lblPIB = new JLabel();
            this.pnlFields.add((Component)this.lblPIB, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPIB.setText("PIB");
            this.tfPib = new PzTextField();
            this.pnlFields.add((Component)this.tfPib, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.lblMBR = new JLabel();
            this.pnlFields.add((Component)this.lblMBR, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblMBR.setText("MBR");
            this.tfMbr = new PzTextField();
            this.pnlFields.add((Component)this.tfMbr, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.lbBrFisIsecka = new JLabel();
            this.pnlFields.add((Component)this.lbBrFisIsecka, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lbBrFisIsecka.setText("Broj fiskalnog isecka");
            this.tfBrFisIsecka = new PzTextField();
            this.pnlFields.add((Component)this.tfBrFisIsecka, (Object)new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.btnNbs = new PzButton();
            this.btnNbs.setText("Na\u0111i kupca|u NBS");
            this.btnNbs.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/nbs.png")));
            this.pnlFields.add((Component)this.btnNbs, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.btnNbs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StampaFakture.this.btnNbsActionPerformed(evt);
                }
            });
            this.indikator = new PzFieldIndikator();
            this.tfBrFisIsecka.setStateIndikator(this.indikator);
            this.tfBrFisIsecka.setVerifyInput(true);
            this.pnlFields.add((Component)this.indikator, (Object)new GridBagConstraints(3, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnFiskal = new PzButton();
            this.pnlGlavni.add((Component)this.btnFiskal, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.btnFiskal.setText("\u0160tampa na|fiskalnom ure\u0111aju");
            this.btnFiskal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/fiskal.png")));
            this.btnFiskal.setActionCommand("potvrdi");
            this.btnFiskal.addActionListener((ActionListener)((Object)this));
            this.btnFiskal.setShortcut("Ctrl+W");
            this.btnStampac = new PzButton();
            this.btnStampac.setText("\u0160tampa na|\u0161tampa\u010du");
            this.btnStampac.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/printer_preferences.png")));
            this.btnStampac.setActionCommand("potvrdi");
            this.btnStampac.addActionListener((ActionListener)((Object)this));
            this.pnlGlavni.add((Component)this.btnStampac, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void emptyFields() {
        this.tfNazivKupca.setVal((Object)"");
        this.tfAdresa.setVal((Object)"");
        this.tfGrad.setVal((Object)"");
        this.tfPib.setVal((Object)"");
        this.tfMbr.setVal((Object)"");
    }

    public void setKupac() {
        this.tfNazivKupca.setVal((Object)this.komitent.getNaziv());
        this.tfAdresa.setVal((Object)this.komitent.getAdresa());
        this.tfGrad.setVal((Object)this.komitent.getGrad());
        this.tfPib.setVal((Object)this.komitent.getPib());
        this.tfMbr.setVal((Object)this.komitent.getMatBroj());
    }

    public static Fiskalniracun getRacun(Fiskalniracun racun, PzDialog parent) {
        fRacun = racun;
        parent.showDialog(StampaFakture.class);
        return fRacun;
    }

    public void actionPerformed(ActionEvent e) {
        block12: {
            EntityManager em = PzEntityManager.getEm();
            em.getTransaction().begin();
            try {
                PzButton button = (PzButton)e.getSource();
                String actionCommand = button.getActionCommand();
                if (!actionCommand.equals("potvrdi")) break block12;
                if (!this.verifiInputFields()) {
                    return;
                }
                try {
                    fRacun.setKomitent(this.komitent);
                    fRacun.setNazivKupca(this.tfNazivKupca.getVal());
                    fRacun.setAdresa(this.tfAdresa.getVal());
                    fRacun.setGrad(this.tfGrad.getVal());
                    fRacun.setPib(this.tfPib.getVal());
                    fRacun.setMbr(this.tfMbr.getVal());
                    fRacun.setBrFiskalnogIsecka(this.tfBrFisIsecka.getVal());
                    em.merge((Object)fRacun);
                    em.getTransaction().commit();
                    if (this.paremetar.equals("gotovinski")) {
                        if (e.getSource() == this.btnStampac) {
                            PzKasaUtil.showReports(this, fRacun, "rs/pezar/kasa/resource/reports/compiled/gotovinski.racun.jasper");
                        } else if (e.getSource() == this.btnFiskal) {
                            PzKasaUtil.stampajRacun((PzDokument)fRacun, true, null);
                        }
                    }
                    this.dispose();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private boolean verifiInputFields() {
        Boolean res = true;
        if (this.tfBrFisIsecka.getVal().equals("")) {
            PzSwingUtility.showErrorMessage(null, (String)"Nije popunjeno polje za broj fiskalnog ise\u010dka!");
            this.tfBrFisIsecka.requestFocus();
            res = false;
        }
        return res;
    }

    private Fiskalniracun getRacun(String oznaka) {
        Fiskalniracun res = null;
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT f FROM Fiskalniracun f where f.arhiviran=1 and f.oznDokumenta=:oznaka");
            q.setParameter("oznaka", (Object)oznaka);
            if (q.getResultList().size() != 0) {
                res = (Fiskalniracun)q.getSingleResult();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        return res;
    }

    public boolean shouldBeShown() {
        this.pnlGlavni.setPaintGradient(true);
        this.pnlGlavni.setGradient(KasaGradientUtil.MALOPRODAJNI_RACUN_GRADIENT);
        this.getSession().putParameter("gradient", (Object)KasaGradientUtil.MALOPRODAJNI_RACUN_GRADIENT);
        boolean res = false;
        if (this.paremetar.equals("fiskalni")) {
            res = true;
        } else {
            this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf('E')});
            if (this.rj != null) {
                res = true;
            }
        }
        return res;
    }

    public static Object getGUIBuilderInstance() {
        return new StampaFakture(Boolean.FALSE);
    }

    public StampaFakture(Boolean initGUI) {
    }

    private void btnNbsActionPerformed(ActionEvent evt) {
        String pibStr = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Unesite PIB kupca:");
        if ("".equals(pibStr) || pibStr == null) {
            return;
        }
        try {
            int pib = Integer.parseInt(pibStr);
            PzGenericService service = PzApplication.getApplication().getGenericServiceRegistry().getService("NBS_GETKOMITENT");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("PIB", String.valueOf(pib));
            map.put("MBR", "0");
            Vector komitenti = (Vector)service.run(map);
            if (komitenti.size() == 0) {
                PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nije prona\u0111en nijedan komitent.");
                return;
            }
            Komitent k = (Komitent)komitenti.get(0);
            this.tfNazivKupca.setVal((Object)k.getNaziv());
            this.tfAdresa.setVal((Object)k.getAdresa());
            this.tfGrad.setVal((Object)k.getGrad());
            this.tfPib.setVal((Object)k.getPib());
            this.tfBrFisIsecka.requestFocusInWindow();
            this.tfMbr.setVal((Object)k.getMatBroj());
        }
        catch (NumberFormatException numberFormatException) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka! PIB mo\u017ee da sadr\u017ei samo numeri\u010dke znakove.");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }
}

