/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.util.PzGradient;

public class IzborDokumenta
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzTable tabelaRacun;
    private JScrollPane scrollPaneRacun;
    private PzButton btnSearch;
    private PzDateField dfEnd;
    private PzDateField dfStart;
    private JLabel lblKrajDatum;
    private JLabel lblPocDatum;
    private static Radnajedinica rj;
    private static Fiskalniracun racun;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel();

    static {
        racun = null;
    }

    public IzborDokumenta(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.postInit();
        this.paintPanel();
    }

    private void postInit() {
        SwingWorker<List<Fiskalniracun>, Object> worker = new SwingWorker<List<Fiskalniracun>, Object>(){

            @Override
            protected List<Fiskalniracun> doInBackground() throws Exception {
                EntityManager em = PzEntityManager.getEm();
                Query q = null;
                q = em.createQuery("SELECT f FROM Fiskalniracun f where f.arhiviran=1 and f.radnajedinica=:rj and f.vreme >= :startDate and f.vreme <= :endDate");
                q.setParameter("rj", (Object)rj);
                q.setParameter("startDate", (Object)IzborDokumenta.this.getTimeStamp(IzborDokumenta.this.dfStart.getVal(), 0, 0, 0));
                q.setParameter("endDate", (Object)IzborDokumenta.this.getTimeStamp(IzborDokumenta.this.dfEnd.getVal(), 23, 59, 59));
                List data = q.getResultList();
                IzborDokumenta.this.brDok.setText(Integer.toString(data.size()));
                return data;
            }

            @Override
            protected void done() {
                super.done();
                try {
                    List data = (List)this.get();
                    if (data.size() != 0) {
                        IzborDokumenta.this.tabelaRacun.setData(data, Fiskalniracun.class);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IzborDokumenta.this.tabelaRacun.requestFocusInWindow();
                        }
                    });
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Throwable)e1);
                }
            }
        };
        worker.execute();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{20, 7, 7, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.0, 0.1, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 117, 7, 117, 20};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPaneRacun = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPaneRacun, (Object)new GridBagConstraints(0, 1, 5, 4, 0.0, 0.0, 10, 1, new Insets(10, 20, 20, 20), 0, 0));
            this.scrollPaneRacun.setPreferredSize(new Dimension(418, 266));
            this.tabelaRacun = new PzTable();
            this.scrollPaneRacun.setViewportView((Component)this.tabelaRacun);
            this.tabelaRacun.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    racun = (Fiskalniracun)IzborDokumenta.this.tabelaRacun.getSelectedEntity();
                    IzborDokumenta.this.dispose();
                }
            });
            this.lblPocDatum = new JLabel("Od dana:");
            this.pnlGlavni.add((Component)this.lblPocDatum, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.lblKrajDatum = new JLabel("Do dana:");
            this.pnlGlavni.add((Component)this.lblKrajDatum, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.dfStart = new PzDateField();
            this.pnlGlavni.add((Component)this.dfStart, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
            this.dfEnd = new PzDateField();
            this.pnlGlavni.add((Component)this.dfEnd, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
            this.btnSearch = new PzButton("Prika\u017ei");
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    IzborDokumenta.this.postInit();
                }
            });
            this.pnlGlavni.add((Component)this.btnSearch, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj dokumenata");
            this.jlStatusBar.setPreferredSize(new Dimension(82, 14));
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(609, 357);
            this.setMinimumSize(new Dimension(609, 357));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Fiskalniracun getFiskalniracun(PzDialog parent, Radnajedinica rj) {
        IzborDokumenta.setRadnajedinica(rj);
        parent.showDialog(IzborDokumenta.class);
        return racun;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static void setRadnajedinica(Radnajedinica rj) {
        IzborDokumenta.rj = rj;
    }

    public static Object getGUIBuilderInstance() {
        return new IzborDokumenta(Boolean.FALSE);
    }

    public IzborDokumenta(Boolean initGUI) {
    }

    private Timestamp getTimeStamp(Date datum, int sat, int min, int sec) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(datum);
        cal.set(11, sat);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }
}

