/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import com.swtdesigner.FocusTraversalOnArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.kasa.gui.PzDialogIzradaMaloprodajnogRacunaNew;
import rs.pezar.kasa.gui.StampaFakture;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class ArhiviranjeNew
extends PzDialog {
    private static final String FISKALNI_PREKO_FAKTURE = "fiskalniPrekoFakture";
    private static final String STORNO_RACUNA = "storno";
    private static final String IZRADA_RACUNA = "izradaRacuna";
    private static final long serialVersionUID = 4634561238599267310L;
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzDoubleField dfGotovina;
    private JLabel lbGotovina;
    private PzDoubleField dfCek;
    private JLabel lbCek;
    private PzDoubleField dfPlatnaKartica;
    private JLabel lbPlatnaKartica;
    private PzDoubleField dfIznosRacuna;
    private PzDoubleField dfKusur;
    private JLabel lbKusur;
    private PzDoubleField dfPrimljeno;
    private JLabel lbPrimljeno;
    private JLabel lbIznosRacuna;
    private PzButton btnPotvrdi;
    private Fiskalniracun racun;
    private Faktura f;
    private final boolean showReport = false;
    public Double gotovina = 0.0;
    public Double cekovi = 0.0;
    private PzDateField dfDatum;
    private JLabel lblDatum;
    private PzDoubleField dfPopust;
    private JLabel lblPopust;
    private JCheckBox cbSaNivelacijom;
    private JPanel jPanel1;
    private JCheckBox cbGotovinski;
    private PzPanelHeader header;
    public Double kartice = 0.0;
    private final boolean arhiviraj = true;
    private final String parameter;
    private HashMap<String, Object> stateMap;
    private JXLayer<Component> layer;
    private PzBusyPainterUI layerUI;
    private boolean updateKolicine;
    private ArrayList<Component> fieldList = new ArrayList();

    public ArhiviranjeNew(PzDialog dialog) {
        super(dialog);
        Boolean bezKase;
        this.parameter = (String)this.getSession().getParameter("parameter");
        this.initGUI();
        if (this.parameter.equals(FISKALNI_PREKO_FAKTURE)) {
            this.f = (Faktura)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.f.getIznos());
            this.dfGotovina.setVal((Object)this.f.getIznos().subtract(this.f.getStornoIznos()));
            this.dfPrimljeno.setVal((Object)this.f.getIznos().subtract(this.f.getStornoIznos()));
            this.cbGotovinski.setEnabled(false);
        } else if (this.parameter.equals(STORNO_RACUNA)) {
            this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.racun.getIznosRacuna());
            this.dfGotovina.setVal((Object)this.racun.getIznosRacuna());
            this.dfPrimljeno.setVal((Object)this.racun.getIznosRacuna());
            this.cbGotovinski.setEnabled(false);
        } else {
            this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.racun.getIznosRacuna());
            this.dfGotovina.setVal((Object)this.racun.getIznosRacuna());
            this.dfPrimljeno.setVal((Object)this.racun.getIznosRacuna());
        }
        Boolean bl = bezKase = this.getSession().getParameter("bez_kase") != null ? (Boolean)this.getSession().getParameter("bez_kase") : Boolean.FALSE;
        if (bezKase.booleanValue()) {
            this.dfDatum.setEnabled(true);
        } else {
            this.dfDatum.setEnabled(false);
        }
        this.paintPanel();
        this.restState();
        this.setFocusTraversal();
        this.updateKolicine = (Boolean)this.getSession().getParameter("updateKolicine");
        if (!"generalni".equals(PzParameter.getParameterValue((String)"KASA_POPUST", (String)"")) || PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_RABATA") == null) {
            this.dfPopust.setEnabled(false);
        }
    }

    private void setFocusTraversal() {
        try {
            this.pnlGlavni.setFocusTraversalPolicyProvider(true);
            String focus = PzParameter.getParameterValue((String)"KASA_ARHIVA_FOCUS");
            if (focus != null) {
                String[] focArr = focus.split("\\s+");
                Vector fields = this.pnlFields.getAllFields();
                ArrayList<Component> fieldsFiltered = new ArrayList<Component>();
                int i = 0;
                while (i < focArr.length) {
                    for (PzField field : fields) {
                        if (!(field instanceof PzDoubleField) || !((Component)field).getName().equals(focArr[i])) continue;
                        fieldsFiltered.add((Component)field);
                    }
                    ++i;
                }
                if (fieldsFiltered.size() > 0) {
                    fieldsFiltered.add((Component)this.btnPotvrdi);
                    Object[] cObj = fieldsFiltered.toArray();
                    Component[] components = new Component[cObj.length];
                    int i2 = 0;
                    while (i2 < components.length) {
                        components[i2] = (Component)cObj[i2];
                        ++i2;
                    }
                    this.pnlGlavni.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(components));
                } else {
                    this.pnlGlavni.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.dfPrimljeno, this.btnPotvrdi}));
                }
            } else {
                this.pnlGlavni.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.dfPrimljeno, this.btnPotvrdi}));
            }
        }
        catch (Exception exception) {
            this.pnlGlavni.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.dfPrimljeno, this.btnPotvrdi}));
        }
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("ARHIVIRANJE");
            this.pnlGlavni = new PzPanel();
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.pnlGlavni, (LayerUI)this.layerUI);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.layer, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{23, 80, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1};
            pnlGlavniLayout.columnWidths = new int[]{32};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(390, 284));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout1 = new GridBagLayout();
            pnlFieldsLayout1.columnWeights = new double[]{0.0, 0.1, 0.0};
            int[] nArray = new int[3];
            nArray[0] = 145;
            nArray[1] = 7;
            pnlFieldsLayout1.columnWidths = nArray;
            pnlFieldsLayout1.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            pnlFieldsLayout1.rowHeights = new int[]{20, 20, 7, 7, 7, 7, 7, 7, 20, 20};
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout1);
            this.pnlFields.setOpaque(false);
            this.pnlFields.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 50));
            this.lbIznosRacuna = new JLabel();
            this.pnlFields.add((Component)this.lbIznosRacuna, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbIznosRacuna.setText("Iznos racuna");
            this.lbIznosRacuna.setFont(new Font("Tahoma", 1, 11));
            this.dfIznosRacuna = new PzDoubleField();
            this.dfIznosRacuna.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfIznosRacuna, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfIznosRacuna.setLimit(7, 2);
            this.dfIznosRacuna.setFocusable(false);
            this.dfIznosRacuna.setName("dfIznosRacuna");
            this.lbPlatnaKartica = new JLabel();
            this.pnlFields.add((Component)this.lbPlatnaKartica, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbPlatnaKartica.setText("Platne kartice");
            this.dfPlatnaKartica = new PzDoubleField();
            this.dfPlatnaKartica.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfPlatnaKartica, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfPlatnaKartica.setLimit(7, 2);
            this.dfPlatnaKartica.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfPlatnaKartica.setName("dfPlatneKartice");
            this.fieldList.add((Component)this.dfPlatnaKartica);
            this.lbCek = new JLabel();
            this.pnlFields.add((Component)this.lbCek, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbCek.setText("Cekovi");
            this.dfCek = new PzDoubleField();
            this.dfCek.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfCek, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfCek.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfCek.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfCek.setName("dfCekovi");
            this.fieldList.add((Component)this.dfCek);
            this.lbGotovina = new JLabel();
            this.pnlFields.add((Component)this.lbGotovina, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbGotovina.setText("Gotovina");
            this.dfGotovina = new PzDoubleField();
            this.dfGotovina.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfGotovina, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfGotovina.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfGotovina.setFocusable(false);
            this.dfGotovina.setName("dfGotovina");
            this.lbPrimljeno = new JLabel();
            this.pnlFields.add((Component)this.lbPrimljeno, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbPrimljeno.setText("Primljeno");
            this.dfPrimljeno = new PzDoubleField();
            this.dfPrimljeno.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfPrimljeno, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfPrimljeno.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfPrimljeno.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculatePovracaj();
                }
            });
            this.dfPrimljeno.setName("dfPrimljeno");
            this.fieldList.add((Component)this.dfPrimljeno);
            this.lbKusur = new JLabel();
            this.pnlFields.add((Component)this.lbKusur, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbKusur.setText("Povra\u0107aj");
            this.lbKusur.setFont(new Font("Tahoma", 1, 11));
            this.dfKusur = new PzDoubleField();
            this.dfKusur.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfKusur, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfKusur.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfKusur.setFocusable(false);
            this.dfKusur.setName("dfKusur");
            this.cbGotovinski = new JCheckBox("Gotovinski ra\u010dun");
            this.cbGotovinski.setFont(new Font("SansSerif", 0, 18));
            this.cbGotovinski.setOpaque(false);
            this.pnlFields.add((Component)this.cbGotovinski, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.fieldList.add(this.cbGotovinski);
            this.cbSaNivelacijom = new JCheckBox("Sa nivelacijom");
            this.cbSaNivelacijom.setFont(new Font("SansSerif", 0, 18));
            this.cbSaNivelacijom.setOpaque(false);
            this.cbSaNivelacijom.setFocusable(false);
            this.pnlFields.add((Component)this.cbSaNivelacijom, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.lblDatum = new JLabel("Datum");
            this.pnlFields.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDatum.setName("lblDatum");
            this.dfDatum = new PzDateField();
            this.dfDatum.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfDatum, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.lblPopust = new JLabel("Popust ( % )");
            this.pnlFields.add((Component)this.lblPopust, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.dfPopust = new PzDoubleField();
            this.dfPopust.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ArhiviranjeNew.this.dfPopustKeyPressed();
                }
            });
            this.dfPopust.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfPopust, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.jPanel1 = new JPanel();
            this.jPanel1.setOpaque(false);
            this.pnlGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 15, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.btnPotvrdi.setFont(new Font("SansSerif", 0, 18));
            this.jPanel1.add((Component)this.btnPotvrdi);
            this.btnPotvrdi.setText("Izdaj ra\u010dun (Ctrl+W)");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.btnPotvrdi.setPreferredSize(new Dimension(256, 36));
            this.fieldList.add((Component)this.btnPotvrdi);
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/cashier1.png")));
            this.header.setTitle("Izdavanje ra\u010duna maloprodaje");
            this.header.setOpaque(false);
            this.pnlGlavni.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.addFieldShortcuts(this.fieldList);
            this.setSize(459, 480);
            this.setRestorable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void addFieldShortcuts(final ArrayList<Component> list) {
        for (final Component field : list) {
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    int i = list.indexOf(field);
                    if (e.getKeyCode() == 38) {
                        if (i != 0) {
                            ((Component)list.get(i - 1)).requestFocusInWindow();
                            if (list.get(i - 1) instanceof PzDoubleField && list.get(i) instanceof PzDoubleField) {
                                PzDoubleField s = (PzDoubleField)list.get(i - 1);
                                PzDoubleField t = (PzDoubleField)list.get(i);
                                if (t.getVal().equals(ArhiviranjeNew.this.dfIznosRacuna.getVal())) {
                                    t.setVal((Object)new Double(0.0));
                                    s.setVal((Object)ArhiviranjeNew.this.dfIznosRacuna.getVal());
                                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                                }
                            }
                        }
                    } else if (e.getKeyCode() == 40) {
                        if (i != list.size() - 1) {
                            ((Component)list.get(i + 1)).requestFocusInWindow();
                            if (list.get(i + 1) instanceof PzDoubleField && list.get(i) instanceof PzDoubleField) {
                                PzDoubleField s = (PzDoubleField)list.get(i + 1);
                                PzDoubleField t = (PzDoubleField)list.get(i);
                                if (t.getVal().equals(ArhiviranjeNew.this.dfIznosRacuna.getVal())) {
                                    t.setVal((Object)new Double(0.0));
                                    s.setVal((Object)ArhiviranjeNew.this.dfIznosRacuna.getVal());
                                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                                }
                            }
                        }
                    } else if (e.getKeyCode() == 113) {
                        ArhiviranjeNew.this.dfPopust.requestFocusInWindow();
                    }
                }
            });
        }
    }

    private void calculateGotovinaPrimljeno() {
        double i = this.dfIznosRacuna.getVal();
        double c = this.dfCek.getVal();
        double k = this.dfPlatnaKartica.getVal();
        double raz = i - c - k;
        this.dfGotovina.setVal((Object)raz);
        this.dfPrimljeno.setVal((Object)(raz > 0.0 ? raz : 0.0));
        this.calculatePovracaj();
    }

    private void calculatePovracaj() {
        this.dfKusur.setVal((Object)(this.dfPrimljeno.getVal() + this.dfCek.getVal() + this.dfPlatnaKartica.getVal() - this.dfIznosRacuna.getVal()));
    }

    private void dfPopustKeyPressed() {
        Double iznos = new Double(this.racun.getIznosRacuna().doubleValue() - this.racun.getIznosRacuna().doubleValue() * (this.dfPopust.getVal() / 100.0));
        this.dfIznosRacuna.setVal((Object)iznos);
        this.dfGotovina.setVal((Object)iznos);
        this.dfPrimljeno.setVal((Object)iznos);
        this.dfPlatnaKartica.setVal((Object)new Double(0.0));
        this.dfCek.setVal((Object)new Double(0.0));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            if (actionCommand.equals("potvrdi") && this.parameter.equals(IZRADA_RACUNA)) {
                this.izdavanjeRacuna();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void izdavanjeRacuna() {
        if (this.dfPrimljeno.getVal() < 0.0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Primljeni iznos ne mo\u017ee biti negativan");
            return;
        }
        Double d = new Double(0.0);
        if (this.dfKusur.getVal() < d) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka! Povra\u0107aj ne mo\u017ee biti negativan. Proverite unete podatke.");
            return;
        }
        this.layerUI.setLocked(true);
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                ArhiviranjeNew.this.ocisti();
                Boolean bezKase = (Boolean)ArhiviranjeNew.this.getSession().getParameter("bez_kase");
                boolean odstampan = false;
                if (bezKase == null) {
                    bezKase = Boolean.FALSE;
                }
                if (!bezKase.booleanValue()) {
                    ArhiviranjeNew.this.pripremiRacunZaStampu(false, ArhiviranjeNew.this.cbSaNivelacijom.isSelected());
                    PzKasaUtil.prevedi(ArhiviranjeNew.this.racun);
                    odstampan = PzKasaUtil.stampajRacun((PzDokument)ArhiviranjeNew.this.racun, false, null);
                } else {
                    ArhiviranjeNew.this.racun.setPoruka("Ra\u010dun registrovan bez \u0161tampanja na fiskalnom \u0161tampa\u010du");
                    ArhiviranjeNew.this.pripremiRacunZaStampu(true, ArhiviranjeNew.this.cbSaNivelacijom.isSelected());
                }
                return odstampan;
            }

            @Override
            protected void done() {
                block13: {
                    try {
                        Boolean bezKase;
                        Boolean odstampan = (Boolean)this.get();
                        boolean arhiva = true;
                        Boolean bl = bezKase = ArhiviranjeNew.this.getSession() != null && ArhiviranjeNew.this.getSession().getParameter("bez_kase") != null ? (Boolean)ArhiviranjeNew.this.getSession().getParameter("bez_kase") : Boolean.FALSE;
                        if (!odstampan.booleanValue() && !bezKase.booleanValue()) {
                            int res = PzSwingUtility.daNeDijalog((Component)((Object)ArhiviranjeNew.this), (Object)"Fiskalni \u0161tampa\u010d je prijavio gre\u0161ku prilikom \u0161tampanja ra\u010duna.\nDa li \u017eelite da proknji\u017eite ra\u010dun bez ponovnog slanja na \u0161tampu?", (String)"Problem", null, (boolean)true);
                            if (res != 0) {
                                arhiva = false;
                            } else {
                                bezKase = true;
                            }
                        }
                        if (arhiva) {
                            ArhiviranjeNew.this.arhivirajRacun(bezKase);
                            if (ArhiviranjeNew.this.cbGotovinski.isSelected()) {
                                ArhiviranjeNew.this.racun = StampaFakture.getRacun(ArhiviranjeNew.this.racun, ArhiviranjeNew.this);
                                if (ArhiviranjeNew.this.racun.getBrFiskalnogIsecka().equals("")) {
                                    return;
                                }
                            }
                        }
                        try {
                            ArhiviranjeNew.this.napraviPrazanRacun();
                            ArhiviranjeNew.this.saveState();
                            ArhiviranjeNew.this.dispose();
                        }
                        catch (Exception e) {
                            if (!(e instanceof OptimisticLockException) && !(e instanceof OptimisticLockException)) {
                                PzMysqlExceptionHandler.handle((Throwable)e);
                                break block13;
                            }
                            e.printStackTrace();
                        }
                    }
                    finally {
                        ArhiviranjeNew.this.layerUI.setLocked(false);
                    }
                }
            }
        };
        worker.execute();
    }

    private void ocisti() {
        block2: {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                em.getTransaction().begin();
                em.createQuery("DELETE FROM Taksafiskalniracun t WHERE t.id.idDok=" + this.racun.getIdDok()).executeUpdate();
                em.createQuery("DELETE FROM Dtaksa t WHERE t.id.idDok=" + this.racun.getIdDok()).executeUpdate();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Throwable)e);
                if (!em.getTransaction().isActive()) break block2;
                em.getTransaction().commit();
            }
        }
    }

    private void saveState() throws IOException {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("cbSaNivelacijom", this.cbSaNivelacijom.isSelected());
        PzApplication.getApplication().getPropManager().saveObject(m, "arh_fisk.sav");
    }

    private void restState() {
        try {
            this.stateMap = (HashMap)PzApplication.getApplication().getPropManager().loadObject("arh_fisk.sav");
        }
        catch (Exception exception) {}
        if (this.stateMap == null) {
            this.stateMap = new HashMap();
            if (this.racun.getRadnajedinica().getpTip().equals("V")) {
                this.stateMap.put("cbSaNivelacijom", false);
            } else {
                this.stateMap.put("cbSaNivelacijom", true);
            }
        }
        this.cbSaNivelacijom.setSelected((Boolean)this.stateMap.get("cbSaNivelacijom"));
    }

    private void prebaciNaMaloprodajneCene(Faktura f) {
        if (f.getDokument().getRadnajedinica().getpTip().equals("S")) {
            BigDecimal novaProdCena;
            BigDecimal stopa;
            BigDecimal cena;
            int i = 0;
            while (i < f.getArtikalDocuments().size()) {
                cena = ((PzArtikalDokument)f.getArtikalDocuments().get(i)).getProdCena();
                stopa = new BigDecimal(String.valueOf(((PzArtikalDokument)f.getArtikalDocuments().get(i)).getTaksa("PDV").getStopa()));
                novaProdCena = cena.add(cena.multiply(stopa.divide(new BigDecimal(100))));
                ((PzArtikalDokument)f.getArtikalDocuments().get(i)).setCena(novaProdCena.doubleValue());
                ++i;
            }
            i = 0;
            while (i < f.getUslugaDocuments().size()) {
                cena = new BigDecimal(String.valueOf(((PzUslugaDokument)f.getUslugaDocuments().get(i)).getCena()));
                stopa = new BigDecimal(String.valueOf(((PzUslugaDokument)f.getUslugaDocuments().get(i)).getTaksa("PDV").getStopa()));
                novaProdCena = cena.add(cena.multiply(stopa.divide(new BigDecimal(100))));
                ((PzUslugaDokument)f.getUslugaDocuments().get(i)).setCena(novaProdCena.doubleValue());
                ++i;
            }
        }
    }

    private void pripremiRacunZaStampu(boolean arhiviraj, boolean saNivelacijom) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        boolean nivSuccess = !saNivelacijom;
        try {
            try {
                Boolean bezKase;
                em.getTransaction().begin();
                this.racun = (Fiskalniracun)em.createQuery("SELECT f FROM Fiskalniracun F JOIN FETCH f.proizvodfiskalniracuns JOIN FETCH f.dokument WHERE f.idDok=" + this.racun.getIdDok()).getSingleResult();
                if (this.dfPopust.getVal().compareTo(new Double(0.0)) > 0 && this.racun.getProizvodfiskalniracuns() != null && this.racun.getProizvodfiskalniracuns().size() > 0) {
                    for (Proizvodfiskalniracun p : this.racun.getProizvodfiskalniracuns()) {
                        p.setProcRabata(p.getProcRabata() + this.dfPopust.getVal());
                    }
                }
                this.racun.sumirajPopust();
                this.racun.primeniPopustNaCene();
                this.racun.setGotovina(this.dfGotovina.getBigDecimal());
                this.racun.setCekovi(this.dfCek.getBigDecimal());
                this.racun.setKartice(this.dfPlatnaKartica.getBigDecimal());
                this.racun.setPrimljeno(this.dfPrimljeno.getBigDecimal());
                if (this.racun.getCekovi().add(this.racun.getKartice()).add(this.racun.getGotovina()).compareTo(this.dfIznosRacuna.getBigDecimal()) != 0) {
                    throw new PzInfoException("Iznos racuna se neslaze sa zbirom pojedinacnih iznosa (gotovina + cekovi + kartice) ");
                }
                Timestamp datum = PzDateUtility.getServerTime((EntityManager)em);
                Boolean bl = bezKase = this.getSession().getParameter("bez_kase") != null ? (Boolean)this.getSession().getParameter("bez_kase") : Boolean.FALSE;
                if (bezKase.booleanValue()) {
                    this.racun.setVreme(new Timestamp(this.dfDatum.getVal().getTime()));
                } else {
                    this.racun.setVreme(datum);
                }
                Nivelacija nivelacija = null;
                if (saNivelacijom) {
                    Faktura f = this.getFaktura(this.racun, em);
                    nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)false, (boolean)true, (EntityManager)em);
                    this.arhiviraj(nivelacija, em);
                    nivSuccess = true;
                }
                PzKasaUtil.pripremiZaStampu(this.racun, em, arhiviraj);
                em.getTransaction().commit();
                if (nivelacija != null) {
                    this.header.setText("Registrovana je promena cene tako da \u0107e biti izra\u0111ena nivelacija.");
                }
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (!(e instanceof OptimisticLockException) && !(e instanceof OptimisticLockException)) {
                    throw e;
                }
                this.pripremiRacunZaStampu(arhiviraj, !nivSuccess);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void arhivirajRacun(boolean bezKase) throws Exception {
        try {
            PzKasaUtil.arhivirajRacun(this.racun, this.updateKolicine, bezKase);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof OptimisticLockException || cause != null && cause instanceof OptimisticLockException) {
                e.printStackTrace();
                this.arhivirajRacun(bezKase);
            }
            throw e;
        }
    }

    public Faktura getFaktura(Fiskalniracun racun, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(racun.getRadnajedinica());
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        for (Proizvodfiskalniracun proizvod : racun.getProizvodfiskalniracuns()) {
            if (proizvod.getId().getSfrProizvod().endsWith("U")) continue;
            Artikalfaktura af = new Artikalfaktura();
            Artikal a = (Artikal)em.find(Artikal.class, (Object)proizvod.getId().getSfrProizvod());
            af.setArtikal(a);
            af.setId(1, proizvod.getId().getSfrProizvod(), 1);
            af.setKolicina(proizvod.getKolicina());
            af.setCena(proizvod.getCena());
            af.setNaziv(proizvod.getNaziv());
            af.setJm(proizvod.getJm());
            af.setAftaksas(new Vector());
            if (proizvod.getTaksas() != null || proizvod.getTaksas().size() != 0) {
                for (PzADTaksa t : proizvod.getTaksas()) {
                    af.getAftaksas().add(new Aftaksa(f.getIdDok(), proizvod.getId().getSfrProizvod(), t.getOznTarGr(), 0, t.getStopa(), t.getOznVrstaTG(), ""));
                }
            }
            f.getArtikalfakturas().add(af);
        }
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void napraviPrazanRacun() {
        if (this.getSession().getParameter("izArhiveObrisanih") != null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                if (!((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).getFiskalniRacun().booleanValue()) {
                    ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).createFiskalniRacun(em);
                }
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshDataTable();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshIznos();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).resetDialogData();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e instanceof OptimisticLockException || e.getCause() instanceof OptimisticLockException) {
                    this.napraviPrazanRacun();
                } else {
                    PzMysqlExceptionHandler.handle((Throwable)e);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

