/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.kasa.gui.PzDialogIzradaMaloprodajnogRacunaNew;
import rs.pezar.kasa.gui.StampaFakture;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.msg.device.cashregister.exceptions.CRException;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class Arhiviranje
extends PzDialog {
    private static final String FISKALNI_PREKO_FAKTURE = "fiskalniPrekoFakture";
    private static final String STORNO_RACUNA = "storno";
    private static final String IZRADA_RACUNA = "izradaRacuna";
    private static final long serialVersionUID = 4634561238599267310L;
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzDoubleField dfGotovina;
    private JLabel lbGotovina;
    private PzDoubleField dfCek;
    private JLabel lbCek;
    private PzDoubleField dfPlatnaKartica;
    private JLabel lbPlatnaKartica;
    private PzDoubleField dfIznosRacuna;
    private PzDoubleField dfKusur;
    private JLabel lbKusur;
    private PzDoubleField dfPrimljeno;
    private JLabel lbPrimljeno;
    private JLabel lbIznosRacuna;
    private PzButton btnPotvrdi;
    private Fiskalniracun racun;
    private Faktura f;
    private final boolean showReport = false;
    public Double gotovina = 0.0;
    public Double cekovi = 0.0;
    private JCheckBox cbSaNivelacijom;
    private JPanel jPanel1;
    private JCheckBox cbGotovinski;
    private PzPanelHeader header;
    public Double kartice = 0.0;
    private final boolean arhiviraj = true;
    private Nivelacija nivelacija;
    private final String parameter = (String)this.getSession().getParameter("parameter");
    private HashMap<String, Object> stateMap;

    public Arhiviranje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        if (this.parameter.equals(FISKALNI_PREKO_FAKTURE)) {
            this.f = (Faktura)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.f.getIznosDokumenta());
            this.dfGotovina.setVal((Object)this.f.getIznosDokumenta());
            this.dfPrimljeno.setVal((Object)this.f.getIznosDokumenta());
            this.cbGotovinski.setEnabled(false);
        } else if (this.parameter.equals(STORNO_RACUNA)) {
            this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
            this.getSession().putParameter("racun", null);
            this.dfIznosRacuna.setVal((Object)this.racun.getIznosRacuna());
            this.dfGotovina.setVal((Object)this.racun.getIznosRacuna());
            this.dfPrimljeno.setVal((Object)this.racun.getIznosRacuna());
            this.cbGotovinski.setEnabled(false);
        } else {
            this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.racun.getIznosRacuna());
            this.dfGotovina.setVal((Object)this.racun.getIznosRacuna());
            this.dfPrimljeno.setVal((Object)this.racun.getIznosRacuna());
        }
        this.paintPanel();
        this.restState();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("ARHIVIRANJE");
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{23, 80, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1};
            pnlGlavniLayout.columnWidths = new int[]{32};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(390, 284));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout1 = new GridBagLayout();
            pnlFieldsLayout1.columnWeights = new double[]{0.0, 0.1, 0.0};
            int[] nArray = new int[3];
            nArray[0] = 145;
            nArray[1] = 7;
            pnlFieldsLayout1.columnWidths = nArray;
            pnlFieldsLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            pnlFieldsLayout1.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 20, 20};
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout1);
            this.pnlFields.setOpaque(false);
            this.pnlFields.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 50));
            this.lbIznosRacuna = new JLabel();
            this.pnlFields.add((Component)this.lbIznosRacuna, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbIznosRacuna.setText("Iznos racuna");
            this.lbIznosRacuna.setFont(new Font("Tahoma", 1, 11));
            this.dfIznosRacuna = new PzDoubleField();
            this.pnlFields.add((Component)this.dfIznosRacuna, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfIznosRacuna.setLimit(7, 2);
            this.dfIznosRacuna.setFocusable(false);
            this.dfIznosRacuna.setName("dfIznosRacuna");
            this.lbPlatnaKartica = new JLabel();
            this.pnlFields.add((Component)this.lbPlatnaKartica, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbPlatnaKartica.setText("Platne kartice");
            this.dfPlatnaKartica = new PzDoubleField();
            this.pnlFields.add((Component)this.dfPlatnaKartica, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfPlatnaKartica.setLimit(7, 2);
            this.dfPlatnaKartica.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    Arhiviranje.this.dfKeyPressed();
                }
            });
            this.lbCek = new JLabel();
            this.pnlFields.add((Component)this.lbCek, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbCek.setText("Cek");
            this.dfCek = new PzDoubleField();
            this.pnlFields.add((Component)this.dfCek, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfCek.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfCek.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    Arhiviranje.this.dfKeyPressed();
                }
            });
            this.lbGotovina = new JLabel();
            this.pnlFields.add((Component)this.lbGotovina, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbGotovina.setText("Gotovina");
            this.dfGotovina = new PzDoubleField();
            this.pnlFields.add((Component)this.dfGotovina, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfGotovina.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfGotovina.setFocusable(false);
            this.dfGotovina.setName("dfGotovina");
            this.lbPrimljeno = new JLabel();
            this.pnlFields.add((Component)this.lbPrimljeno, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbPrimljeno.setText("Primljeno");
            this.dfPrimljeno = new PzDoubleField();
            this.pnlFields.add((Component)this.dfPrimljeno, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfPrimljeno.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfPrimljeno.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    Arhiviranje.this.dfKusurKeyPressed();
                }
            });
            this.lbKusur = new JLabel();
            this.pnlFields.add((Component)this.lbKusur, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbKusur.setText("Kusur");
            this.lbKusur.setFont(new Font("Tahoma", 1, 11));
            this.dfKusur = new PzDoubleField();
            this.pnlFields.add((Component)this.dfKusur, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfKusur.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfKusur.setFocusable(false);
            this.dfKusur.setName("dfKusur");
            this.cbGotovinski = new JCheckBox("\u0160tampa se gotovinski ra\u010dun");
            this.cbGotovinski.setOpaque(false);
            this.cbGotovinski.setFocusable(false);
            this.pnlFields.add((Component)this.cbGotovinski, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 5, 0), 0, 0));
            this.cbSaNivelacijom = new JCheckBox("Sa nivelacijom na kol. izlaza");
            this.cbSaNivelacijom.setOpaque(false);
            this.cbSaNivelacijom.setFocusable(false);
            this.pnlFields.add((Component)this.cbSaNivelacijom, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
            this.jPanel1 = new JPanel();
            this.jPanel1.setOpaque(false);
            this.pnlGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.jPanel1.add((Component)this.btnPotvrdi);
            this.btnPotvrdi.setText("Izdaj ra\u010dun (Ctrl+W)");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/cashier1.png")));
            this.header.setTitle("Izdavanje ra\u010duna maloprodaje");
            this.header.setOpaque(false);
            this.pnlGlavni.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(437, 380);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void dfKeyPressed() {
        this.dfGotovina.setVal((Object)(this.dfIznosRacuna.getVal() - this.dfCek.getVal() - this.dfPlatnaKartica.getVal()));
        this.dfPrimljeno.setVal((Object)(this.dfIznosRacuna.getVal() - this.dfCek.getVal() - this.dfPlatnaKartica.getVal()));
    }

    private void dfKusurKeyPressed() {
        this.dfKusur.setVal((Object)(this.dfPrimljeno.getVal() + this.dfCek.getVal() + this.dfPlatnaKartica.getVal() - this.dfIznosRacuna.getVal()));
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        block23: {
            em = PzEntityManager.getEm();
            try {
                button = (PzButton)e.getSource();
                actionCommand = button.getActionCommand();
                if (!actionCommand.equals("potvrdi")) break block23;
                if (this.parameter.equals("fiskalniPrekoFakture")) {
                    em.getTransaction().begin();
                    iznos = new BigDecimal[]{this.dfPlatnaKartica.getBigDecimal(), this.dfCek.getBigDecimal(), this.dfGotovina.getBigDecimal(), this.dfPrimljeno.getBigDecimal()};
                    this.prebaciNaMaloprodajneCene(this.f);
                    if (PzKasaUtil.stampajRacun((PzDokument)this.f, false, iznos)) {
                        for (Artikalfaktura af : this.f.getArtikalfakturas()) {
                            if (af.getArtikalfakturaparameter("STAMPANO") != null) continue;
                            afp = new Artikalfakturaparameter(af, "STAMPANO", "true", "Stampano na fiskalnom stampacu");
                            em.persist((Object)afp);
                            af.addArtikalFakturaparameter(afp);
                        }
                        if (this.cbSaNivelacijom.isSelected()) {
                            this.nivelacija = PzEntityUtil.createNivelacija((PzDokument)this.f, (boolean)false, (boolean)true, (EntityManager)em);
                            if (this.nivelacija != null) {
                                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.nivelacija, true, null, em);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(null, "Registrovana je promena cene zbog cega je izradjena nivelacija broj " + Arhiviranje.this.nivelacija.getrBroj(), "Informacija", 1);
                                    }
                                });
                            }
                        }
                    }
                    em.getTransaction().commit();
                } else if (this.parameter.equals("storno")) {
                    this.racun.setGotovina(this.dfGotovina.getBigDecimal());
                    this.racun.setCekovi(this.dfCek.getBigDecimal());
                    this.racun.setKartice(this.dfPlatnaKartica.getBigDecimal());
                    this.racun.setPrimljeno(this.dfPrimljeno.getBigDecimal());
                    this.getSession().putParameter("racun", (Object)this.racun);
                    if (this.cbSaNivelacijom.isSelected()) {
                        this.getSession().putParameter("saNivelacijom", (Object)Boolean.TRUE);
                    } else {
                        this.getSession().putParameter("saNivelacijom", (Object)Boolean.FALSE);
                    }
                } else {
                    this.racun.sumirajPopust();
                    this.racun.primeniPopustNaCene();
                    this.racun.setGotovina(this.dfGotovina.getBigDecimal());
                    this.racun.setCekovi(this.dfCek.getBigDecimal());
                    this.racun.setKartice(this.dfPlatnaKartica.getBigDecimal());
                    this.racun.setPrimljeno(this.dfPrimljeno.getBigDecimal());
                    bezKase = (Boolean)this.getSession().getParameter("bez_kase");
                    if (bezKase == null) {
                        bezKase = Boolean.FALSE;
                    }
                    if (!bezKase.booleanValue()) {
                        this.arhivirajRacun(em);
                        PzKasaUtil.stampajRacun((PzDokument)this.racun, false, null);
                    } else {
                        this.racun.setPoruka("Ra\u010dun registrovan bez \u0161tampanja na fiskalnom \u0161tampa\u010du");
                        this.arhivirajRacun(em);
                    }
                }
                if (!this.parameter.equals("izradaRacuna")) ** GOTO lbl64
                if (!this.cbGotovinski.isSelected()) ** GOTO lbl58
                this.racun = StampaFakture.getRacun(this.racun, this);
                if (this.racun.getBrFiskalnogIsecka().equals("")) {
                    return;
                }
                try {
                    PzKasaUtil.showReports(this, this.racun, "rs/pezar/kasa/resource/reports/compiled/gotovinski.racun.jasper");
lbl58:
                    // 2 sources

                    em.getTransaction().begin();
                    if (!((PzDialogIzradaMaloprodajnogRacunaNew)this.getParent()).getFiskalniRacun().booleanValue()) {
                        ((PzDialogIzradaMaloprodajnogRacunaNew)this.getParent()).createFiskalniRacun(em);
                    }
                    ((PzDialogIzradaMaloprodajnogRacunaNew)this.getParent()).refreshDataTable();
                    ((PzDialogIzradaMaloprodajnogRacunaNew)this.getParent()).refreshIznos();
                    em.getTransaction().commit();
lbl64:
                    // 2 sources

                    this.dispose();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    if (e1 instanceof CRException) {
                        JOptionPane.showMessageDialog((Component)this, ((CRException)e1).getMessages(), "Gre\u0161ka", 0);
                        break block23;
                    }
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private void saveState() throws IOException {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("cbSaNivelacijom", this.cbSaNivelacijom.isSelected());
        PzApplication.getApplication().getPropManager().saveObject(m, "arh_fisk.sav");
    }

    private void restState() {
        try {
            this.stateMap = (HashMap)PzApplication.getApplication().getPropManager().loadObject("arh_fisk.sav");
        }
        catch (Exception exception) {}
        if (this.stateMap == null) {
            this.stateMap = new HashMap();
            if (this.racun.getRadnajedinica().getpTip().equals("V")) {
                this.stateMap.put("cbSaNivelacijom", false);
            } else {
                this.stateMap.put("cbSaNivelacijom", true);
            }
        }
        this.cbSaNivelacijom.setSelected((Boolean)this.stateMap.get("cbSaNivelacijom"));
    }

    private void prebaciNaMaloprodajneCene(Faktura f) {
        if (f.getDokument().getRadnajedinica().getpTip().equals("S")) {
            BigDecimal novaProdCena;
            BigDecimal stopa;
            BigDecimal cena;
            int i = 0;
            while (i < f.getArtikalDocuments().size()) {
                cena = ((PzArtikalDokument)f.getArtikalDocuments().get(i)).getProdCena();
                stopa = new BigDecimal(String.valueOf(((PzArtikalDokument)f.getArtikalDocuments().get(i)).getTaksa("PDV").getStopa()));
                novaProdCena = cena.add(cena.multiply(stopa.divide(new BigDecimal(100))));
                ((PzArtikalDokument)f.getArtikalDocuments().get(i)).setCena(novaProdCena.doubleValue());
                ++i;
            }
            i = 0;
            while (i < f.getUslugaDocuments().size()) {
                cena = new BigDecimal(String.valueOf(((PzUslugaDokument)f.getUslugaDocuments().get(i)).getCena()));
                stopa = new BigDecimal(String.valueOf(((PzUslugaDokument)f.getUslugaDocuments().get(i)).getTaksa("PDV").getStopa()));
                novaProdCena = cena.add(cena.multiply(stopa.divide(new BigDecimal(100))));
                ((PzUslugaDokument)f.getUslugaDocuments().get(i)).setCena(novaProdCena.doubleValue());
                ++i;
            }
        }
    }

    private void arhivirajRacun(EntityManager em) throws Exception {
        if (em == null) {
            em = PzEntityManagerFactory.getInstance().createEm();
        }
        try {
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            if (this.cbSaNivelacijom.isSelected()) {
                Faktura f = this.getFaktura(this.racun, em);
                this.nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)false, (boolean)true, (EntityManager)em);
                this.arhiviraj(this.nivelacija, em);
            }
            PzKasaUtil.arhivirajRacunOld(this.racun, em);
            PzKasaUtil.updateStanje(this.racun, em);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            PzLogger.getInstance().logException((Throwable)e);
            if (e instanceof OptimisticLockException) {
                int res;
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if ((res = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Gre\u0161ka prilikom unosa ra\u010duna u bazu. \u017delite da poku\u0161am ponovo?", (String)"Gre\u0161ka", null, (boolean)false)) == 0) {
                    this.arhivirajRacun(em);
                }
            }
            throw e;
        }
    }

    public Faktura getFaktura(Fiskalniracun racun, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(this.f.getRadnajedinica());
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        for (Proizvodfiskalniracun proizvod : racun.getProizvodfiskalniracuns()) {
            if (proizvod.getId().getSfrProizvod().endsWith("U")) continue;
            Artikalfaktura af = new Artikalfaktura();
            Artikal a = (Artikal)em.find(Artikal.class, (Object)proizvod.getId().getSfrProizvod());
            af.setArtikal(a);
            af.setId(1, proizvod.getId().getSfrProizvod(), 1);
            af.setKolicina(proizvod.getKolicina());
            af.setCena(proizvod.getCena());
            af.setNaziv(proizvod.getNaziv());
            af.setJm(proizvod.getJm());
            f.getArtikalfakturas().add(af);
        }
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "Registrovana je promena cene tako da \u0107e biti izra\u0111ena nivelacija.", "Informacija", 1);
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }
}

