/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtimepiece;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class JTimepiece {
    private Calendar calendar = null;

    public JTimepiece() {
        this.setCalendar(new GregorianCalendar());
    }

    public JTimepiece(Calendar calendar) {
        this.setCalendar(calendar);
    }

    public JTimepiece(Locale locale) {
        this.setCalendar(new GregorianCalendar(locale));
    }

    public JTimepiece(TimeZone timeZone) {
        this.setCalendar(new GregorianCalendar(timeZone));
    }

    public JTimepiece(TimeZone timeZone, Locale locale) {
        this.setCalendar(new GregorianCalendar(timeZone, locale));
    }

    public Date addDay(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(5, amount);
        return this.getCalendar().getTime();
    }

    public Date addHour(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(10, amount);
        return this.getCalendar().getTime();
    }

    public Date addMillisecond(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(14, amount);
        return this.getCalendar().getTime();
    }

    public Date addMinute(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(12, amount);
        return this.getCalendar().getTime();
    }

    public Date addMonth(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(2, amount);
        return this.getCalendar().getTime();
    }

    public Date addSecond(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(13, amount);
        return this.getCalendar().getTime();
    }

    public Date addYear(Date inputDate, int amount) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().add(1, amount);
        return this.getCalendar().getTime();
    }

    public String convertDateToString(Date inputDate, String dateFormat) {
        SimpleDateFormat realDateFormat = new SimpleDateFormat(dateFormat);
        String outputDate = null;
        if (inputDate != null) {
            outputDate = realDateFormat.format(inputDate);
        }
        return outputDate;
    }

    public Date convertStringToDate(String inputDate, String dateFormat) {
        SimpleDateFormat realDateFormat = new SimpleDateFormat(dateFormat);
        Date outputDate = null;
        String newString = null;
        if (inputDate != null && !(newString = this.convertDateToString(outputDate = realDateFormat.parse(inputDate, new ParsePosition(0)), dateFormat)).equals(inputDate)) {
            IllegalArgumentException exception = new IllegalArgumentException("Data in string is not a valid date.");
            throw exception;
        }
        return outputDate;
    }

    public Date createDate(int inputYear, int inputMonth, int inputDay) {
        this.getCalendar().clear();
        this.getCalendar().set(inputYear, inputMonth, inputDay);
        return this.getCalendar().getTime();
    }

    public Date createDate(int inputYear, int inputMonth, int inputDay, int inputHour, int inputMinute, int inputSecond) {
        this.getCalendar().clear();
        this.getCalendar().set(inputYear, inputMonth, inputDay, inputHour, inputMinute, inputSecond);
        return this.getCalendar().getTime();
    }

    public Date createDate(int inputYear, int inputMonth, int inputDay, int inputHour, int inputMinute, int inputSecond, int inputMillisecond) {
        this.getCalendar().clear();
        this.getCalendar().set(inputYear, inputMonth, inputDay, inputHour, inputMinute, inputSecond);
        this.getCalendar().set(14, inputMillisecond);
        return this.getCalendar().getTime();
    }

    private Calendar getCalendar() {
        return this.calendar;
    }

    public int getCalendarDaysAfter(Date date1, Date date2) {
        Date newDate1 = this.createDate(this.getYear(date1), this.getMonth(date1), this.getDayOfMonth(date1));
        Date newDate2 = this.createDate(this.getYear(date2), this.getMonth(date2), this.getDayOfMonth(date2));
        int daysAfter = new Double(this.getDaysAfter(newDate1, newDate2)).intValue();
        return daysAfter;
    }

    public int getCalendarMonthsAfter(Date date1, Date date2) {
        int month1 = this.getMonth(date1);
        int month2 = this.getMonth(date2);
        int year1 = this.getYear(date1);
        int year2 = this.getYear(date2);
        int difference = 0;
        if (year1 == year2) {
            difference = month2 - month1;
        } else if (year1 < year2) {
            int yearCtr = year2 - 1;
            difference = month2;
            while (yearCtr > year1) {
                difference += 12;
                --yearCtr;
            }
            difference = difference + 12 - month1;
        } else if (year1 > year2) {
            int yearCtr = year1 - 1;
            difference = month1;
            while (yearCtr > year2) {
                difference += 12;
                --yearCtr;
            }
            difference = difference + 12 - month2;
            difference *= -1;
        }
        return difference;
    }

    public int getCalendarYearsAfter(Date date1, Date date2) {
        int year1 = this.getYear(date1);
        int year2 = this.getYear(date2);
        int difference = year2 - year1;
        return difference;
    }

    public Date getCurrentDate() {
        GregorianCalendar _calendar = new GregorianCalendar();
        return _calendar.getTime();
    }

    public String getDayAbrv(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE");
        String dayAbrv = dateFormat.format(inputDate);
        return dayAbrv;
    }

    public String getDayName(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE");
        String dayName = dateFormat.format(inputDate);
        return dayName;
    }

    public int getDayOfMonth(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(5);
    }

    public int getDayOfWeek(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(7);
    }

    public int getDayOfYear(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(6);
    }

    public double getDaysAfter(Date date1, Date date2) {
        double amount1 = date1.getTime();
        double amount2 = date2.getTime();
        double difference = (amount2 - amount1) / 8.64E7;
        return difference;
    }

    public int getFirstDayOfWeek(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().getFirstDayOfWeek();
    }

    public int getHour(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(10);
    }

    public int getHourOfDay(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(11);
    }

    public double getHoursAfter(Date date1, Date date2) {
        double amount1 = date1.getTime();
        double amount2 = date2.getTime();
        double difference = (amount2 - amount1) / 3600000.0;
        return difference;
    }

    public Date getLastDateOfMonth(Date inputDate) {
        Date nextMonthDate = this.addMonth(inputDate, 1);
        this.getCalendar().setTime(nextMonthDate);
        this.getCalendar().set(5, 1);
        Date lastDayOfMonth = this.addDay(this.getCalendar().getTime(), -1);
        return lastDayOfMonth;
    }

    public int getMillisecond(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(14);
    }

    public long getMillisecondsAfter(Date date1, Date date2) {
        long amount1 = date1.getTime();
        long amount2 = date2.getTime();
        long difference = amount2 - amount1;
        return difference;
    }

    public int getMinute(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(12);
    }

    public double getMinutesAfter(Date date1, Date date2) {
        double amount1 = date1.getTime();
        double amount2 = date2.getTime();
        double difference = (amount2 - amount1) / 60000.0;
        return difference;
    }

    public int getMonth(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(2);
    }

    public String getMonthAbrv(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM");
        String monthAbrv = dateFormat.format(inputDate);
        return monthAbrv;
    }

    public String getMonthName(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM");
        String monthName = dateFormat.format(inputDate);
        return monthName;
    }

    public int getSecond(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(13);
    }

    public double getSecondsAfter(Date date1, Date date2) {
        double amount1 = date1.getTime();
        double amount2 = date2.getTime();
        double difference = (amount2 - amount1) / 1000.0;
        return difference;
    }

    public int getTimeZoneOffset(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(15);
    }

    public int getWeekOfMonth(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(4);
    }

    public int getWeekOfYear(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(3);
    }

    public int getYear(Date inputDate) {
        this.getCalendar().setTime(inputDate);
        return this.getCalendar().get(1);
    }

    public boolean isAfter(Date date1, Date date2) {
        boolean rtnValue = false;
        if (date1.getTime() > date2.getTime()) {
            rtnValue = true;
        }
        return rtnValue;
    }

    public boolean isAM(Date inputDate) {
        boolean rtnValue;
        this.getCalendar().setTime(inputDate);
        switch (this.getCalendar().get(9)) {
            case 0: {
                rtnValue = true;
                break;
            }
            default: {
                rtnValue = false;
            }
        }
        return rtnValue;
    }

    public boolean isBefore(Date date1, Date date2) {
        boolean rtnValue = false;
        if (date1.getTime() < date2.getTime()) {
            rtnValue = true;
        }
        return rtnValue;
    }

    public boolean isEqualTo(Date date1, Date date2) {
        boolean rtnValue = false;
        if (date1.getTime() == date2.getTime()) {
            rtnValue = true;
        }
        return rtnValue;
    }

    public boolean isLeapYear(Date inputDate) {
        boolean rtnValue = false;
        this.getCalendar().setTime(inputDate);
        rtnValue = ((GregorianCalendar)this.getCalendar()).isLeapYear(this.getYear(inputDate));
        return rtnValue;
    }

    public boolean isPM(Date inputDate) {
        boolean rtnValue;
        this.getCalendar().setTime(inputDate);
        switch (this.getCalendar().get(9)) {
            case 1: {
                rtnValue = true;
                break;
            }
            default: {
                rtnValue = false;
            }
        }
        return rtnValue;
    }

    private void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Date setDayOfMonth(Date inputDate, int dayOfMonth) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(5, dayOfMonth);
        return this.getCalendar().getTime();
    }

    public Date setDayOfWeek(Date inputDate, int dayOfWeek) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(7, dayOfWeek);
        return this.getCalendar().getTime();
    }

    public Date setDayOfYear(Date inputDate, int dayOfYear) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(6, dayOfYear);
        return this.getCalendar().getTime();
    }

    public Date setHour(Date inputDate, int hour) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(10, hour);
        return this.getCalendar().getTime();
    }

    public Date setHourOfDay(Date inputDate, int hourOfDay) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(11, hourOfDay);
        return this.getCalendar().getTime();
    }

    public Date setMillisecond(Date inputDate, int millisecond) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(14, millisecond);
        return this.getCalendar().getTime();
    }

    public Date setMinute(Date inputDate, int minute) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(12, minute);
        return this.getCalendar().getTime();
    }

    public Date setMonth(Date inputDate, int month) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(2, month);
        return this.getCalendar().getTime();
    }

    public Date setSecond(Date inputDate, int second) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(13, second);
        return this.getCalendar().getTime();
    }

    public Date setWeekOfMonth(Date inputDate, int weekOfMonth) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(4, weekOfMonth);
        return this.getCalendar().getTime();
    }

    public Date setWeekOfYear(Date inputDate, int weekOfYear) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(3, weekOfYear);
        return this.getCalendar().getTime();
    }

    public Date setYear(Date inputDate, int year) {
        this.getCalendar().setTime(inputDate);
        this.getCalendar().set(1, year);
        return this.getCalendar().getTime();
    }
}

