/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.bill;

import java.util.HashMap;
import rs.pezar.kasa.bill.MetalinkBillHeader;
import rs.pezar.msg.device.cashregister.data.Article;

public class MetalinkArticle {
    static HashMap<String, String> taxRates = new HashMap();

    static {
        taxRates.put("A", "0");
        taxRates.put("G", "1");
        taxRates.put("D", "2");
        taxRates.put("d", "3");
        taxRates.put("E", "4");
        taxRates.put("Z", "5");
        taxRates.put("I", "6");
        taxRates.put("J", "7");
        taxRates.put("K", "8");
    }

    public static String getMetalinkArticle(Article article) throws Exception {
        String temp = "";
        String code = article.getSifra();
        String taxRate = taxRates.get(String.valueOf(article.getTaxRate()));
        String name = String.valueOf(article.getSifra()) + " " + article.getName();
        String price = String.valueOf(article.getPrice());
        String quantity = String.valueOf(article.getQuantity());
        if (taxRate == null || taxRate.length() == 0) {
            throw new Exception("Artikal " + code + " nema podesenu stopu poreza.");
        }
        if (name == null || name.length() == 0) {
            throw new Exception("Artikal " + code + " ne moze imati prazan naziv.");
        }
        if (price == null) {
            throw new Exception("Artikal " + code + " nema definisanu cenu.");
        }
        if (quantity == null || quantity.equals("0")) {
            throw new Exception("Artikal " + code + " ne moze imati cenu 0 ili cena nije definisana.");
        }
        if (code == null || code.length() == 0) {
            throw new Exception("Na racunu je detektovan artikal sa nedefinisanom sifrom.");
        }
        name = name.replaceAll("\u00c5\u00a0", "S");
        name = name.replaceAll("\u00c5\u00a1", "s");
        name = name.replaceAll("\u00c4\u2018", "d");
        name = name.replaceAll("\u00c4\ufffd", "D");
        name = name.replaceAll("\u00c5\u00be", "z");
        name = name.replaceAll("\u00c5\u00bd", "Z");
        name = name.replaceAll("\u00c4\ufffd", "c");
        name = name.replaceAll("\u00c4\u0152", "C");
        name = name.replaceAll("\u00c4\u2021", "c");
        name = name.replaceAll("\u00c4\u2020", "C");
        name = name.replaceAll(",", " ");
        name = name.replaceAll("'", " ");
        name = name.replaceAll("\"", " ");
        name = name.replaceAll("`", " ");
        temp = String.valueOf(temp) + MetalinkBillHeader.ART_ID + "=\"" + code + "\" ";
        temp = String.valueOf(temp) + MetalinkBillHeader.TAX_ID + "=\"" + taxRate + "\" ";
        temp = String.valueOf(temp) + MetalinkBillHeader.PLU_NAZIV + "=\"" + name + "\" ";
        temp = String.valueOf(temp) + MetalinkBillHeader.CENA + "=\"" + price + "\" ";
        temp = String.valueOf(temp) + MetalinkBillHeader.KOLICINA + "=\"" + quantity + "\" ";
        temp = "<ROW " + temp + " /> ";
        return temp;
    }
}

