/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.util.HashMap;
import java.util.Vector;
import rs.pezar.kasa.Transformer.MetalinkTransformer;
import rs.pezar.kasa.putGetEngine.DataGetter;
import rs.pezar.kasa.putGetEngine.PutGetEngine;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegisterControlInterface;

public class Metalink {
    public static final String BILL_TYPE = "BILL_TYPE";
    public static final String CONTROL_TYPE = "CONTROL_TYPE";
    public static final String REQUIRED_VERSION = "ver7.4-Final-2009";
    private PutGetEngine putGetEngine;

    public Metalink(HashMap<String, String> params) {
        this.putGetEngine = new PutGetEngine(params);
    }

    public HashMap<String, String> runWithTheBill(DeviceDataInterface data) {
        Vector returnData = new Vector();
        HashMap<Object, Object> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        try {
            if (bill.isPreBill()) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Nije dozvoljeno stampanje predracuna.");
            } else {
                String metalinkBill = MetalinkTransformer.transform(data);
                System.out.println(metalinkBill);
                restemp = this.putGetEngine.putGet(metalinkBill, BILL_TYPE);
                result = this.formatReturnedData(restemp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("MESSAGE", e.getMessage());
            result.put("CODE", "ERROR");
        }
        if (result.get("CODE") == null) {
            result.put("CODE", "SUCCESS");
            int i = 0;
            while (i < returnData.size()) {
                result.put("MESSAGE", (String)returnData.elementAt(i));
                ++i;
            }
        }
        String error1 = restemp.get(DataGetter.INFO_COMM_ERROR) == null ? "" : restemp.get(DataGetter.INFO_COMM_ERROR);
        String error2 = restemp.get(DataGetter.INFO_NOPAPER) == null ? "" : restemp.get(DataGetter.INFO_NOPAPER);
        result.put("INFO", "L|" + error1 + ";" + error2);
        return result;
    }

    public HashMap<String, String> runWithTheControl(DeviceDataInterface data) {
        HashMap<Object, Object> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        CashRegisterControl cntrl = (CashRegisterControl)data.getData();
        try {
            String tempControl = MetalinkTransformer.transform((CashRegisterControlInterface)cntrl);
            System.out.println(tempControl);
            restemp = this.putGetEngine.putGet(tempControl, CONTROL_TYPE);
            result = this.formatReturnedData(restemp);
        }
        catch (Exception e) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", e.getMessage());
        }
        String info = "L|OK.";
        info = String.valueOf(info) + (String)result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    private HashMap<String, String> formatReturnedData(HashMap<String, String> returnedData) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (returnedData.containsKey(DataGetter.INFO_COMM_ERROR) || returnedData.containsKey(DataGetter.INFO_ERROR)) {
            String error1 = returnedData.get(DataGetter.INFO_COMM_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_COMM_ERROR);
            String error3 = returnedData.get(DataGetter.INFO_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_ERROR);
            result.put("CODE", "ERROR");
            result.put("MESSAGE", error1 + "." + error3);
        }
        if (returnedData.containsKey(DataGetter.INFO_OK)) {
            String message = returnedData.get(DataGetter.INFO_OK);
            result.put("CODE", "SUCCESS");
            result.put("MESSAGE", message);
        }
        if (returnedData.containsKey(DataGetter.INFO_NOPAPER)) {
            String error2 = returnedData.get(DataGetter.INFO_NOPAPER) == null ? "" : returnedData.get(DataGetter.INFO_NOPAPER);
            result.put("INFO", error2);
        }
        if (returnedData.size() == 0) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", "Metalink ne vraca podatke, proverite da li ste upalili Metalink i dobro podesili foldere za komunikaciju sa njim. Za podesavanje pogledajte uputstvo za metalink!");
        }
        return result;
    }
}

