/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui.frames.galeb.fp550;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import rs.pezar.kasa.FP550Driver;
import rs.pezar.kasa.commPortHandler.Fp550Port;
import rs.pezar.kasa.util.OSTool;
import rs.pezar.msg.device.interfaces.FsmListener;

public class PzSetupPanel
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel pnlSve;
    private JLabel lblPort;
    private JButton btnGotovo;
    private JComboBox cmbBrzina;
    private JComboBox cmbPort;
    private JLabel lblBrzina;
    private JPanel pnlStampac;
    Vector<String> portList;
    private static HashMap<String, String> map;
    private static boolean odustani;
    private static PzSetupPanel panel;
    private JLabel lblNewLabel;
    private JLabel lblPezar;
    private JLabel lblSpregaZaRad;
    private JLabel lblFpFiskalniPrinter;
    private JLabel lblFwsr;
    private JLabel lblCopyrightTetrabyteDoo;
    private JLabel lblWwwtetrabyters;
    private JLabel lblInstaliran;
    private FP550Driver driver;
    private FsmListener fsmListener;
    private Boolean driverInit;
    private JLabel lblInstaliranOsIcon;
    private JButton btnDetektuj;
    private String databasePath;
    private Boolean instaliran;

    static {
        odustani = false;
    }

    public PzSetupPanel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.driverInit = false;
        this.instaliran = false;
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PzSetupPanel.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_24.png")));
        try {
            if (!Fp550Port.isInstalled()) {
                Fp550Port.install((JDialog)this);
            } else {
                this.instaliran = true;
            }
        }
        catch (Exception e) {
            this.instaliran = false;
            JOptionPane.showMessageDialog(this, "Instalacija drivera neuspesna. " + e.getMessage(), "Greska", 0);
            e.printStackTrace();
        }
        this.portList = Fp550Port.getAvailablePortNames();
        this.initGUI();
    }

    public PzSetupPanel(JDialog parent, Boolean driverInit) {
        super(parent);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.driverInit = false;
        this.instaliran = false;
        this.driverInit = driverInit;
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PzSetupPanel.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_24.png")));
        try {
            if (!Fp550Port.isInstalled()) {
                Fp550Port.install();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Instalacija drivera neuspesna. " + e.getMessage(), "Greska", 0);
            e.printStackTrace();
        }
        this.portList = Fp550Port.getAvailablePortNames();
        this.initGUI();
    }

    public PzSetupPanel(JDialog parent) {
        super(parent);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.driverInit = false;
        this.instaliran = false;
        this.portList = Fp550Port.getAvailablePortNames();
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setResizable(false);
            this.setTitle("Pezar FP550 sprega");
            this.setPreferredSize(new Dimension(440, 473));
            this.pnlSve = new JPanel();
            this.getContentPane().add((Component)this.pnlSve, "Center");
            this.pnlSve.setLayout(null);
            this.pnlSve.setPreferredSize(new Dimension(238, 227));
            this.pnlStampac = new JPanel();
            this.pnlStampac.setLayout(null);
            this.pnlSve.add(this.pnlStampac);
            this.pnlStampac.setBounds(10, 226, 367, 92);
            this.pnlStampac.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Parametri konekcije", 1, 2, null, new Color(0, 0, 0)));
            this.lblPort = new JLabel();
            this.lblPort.setHorizontalAlignment(4);
            this.pnlStampac.add(this.lblPort);
            this.lblPort.setText("Port:");
            this.lblPort.setBounds(10, 24, 83, 14);
            this.lblBrzina = new JLabel();
            this.lblBrzina.setHorizontalAlignment(4);
            this.pnlStampac.add(this.lblBrzina);
            this.lblBrzina.setText("Brzina:");
            this.lblBrzina.setBounds(10, 52, 83, 14);
            DefaultComboBoxModel<String> cmbPortModel = new DefaultComboBoxModel<String>(this.portList);
            this.cmbPort = new JComboBox();
            this.pnlStampac.add(this.cmbPort);
            this.cmbPort.setModel(cmbPortModel);
            this.cmbPort.setBounds(103, 21, 145, 21);
            DefaultComboBoxModel<String> cmbBrzinaModel = new DefaultComboBoxModel<String>(new String[]{"19200"});
            this.cmbBrzina = new JComboBox();
            this.pnlStampac.add(this.cmbBrzina);
            this.cmbBrzina.setModel(cmbBrzinaModel);
            this.cmbBrzina.setBounds(103, 49, 145, 21);
            this.btnDetektuj = new JButton("Detektuj!");
            this.btnDetektuj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
            this.btnDetektuj.setBounds(258, 24, 89, 48);
            this.btnDetektuj.addActionListener(this);
            this.pnlStampac.add(this.btnDetektuj);
            this.btnGotovo = new JButton();
            this.pnlSve.add(this.btnGotovo);
            this.btnGotovo.setText("Podesi");
            this.btnGotovo.setBounds(142, 329, 101, 32);
            this.lblNewLabel = new JLabel("");
            this.lblNewLabel.setIcon(new ImageIcon(PzSetupPanel.class.getResource("/rs/pezar/kasa/resource/fp550icons/galebpf550_128.png")));
            this.lblNewLabel.setBounds(10, 0, 136, 141);
            this.pnlSve.add(this.lblNewLabel);
            this.lblPezar = new JLabel("Pezar");
            this.lblPezar.setFont(new Font("Tahoma", 1, 16));
            this.lblPezar.setHorizontalAlignment(0);
            this.lblPezar.setBounds(156, 11, 211, 20);
            this.pnlSve.add(this.lblPezar);
            this.lblSpregaZaRad = new JLabel("sprega za rad sa uredjajem");
            this.lblSpregaZaRad.setHorizontalAlignment(0);
            this.lblSpregaZaRad.setBounds(156, 32, 211, 14);
            this.pnlSve.add(this.lblSpregaZaRad);
            this.lblFpFiskalniPrinter = new JLabel("FP550 fiskalni printer");
            this.lblFpFiskalniPrinter.setFont(new Font("Tahoma", 1, 18));
            this.lblFpFiskalniPrinter.setHorizontalAlignment(0);
            this.lblFpFiskalniPrinter.setBounds(156, 57, 211, 20);
            this.pnlSve.add(this.lblFpFiskalniPrinter);
            this.lblFwsr = new JLabel("SW: 2.2 - 1.5SR FW: 1.5-SR");
            this.lblFwsr.setFont(new Font("Tahoma", 1, 11));
            this.lblFwsr.setHorizontalAlignment(0);
            this.lblFwsr.setBounds(156, 83, 211, 14);
            this.pnlSve.add(this.lblFwsr);
            this.lblCopyrightTetrabyteDoo = new JLabel("Copyright TETRABYTE DOO");
            this.lblCopyrightTetrabyteDoo.setHorizontalAlignment(0);
            this.lblCopyrightTetrabyteDoo.setBounds(156, 108, 211, 14);
            this.pnlSve.add(this.lblCopyrightTetrabyteDoo);
            this.lblWwwtetrabyters = new JLabel("www.tetrabyte.rs");
            this.lblWwwtetrabyters.setHorizontalAlignment(0);
            this.lblWwwtetrabyters.setBounds(156, 121, 211, 14);
            this.pnlSve.add(this.lblWwwtetrabyters);
            String instaliran = "";
            String ico = "";
            try {
                if (this.isDriverInstalled()) {
                    if (OSTool.isWindows()) {
                        instaliran = "Sprega je instalirana. Windows verzija.";
                        ico = "/rs/pezar/kasa/res/osLogo/logoWin3.png";
                    } else if (OSTool.isUnix()) {
                        instaliran = "Sprega je instalirana. Linux verzija.";
                        ico = "/rs/pezar/kasa/res/osLogo/logoLin4.png";
                    }
                } else {
                    instaliran = "Sprega nije instalirana.";
                }
            }
            catch (Exception exception) {}
            this.lblInstaliran = new JLabel(instaliran);
            this.lblInstaliran.setHorizontalTextPosition(10);
            this.lblInstaliran.setHorizontalAlignment(0);
            this.lblInstaliran.setBounds(10, 205, 367, 20);
            this.pnlSve.add(this.lblInstaliran);
            this.lblInstaliranOsIcon = new JLabel("");
            this.lblInstaliranOsIcon.setHorizontalAlignment(0);
            this.lblInstaliranOsIcon.setBounds(10, 143, 367, 65);
            this.lblInstaliranOsIcon.setIcon(new ImageIcon(PzSetupPanel.class.getResource(ico)));
            this.pnlSve.add(this.lblInstaliranOsIcon);
            this.btnGotovo.addActionListener(this);
            this.setSize(393, 400);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.btnGotovo)) {
            this.onGotovoPressed();
        } else if (arg0.getSource().equals(this.btnDetektuj)) {
            this.onDetektujPressed();
        }
    }

    private void onDetektujPressed() {
        HashMap<String, String> ports = Fp550Port.probeDevice();
        if (ports != null) {
            JOptionPane.showMessageDialog(this, "Printer detektovan na portu: " + ports.get("PORT"), "Detektovan!", 1);
            this.cmbPort.setSelectedItem(ports.get("PORT"));
        } else {
            JOptionPane.showMessageDialog(this, "Printer nije detektovan", "Nije detektovan!", 0);
        }
    }

    private void onOdustaniPressed() {
        odustani = true;
        this.dispose();
    }

    private void onGotovoPressed() {
        map = new HashMap();
        map.put("BAUD", this.cmbBrzina.getModel().getSelectedItem().toString());
        map.put("PORT", this.cmbPort.getModel().getSelectedItem().toString());
        map.put("LOG", "ERRORS");
        if (this.driverInit.booleanValue()) {
            try {
                this.onPoveziPressed();
            }
            catch (Exception e) {
                if (this.driver != null) {
                    this.driver.stopDriver();
                }
                JOptionPane.showMessageDialog(this, e.getMessage(), "Greska", 0);
                return;
            }
        }
        this.dispose();
    }

    public FsmListener getFsmListener() {
        return this.fsmListener;
    }

    private void onPoveziPressed() throws NumberFormatException, Exception {
        this.driver = new FP550Driver(map, this.fsmListener);
        this.driver.setDatabasePath(this.databasePath);
        this.driver.runDriver();
    }

    public static HashMap<String, String> getParams() {
        panel = new PzSetupPanel();
        panel.setModal(true);
        panel.setVisible(true);
        return map;
    }

    public static FP550Driver getFp550Driver(JDialog parent, String databasePath) {
        panel = new PzSetupPanel(parent, (Boolean)true);
        PzSetupPanel.panel.databasePath = databasePath;
        panel.setModal(true);
        panel.setVisible(true);
        return PzSetupPanel.panel.driver;
    }

    public static HashMap<String, String> getParams(JDialog parent) {
        panel = new PzSetupPanel(parent);
        panel.setModal(true);
        panel.setVisible(true);
        return map;
    }

    public boolean isDriverInstalled() throws Exception {
        return this.instaliran;
    }

    public static void main(String[] args) {
        File f = new File(String.valueOf(System.getProperties().getProperty("java.home")) + "\\lib\\ext\\RXTXcomm.jar");
        File f1 = new File(String.valueOf(System.getProperties().getProperty("java.home")) + "\\bin\\rxtxSerial.dll");
        if (f.exists() && f1.exists()) {
            System.out.println("Sprega instalirana");
        } else {
            System.out.println("Sprega nije instalirana");
        }
    }
}

