/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import rs.pezar.kasa.cashregister.CashRegisterControl;
import rs.pezar.kasa.cashregister.CashRegisterProtocol;
import rs.pezar.kasa.cashregister.DatecsProtocol;
import rs.pezar.kasa.cashregister.galeb.fp550.FP550Control;
import rs.pezar.kasa.commPortHandler.Fp550Port;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.databaseEngine.DatabaseEngine;
import rs.pezar.kasa.databaseEngine.exception.FiscalBaseException;
import rs.pezar.kasa.fsm.CashRegisterFSM;
import rs.pezar.kasa.gui.frames.galeb.fp550.PzSetupPanel;
import rs.pezar.kasa.messages.Messages;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.FsmListener;
import rs.pezar.msg.device.interfaces.cashRegister.ArticleInterface;
import rs.pezar.msg.device.interfaces.cashRegister.BillInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegister;

public class FP550Driver
implements CashRegister {
    public static final String DRIVER_VERSION = "2.2 - 1.5SR";
    public static final String REQUIRED_FIRMWARE = "1.5;2.0";
    public static final char CLOSURE_TAX_AMOUNTS = '0';
    public static final char CLOSURE_NETO_TAX_AMOUNTS = '1';
    public static final char CLOSURE_SUM_TAX_AMOUNTS = '2';
    public static final char CLOSURE_TAX_RATES = '3';
    public static final char CLOSURE_PEROD_TAX_RATES = '4';
    public static final char CLOSURE_PERIOD_NETO_TAX_RATES = '5';
    public static final char CLOSURE_PERIOD_SUM_TAX_AMOUNT = '6';
    public static final char PAY_METHOD_CASH = 'P';
    public static final char PAY_METHOD_CHECK = 'C';
    public static final char PAY_METHOD_CARD = 'D';
    public static final String BASE_NAME = "fp550db";
    public static final String WORKING_SUBFOLDER = "\\device\\fp550";
    public static final String LOG_SUBFOLDER = "\\device\\fp550\\log";
    private FP550Control control;
    private CashRegisterFSM cashRegisterFSM;
    private FsmListener cashRegisterReportListener;
    private CashRegisterBill bill;
    private Vector<String> result;
    private Vector<String> errors;
    private Vector<String> infos;
    private static boolean notReturningAnswer = false;
    private static Semaphore testSemaphore;
    private HashMap<String, String> params;
    String databasePath = null;
    private DatabaseEngine databaseEngine;
    private Integer tempCounter = 0;
    private Random random = new Random();
    private String deviceId;

    public FP550Driver(HashMap<String, String> params, FsmListener fsmListener) throws Exception {
        this.control = new FP550Control();
        HashMap<String, Object> portParams = new HashMap<String, Object>();
        portParams.put("BAUD", Integer.parseInt(params.get("BAUD")));
        portParams.put("PARITY", 0);
        portParams.put("DATA_BITS", 8);
        portParams.put("STOP_BITS", 1);
        portParams.put("PORT_NAME", params.get("PORT"));
        this.cashRegisterFSM = new CashRegisterFSM((CashRegisterControl)this.control, (DevicePort)new Fp550Port(portParams), params);
        this.cashRegisterReportListener = fsmListener;
    }

    public FP550Driver() {
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public boolean initDriver(HashMap<String, String> params) {
        this.control = new FP550Control();
        this.params = params == null || params.get("PORT") == null || params.get("BAUD") == null ? PzSetupPanel.getParams() : params;
        if (this.params == null) {
            return false;
        }
        HashMap<String, Object> portParams = new HashMap<String, Object>();
        portParams.put("BAUD", Integer.parseInt(this.params.get("BAUD")));
        portParams.put("PARITY", 0);
        portParams.put("DATA_BITS", 8);
        portParams.put("STOP_BITS", 1);
        portParams.put("PORT_NAME", this.params.get("PORT"));
        this.cashRegisterFSM = new CashRegisterFSM((CashRegisterControl)this.control, (DevicePort)new Fp550Port(portParams), this.params);
        this.cashRegisterReportListener = null;
        return true;
    }

    public void addInfoListener(ActionListener fsmListener) {
        this.cashRegisterReportListener = (FsmListener)fsmListener;
    }

    public String testDriver() throws Exception {
        Vector<String> results = this.InfoFiscalTransactionStatus();
        String[] returnedParameters = results.get(0).split(",");
        String amountStr = String.valueOf(returnedParameters[2].substring(0, 8)) + "." + returnedParameters[2].substring(8, 10);
        BigDecimal amount = new BigDecimal(amountStr);
        if (returnedParameters[0].equals("1")) {
            if (this.checkForInfo(DatecsProtocol.INFO_FISCAL_BILL_OPEN)) {
                try {
                    this.BillTotal('D', amount);
                    this.BillTotal('P', amount);
                    this.BillTotal('C', amount);
                }
                catch (Exception exception) {}
                this.BillClose();
            }
            if (this.checkForInfo(DatecsProtocol.INFO_TEXT_BILL_OPEN)) {
                this.CloseText();
            }
        }
        String frver = this.getFirmwareVer();
        String[] rfrver = REQUIRED_FIRMWARE.split(";");
        boolean passed = false;
        int i = 0;
        while (i < rfrver.length) {
            if (frver.contains(rfrver[i])) {
                passed = true;
                break;
            }
            ++i;
        }
        if (!passed) {
            throw new Exception("Potrebna verzija firmware-a fiskalnog uradjaja je:" + REQUIRED_FIRMWARE.replace(";", " ili ") + " dok je trenutna: " + frver);
        }
        return results.get(0);
    }

    public Vector<String> CloseText() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlCloseText()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public void setDatabasePath(String path) {
        this.databasePath = path;
    }

    public void runDriver() throws Exception {
        this.databaseEngine = new DatabaseEngine(this.databasePath, WORKING_SUBFOLDER, BASE_NAME);
        this.cashRegisterFSM.setLogResource(String.valueOf(this.databasePath) + LOG_SUBFOLDER, Byte.valueOf((byte)17));
        this.cashRegisterFSM.start();
        Vector<String> info = null;
        try {
            info = this.InfoDiagnose();
        }
        catch (Exception e1) {
            this.deviceId = "Uredjaj nije konektovan";
            e1.printStackTrace();
        }
        if (info != null) {
            String[] info1 = info.get(0).split(",");
            this.deviceId = info1[4].substring(2);
        }
        this.databaseEngine.createDatabase();
        this.tempCounter = this.databaseEngine.getMaxTemp();
        this.tempCounter = this.tempCounter + 1;
        this.testDriver();
        try {
            this.CheckDriverIntegrity();
        }
        catch (Exception e) {
            Vector<String> text = new Vector<String>();
            text.add("Detektovana desinhronizacija!");
            text.add("Pozeljno je uraditi brisanje");
            text.add("artikala iz baze stampaca na");
            text.add("kraju dana.");
            this.PrintText(text);
            e.printStackTrace();
        }
        this.testDriver();
    }

    public void stopDriver() {
        this.cashRegisterFSM.stop();
    }

    public CashRegisterProtocol GetProtocol() {
        return this.control.GetProtocol();
    }

    public Vector<String> ArticleChangePrice(int itemCode, BigDecimal newPrice) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemSetNewPrice(itemCode, newPrice)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    private Vector<String> getResults(Messages msg) throws Exception {
        this.result = msg.ReturnMessageText();
        this.errors = msg.ReturnErrors();
        this.infos = msg.ReturnInfos();
        if (this.cashRegisterReportListener != null) {
            this.cashRegisterReportListener.onInfo(this.infos);
        }
        if (this.errors != null && this.errors.size() != 0) {
            String message = "";
            int i = 0;
            while (i < this.errors.size()) {
                message = String.valueOf(message) + this.errors.get(i) + "\n";
                ++i;
            }
            throw new Exception(message);
        }
        return this.result;
    }

    private boolean checkForInfo(String info) {
        for (String inf : this.infos) {
            if (!inf.contains(info)) continue;
            return true;
        }
        return false;
    }

    public void CheckDriverIntegrity() throws Exception {
        Integer numofRows = this.databaseEngine.getNumberOfRows();
        Integer noofart = this.GetNumberOfProgrammedArticles();
        System.out.println("Broj redova u bazi: " + numofRows + "\nBroj artikala u stampacu: " + noofart);
        if (numofRows + 1 != noofart && (numofRows != 0 || noofart != 0)) {
            throw new Exception("Driver je detektovao desinhronizaciju medju podacima u stampacu i podacima u fiskalnoj bazi na ovom racunaru. Morate isprazniti sve artikle iz stampaca i baze.");
        }
    }

    public Vector<String> ArticleDefine(int itemcode, char itemTaxGroup, BigDecimal price, String itemName, String unit) throws Exception {
        String command = new String(this.control.ControlItemSet(itemcode, itemTaxGroup, price, itemName, unit), "cp1252");
        this.cashRegisterFSM.AddToCommandList(command);
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> ArticleErase(int articleCode) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemDelete(articleCode)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> ArticleGetFirstUnusedNumber() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemGetFirstUnused()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> ArticleEraseAll() throws Exception {
        Vector<String> result = new Vector<String>();
        String results = "";
        Integer noofart = this.GetNumberOfProgrammedArticles();
        if (noofart == 1 || noofart == 0) {
            result.add("P");
            this.dropDatabase();
            return result;
        }
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemGetFirst()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        String first = this.getResults(msg).get(0);
        String[] temp = first.split(",");
        if (temp[0].equals("P")) {
            results = String.valueOf(results) + first + ",";
            this.ArticleErase(Integer.parseInt(temp[1]));
            this.databaseEngine.deletePluRecord(temp[1]);
        }
        Vector<String> res = null;
        Integer pos = 0;
        try {
            while (true) {
                this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemGetFirst()));
                this.cashRegisterFSM.ExecuteCommand();
                String other = this.getResults(msg).get(0);
                temp = other.split(",");
                if (temp[0].equals("P")) {
                    results = String.valueOf(results) + first + ",";
                    res = this.ArticleErase(Integer.parseInt(temp[1]));
                    this.databaseEngine.deletePluRecord(temp[1]);
                }
                pos = pos + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Pozicija na kojoj je izbacio:" + pos);
            this.databaseEngine.dropDatabase();
            System.out.println((String)res.get(0));
            System.out.println("Done");
            result.add(results);
            return result;
        }
    }

    public Vector<String> ArticleImportList() throws Exception {
        return null;
    }

    public Vector<String> ArticleNumber(int artNumber) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemGet(artNumber)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> GetArticlesFromFP() throws Exception {
        String art = null;
        Vector<String> result = new Vector<String>();
        int i = 1;
        while (i < 65023) {
            art = this.ArticleNumber(i).get(0);
            result.add(art);
            ++i;
        }
        return result;
    }

    public Vector<String> Beep() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlBeep()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> BillAddArticleAndShowOnDisplay(char sign, int itemCode, BigDecimal quan) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlRegisterSellingsWithDisplay(sign, itemCode, quan)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> BillAddArticleWithoutShowingOnDisplay(char sign, int itemCode, BigDecimal quan) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlRegisterSellingsWithoutDisplay(sign, itemCode, quan)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> BillOpen(String operaterCode, String operatorPassword, String cashRegisterNumber) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlOpenBill(operaterCode, operatorPassword, cashRegisterNumber)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> BillShowCurrentSum() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlCheckSum()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> BillTotal(char paymentMode, BigDecimal amount) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlPayRegister(paymentMode, amount)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> BillClose() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlCloseBill()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> CloseTheDay() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlCloseTheDay('0')));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> CloseTheWithoutWritingToFiscalMemory() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlCloseTheDay('1')));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> PaperCut() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlPaperCut()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> DisplayErase() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlDisplayErase()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> DisplayFullControl() {
        return null;
    }

    public Vector<String> DisplayShowDateAndTime() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlDisplayErase()));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlDisplayDateAndTime()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> DisplayShowText(String text1, String text2) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlDisplayErase()));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlDisplayMessageUpper(text1)));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlDisplayMessageLower(text2)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> DrawerOpen() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlOpenCashDrawer()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> FooterSet(char footerRowNr, String footer) throws Exception {
        if (footerRowNr > '6' || footerRowNr < '9') {
            this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlSetHeaderFooter(footerRowNr, footer)));
            Messages msg = this.cashRegisterFSM.ExecuteCommand();
            return this.getResults(msg);
        }
        throw new Exception("Broj reda za futer treba da bude izmedju '6' i '9'");
    }

    public Vector<String> HeaderSet(char headerRowNr, String header) throws Exception {
        if (headerRowNr > '0' || headerRowNr < '5') {
            this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlSetHeaderFooter(headerRowNr, header)));
            Messages msg = this.cashRegisterFSM.ExecuteCommand();
            return this.getResults(msg);
        }
        throw new Exception("Broj reda za futer treba da bude izmedju '0' i '5'");
    }

    public Vector<String> FooterGet() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('6')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('7')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('8')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('9')));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> HeaderGet() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('0')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('1')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('2')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('3')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('4')));
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetHeaderFooter('5')));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoAmountP() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetAmountInfoP()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoCurrentBill() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetCurrentBillInfo()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoDailyInfo(int closure, char type) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetDailyInfo(closure, type)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoDailyPeriod(int closure1, char type, int closure2) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetDailyPeriodInfo(closure1, type, closure2)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoDateTime() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetDateTime()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoDayTraffic() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetDayTrafficInfo()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoDayTrafficOnP() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetDayTrafficInfoOnP()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoDiagnose() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetDiagnose()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoFiscalMemoryDump(int startAddress, int count) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetFiscalMemoryDump(startAddress, count)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoFiscalMemorySpaceLeft() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetFiscalMemorySpaceLeft()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoFiscalTransactionStatus() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetFiscalTransactionStatus()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoLastBill() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetLastBillInfo()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoNumberOnLastPrintedDocument() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetNumberOnLastPrintedDocument()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoOnSellingsFromOperatngMemory(int reg) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetInfoOnSellingsFromOperatngMemory(reg)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoOperaterInfo(int operaterId) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetOperaterInfo(operaterId)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoPIB() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetPIB()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoStatusDeviceRegister() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetStatusDeviceRegister()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoStatusDeviceRegisterWait() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetStatusDeviceRegisterWait()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> InfoTaxRates() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlGetTaxRates()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> LogoAdd(String logoPath) throws Exception {
        return null;
    }

    public Vector<String> LogoFillBlank() throws Exception {
        return null;
    }

    public Vector<String> LogoPrintingAllowed(boolean allow) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlAllowLogoToBePrinted(allow)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> PrintDiagnose() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlPrintDiagnose()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> PrintText(Vector<String> text) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlOpenText()));
        int i = 0;
        while (i < text.size()) {
            this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlPrintText(text.get(i))));
            ++i;
        }
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlCloseText()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> PrintTextS(String text) throws Exception {
        text = text.replaceAll("\n", "");
        text = text.replaceAll("\b", "");
        text = text.replaceAll("\t", "");
        text = text.replaceAll("\r", "");
        text = text.replaceAll("\f", "");
        String[] tempText = text.split("(?<=\\G.{29})|(#crlf)");
        int i = 0;
        while (i < tempText.length - 1) {
            if (!StringUtils.endsWith((String)tempText[i], (String)" ") && !StringUtils.startsWith((String)tempText[i + 1], (String)" ")) {
                int n = i;
                tempText[n] = String.valueOf(tempText[n]) + "-";
            }
            if (StringUtils.startsWith((String)tempText[i], (String)" ")) {
                tempText[i] = StringUtils.substring((String)tempText[i], (int)1, (int)tempText[i].length());
            }
            ++i;
        }
        return this.PrintText(new Vector<String>(Arrays.asList(tempText)));
    }

    public Vector<String> RaiseOrInputMoney(BigDecimal amount) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlMoneyRaise(amount)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> ReportArticle(int option) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlInfoOnItem(option)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> ReportOperater() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlInfoOnOperater()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> ReportPeriodical(String startDate, String endDate) throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlInfoPeriodical(startDate, endDate)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public byte[][] InitialSequence() throws Exception {
        return null;
    }

    public Vector<String> PaperRollMain() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlRollDownPaper(5, 1)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> PaperRollSecond() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlRollDownPaper(5, 2)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Vector<String> GetTechInfo() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlItemGetTechnicalInfo()));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public Integer GetNumberOfProgrammedArticles() throws Exception {
        Vector<String> results = this.GetTechInfo();
        String rs = results.get(0);
        Integer nuofarticles = Integer.parseInt(rs.split(",")[2]);
        return nuofarticles;
    }

    public Vector<String> TestFiscalmemory() throws Exception {
        this.cashRegisterFSM.AddToCommandList(new String(this.control.ControlFiscalMemoryTest(false)));
        Messages msg = this.cashRegisterFSM.ExecuteCommand();
        return this.getResults(msg);
    }

    public HashMap<String, String> runWithTheBill(DeviceDataInterface data) {
        Vector<String> returnData = null;
        Vector<String> returnData1 = null;
        HashMap<String, String> result = new HashMap<String, String>();
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        try {
            if (bill.isPreBill()) {
                returnData = this.PrintPreBill((BillInterface)bill, "PREDRACUN", null);
            } else {
                returnData = this.PrintBill((BillInterface)bill);
                if (bill.getBillAdditionalText() != null && bill.getBillAdditionalText().length() != 0) {
                    returnData1 = this.PrintTextS(bill.getBillAdditionalText());
                    if (returnData == null) {
                        returnData = returnData1;
                    } else {
                        returnData.addAll(returnData1);
                    }
                }
            }
        }
        catch (Exception e) {
            result.put("MESSAGE", e.getMessage());
            result.put("CODE", "ERROR");
        }
        if (result.get("CODE") == null) {
            result.put("CODE", "SUCCESS");
            int i = 0;
            while (i < returnData.size()) {
                result.put("MESSAGE", returnData.elementAt(i));
                ++i;
            }
        }
        String info = "";
        int i = 0;
        while (i < this.infos.size()) {
            info = String.valueOf(info) + this.infos.elementAt(i) + ";";
            ++i;
        }
        result.put("INFO", info);
        return result;
    }

    public HashMap<String, String> runWithTheControl(DeviceDataInterface data) {
        Vector<String> returnData = null;
        HashMap<String, String> result = new HashMap<String, String>();
        rs.pezar.msg.device.cashregister.data.CashRegisterControl cntrl = (rs.pezar.msg.device.cashregister.data.CashRegisterControl)data.getData();
        String msgCntrl = cntrl.getControlCode();
        HashMap params = cntrl.getParameters();
        if (msgCntrl.equals("CODE_CLOSE_THE_DAY")) {
            try {
                returnData = this.CloseTheDay();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                int i = 0;
                while (i < returnData.size()) {
                    result.put("MESSAGE", returnData.elementAt(i));
                    ++i;
                }
            }
        } else if (msgCntrl.equals("CODE_DAILY_INFO")) {
            try {
                returnData = this.CloseTheWithoutWritingToFiscalMemory();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                int i = 0;
                while (i < returnData.size()) {
                    result.put("MESSAGE", returnData.elementAt(i));
                    ++i;
                }
            }
        } else if (msgCntrl.equals("CODE_DELETE_ALL_ART")) {
            try {
                returnData = this.ArticleEraseAll();
            }
            catch (Exception e) {
                result.put("MESSAGE", String.valueOf(e.getMessage()) + "Niste zatvorili dan ili su artikli vec obrisani.");
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                int i = 0;
                while (i < returnData.size()) {
                    result.put("MESSAGE", returnData.elementAt(i));
                    ++i;
                }
            }
        } else if (msgCntrl.equals("CODE_TEST")) {
            Vector<String> testText = new Vector<String>();
            testText.add("Ovo je test printera");
            if (params != null) {
                testText.add("Zahtevao:");
                testText.add((String)params.get("USER"));
            }
            try {
                returnData = this.PrintText(testText);
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                int i = 0;
                while (i < returnData.size()) {
                    result.put("MESSAGE", returnData.elementAt(i));
                    ++i;
                }
            }
        } else if (msgCntrl.equals("CODE_PERIODICAL")) {
            if (params == null || params.size() < 2) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Morate proslediti parametre, tj datum od kada i datum do kada zelite izvestaj.");
            } else {
                String startDate = (String)params.get("DATE1");
                String endDate = (String)params.get("DATE2");
                try {
                    returnData = this.ReportPeriodical(startDate, endDate);
                }
                catch (Exception e) {
                    result.put("MESSAGE", e.getMessage());
                    result.put("CODE", "ERROR");
                }
                if (result.get("CODE") == null) {
                    result.put("CODE", "SUCCESS");
                    int i = 0;
                    while (i < returnData.size()) {
                        result.put("MESSAGE", returnData.elementAt(i));
                        ++i;
                    }
                }
            }
        } else if (msgCntrl.equals("CODE_TO_DISPLAY")) {
            if (params == null || params.size() < 1) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Morate proslediti parametar/e, tj Tekst za gornji i donji red dipleja.");
            } else {
                String paramUp = (String)params.get("UP");
                String paramDown = (String)params.get("DOWN");
                if (paramUp == null) {
                    paramUp = "";
                }
                if (paramDown == null) {
                    paramDown = "";
                }
                try {
                    returnData = this.DisplayShowText(paramUp, paramDown);
                }
                catch (Exception e) {
                    result.put("MESSAGE", e.getMessage());
                    result.put("CODE", "ERROR");
                }
                if (result.get("CODE") == null) {
                    result.put("CODE", "SUCCESS");
                    int i = 0;
                    while (i < returnData.size()) {
                        result.put("MESSAGE", returnData.elementAt(i));
                        ++i;
                    }
                }
            }
        } else if (msgCntrl.equals("CODE_SELL_DISPLAY")) {
            if (params == null || params.size() < 1) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Morate proslediti parametre\n P1: Naziv artikla\n P2: cena artikla\n P3: kolicina artikla\n P4: trenutna suma sa racuna.");
            } else {
                String name = (String)params.get("NAME");
                String quantity = (String)params.get("Q");
                String articlePrice = (String)params.get("PRICE");
                String sum = (String)params.get("SUM");
                String paramUp = "                    ";
                String paramDown = "                    ";
                if (name == null) {
                    name = "";
                }
                if (quantity == null) {
                    quantity = "";
                }
                if (articlePrice == null) {
                    articlePrice = "";
                }
                if (sum == null) {
                    sum = "";
                }
                if (!name.equals("")) {
                    quantity = Double.parseDouble(quantity) > 1.0 ? "*" + quantity : "";
                    articlePrice = String.valueOf(quantity) + " " + articlePrice;
                    paramUp = String.valueOf((String.valueOf(name) + "                    ").substring(0, 20 - articlePrice.length())) + articlePrice;
                    paramDown = "SUMA                ";
                    paramDown = String.valueOf(paramDown.substring(0, 20 - sum.toString().length())) + sum;
                }
                try {
                    returnData = this.DisplayShowText(paramUp, paramDown);
                }
                catch (Exception e) {
                    result.put("MESSAGE", e.getMessage());
                    result.put("CODE", "ERROR");
                }
                if (result.get("CODE") == null) {
                    result.put("CODE", "SUCCESS");
                    int i = 0;
                    while (i < returnData.size()) {
                        result.put("MESSAGE", returnData.elementAt(i));
                        ++i;
                    }
                }
            }
        } else if (msgCntrl.equals("CODE_DIAGNOSE")) {
            try {
                returnData = this.PrintDiagnose();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                int i = 0;
                while (i < returnData.size()) {
                    result.put("MESSAGE", returnData.elementAt(i));
                    ++i;
                }
            }
        } else if (msgCntrl.equals("CODE_INFO")) {
            String ret = null;
            try {
                ret = this.getDeviceInfo();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                result.put("MESSAGE", ret);
            }
        } else if (msgCntrl.equals("CODE_INFO_ART")) {
            Integer numofRows = null;
            Integer noofart = null;
            try {
                numofRows = this.databaseEngine.getNumberOfRows();
                noofart = this.GetNumberOfProgrammedArticles();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                result.put("MESSAGE", String.valueOf(numofRows.toString()) + ";" + noofart.toString());
            }
        } else if (msgCntrl.equals("CODE_PRINT_TEXT")) {
            if (params == null || params.size() < 1) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Morate proslediti parametar, tj tekst koji se stampa.");
            } else {
                String text = (String)params.get("TEXT");
                try {
                    returnData = this.PrintTextS(text);
                }
                catch (Exception e) {
                    result.put("MESSAGE", e.getMessage());
                    result.put("CODE", "ERROR");
                }
                if (result.get("CODE") == null) {
                    result.put("CODE", "SUCCESS");
                    int i = 0;
                    while (i < returnData.size()) {
                        result.put("MESSAGE", returnData.elementAt(i));
                        ++i;
                    }
                }
            }
        } else if (msgCntrl.equals("CODE_GET_HEADER")) {
            try {
                returnData = this.HeaderGet();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                String temp = "";
                int i = 0;
                while (i < returnData.size()) {
                    temp = String.valueOf(temp) + returnData.elementAt(i) + ";";
                    ++i;
                }
                result.put("MESSAGE", temp);
            }
        } else if (msgCntrl.equals("CODE_GET_FOOTER")) {
            try {
                returnData = this.FooterGet();
            }
            catch (Exception e) {
                result.put("MESSAGE", e.getMessage());
                result.put("CODE", "ERROR");
            }
            if (result.get("CODE") == null) {
                result.put("CODE", "SUCCESS");
                String temp = "";
                int i = 0;
                while (i < returnData.size()) {
                    temp = String.valueOf(temp) + returnData.elementAt(i) + ";";
                    ++i;
                }
                result.put("MESSAGE", temp);
            }
        } else {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", "Komanda poslata uredjaju nije podrzana od strane drajvera uredjaja");
        }
        String info = "";
        if (this.infos != null) {
            int i = 0;
            while (i < this.infos.size()) {
                info = String.valueOf(info) + this.infos.elementAt(i) + ";";
                ++i;
            }
        }
        result.put("INFO", info);
        return result;
    }

    public Vector<String> NewBill() throws Exception {
        this.bill = new CashRegisterBill();
        return null;
    }

    public Vector<String> AddArticle(Integer plu, String name, BigDecimal price, BigDecimal quantity, String sifra, char taxRate, String unit) throws Exception {
        if (this.bill == null) {
            throw new Exception("Nije otvoren racun");
        }
        Article article = new Article();
        article.setPLU(plu);
        article.setName(name);
        article.setPrice(price);
        article.setQuantity(quantity);
        article.setSifra(sifra);
        article.setTaxRate(taxRate);
        article.setUnit(unit);
        this.bill.addArticle(article);
        try {
            this.checkForABillValidity((BillInterface)this.bill);
        }
        catch (Exception e) {
            this.bill.getArticles().remove(this.bill.getArticles().size());
            throw e;
        }
        this.DisplayErase();
        String textGornji = article.getName();
        String textDonji = "+" + String.valueOf(article.getQuantity()) + "*" + String.valueOf(article.getPrice()) + "=" + String.valueOf(article.getQuantity().multiply(article.getPrice()));
        this.DisplayShowText(textGornji, textDonji);
        return null;
    }

    public Vector<String> AddArticle(ArticleInterface article) throws Exception {
        if (this.bill == null) {
            throw new Exception("Nije otvoren racun");
        }
        if (article == null) {
            throw new Exception("Artikal je null");
        }
        this.bill.addArticle((Article)article);
        try {
            this.checkForABillValidity((BillInterface)this.bill);
        }
        catch (Exception e) {
            this.bill.getArticles().remove(this.bill.getArticles().size());
            throw e;
        }
        this.DisplayErase();
        String textGornji = article.getName();
        String textDonji = "+ " + String.valueOf(article.getQuantity()) + " * " + String.valueOf(article.getPrice()) + " = " + String.valueOf(article.getQuantity().multiply(article.getPrice()));
        this.DisplayShowText(textGornji, textDonji);
        return null;
    }

    public Vector<String> PrintBill(String cashRegisterCode, String operaterCode, String operaterPassword, BigDecimal payedAmountCard, BigDecimal payedAmountCash, BigDecimal payedAmountCheck) throws Exception {
        if (this.bill == null) {
            throw new Exception("Nije otvoren racun");
        }
        if (this.bill.getArticles().size() == 0) {
            throw new Exception("Nema artikala na racunu");
        }
        this.bill.setCashRegisterCode(cashRegisterCode);
        this.bill.setOperaterCode(operaterCode);
        this.bill.setOperaterPassword(operaterPassword);
        this.bill.setPaidAmountCard(payedAmountCard);
        this.bill.setPaidAmountCash(payedAmountCash);
        this.bill.setPaidAmountCheck(payedAmountCheck);
        Vector<String> temp = this.PrintBill((BillInterface)this.bill);
        this.bill.getArticles().clear();
        this.bill = null;
        return temp;
    }

    public Vector<String> PrintBill(BillInterface bill) throws Exception {
        Vector<String> temp;
        if (bill == null) {
            throw new Exception("Racun je null");
        }
        this.correctDoubleShifra(bill);
        this.checkForABillValidity(bill);
        this.sumCheck(bill);
        this.checkForArticles(bill);
        this.addPluWhereNeeded(bill);
        this.checkForArticleNames(bill);
        if (bill.getBillIdString() != null) {
            this.FooterSet('7', bill.getBillIdString());
        } else {
            this.FooterSet('7', "");
        }
        this.DisplayErase();
        this.BillOpen(bill.getOperaterCode(), bill.getOperaterPassword(), bill.getCashRegisterCode());
        int i = 0;
        while (i < bill.getArticles().size()) {
            this.BillAddArticleWithoutShowingOnDisplay('+', ((Article)bill.getArticles().get(i)).getPLU(), ((Article)bill.getArticles().get(i)).getQuantity());
            ++i;
        }
        try {
            temp = this.BillTotal('D', bill.getPaidAmountCard());
            temp = this.BillTotal('P', bill.getPaidAmountCash());
            temp = this.BillTotal('C', bill.getPaidAmountCheck());
        }
        catch (Exception exception) {}
        try {
            this.DrawerOpen();
        }
        catch (Exception exception) {}
        temp = this.BillClose();
        return temp;
    }

    public void correctDoubleShifra(BillInterface bill) {
        int i = 0;
        while (i < bill.getArticles().size()) {
            String sifra = ((Article)bill.getArticles().get(i)).getSifra();
            if (sifra != null && this.howManySifras(bill, sifra) > 1) {
                ((Article)bill.getArticles().get(i)).setSifra("temp" + String.format("%04d", this.tempCounter));
                this.tempCounter = this.tempCounter + 1;
            }
            ++i;
        }
    }

    private Integer howManySifras(BillInterface bill, String sifra) {
        int brojDuplikata = 0;
        int i = 0;
        while (i < bill.getArticles().size()) {
            String s = ((Article)bill.getArticles().get(i)).getSifra();
            if (sifra.equals(s)) {
                ++brojDuplikata;
            }
            ++i;
        }
        return brojDuplikata;
    }

    private void addPluWhereNeeded(BillInterface bill) throws FiscalBaseException {
        int i = 0;
        while (i < bill.getArticles().size()) {
            String plu;
            String sifra = ((Article)bill.getArticles().get(i)).getSifra();
            if (sifra != null && (plu = this.getPlu(sifra)) != null) {
                ((Article)bill.getArticles().get(i)).setPLU(Integer.valueOf(Integer.parseInt(plu)));
            }
            ++i;
        }
    }

    private void checkForArticleNames(BillInterface bill) throws Exception {
        this.databaseEngine.checkNames(bill);
    }

    private void checkForABillValidity(BillInterface bill) throws Exception {
        int i = 0;
        while (i < bill.getArticles().size()) {
            if (((Article)bill.getArticles().get(i)).getPrice().doubleValue() <= 0.0) {
                throw new Exception("Cena ne moze biti manja ili jednaka 0, artikal na poziciji " + (i + 1));
            }
            if ((((Article)bill.getArticles().get(i)).getName() == null || ((Article)bill.getArticles().get(i)).getName().trim().equals("")) && ((Article)bill.getArticles().get(i)).getPLU() == null) {
                throw new Exception("Artikal mora imati ime, artikal na poziciji " + (i + 1));
            }
            if (((Article)bill.getArticles().get(i)).getQuantity().doubleValue() <= 0.0) {
                throw new Exception("Kvantitet mora biti veci od 0, artikal na poziciji " + (i + 1));
            }
            if (((Article)bill.getArticles().get(i)).getQuantity().doubleValue() > 99999.0) {
                throw new Exception("Kvantitet ne sme biti veci od 99999, artikal na poziciji " + (i + 1));
            }
            if (bill.getPaidAmountCard() == null) {
                bill.setPaidAmountCard(BigDecimal.ZERO);
            }
            if (bill.getPaidAmountCash() == null) {
                bill.setPaidAmountCash(BigDecimal.ZERO);
            }
            if (bill.getPaidAmountCheck() == null) {
                bill.setPaidAmountCheck(BigDecimal.ZERO);
            }
            if (bill.getPaidAmountCard().equals(BigDecimal.ZERO) && bill.getPaidAmountCash().equals(BigDecimal.ZERO) && bill.getPaidAmountCheck().equals(BigDecimal.ZERO)) {
                throw new Exception("Sva tri iznosa (kes, cek i kartica) su 0 ili nisu prosledjeni ");
            }
            BigDecimal quantity = ((Article)bill.getArticles().get(i)).getQuantity();
            BigDecimal bdQuantity = new BigDecimal(String.valueOf(((Article)bill.getArticles().get(i)).getQuantity()));
            int decimalPlaces = FP550Control.getNumberOfDecimalPlaces(bdQuantity);
            if (decimalPlaces > 3 || quantity.doubleValue() > 99999.0 && decimalPlaces == 0 || quantity.doubleValue() > 999.9 && decimalPlaces == 1 || quantity.doubleValue() > 99.99 && decimalPlaces == 2 || quantity.doubleValue() > 9.999 && decimalPlaces == 3) {
                throw new Exception("Kolicina se ne uklapa ni u jedan sablon ponudjen od proizvodjaca fiskalnog uredjaja, artikal na poziciji " + (i + 1) + ".\n Sabloni: #####, ###.#, ##.##, #.###");
            }
            if (((Article)bill.getArticles().get(i)).getTaxRate() != 'A' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'D' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'd' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'E' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'G' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'I' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'J' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'K' && ((Article)bill.getArticles().get(i)).getTaxRate() != 'Z') {
                throw new Exception("Poreska grupa nije prepoznata, artikal na poziciji " + (i + 1));
            }
            ++i;
        }
    }

    private void sumCheck(BillInterface bill) throws Exception {
        BigDecimal sum = BigDecimal.ZERO;
        int i = 0;
        while (i < bill.getArticles().size()) {
            BigDecimal price = ((Article)bill.getArticles().get(i)).getPrice().setScale(2, 4);
            BigDecimal quantity = ((Article)bill.getArticles().get(i)).getQuantity().setScale(3, 4);
            sum = sum.add(quantity.multiply(price));
            ++i;
        }
        if ((sum = sum.setScale(2, 4)).compareTo(bill.getPaidAmountCard().add(bill.getPaidAmountCash()).add(bill.getPaidAmountCheck())) == 1) {
            throw new Exception("Uplaceni iznos je manji od iznosa na racunu");
        }
    }

    private void checkForArticles(BillInterface bill) throws Exception {
        int i = 0;
        while (i < bill.getArticles().size()) {
            String plu;
            if (((Article)bill.getArticles().get(i)).getSifra() != null && (plu = this.getPlu(((Article)bill.getArticles().get(i)).getSifra())) != null) {
                ((Article)bill.getArticles().get(i)).setPLU(Integer.valueOf(Integer.parseInt(plu)));
            }
            if (((Article)bill.getArticles().get(i)).getPLU() == null) {
                Vector<String> temp = this.ArticleGetFirstUnusedNumber();
                int newNumber = Integer.parseInt(temp.get(0));
                ((Article)bill.getArticles().get(i)).setPLU(Integer.valueOf(newNumber));
                this.ArticleDefine(newNumber, ((Article)bill.getArticles().get(i)).getTaxRate(), ((Article)bill.getArticles().get(i)).getPrice(), ((Article)bill.getArticles().get(i)).getName(), ((Article)bill.getArticles().get(i)).getUnit());
                this.setPlu(((Article)bill.getArticles().get(i)).getSifra(), String.valueOf(newNumber), ((Article)bill.getArticles().get(i)).getName());
            }
            this.ArticleChangePrice(((Article)bill.getArticles().get(i)).getPLU(), ((Article)bill.getArticles().get(i)).getPrice());
            ++i;
        }
    }

    public Vector<String> PrintPreBill(BillInterface bill, String name, String additionalInfo) throws Exception {
        int i;
        if (bill == null) {
            throw new Exception("Racun je null");
        }
        if (bill.getArticles().size() == 0) {
            throw new Exception("Nema artikala na racunu");
        }
        BigDecimal total = new BigDecimal(0);
        Vector<String> temp = new Vector<String>();
        temp.add("Ovo nije fiskalni racun!");
        temp.add(" ");
        if (bill.getBillHeaderText() != null && !"".equals(bill.getBillHeaderText())) {
            String[] header = bill.getBillHeaderText().split("#crlf");
            i = 0;
            while (i < header.length) {
                temp.add(header[i].toString());
                ++i;
            }
        } else if (name != null) {
            temp.add(name);
        }
        temp.add(" ");
        temp.add("------------------------------");
        int i2 = 0;
        while (i2 < bill.getArticles().size()) {
            temp.add(((Article)bill.getArticles().get(i2)).getName());
            temp.add(String.format("%15s%15s", " " + String.valueOf(((Article)bill.getArticles().get(i2)).getQuantity()) + "x " + String.valueOf(((Article)bill.getArticles().get(i2)).getPrice()), String.valueOf(((Article)bill.getArticles().get(i2)).getQuantity().multiply(((Article)bill.getArticles().get(i2)).getPrice()))));
            total = total.add(((Article)bill.getArticles().get(i2)).getQuantity().multiply(((Article)bill.getArticles().get(i2)).getPrice()));
            ++i2;
        }
        temp.add("------------------------------");
        temp.add(String.format("%30s", "Total:" + String.valueOf(total)));
        temp.add(" ");
        if (bill.getBillAdditionalText() != null && !"".equals(bill.getBillAdditionalText())) {
            String[] footer = bill.getBillAdditionalText().split("#crlf");
            i = 0;
            while (i < footer.length) {
                temp.add(footer[i].toString());
                ++i;
            }
        }
        if (additionalInfo != null) {
            String[] temps = additionalInfo.split("(?<=\\G.{30})");
            i = 0;
            while (i < temps.length) {
                temp.add(temps[i]);
                ++i;
            }
        }
        temp.add("Ovo nije fiskalni racun!   ");
        return this.PrintText(temp);
    }

    private void setPlu(String sifra, String plu, String naziv) throws FiscalBaseException {
        this.databaseEngine.setPlu(sifra, plu, naziv);
    }

    private String getSifra(String plu) throws FiscalBaseException {
        return this.databaseEngine.getSifra(plu);
    }

    private String getPlu(String sifra) throws FiscalBaseException {
        return this.databaseEngine.getPlu(sifra);
    }

    private void dropDatabase() throws FiscalBaseException {
        this.databaseEngine.dropDatabase();
    }

    public String getDeviceInfo() {
        Vector<String> info;
        try {
            info = this.InfoDiagnose();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String[] infos = info.get(0).split(",");
        String[] temps = infos[0].split(" ");
        return "Verzija firmware-a:" + temps[0] + " \nDatum Firmware-a:" + temps[1] + " \nVreme Firmware-a:" + temps[2] + " \nKontrolni iznos eprom-a:" + infos[1] + " \nSwitches: " + infos[2] + " \nZemlja:" + infos[3] + " \nIBFM:" + infos[4] + " \nFabricki broj fiskalnog stampaca:" + infos[5];
    }

    public String getFirmwareVer() {
        Vector<String> info;
        try {
            info = this.InfoDiagnose();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String[] infos = info.get(0).split(",");
        String[] temps = infos[0].split(" ");
        return temps[0];
    }

    public static void main(String[] args) throws Exception {
        FP550Driver driver = new FP550Driver();
        driver.setDatabasePath("d:\\Documents and Settings\\lazar\\.pezar\\");
        driver.setPlu("asd345", "234", "Naziv1");
        System.out.println(driver.getPlu("asd345"));
        System.out.println(driver.getSifra("234"));
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getFabricatingNr() {
        Vector<String> info;
        try {
            info = this.InfoDiagnose();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String[] infos = info.get(0).split(",");
        return infos[5];
    }

    public Vector<String> getInfos() {
        return this.infos;
    }

    static class CheckTask
    extends TimerTask {
        CheckTask() {
        }

        @Override
        public void run() {
            notReturningAnswer = true;
            testSemaphore.release();
        }
    }
}

