/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.trebovanje;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.ArtikalopstidokumentPK;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Prjmestotroska;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.proizvodnja.gui.PzDialogTrebovanje;
import rs.pezar.proizvodnja.gui.trebovanje.Arhiviranje;
import rs.pezar.proizvodnja.gui.trebovanje.DodavanjeStavke;
import rs.pezar.proizvodnja.gui.trebovanje.DodavanjeStavkeSastavnica;
import rs.pezar.proizvodnja.gui.trebovanje.PzDialogIzborRN;
import rs.pezar.sifarnici.gui.PzDialogMestoTroska;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogIzrada
extends PzDialog {
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzButton btnIzmenaRj;
    private PzButton btnIzmenaRN;
    private PzDoubleField dfUkupnaKolicina;
    private JLabel lblUkupnaKolicina;
    private PzDoubleField dfUkupnaVrednost;
    private JLabel lblUkupnaVrednost;
    private PzTextField tfNazivRj;
    private PzTextField tfRj;
    private JLabel lblRj;
    private PzToolBarIcon icnDodavanjeArt;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzTextField tfRadniNalog;
    private JLabel lblRadniNalog;
    private PzTable tblArtikli;
    private JScrollPane scrollPane;
    private PzPanel pnlPolja;
    private Radnajedinica rj;
    private Prjmestotroska prj;
    private Opstidokument trebovanje;
    private PzToolBarIcon icnDodajSve;
    private PzToolBarIcon icnArhiva;
    private RadniNalog radniNalog;
    private final PzDialogTrebovanje parent;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brStavki = new JLabel();
    String tipDokumenta;
    private String tableID;
    boolean izmena;

    public PzDialogIzrada(PzDialog dialog) {
        super(dialog);
        this.parent = (PzDialogTrebovanje)dialog;
        this.izmena = (Boolean)this.getSession().getParameter("update");
        this.trebovanje = this.izmena ? (Opstidokument)this.getSession().getParameter("trebovanje") : new Opstidokument();
        this.tipDokumenta = (String)this.getSession().getParameter("tipDokumenta");
        this.tableID = "TABLE_TREBOVANJE";
        this.setId("TREBOVANJE");
        if (this.tipDokumenta.equals("TREBOVANJE_SASTAVNICE")) {
            this.tableID = "TABLE_TREBOVANJE_SASTAVNICE";
            this.setId("TREBOVANJE_SASTAVNICE");
        } else if (this.tipDokumenta.equals("PREDAJNICA")) {
            this.tableID = "TABLE_PREDAJNICA";
            this.setId("PREDAJNICA");
        }
        this.initGUI();
        this.postInit();
        this.paintPanel();
        this.tblArtikli.checkAll();
        if (this.izmena) {
            this.tfRj.setVal((Object)(String.valueOf(this.trebovanje.getPrjmestotroska().getId().getOznPrj()) + "/" + this.trebovanje.getPrjmestotroska().getId().getOznMTroska()));
            this.tfNazivRj.setVal((Object)this.trebovanje.getPrjmestotroska().getNaziv());
            this.tfRadniNalog.setVal((Object)this.trebovanje.getRadninalog().getOznRadniNalog());
            this.setSelektovano();
        }
    }

    private void postInit() {
        if (this.trebovanje.getArtikalDocuments() != null) {
            this.tblArtikli.setData(this.trebovanje.getArtikalopstidokuments(), Artikalopstidokument.class);
        }
    }

    private void setSelektovano() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzrada.this.brStavki.setText(String.valueOf(PzDialogIzrada.this.tblArtikli.getDataSize()));
            }
        });
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void setIznosSelektovanih() {
        double iznosSelektovanih = 0.0;
        double iznosKolicine = 0.0;
        for (Artikalopstidokument art : this.trebovanje.getArtikalopstidokuments()) {
            iznosKolicine += art.getKolicina();
            iznosSelektovanih += BDConverter.getIznos((double)(art.getKolicina() * art.getCenaBezPoreza())).doubleValue();
        }
        this.dfUkupnaKolicina.setVal((Object)iznosKolicine);
        this.dfUkupnaVrednost.setVal((Object)iznosSelektovanih);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Izrada trebovanja");
            if (this.tipDokumenta.equals("TREBOVANJE_SASTAVNICE")) {
                this.setTitle("Izrada trebovanja preko sastavnice (normativa)");
            } else if (this.tipDokumenta.equals("PREDAJNICA")) {
                this.setTitle("Izrada predajnice");
            }
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{85, 99, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanjeArt = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanjeArt);
            this.icnDodavanjeArt.setText("Dodavanje|stavke|(Insert)");
            this.icnDodavanjeArt.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_add.png")));
            this.icnDodavanjeArt.addActionListener((ActionListener)((Object)this));
            this.icnDodavanjeArt.setActionCommand("dodavanje");
            this.icnDodavanjeArt.setShortcut("Insert");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|stavke|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|stavke|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.setShortcut("delete");
            if (this.getSession().getParameter("tipDokumenta").equals("TREBOVANJE")) {
                this.icnDodajSve = new PzToolBarIcon();
                this.toolbar.add((Component)this.icnDodajSve);
                this.icnDodajSve.setText("Dodavanje|artikala|iz lagera|(F5)");
                this.icnDodajSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_add.png")));
                this.icnDodajSve.setActionCommand("dodajSve");
                this.icnDodajSve.addActionListener((ActionListener)((Object)this));
                this.icnDodajSve.setShortcut("F5");
            }
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva i|\u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/printer_preferences.png")));
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.setShortcut("CTRL+W");
            this.pnlPolja = new PzPanel();
            GridBagLayout pnlPoljaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlPolja, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlPoljaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPoljaLayout.rowHeights = new int[]{10, 25, 25, 1, 7, 7};
            pnlPoljaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPoljaLayout.columnWidths = new int[]{25, 100, 135, 138, 140, 110, 7};
            this.pnlPolja.setLayout((LayoutManager)pnlPoljaLayout);
            this.pnlPolja.setOpaque(false);
            this.lblRadniNalog = new JLabel();
            this.pnlPolja.add((Component)this.lblRadniNalog, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRadniNalog.setText("Radni nalog");
            this.tfRadniNalog = new PzTextField();
            this.pnlPolja.add((Component)this.tfRadniNalog, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRadniNalog.setFocusable(false);
            this.lblRj = new JLabel();
            this.pnlPolja.add((Component)this.lblRj, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRj.setText("Prj/mt");
            this.tfRj = new PzTextField();
            this.pnlPolja.add((Component)this.tfRj, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRj.setFocusable(false);
            this.tfNazivRj = new PzTextField();
            this.pnlPolja.add((Component)this.tfNazivRj, (Object)new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivRj.setFocusable(false);
            this.lblUkupnaKolicina = new JLabel();
            this.pnlPolja.add((Component)this.lblUkupnaKolicina, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUkupnaKolicina.setText("Ukupna kolicina");
            this.dfUkupnaKolicina = new PzDoubleField();
            this.pnlPolja.add((Component)this.dfUkupnaKolicina, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfUkupnaKolicina.setFocusable(false);
            this.dfUkupnaKolicina.setDecimalFormat(new DecimalFormat("###,###.000"));
            this.dfUkupnaKolicina.setVal((Object)this.trebovanje.getProcRabata());
            this.lblUkupnaVrednost = new JLabel();
            this.pnlPolja.add((Component)this.lblUkupnaVrednost, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 10), 0, 0));
            this.lblUkupnaVrednost.setText("Vrednost");
            if (this.getSession().getParameter("tipDokumenta").equals("PREDAJNICA")) {
                this.lblUkupnaKolicina.setVisible(false);
                this.dfUkupnaKolicina.setVisible(false);
                this.lblUkupnaVrednost.setText("Planska vrednost");
            }
            this.dfUkupnaVrednost = new PzDoubleField();
            this.pnlPolja.add((Component)this.dfUkupnaVrednost, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfUkupnaVrednost.setFocusable(false);
            this.dfUkupnaVrednost.setDecimalFormat(new DecimalFormat(PzParameter.getParameterValue((String)"DEFAULT_DECIMAL_FORMAT", (String)"###,###.00")));
            this.dfUkupnaVrednost.setVal((Object)this.trebovanje.getIznosBezPoreza());
            this.btnIzmenaRj = new PzButton();
            this.pnlPolja.add((Component)this.btnIzmenaRj, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 5, 1, 0), 0, 0));
            this.btnIzmenaRj.setName("btnIzmenaRj");
            this.btnIzmenaRj.setActionCommand("izmenaRj");
            this.btnIzmenaRj.addActionListener((ActionListener)((Object)this));
            this.btnIzmenaRj.setFocusable(false);
            this.btnIzmenaRj.setText("Promena Prj/mt");
            if (this.getSession().getParameter("gradjevinarstvo") == null || !((Boolean)this.getSession().getParameter("gradjevinarstvo")).booleanValue()) {
                this.btnIzmenaRN = new PzButton();
                this.pnlPolja.add((Component)this.btnIzmenaRN, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 5, 1, 0), 0, 0));
                this.btnIzmenaRN.setName("btnIzmenaRN");
                this.btnIzmenaRN.setActionCommand("izmenaRN");
                this.btnIzmenaRN.addActionListener((ActionListener)((Object)this));
                this.btnIzmenaRN.setFocusable(false);
                this.btnIzmenaRN.setText("Promena RN");
            }
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            if (this.trebovanje.getArtikalopstidokuments() == null) {
                this.trebovanje.setArtikalopstidokuments((List)new IndirectList());
            }
            this.tblArtikli = new PzTable(this.trebovanje.getArtikalopstidokuments(), Artikalopstidokument.class);
            this.tblArtikli.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDialogIzrada.this.icnDodavanjeArt.doClick();
                }
            });
            this.tblArtikli.setId(this.tableID);
            this.scrollPane.setViewportView((Component)this.tblArtikli);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brStavki);
            this.brStavki.setFocusable(false);
            this.brStavki.setOpaque(false);
            this.setPreferredSize(new Dimension(925, 600));
            this.setMinimumSize(new Dimension(925, 600));
            if (this.izmena) {
                this.setSelektovano();
            }
            this.pack();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        PzButton button = (PzButton)arg0.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        this.getSession().putParameter("trebovanje", (Object)this.trebovanje);
        this.getSession().putParameter("tabela", (Object)this.tblArtikli);
        try {
            if (actionCommand.equals("izmenaRj")) {
                this.prj = PzDialogMestoTroska.getPrj((PzDialog)this);
                if (this.prj != null) {
                    em.getTransaction().begin();
                    Opstidokument tr = (Opstidokument)PzEntityManager.find(Opstidokument.class, (Object)this.trebovanje.getIdDok(), (EntityManager)em);
                    tr.setPrjmestotroska(this.prj);
                    this.trebovanje.setPrjmestotroska(this.prj);
                    em.merge((Object)tr);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().commit();
                    }
                    this.tfRj.setVal((Object)(String.valueOf(this.prj.getId().getOznPrj()) + "/" + this.prj.getId().getOznMTroska()));
                    this.tfNazivRj.setVal((Object)this.prj.getNaziv());
                }
            } else if (actionCommand.equals("izmenaRN")) {
                HashMap<String, Object> h = PzDialogIzborRN.getIzbor(this);
                if (h != null) {
                    this.radniNalog = (RadniNalog)h.get("radninalog");
                    em.getTransaction().begin();
                    Opstidokument tr = (Opstidokument)PzEntityManager.find(Opstidokument.class, (Object)this.trebovanje.getIdDok(), (EntityManager)em);
                    tr.setRadninalog(this.radniNalog);
                    this.trebovanje.setRadninalog(this.radniNalog);
                    em.merge((Object)tr);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().commit();
                    }
                    this.tfRadniNalog.setVal((Object)this.radniNalog.getOznRadniNalog());
                }
            } else if (actionCommand.equals("dodavanje")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("trebovanje", (Object)this.trebovanje);
                this.getSession().putParameter("tabela", (Object)this.tblArtikli);
                if (this.tipDokumenta.equals("TREBOVANJE")) {
                    this.showDialog(DodavanjeStavke.class);
                } else if (this.tipDokumenta.equals("TREBOVANJE_SASTAVNICE")) {
                    this.showDialog(DodavanjeStavkeSastavnica.class);
                } else if (this.tipDokumenta.equals("PREDAJNICA")) {
                    this.showDialog(rs.pezar.proizvodnja.gui.predajnice.DodavanjeStavke.class);
                }
                this.dfUkupnaKolicina.setVal((Object)this.trebovanje.getProcRabata());
                this.dfUkupnaVrednost.setVal((Object)this.trebovanje.getIznosBezPoreza());
                this.setSelektovano();
            } else if (actionCommand.equals("izmena")) {
                if (this.tblArtikli.getSelectedRow() != -1) {
                    this.getSession().putParameter("trebovanje", (Object)this.trebovanje);
                    this.getSession().putParameter("tabela", (Object)this.tblArtikli);
                    this.getSession().putParameter("update", (Object)true);
                    if (this.tipDokumenta.equals("TREBOVANJE")) {
                        this.showDialog(DodavanjeStavke.class);
                    } else if (this.tipDokumenta.equals("TREBOVANJE_SASTAVNICE")) {
                        this.showDialog(DodavanjeStavkeSastavnica.class);
                    } else if (this.tipDokumenta.equals("PREDAJNICA")) {
                        this.showDialog(rs.pezar.proizvodnja.gui.predajnice.DodavanjeStavke.class);
                    }
                    this.dfUkupnaKolicina.setVal((Object)this.trebovanje.getProcRabata());
                    this.dfUkupnaVrednost.setVal((Object)this.trebovanje.getIznosBezPoreza());
                    this.setSelektovano();
                }
            } else {
                int rez;
                if (actionCommand.equalsIgnoreCase("brisanje")) {
                    if (this.tblArtikli.getSelectedEntity() == null) {
                        return;
                    }
                    rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                    if (rez != 0) {
                        return;
                    }
                    em.getTransaction().begin();
                    Artikalopstidokument arttr = (Artikalopstidokument)this.tblArtikli.getSelectedEntity();
                    this.trebovanje.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza().subtract(BDConverter.getIznos((double)(arttr.getKolicina() * arttr.getCenaBezPoreza()))));
                    this.trebovanje.setProcRabata(this.trebovanje.getProcRabata() - arttr.getKolicina());
                    Opstidokument tr = (Opstidokument)em.find(Opstidokument.class, (Object)this.trebovanje.getIdDok());
                    tr.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza());
                    tr.setProcRabata(this.trebovanje.getProcRabata());
                    this.dfUkupnaKolicina.setVal((Object)tr.getProcRabata());
                    this.dfUkupnaVrednost.setVal((Object)tr.getIznosBezPoreza());
                    this.tblArtikli.removeSelectedEntity(false, em);
                    em.getTransaction().commit();
                    this.tblArtikli.commitRemove();
                    this.refresh();
                    return;
                }
                if (actionCommand.equals("arhiva")) {
                    if (this.tblArtikli.getRowCount() != 0) {
                        this.trebovanje = (Opstidokument)em.find(Opstidokument.class, (Object)this.trebovanje.getIdDok());
                        this.getSession().putParameter("trebovanje", (Object)this.trebovanje);
                        if (this.trebovanje.getTip().equals("PREDAJNICA")) {
                            this.showDialog(rs.pezar.proizvodnja.gui.predajnice.Arhiviranje.class);
                        } else {
                            this.getSession().putParameter("tableTr", this.getSession().getParameter("tabelaTreb"));
                            if (((Boolean)this.getSession().getParameter("gradjevinarstvo")).booleanValue()) {
                                this.getSession().putParameter("rn", this.getSession().getParameter("radninalog"));
                            }
                            this.showDialog(Arhiviranje.class);
                        }
                    }
                } else if (actionCommand.equals("dodajSve")) {
                    rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Preuzimanje svih artikala iz lagera?", (String)"Preuzimanje lagera", null, (boolean)false);
                    if (rez != 0) {
                        return;
                    }
                    PzWorkerDialog.showStatus((String)"Molimo sa\u010dekajte...", (PzDialog)this);
                    SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            EntityManager em = PzEntityManager.getEm();
                            try {
                                try {
                                    em.getTransaction().begin();
                                    PzDialogIzrada.this.dopuniti(em);
                                    em.getTransaction().commit();
                                }
                                catch (Exception e) {
                                    if (em.getTransaction().isActive()) {
                                        em.getTransaction().rollback();
                                    }
                                    throw e;
                                }
                            }
                            finally {
                                em.close();
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                try {
                                    PzDialogIzrada.this.tblArtikli.commitInsert();
                                    PzDialogIzrada.this.dfUkupnaKolicina.setVal((Object)PzDialogIzrada.this.trebovanje.getProcRabata());
                                    PzDialogIzrada.this.dfUkupnaVrednost.setVal((Object)PzDialogIzrada.this.trebovanje.getIznosBezPoreza());
                                    PzDialogIzrada.this.setSelektovano();
                                }
                                catch (Exception e) {
                                    PzMysqlExceptionHandler.handle((Throwable)e);
                                    e.printStackTrace();
                                    PzWorkerDialog.hideStatus();
                                }
                            }
                            finally {
                                PzWorkerDialog.hideStatus();
                            }
                        }
                    };
                    sw.execute();
                    return;
                }
            }
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        finally {
            em.close();
        }
    }

    private void dopuniti(EntityManager em) {
        Query q = null;
        boolean cenePlanske = this.trebovanje.getRadnajedinica().getgTip().equals("S") && this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PLANSKA") || this.trebovanje.getRadnajedinica().getgTip().equals("P");
        double cena = 0.0;
        BigDecimal cenabd = new BigDecimal("0.00");
        q = cenePlanske ? em.createQuery("SELECT s.id.sfrProizvod, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.artikal.cenaPlanska, s.kolicina-s.alocKolicina FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.artikal.cenaPlanska != 0 AND s.radnajedinica=:rj AND s.id.sfrProizvod NOT IN (SELECT a.id.sfrProizvod FROM Artikalopstidokument a WHERE a.id.idDok =:iddok)") : em.createQuery("SELECT s.id.sfrProizvod, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prosNabCena, s.kolicina-s.alocKolicina FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.prosNabCena != 0 AND s.radnajedinica=:rj AND s.id.sfrProizvod NOT IN (SELECT a.id.sfrProizvod FROM Artikalopstidokument a WHERE a.id.idDok =:iddok)");
        q.setParameter("rj", (Object)this.trebovanje.getRadnajedinica());
        q.setParameter("iddok", (Object)this.trebovanje.getIdDok());
        Vector stavke = (Vector)q.getResultList();
        Opstidokument n = (Opstidokument)em.find(Opstidokument.class, (Object)this.trebovanje.getIdDok());
        for (Object[] obj : stavke) {
            String sifra = (String)obj[0];
            String naziv = (String)obj[1];
            String bliziOpis = (String)obj[2];
            String jm = (String)obj[3];
            if (cenePlanske) {
                cena = (Double)obj[4];
            } else {
                cenabd = (BigDecimal)obj[4];
            }
            double kolicina = (Double)obj[5];
            Artikalopstidokument artod = new Artikalopstidokument();
            ArtikalopstidokumentPK artPK = new ArtikalopstidokumentPK(this.trebovanje.getIdDok(), sifra, 1);
            artod.setId(artPK);
            artod.setNaziv(naziv);
            artod.setBliziOpis(bliziOpis);
            artod.setJm(jm);
            if (cenePlanske) {
                artod.setCenaBezPoreza(cena);
            } else {
                artod.setCenaBezPoreza(cenabd.doubleValue());
            }
            artod.setKolicina(kolicina);
            artod.setOpstidokument(this.trebovanje);
            this.tblArtikli.insert((PzEntity)artod, em);
            this.trebovanje.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza().add(BDConverter.getIznos((double)(artod.getKolicina() * artod.getCenaBezPoreza()))));
            this.trebovanje.setProcRabata(this.trebovanje.getProcRabata() + kolicina);
        }
        n.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza());
        n.setProcRabata(this.trebovanje.getProcRabata());
        em.merge((Object)this.trebovanje);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldBeShown() {
        if (((Boolean)this.getSession().getParameter("update")).booleanValue()) {
            return true;
        }
        boolean izradaGradjevinarstvo = (Boolean)this.getSession().getParameter("gradjevinarstvo") != null ? (Boolean)this.getSession().getParameter("gradjevinarstvo") : false;
        boolean result = true;
        if (this.getSession().getParameter("tipDokumenta").equals("TREBOVANJE")) {
            this.rj = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"S", "SR", "P"});
        } else if (this.getSession().getParameter("tipDokumenta").equals("PREDAJNICA")) {
            this.rj = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"G", "P"});
        }
        if (this.rj == null) {
            if (!this.getSession().getParameter("tipDokumenta").equals("TREBOVANJE_SASTAVNICE")) return false;
        }
        this.prj = PzDialogMestoTroska.getPrj((PzDialog)this);
        if (this.prj == null) return false;
        this.tfRj.setVal((Object)(String.valueOf(this.prj.getId().getOznPrj()) + "/" + this.prj.getId().getOznMTroska()));
        this.tfNazivRj.setVal((Object)this.prj.getNaziv());
        HashMap<String, Object> hm = null;
        if (izradaGradjevinarstvo) {
            this.radniNalog = (RadniNalog)this.getSession().getParameter("radninalog");
        } else {
            hm = PzDialogIzborRN.getIzbor(this);
        }
        if (hm == null) {
            if (this.radniNalog == null) return false;
        }
        if (hm != null) {
            this.radniNalog = (RadniNalog)hm.get("radninalog");
        }
        this.tfRadniNalog.setVal((Object)this.radniNalog.getOznRadniNalog());
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (this.trebovanje == null) {
                    this.trebovanje = new Opstidokument();
                }
                this.trebovanje.setStorno(0);
                this.trebovanje.setArhiviran((short)0);
                if (this.getSession().getParameter("tipDokumenta").equals("TREBOVANJE")) {
                    this.trebovanje.setTip("TREBOVANJE");
                } else if (this.getSession().getParameter("tipDokumenta").equals("TREBOVANJE_SASTAVNICE")) {
                    this.trebovanje.setTip("TREBOVANJE_SASTAVNICE");
                } else if (this.getSession().getParameter("tipDokumenta").equals("PREDAJNICA")) {
                    this.trebovanje.setTip("PREDAJNICA");
                }
                em.getTransaction().begin();
                if (this.getSession().getParameter("tipDokumenta").equals("TREBOVANJE") || this.getSession().getParameter("tipDokumenta").equals("PREDAJNICA")) {
                    this.trebovanje.setRadnajedinica(this.rj);
                }
                this.trebovanje.setPrjmestotroska(this.prj);
                this.trebovanje.setRadninalog(this.radniNalog);
                this.trebovanje.setDatum(new Date(new java.util.Date().getTime()));
                this.trebovanje.setProknjizen((short)0);
                PzDokumentManager.getInstance().snimiDokument((PzDokument)this.trebovanje, true, null, em);
                em.getTransaction().commit();
                ((PzTable)this.getSession().getParameter("tabela")).insert((PzEntity)this.trebovanje, false);
                if (!this.trebovanje.getTip().equals("TREBOVANJE")) return result;
                if (this.rj.getNacinVodjenja().equals("PLANSKA")) {
                    this.lblUkupnaVrednost.setText("Planska vrednost");
                    return result;
                }
                if (!this.rj.getNacinVodjenja().equals("PRNC")) return result;
                this.lblUkupnaVrednost.setText("Nabavna vrednost");
                return result;
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
            return result;
        }
        finally {
            em.close();
        }
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzrada.this.brStavki.setText(String.valueOf(PzDialogIzrada.this.tblArtikli.getRowCount()));
            }
        });
    }
}

