/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.prijemnice;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.proizvodnja.PzExtensionLoader;
import rs.pezar.proizvodnja.gui.prijemnice.Dodavanje;
import rs.pezar.proizvodnja.gui.prijemnice.PosaljiNalogZaPrijem;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogPDV;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogPrijemnicaArhiviranje;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogTroskovi;
import rs.pezar.proizvodnja.util.PzProizvodnjaUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.event.PzTablePropertyListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.renderers.PzDoubleCellRenderer;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzDialogIzradaPrijemnice
extends PzDialog {
    private static final String RESTORAN = "restoran";
    private static final long serialVersionUID = 1L;
    private PzPanelHeader header;
    private PzPanel mainPanel;
    private PzPanel pnlZaglavlje;
    private PzFieldIndikator indBrDokumenta;
    private PzFieldIndikator indSfrk;
    private PzDoubleField pdvIznos;
    private JLabel labelPDVIznos;
    private JTextField nazivDobavljaca;
    private JLabel labelBrutoIznos;
    private PzDoubleField troskovi;
    private PzDoubleField prodajna;
    private PzDoubleField nabavna;
    private PzPanel pnlRight;
    private JLabel labelKomitent;
    private JLabel labelDatDokumenta;
    private JLabel labelDatPrometa;
    private JLabel labelRabat;
    private JLabel labelDatValute;
    private PzTextField brDokumenta;
    private JComboBox tipDokumenta;
    private PzDoubleField kursEvra;
    private PzDoubleField procRabata;
    private PzDateField datValute;
    private PzDoubleField trosakBezPdv;
    private JLabel labelTrosak;
    private PzNumericOnlyTextField valuta;
    private JLabel labelValuta;
    private PzDateField datDPO;
    private PzDoubleField iznos;
    private PzNumericOnlyTextField sfrKomitent;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private JPanel pnlTable;
    private JPanel pnlIcons2;
    private PzToolBarIcon icnArhiva;
    private PzButton icnAzurPdv;
    private PzToolBarIcon icnProbnoListanje;
    private PzToolBarIcon icnAzurTroskova;
    private PzToolBarIcon icnAzurZaglavlja;
    private JPanel pnlIcons1;
    private JScrollPane scpIcons;
    private PzTable table;
    private JScrollPane scpArtikli;
    private JLabel labelTroskovi;
    private JLabel labelPlanska;
    private JLabel labelNabavna;
    private JPanel pnlSumarneVrednosti;
    private PzButton btnZaglavlje;
    private JSplitPane splitPane;
    private PzRadioGroup<PzChoice> pnlPDV;
    private JLabel labelBroj;
    private JLabel labelTip;
    private JLabel labelKurs;
    private PzDateField datDokumenta;
    private PzDateField datIzrade;
    private JLabel labelDatIzrade;
    private PzComponentGroup compGroupZaglavlje;
    private PzComponentGroup compGroupTable;
    private Kalkulacija kalkulacija;
    private Radnajedinica rj;
    private Radnajedinica rjPrenosnica;
    private PzTable tableKalk;
    private boolean izmena;
    private PzComponentGroup compGroupPDV;
    private String sfrKom;
    private Komitent komitent;
    private Artikalkalkulacija artdok;
    private JLabel lblIznosUValuti;
    private PzDoubleField tfIznosUValuti;
    private PzToolBarIcon icnNalog;
    private JLabel lblNijeObveznikPDV;
    private JLabel lblInoKomitent;
    private Short domaciKomitent;
    private String parameter;
    private String stranaValuta;
    private Kurs kurs;

    public PzDialogIzradaPrijemnice(PzDialog dialog) {
        super(dialog);
        this.tableKalk = (PzTable)this.getSession().getParameter("table");
        this.izmena = (Boolean)this.getSession().getParameter("update");
        this.parameter = (String)this.getSession().getParameter("parameter");
        this.kalkulacija = this.izmena ? (Kalkulacija)this.tableKalk.getSelectedEntity() : new Kalkulacija();
        this.initGUI();
        this.paintPanel();
        try {
            if (this.izmena) {
                this.fillDokument(this.tableKalk.getSelectedEntity());
                this.compGroupZaglavlje.disableAll();
                this.compGroupTable.enableAll();
                this.nazivDobavljaca.setText(this.kalkulacija.getKomitent().getNaziv());
                this.icnAzurPdv.setEnabled(true);
                this.calculatePDV();
                if (!this.kalkulacija.getPdv().equalsIgnoreCase("SA_PRAVOM")) {
                    this.compGroupPDV.hideAll();
                }
                if (this.kalkulacija.getPdv().equalsIgnoreCase("SA_PRAVOM") && (this.kalkulacija.getTaksakalkulacijas() == null || this.kalkulacija.getTaksakalkulacijas().size() == 0) && this.kalkulacija.getPodTip().equals(TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA) && !this.kalkulacija.getRadnajedinica().getgTip().equals("V")) {
                    this.compGroupTable.disableAll();
                }
                this.header.setText("RJ: " + this.kalkulacija.getRadnajedinica().getPunNaziv() + ", za korisnika " + PzExtensionLoader.getLoggedUser().getFullName());
                if (this.kalkulacija.getPodTip().equals(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA) || this.kalkulacija.getKomitent().getDomaciKomitent() == 0 || this.kalkulacija.getKomitent().getObveznikPDV() == 0) {
                    this.icnAzurPdv.setEnabled(false);
                    this.labelPDVIznos.setVisible(false);
                    this.pdvIznos.setVisible(false);
                    this.compGroupTable.enableAll();
                    this.pnlPDV.setVisible(false);
                }
                if (this.kalkulacija.getKomitent().getDomaciKomitent() != 1) {
                    this.lblIznosUValuti.setVisible(true);
                    this.tfIznosUValuti.setVisible(true);
                }
            } else {
                this.kalkulacija.setRadnajedinica(this.rj);
                this.enableButtons(false);
            }
            this.calculateTrosak((Vector)this.kalkulacija.getTrosaks());
            this.calculateSum((Vector)this.kalkulacija.getArtikalkalkulacijas());
            this.setFirstComponentInFocus((Component)this.sfrKomitent);
            this.stranaValuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
            this.lblIznosUValuti.setText("Iznos u valuti-" + this.stranaValuta);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void enableButtons(boolean enable) {
        this.icnArhiva.setEnabled(enable);
        this.icnAzurPdv.setEnabled(enable);
        this.icnProbnoListanje.setEnabled(enable);
        this.icnAzurTroskova.setEnabled(enable);
        this.icnNalog.setEnabled(enable);
        this.icnBrisanje.setEnabled(enable);
        this.icnIzmena.setEnabled(enable);
        this.icnDodavanje.setEnabled(enable);
    }

    private void fillDokument(PzEntity entity) {
        Kalkulacija dokument = (Kalkulacija)entity;
        this.datIzrade.setVal((Object)dokument.getDatum());
        this.brDokumenta.setVal((Object)dokument.getOznDokumenta());
        PzSwingUtility.setSelectedValue((Object)dokument.getPodTip(), (JComboBox)this.tipDokumenta);
        this.kursEvra.setVal((Object)dokument.getKurs());
        this.procRabata.setVal((Object)dokument.getProcRabata());
        this.datValute.setVal((Object)dokument.getDatValute());
        this.trosakBezPdv.setVal((Object)dokument.getTrosakBezPdv());
        this.datDPO.setVal((Object)dokument.getDatDPO());
        this.valuta.setVal((Object)PzDateUtility.subtract((Date)this.datValute.getVal(), (Date)this.datDPO.getVal()));
        this.iznos.setVal((Object)dokument.getIznos());
        this.sfrKomitent.setVal((Object)dokument.getKomitent().getSfrKomitent());
        this.domaciKomitent = dokument.getKomitent().getDomaciKomitent();
        if (this.domaciKomitent == 0) {
            this.lblInoKomitent.setVisible(true);
        } else if (dokument.getKomitent().getObveznikPDV() == 0) {
            this.lblNijeObveznikPDV.setVisible(true);
        }
        this.datDokumenta.setVal((Object)dokument.getDatFakture());
        for (PzChoice choice : this.pnlPDV.getValues()) {
            if (!choice.getValue().equals(dokument.getPdv())) continue;
            this.pnlPDV.setSelectedValue((Object)choice);
        }
        this.compGroupZaglavlje.disableAll();
        this.compGroupTable.enableAll();
        PzSwingUtility.setSelectedValue((Object)dokument.getTip(), (JComboBox)this.tipDokumenta);
        this.table.setData(this.kalkulacija.getArtikalkalkulacijas(), Artikalkalkulacija.class);
        this.table.getTableHeader().setFocusable(false);
        this.sfrKom = dokument.getKomitent().getSfrKomitent();
        this.pnlZaglavlje.updateAllFieldsState();
        this.getSession().putParameter("TRENUTNI_DOKUMENT", (Object)this.kalkulacija);
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_prijemnica.png")));
            this.header.setTitle("Izrada prijemnice repromaterijala");
            this.header.setOpaque(false);
            this.mainPanel.add((Component)this.header, (Object)"North");
            this.pnlRight = new PzPanel();
            this.pnlRight.setOpaque(false);
            GridBagLayout pnlTableLayout = new GridBagLayout();
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.columnWidths = new int[]{7};
            pnlTableLayout.rowWeights = new double[]{0.0, 0.0, 1.0};
            pnlTableLayout.rowHeights = new int[]{263, 62, 300};
            this.pnlRight.setLayout((LayoutManager)pnlTableLayout);
            this.pnlRight.setPreferredSize(new Dimension(792, 330));
            this.pnlZaglavlje = new PzPanel();
            this.pnlZaglavlje.setOpaque(false);
            this.pnlRight.add((Component)this.pnlZaglavlje, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlZaglavlje.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Zaglavlje", 4, 0));
            this.pnlZaglavlje.setLayout(null);
            this.pnlZaglavlje.setTransferFocusOnEnter(true);
            this.labelDatIzrade = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelDatIzrade, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelDatIzrade.setText("Datum izrade");
            this.labelDatIzrade.setBounds(18, 86, 109, 14);
            this.labelKomitent = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelKomitent, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelKomitent.setText("\u0160ifra dobavlja\u010da");
            this.labelKomitent.setBounds(18, 34, 109, 14);
            this.labelDatDokumenta = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelDatDokumenta, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelDatDokumenta.setText("Datum dokumenta");
            this.labelDatDokumenta.setBounds(322, 59, 124, 14);
            this.datIzrade = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datIzrade.setBounds(134, 80, 103, 25);
            this.datDokumenta = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datDokumenta, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datDokumenta.setBounds(457, 54, 109, 25);
            this.sfrKomitent = new PzNumericOnlyTextField();
            this.pnlZaglavlje.add((Component)this.sfrKomitent, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.sfrKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.sfrKomitent.setBounds(134, 28, 103, 25);
            this.sfrKomitent.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaPrijemnice.this.komitent.getDomaciKomitent() != 1) {
                        PzDialogIzradaPrijemnice.this.lblIznosUValuti.setVisible(true);
                        PzDialogIzradaPrijemnice.this.tfIznosUValuti.setVisible(true);
                    }
                    return true;
                }
            });
            this.iznos = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.iznos, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.iznos.setBounds(457, 132, 109, 25);
            this.labelDatPrometa = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelDatPrometa, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelDatPrometa.setText("Datum DPO");
            this.labelDatPrometa.setBounds(322, 85, 124, 14);
            this.datDPO = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datDPO, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datDPO.setBounds(457, 80, 109, 25);
            this.labelValuta = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelValuta, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.labelValuta.setText("Valuta");
            this.labelValuta.setBounds(630, 58, 128, 14);
            this.valuta = new PzNumericOnlyTextField();
            this.pnlZaglavlje.add((Component)this.valuta, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.valuta.setText("0");
            this.valuta.setBounds(766, 52, 102, 24);
            this.valuta.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    PzDialogIzradaPrijemnice.this.keyRel(evt);
                }
            });
            this.trosakBezPdv = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.trosakBezPdv, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.trosakBezPdv.setBounds(766, 78, 102, 24);
            this.trosakBezPdv.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        PzDialogIzradaPrijemnice.this.calculateTrosak((Vector)PzDialogIzradaPrijemnice.this.kalkulacija.getTrosaks());
                    }
                }
            });
            this.brDokumenta = new PzTextField(){

                public boolean entityExists() {
                    if (PzDialogIzradaPrijemnice.this.izmena && PzDialogIzradaPrijemnice.this.brDokumenta.getVal().equals(PzDialogIzradaPrijemnice.this.kalkulacija.getOznDokumenta())) {
                        return false;
                    }
                    String q = null;
                    q = PzDialogIzradaPrijemnice.this.tipDokumenta.getSelectedItem().toString().equals("Faktura") ? "SELECT k FROM Kalkulacija k WHERE k.arhiviran<>-1 and k.oznDokumenta = :brdok AND k.komitent = :komitent AND ((k.tip in :tipKalk AND k.podTip IN ('" + TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA + "', 'POCETNO')) OR k.tip ='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "'" + " OR k.tip = '" + TipDokumentConfig.get().TROSAK + "' OR k.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "')" : "SELECT k FROM Kalkulacija k WHERE k.arhiviran<>-1 and k.oznDokumenta = :brdok AND k.komitent = :komitent AND k.tip in (:tipKalk) AND k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "'";
                    EntityManager em = PzEntityManager.getEm();
                    Query query = em.createQuery(q).setParameter("brdok", (Object)PzDialogIzradaPrijemnice.this.brDokumenta.getVal()).setParameter("komitent", (Object)PzDialogIzradaPrijemnice.this.komitent).setParameter("tipKalk", Arrays.asList(TipDokumentConfig.get().KALKULACIJA, TipDokumentConfig.get().PRIJEMNICA_REPRO));
                    Vector result = (Vector)query.getResultList();
                    em.clear();
                    em.close();
                    return result.size() > 0;
                }
            };
            this.brDokumenta.setMsgEntityExists("Ra\u010dun dobavlja\u010da sa izabranim brojem ve\u0107 postoji u bazi. Molim izaberite drugi broj dokumenta.");
            this.brDokumenta.setMsgEmptyField("Polje sa brojem dokumenta ne mo\u017ee ostati prazno.");
            this.pnlZaglavlje.add((Component)this.brDokumenta, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setBounds(134, 54, 158, 25);
            this.brDokumenta.setPKField(Kalkulacija.class, null);
            this.brDokumenta.setToUpperCase(true);
            this.brDokumenta.setMaxLength(30);
            this.datValute = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datValute, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datValute.setBounds(134, 106, 103, 25);
            this.datValute.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    PzDialogIzradaPrijemnice.this.keyRel(evt);
                }
            });
            this.procRabata = new PzDoubleField();
            this.procRabata.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
            this.pnlZaglavlje.add((Component)this.procRabata, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.procRabata.setBounds(457, 106, 109, 24);
            this.procRabata.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    int rez;
                    if (PzDialogIzradaPrijemnice.this.procRabata.getBigDecimal().compareTo(BDConverter.getProcRabata((double)PzDialogIzradaPrijemnice.this.kalkulacija.getProcRabata())) != 0 && (rez = PzSwingUtility.daNeDijalog((Component)((Object)PzDialogIzradaPrijemnice.this), (Object)"Da li \u017eelite da prea\u017eurirate sve stavke novim procentom rabata?", (String)"Novi procenat rabata", null, (boolean)true)) == 0) {
                        PzDialogIzradaPrijemnice.this.azurirajRabatNaStavkama();
                    }
                    return true;
                }
            });
            this.kursEvra = new PzDoubleField();
            this.kursEvra.setDecimalFormat(PzFormatFactory.getKursFormat());
            this.pnlZaglavlje.add((Component)this.kursEvra, (Object)new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.kursEvra.setBounds(766, 103, 102, 24);
            this.kursEvra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaPrijemnice.this.komitent.getDomaciKomitent() == 0 && PzDialogIzradaPrijemnice.this.kursEvra.getVal() == 0.0) {
                        PzSwingUtility.showErrorMessage((Component)PzDialogIzradaPrijemnice.this.kursEvra, (String)"Kurs evra je nelogi\u010dan.");
                        return false;
                    }
                    return true;
                }
            });
            this.tipDokumenta = new JComboBox();
            this.pnlZaglavlje.add((Component)this.tipDokumenta, (Object)new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tipDokumenta.setBounds(766, 26, 102, 25);
            this.tipDokumenta.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    PzDialogIzradaPrijemnice.this.tipDokumentaItemStateChanged(evt);
                }
            });
            this.tipDokumenta.addItem(new PzChoice("Faktura", (Object)TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA));
            this.tipDokumenta.addItem(new PzChoice("Otpremnica", (Object)TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA));
            this.labelDatValute = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelDatValute, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelDatValute.setText("Datum valute");
            this.labelDatValute.setBounds(18, 112, 109, 14);
            this.labelRabat = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelRabat, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.labelRabat.setText("% rabata");
            this.labelRabat.setBounds(322, 110, 98, 14);
            this.labelKurs = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelKurs, (Object)new GridBagConstraints(4, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.labelKurs.setText("Kurs evra");
            this.labelKurs.setBounds(630, 110, 124, 14);
            this.labelTip = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelTip, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelTip.setText("Tip dokumenta");
            this.labelTip.setBounds(630, 32, 109, 14);
            this.labelBroj = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelBroj, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.labelBroj.setText("Broj dokumenta");
            this.labelBroj.setBounds(18, 60, 109, 14);
            this.pnlPDV = new PzRadioGroup((Object[])new PzChoice[]{new PzChoice("Sa pravom na odbitak", (Object)"SA_PRAVOM"), new PzChoice("Bez prava na odbitak", (Object)"BEZ_PRAVA"), new PzChoice("Oslobo\u0111eno PDV-a", (Object)"OSLOBODJENO")});
            this.pnlPDV.setOpaque(false);
            this.pnlPDV.setSelectedIndex(0);
            this.pnlPDV.setLayoutAxis(1);
            this.pnlZaglavlje.add(this.pnlPDV);
            this.pnlPDV.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "PDV", 4, 0));
            this.pnlPDV.setBounds(18, 160, 225, 91);
            this.pnlPDV.addRadioGroupListener(this.getRadioGroupListener());
            this.btnZaglavlje = new PzButton();
            this.pnlZaglavlje.add((Component)this.btnZaglavlje);
            this.btnZaglavlje.setText("Snimi zaglavlje");
            this.btnZaglavlje.setBounds(286, 167, 149, 33);
            this.btnZaglavlje.setActionCommand("snimi_zaglavlje");
            this.btnZaglavlje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnZaglavlje.addActionListener((ActionListener)((Object)this));
            this.labelBrutoIznos = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelBrutoIznos);
            this.labelBrutoIznos.setText("Bruto iznos");
            this.labelBrutoIznos.setBounds(322, 138, 98, 14);
            this.nazivDobavljaca = new JTextField();
            this.pnlZaglavlje.add((Component)this.nazivDobavljaca);
            this.nazivDobavljaca.setBounds(259, 27, 307, 25);
            this.nazivDobavljaca.setEditable(false);
            this.nazivDobavljaca.setFocusable(false);
            this.compGroupPDV = new PzComponentGroup();
            this.icnAzurPdv = new PzButton();
            this.compGroupPDV.add((Component)this.icnAzurPdv);
            this.pnlZaglavlje.add((Component)this.icnAzurPdv);
            this.icnAzurPdv.setText("A\u017euriranje|PDV-a|(F8)");
            this.icnAzurPdv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/pdv_edit.png")));
            this.icnAzurPdv.setActionCommand("PzDialogPDV");
            this.icnAzurPdv.addActionListener((ActionListener)((Object)this));
            this.icnAzurPdv.setShortcut("f8");
            this.icnAzurPdv.setBounds(286, 200, 149, 46);
            this.labelPDVIznos = new JLabel();
            this.compGroupPDV.add((Component)this.labelPDVIznos);
            this.pnlZaglavlje.add((Component)this.labelPDVIznos);
            this.labelPDVIznos.setText("Iznos PDV-a:");
            this.labelPDVIznos.setBounds(469, 191, 111, 26);
            this.labelPDVIznos.setFont(new Font("Tahoma", 1, 16));
            this.labelPDVIznos.setForeground(new Color(128, 0, 0));
            this.pdvIznos = new PzDoubleField();
            this.compGroupPDV.add((Component)this.pdvIznos);
            this.pnlZaglavlje.add((Component)this.pdvIznos);
            this.pdvIznos.setBounds(580, 191, 168, 26);
            this.pdvIznos.setEditable(false);
            this.pdvIznos.setFocusable(false);
            this.pdvIznos.setForeground(new Color(0, 0, 128));
            this.pdvIznos.setFont(new Font("Tahoma", 1, 16));
            this.indSfrk = new PzFieldIndikator();
            this.pnlZaglavlje.add((Component)this.indSfrk);
            this.indSfrk.setBounds(239, 32, 16, 16);
            this.indBrDokumenta = new PzFieldIndikator();
            this.pnlZaglavlje.add((Component)this.indBrDokumenta);
            this.indBrDokumenta.setBounds(296, 59, 16, 16);
            this.lblInoKomitent = new JLabel();
            this.pnlZaglavlje.add((Component)this.lblInoKomitent);
            this.lblInoKomitent.setBounds(469, 191, 279, 26);
            this.lblInoKomitent.setName("lblInoKomitent");
            this.lblInoKomitent.setVisible(false);
            this.lblNijeObveznikPDV = new JLabel();
            this.pnlZaglavlje.add((Component)this.lblNijeObveznikPDV);
            this.lblNijeObveznikPDV.setBounds(469, 191, 279, 24);
            this.lblNijeObveznikPDV.setName("lblNijeObveznikPDV");
            this.lblNijeObveznikPDV.setVisible(false);
            this.labelTrosak = new JLabel();
            this.pnlZaglavlje.add((Component)this.labelTrosak);
            this.labelTrosak.setBounds(630, 84, 124, 12);
            this.labelTrosak.setText("Tro\u0161ak");
            this.tfIznosUValuti = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.tfIznosUValuti);
            this.tfIznosUValuti.setBounds(134, 132, 103, 25);
            this.tfIznosUValuti.setVisible(false);
            this.tfIznosUValuti.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaPrijemnice.this.tfIznosUValuti.getVal() != 0.0 && PzDialogIzradaPrijemnice.this.kursEvra.getVal() != 0.0) {
                        PzDialogIzradaPrijemnice.this.iznos.setVal((Object)(PzDialogIzradaPrijemnice.this.tfIznosUValuti.getVal() * PzDialogIzradaPrijemnice.this.kursEvra.getVal()));
                    }
                    return true;
                }
            });
            this.lblIznosUValuti = new JLabel();
            this.pnlZaglavlje.add((Component)this.lblIznosUValuti);
            this.lblIznosUValuti.setBounds(18, 136, 98, 18);
            this.lblIznosUValuti.setName("lblIznosUValuti");
            this.lblIznosUValuti.setVisible(false);
            this.pnlSumarneVrednosti = new JPanel();
            this.pnlSumarneVrednosti.setOpaque(false);
            FlowLayout pnlSumarneVrednostiLayout = new FlowLayout();
            pnlSumarneVrednostiLayout.setHgap(5);
            this.pnlSumarneVrednosti.setLayout(pnlSumarneVrednostiLayout);
            this.pnlRight.add((Component)this.pnlSumarneVrednosti, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlSumarneVrednosti.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Sumarne vrednosti", 4, 0));
            this.labelNabavna = new JLabel();
            this.pnlSumarneVrednosti.add(this.labelNabavna);
            this.labelNabavna.setText("Nabavna:");
            this.labelNabavna.setHorizontalAlignment(4);
            this.labelNabavna.setFont(new Font("Tahoma", 1, 16));
            this.nabavna = new PzDoubleField();
            this.pnlSumarneVrednosti.add((Component)this.nabavna);
            this.nabavna.setEditable(false);
            this.nabavna.setPreferredSize(new Dimension(150, 25));
            this.nabavna.setFont(new Font("Tahoma", 1, 14));
            this.nabavna.setForeground(new Color(0, 0, 255));
            this.nabavna.setSize(150, 25);
            this.nabavna.setFocusable(false);
            this.labelPlanska = new JLabel();
            this.pnlSumarneVrednosti.add(this.labelPlanska);
            this.labelPlanska.setText("Planska:");
            this.labelPlanska.setFont(new Font("Tahoma", 1, 16));
            this.labelPlanska.setPreferredSize(new Dimension(90, 14));
            this.labelPlanska.setHorizontalAlignment(4);
            this.prodajna = new PzDoubleField();
            this.pnlSumarneVrednosti.add((Component)this.prodajna);
            this.prodajna.setEditable(false);
            this.prodajna.setEnabled(true);
            this.prodajna.setPreferredSize(new Dimension(150, 25));
            this.prodajna.setFont(new Font("Tahoma", 1, 14));
            this.prodajna.setForeground(new Color(0, 0, 255));
            this.prodajna.setSize(150, 25);
            this.prodajna.setFocusable(false);
            this.labelTroskovi = new JLabel();
            this.labelTroskovi.setHorizontalAlignment(4);
            this.pnlSumarneVrednosti.add(this.labelTroskovi);
            this.labelTroskovi.setText("Tro\u0161kovi:");
            this.labelTroskovi.setFont(new Font("Tahoma", 1, 16));
            this.labelTroskovi.setPreferredSize(new Dimension(90, 14));
            this.troskovi = new PzDoubleField();
            this.pnlSumarneVrednosti.add((Component)this.troskovi);
            this.troskovi.setEditable(false);
            this.troskovi.setEnabled(true);
            this.troskovi.setPreferredSize(new Dimension(150, 25));
            this.troskovi.setFont(new Font("Tahoma", 1, 14));
            this.troskovi.setForeground(new Color(0, 0, 255));
            this.troskovi.setSize(150, 25);
            this.troskovi.setFocusable(false);
            this.pnlTable = new JPanel();
            this.pnlTable.setOpaque(false);
            GridBagLayout pnlTableLayout1 = new GridBagLayout();
            this.pnlRight.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlTableLayout1.rowWeights = new double[]{0.1, 0.0};
            pnlTableLayout1.rowHeights = new int[]{150, 7};
            pnlTableLayout1.columnWeights = new double[]{0.1};
            pnlTableLayout1.columnWidths = new int[]{7};
            this.pnlTable.setLayout(pnlTableLayout1);
            this.pnlTable.setBackground(new Color(192, 192, 192));
            this.pnlTable.setBorder(BorderFactory.createEtchedBorder(1));
            this.scpArtikli = new JScrollPane();
            this.pnlTable.add((Component)this.scpArtikli, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.table = new PzTable();
            this.table.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Artikalkalkulacija ak = (Artikalkalkulacija)entity;
                    return new Object[]{ak.getId().getSfrProizvod(), ak.getNaziv(), ak.getJm(), ak.getKolicina(), ak.getFakturnaCena(), ak.getProcRabata(), ak.getProdCena()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Fakturna cena", "% rabata", "Planska cena"};
                }
            });
            this.scpArtikli.setViewportView((Component)this.table);
            this.table.setPropertyListener(new PzTablePropertyListener(){

                public void entityRemoved(PzEntity entity) {
                    PzDialogIzradaPrijemnice.this.calculateSum((Vector)PzDialogIzradaPrijemnice.this.kalkulacija.getArtikalkalkulacijas());
                }

                public void entityAdded(PzEntity entity) {
                    PzDialogIzradaPrijemnice.this.calculateSum((Vector)PzDialogIzradaPrijemnice.this.kalkulacija.getArtikalkalkulacijas());
                }
            });
            this.table.getColumn(5).setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKursFormat()));
            this.table.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaPrijemnice.this.showDialogDodavanje();
                }
            });
            this.pnlIcons2 = new JPanel();
            this.pnlIcons2.setOpaque(false);
            FlowLayout pnlIcons2Layout = new FlowLayout();
            pnlIcons2Layout.setAlignment(0);
            pnlIcons2Layout.setHgap(5);
            this.pnlIcons2.setLayout(pnlIcons2Layout);
            this.pnlTable.add((Component)this.pnlIcons2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlIcons2.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.pnlIcons2.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(Insert)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_add_small.png")));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnDodavanje.setPreferredSize(new Dimension(70, 70));
            this.icnIzmena = new PzToolBarIcon();
            this.pnlIcons2.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit_small.png")));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnIzmena.setPreferredSize(new Dimension(70, 70));
            this.icnBrisanje = new PzToolBarIcon();
            this.pnlIcons2.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_delete_small.png")));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(70, 70));
            this.scpIcons = new JScrollPane();
            this.splitPane = new JSplitPane();
            this.splitPane.setEnabled(false);
            this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0, false), "ENTER");
            this.splitPane.add((Component)this.pnlRight, "right");
            this.splitPane.add((Component)this.scpIcons, "left");
            this.splitPane.setOpaque(false);
            this.scpIcons.setOpaque(false);
            this.scpIcons.getVerticalScrollBar().setFocusable(false);
            this.pnlIcons1 = new JPanel();
            this.pnlIcons1.setOpaque(false);
            this.scpIcons.setViewportView(this.pnlIcons1);
            this.pnlIcons1.setPreferredSize(new Dimension(40, 400));
            this.icnAzurZaglavlja = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnAzurZaglavlja);
            this.icnAzurZaglavlja.setText("A\u017eiriranje|zaglavlja|(F4)");
            this.icnAzurZaglavlja.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_header.png")));
            this.icnAzurZaglavlja.setActionCommand("azuriraj_zaglavlje");
            this.icnAzurZaglavlja.addActionListener((ActionListener)((Object)this));
            this.icnAzurZaglavlja.setShortcut("f4");
            this.icnAzurZaglavlja.setPreferredSize(new Dimension(60, 100));
            this.icnAzurTroskova = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnAzurTroskova);
            this.icnAzurTroskova.setText("A\u017euriranje|tro\u0161kova|(F5)");
            this.icnAzurTroskova.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/money_envelope.png")));
            this.icnAzurTroskova.setActionCommand("troskovi");
            this.icnAzurTroskova.addActionListener((ActionListener)((Object)this));
            this.icnAzurTroskova.setShortcut("F5");
            this.icnAzurTroskova.setPreferredSize(new Dimension(60, 100));
            this.icnProbnoListanje = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnProbnoListanje);
            this.icnProbnoListanje.setText("Probno|listanje|(F7)");
            this.icnProbnoListanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/documents.png")));
            this.icnProbnoListanje.setActionCommand("listanje");
            this.icnProbnoListanje.addActionListener((ActionListener)((Object)this));
            this.icnProbnoListanje.setShortcut("F7");
            this.icnProbnoListanje.setPreferredSize(new Dimension(60, 100));
            this.icnNalog = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnNalog);
            this.icnNalog.setText("Po\u0161alji|nalog|(ALT+F4)");
            this.icnNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/briefcase2_document.png")));
            this.icnNalog.addActionListener((ActionListener)((Object)this));
            this.icnNalog.setActionCommand("nalog");
            this.icnNalog.setShortcut("alt+f4");
            this.icnNalog.setPreferredSize(new Dimension(60, 100));
            this.icnArhiva = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|i \u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/printer_preferences.png")));
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.setShortcut("ctrl+w");
            this.icnArhiva.setPreferredSize(new Dimension(60, 100));
            this.splitPane.setOpaque(false);
            this.mainPanel.add((Component)this.splitPane, (Object)"Center");
            this.splitPane.setDividerLocation(70);
            this.compGroupZaglavlje = new PzComponentGroup();
            this.compGroupZaglavlje.add(this.pnlZaglavlje.getComponents());
            this.compGroupTable = new PzComponentGroup();
            this.compGroupTable.add(this.pnlTable.getComponents());
            this.compGroupTable.disableAll();
            this.sfrKomitent.setStateIndikator(this.indSfrk);
            this.brDokumenta.setStateIndikator(this.indBrDokumenta);
            this.iznos.setName("iznos");
            this.setSize(1024, 768);
            this.setMinimumSize(new Dimension(1000, 670));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void azurirajRabatNaStavkama() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PzDialogIzradaPrijemnice.this.kalkulacija != null && PzDialogIzradaPrijemnice.this.kalkulacija.getArtikalkalkulacijas() != null) {
                    for (Artikalkalkulacija ak : PzDialogIzradaPrijemnice.this.kalkulacija.getArtikalkalkulacijas()) {
                        ak.setProcRabata(PzDialogIzradaPrijemnice.this.procRabata.getVal().doubleValue());
                    }
                    PzDialogIzradaPrijemnice.this.table.refreshData();
                }
            }
        });
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzradaPrijemnice(Boolean.FALSE);
    }

    public PzDialogIzradaPrijemnice(Boolean initGUI) {
    }

    private PzRadioGroupListener getRadioGroupListener() {
        return new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                if (evt.getStateChange() != 1) {
                    return;
                }
                if (((PzChoice)evt.getValue()).getValue().equals("SA_PRAVOM")) {
                    PzDialogIzradaPrijemnice.this.compGroupPDV.showAll();
                    return;
                }
                if (((PzChoice)evt.getValue()).getValue().equals("BEZ_PRAVA")) {
                    if (PzDialogIzradaPrijemnice.this.kalkulacija.getTaksakalkulacijas() != null && PzDialogIzradaPrijemnice.this.kalkulacija.getTaksakalkulacijas().size() > 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogIzradaPrijemnice.this), (String)"Da biste izabrali ovu opciju morate prethodno ukloniti PDV sa kalkulacije.");
                        PzDialogIzradaPrijemnice.this.pnlPDV.setSelectedIndex(0);
                    } else {
                        PzDialogIzradaPrijemnice.this.compGroupPDV.hideAll();
                    }
                    return;
                }
                if (((PzChoice)evt.getValue()).getValue().equals("OSLOBODJENO")) {
                    if (PzDialogIzradaPrijemnice.this.kalkulacija.getTaksakalkulacijas() != null && PzDialogIzradaPrijemnice.this.kalkulacija.getTaksakalkulacijas().size() > 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogIzradaPrijemnice.this), (String)"Da biste izabrali ovu opciju morate prethodno ukloniti PDV sa kalkulacije.");
                        PzDialogIzradaPrijemnice.this.pnlPDV.setSelectedIndex(0);
                    } else {
                        PzDialogIzradaPrijemnice.this.compGroupPDV.hideAll();
                    }
                    return;
                }
            }
        };
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((AbstractButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("brisanje")) {
                if (this.table.getSelectedEntity() != null) {
                    this.table.removeSelectedEntity(true, true);
                    return;
                }
                return;
            }
            if (actionCommand.equals("snimi_zaglavlje")) {
                if (this.sfrKomitent.getVal().equals("") || this.brDokumenta.getVal().equals("")) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Pre snimanja zaglavlja morate uneti vrednosti u obavezna polja.");
                    return;
                }
                if (this.sfrKom == null) {
                    this.sfrKom = this.sfrKomitent.getVal();
                }
                this.saveDokument();
                if (!this.pdvIznos.getVal().equals(0.0)) {
                    this.compGroupTable.enableAll();
                }
                this.enableButtons(true);
                if (this.kalkulacija.getPodTip().equals(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA) || this.kalkulacija.getPodTip().equals(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA) || this.kalkulacija.getKomitent().getDomaciKomitent() == 0 || this.kalkulacija.getKomitent().getObveznikPDV() == 0) {
                    this.icnAzurPdv.setEnabled(false);
                    this.labelPDVIznos.setVisible(false);
                    this.pdvIznos.setVisible(false);
                    this.compGroupTable.enableAll();
                    this.pnlPDV.setVisible(false);
                }
                if (this.pnlPDV.getSelectedIndex() == 1 || this.pnlPDV.getSelectedIndex() == 2) {
                    this.compGroupTable.enableAll();
                }
                return;
            }
            if (actionCommand.equals("azuriraj_zaglavlje")) {
                this.compGroupZaglavlje.enableAll();
                this.compGroupTable.disableAll();
                if (!this.tipDokumenta.getSelectedItem().toString().equals("Faktura")) {
                    this.trosakBezPdv.setEnabled(false);
                }
                if (this.kalkulacija.getId() > 0) {
                    this.izmena = true;
                }
                this.sfrKomitent.requestFocus();
                this.enableButtons(false);
                return;
            }
            if (actionCommand.equals("Izmena")) {
                if (this.table.getSelectedEntity() != null) {
                    this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                    this.getSession().putParameter("update", (Object)true);
                    this.getSession().putParameter("table", (Object)this.table);
                    this.showDialog(Dodavanje.class);
                }
            } else if (actionCommand.equals("Dodavanje")) {
                this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("table", (Object)this.table);
                this.showDialog(Dodavanje.class);
            } else {
                if (actionCommand.equals("listanje")) {
                    this.listanje(this.nabavna.getBigDecimal());
                    return;
                }
                if (actionCommand.equals("troskovi")) {
                    this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                    this.showDialog(PzDialogTroskovi.class);
                    this.calculateTrosak((Vector)this.kalkulacija.getTrosaks());
                    return;
                }
                if (actionCommand.equals("arhiva")) {
                    if (PzParameter.getBoolean((String)"NALOG_ZA_PRIJEM_OBAVEZAN", (boolean)false).booleanValue()) {
                        if (this.kalkulacija.getDokument().getNalogprijems() == null || this.kalkulacija.getDokument().getNalogprijems().size() == 0) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "Da biste arhivirali prijemnicu prvo morate poslati nalog magacinu da primi robu!", "Obave\u0161tenje", 1);
                            return;
                        }
                        if (((Nalogprijem)this.kalkulacija.getDokument().getNalogprijems().get(0)).getStatus() != 2) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "Roba jo\u0161 uvek nije spakovana u magacin. Ne mo\u017eete arhivirati prijemnicu pre nego se roba spakuje!", "Obave\u0161tenje", 1);
                            return;
                        }
                    }
                    if (this.kalkulacija.getArtikalkalkulacijas() == null || this.kalkulacija.getArtikalkalkulacijas().size() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Ne mo\u017eete arhivirati prijemnicu jer nije uneta nijedna stavka!", "Obave\u0161tenje", 1);
                        return;
                    }
                    this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                    this.getSession().putParameter("iznos_dokumenta", (Object)this.iznos.getVal());
                    this.getSession().putParameter("nabavna", (Object)this.nabavna.getVal());
                    this.showDialog(PzDialogPrijemnicaArhiviranje.class);
                    return;
                }
                if (actionCommand.equalsIgnoreCase("PzDialogPDV")) {
                    this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                    this.getSession().putParameter("storno", (Object)false);
                    this.showDialog(PzDialogPDV.class);
                    return;
                }
                if (actionCommand.equalsIgnoreCase("nalog")) {
                    if (this.kalkulacija.getDokument().getNalogprijems() != null && this.kalkulacija.getDokument().getNalogprijems().size() > 0) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Ve\u0107 je izdat jedan nalog magacinu za prijem robe. Ne mo\u017eete izdati dva!", "Obave\u0161tenje", 1);
                        return;
                    }
                    if (this.kalkulacija.getArtikalDocuments() == null || this.kalkulacija.getArtikalDocuments().size() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Nema podataka za izradu naloga!", "Obave\u0161tenje", 1);
                        return;
                    }
                    this.getSession().putParameter("kalkulacija_nalog", (Object)this.kalkulacija);
                    this.showDialog(PosaljiNalogZaPrijem.class);
                    return;
                }
            }
            this.table.scrollRowToVisible(this.table.getSelectedRow());
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void showDialogDodavanje() {
        this.icnDodavanje.doClick();
    }

    private void saveDokument() throws Exception {
        if (this.kalkulacija != null && this.kalkulacija.getTaksakalkulacijas() != null && this.kalkulacija.getTaksakalkulacijas().size() > 0 && (this.komitent.getDomaciKomitent() == 0 || this.komitent.getObveznikPDV() == 0)) {
            int option = JOptionPane.showConfirmDialog((Component)((Object)this), "Izabrali ste komitenta koji nije u sistemu PDV-a, a na prijemnici postoji porez. \nUkoliko nastavite porez \u0107e biti uklonjen sa prijemnice prilikom snimanja zaglavlja. \nDa li \u017eelite da nastavite?", "Postoji porez", 0);
            if (option == 0) {
                this.kalkulacija.setTaksakalkulacijas(new Vector());
                this.calculatePDV();
            } else {
                return;
            }
        }
        if (this.kalkulacija == null) {
            this.kalkulacija = new Kalkulacija();
        }
        this.calculateTrosak((Vector)this.kalkulacija.getTrosaks());
        this.kalkulacija.setOznDokumenta(this.brDokumenta.getVal());
        this.kalkulacija.setDatFakture(this.datDokumenta.getVal());
        this.kalkulacija.setKurs(this.kursEvra.getVal().doubleValue());
        this.kalkulacija.setDatum(this.datIzrade.getVal());
        this.kalkulacija.setDatDPO(this.datDPO.getVal());
        this.kalkulacija.setDatValute(this.datValute.getVal());
        this.kalkulacija.setIznos(this.iznos.getBigDecimal());
        if (this.komitent.getDomaciKomitent() == 0) {
            this.kalkulacija.setPdv("INO");
        } else if (this.komitent.getObveznikPDV() == 0 && this.komitent.getSrbija() == 1) {
            this.kalkulacija.setPdv("NIJE_OBVEZNIK");
        } else if (this.komitent.getObveznikPDV() == 0 && this.komitent.getSrbija() == 0) {
            this.kalkulacija.setPdv("KOSOVO");
        } else {
            this.kalkulacija.setPdv((String)((PzChoice)this.pnlPDV.getSelectedValue()).getValue());
        }
        this.kalkulacija.setProcRabata(this.procRabata.getVal().doubleValue());
        this.kalkulacija.setTrosakBezPdv(this.trosakBezPdv.getBigDecimal());
        this.kalkulacija.setArhiviran((short)0);
        this.kalkulacija.setPoruka("");
        this.kalkulacija.setPodTip((String)((PzChoice)this.tipDokumenta.getSelectedItem()).getValue());
        this.kalkulacija.setKomitent(this.komitent);
        this.calculateSum((Vector)this.kalkulacija.getArtikalkalkulacijas());
        this.domaciKomitent = this.komitent.getDomaciKomitent();
        if (!this.izmena) {
            this.kalkulacija.setTip(TipDokumentConfig.get().PRIJEMNICA_REPRO);
            this.kalkulacija.setRadnajedinica(this.rj);
            if (this.tableKalk.insert((PzEntity)this.kalkulacija, true)) {
                this.compGroupZaglavlje.disableAll();
                this.compGroupPDV.enableAll();
                if (this.komitent.getDomaciKomitent() == 0) {
                    this.compGroupTable.enableAll();
                    this.compGroupPDV.disableAll();
                }
            }
            this.table.setData(this.kalkulacija.getArtikalkalkulacijas(), Artikalkalkulacija.class);
        } else if (this.tableKalk.updateSelectedEntity((PzEntity)this.kalkulacija, true)) {
            this.domaciKomitent = this.kalkulacija.getKomitent().getDomaciKomitent();
            this.compGroupZaglavlje.disableAll();
            this.compGroupPDV.enableAll();
            if (this.komitent.getDomaciKomitent() == 0) {
                this.compGroupTable.enableAll();
                this.compGroupPDV.disableAll();
            }
        }
        this.getSession().putParameter("TRENUTNI_DOKUMENT", (Object)this.kalkulacija);
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
        this.pnlZaglavlje.updateAllFieldsState();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            ((PzFieldImpl)component).setVal((Object)((Komitent)entity).getSfrKomitent());
            this.nazivDobavljaca.setText(((Komitent)entity).getNaziv());
            this.komitent = (Komitent)entity;
            int selIndex = this.tipDokumenta.getSelectedIndex();
            if (this.komitent.getDomaciKomitent() == 0 || this.komitent.getObveznikPDV() == 0 || selIndex != 0) {
                this.pnlPDV.setVisible(false);
                this.labelPDVIznos.setVisible(false);
                this.pdvIznos.setVisible(false);
                this.lblNijeObveznikPDV.setVisible(false);
                this.lblInoKomitent.setVisible(false);
                if (this.komitent.getDomaciKomitent() == 0) {
                    this.lblInoKomitent.setVisible(true);
                    this.lblNijeObveznikPDV.setVisible(false);
                } else if (this.komitent.getObveznikPDV() == 0) {
                    this.lblInoKomitent.setVisible(false);
                    this.lblNijeObveznikPDV.setVisible(true);
                }
            } else {
                this.pnlPDV.setVisible(true);
                this.labelPDVIznos.setVisible(true);
                this.pdvIznos.setVisible(true);
                this.lblInoKomitent.setVisible(false);
                this.lblNijeObveznikPDV.setVisible(false);
            }
            this.domaciKomitent = this.komitent.getDomaciKomitent();
        }
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    private void tipDokumentaItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        PzChoice choice = (PzChoice)evt.getItem();
        if (this.pnlPDV != null) {
            if (choice.getValue().equals("FAKTURA")) {
                this.pnlPDV.setVisible(true);
                this.pnlPDV.setFocusable(true);
                this.trosakBezPdv.setEnabled(true);
                this.icnAzurPdv.setEnabled(true);
                this.labelPDVIznos.setVisible(true);
                this.pdvIznos.setVisible(true);
            } else {
                this.pnlPDV.setVisible(false);
                this.pnlPDV.setFocusable(false);
                this.trosakBezPdv.setEnabled(false);
                this.icnAzurPdv.setEnabled(false);
                this.labelPDVIznos.setVisible(false);
                this.pdvIznos.setVisible(false);
            }
        }
    }

    private void keyRel(KeyEvent evt) {
        int val = this.valuta.getIntVal();
        Date date1 = this.datDokumenta.getVal();
        if (evt.getSource() == this.valuta) {
            this.datValute.setVal((Object)PzDateUtility.add((Date)date1, (int)val));
        } else {
            this.valuta.setVal((Object)PzDateUtility.subtract((Date)this.datValute.getVal(), (Date)this.datDokumenta.getVal()));
        }
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            this.rj = this.kalkulacija.getRadnajedinica();
            return true;
        }
        boolean result = false;
        this.rj = this.parameter.equals(RESTORAN) ? PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"SR"}) : PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"S"});
        if (this.rj != null) {
            result = true;
        }
        return result;
    }

    private void calculateSum(Vector<Artikalkalkulacija> art) {
        BigDecimal nabSum = this.trosakBezPdv.getBigDecimal().add(this.pdvIznos.getBigDecimal());
        BigDecimal prodSum = new BigDecimal(0);
        if (art != null) {
            for (Artikalkalkulacija a : art) {
                BigDecimal fakturnaCena = BDConverter.getFakturnaCena((double)a.getFakturnaCena());
                BigDecimal kolicina = BDConverter.getKolicina((double)a.getKolicina());
                BigDecimal fakturnaVrednost = fakturnaCena.multiply(kolicina);
                BigDecimal procRabata = BDConverter.getProcRabata100((double)a.getProcRabata());
                BigDecimal vredRabata = BDConverter.getIznos((BigDecimal)fakturnaVrednost.multiply(procRabata));
                BigDecimal nabVred = BDConverter.getIznos((BigDecimal)fakturnaVrednost.subtract(vredRabata));
                nabSum = nabSum.add(nabVred);
                prodSum = prodSum.add(BDConverter.getIznos((double)(a.getKolicina() * a.getProdCena().doubleValue())));
            }
        }
        this.nabavna.setVal((Object)nabSum);
        this.prodajna.setVal((Object)prodSum);
    }

    public void calculateTrosak(Vector<Trosak> vector) {
        BigDecimal trSum = this.trosakBezPdv.getBigDecimal();
        if (vector != null) {
            for (Trosak t : vector) {
                trSum = trSum.add(t.getOsnovica());
                trSum = trSum.add(t.getBezPrava());
                trSum = trSum.add(t.getOslobodjeno());
            }
        }
        this.troskovi.setVal((Object)trSum);
    }

    public double getTrosak() {
        return this.troskovi.getVal();
    }

    public double getIznos() {
        return this.iznos.getVal();
    }

    public double getPDV() {
        return this.pdvIznos.getVal();
    }

    public Short getDomaciKomitent() {
        return this.domaciKomitent;
    }

    public double getKursEvra() {
        return this.kursEvra.getVal();
    }

    public double getNabavna() {
        return this.nabavna.getVal();
    }

    public void calculatePDV() {
        BigDecimal pdvSum = new BigDecimal(0.0);
        if (this.kalkulacija.getTaksakalkulacijas() != null) {
            for (Taksakalkulacija pdv : this.kalkulacija.getTaksakalkulacijas()) {
                if (!pdv.getVrsta().equals("PDV")) continue;
                pdvSum = pdvSum.add(pdv.getIznos());
            }
        }
        this.pdvIznos.setVal((Object)pdvSum);
        this.calculateSum((Vector)this.kalkulacija.getArtikalkalkulacijas());
    }

    public PzComponentGroup getTableGroup() {
        return this.compGroupTable;
    }

    public String getPdvChoice() {
        return (String)((PzChoice)this.pnlPDV.getSelectedValue()).getValue();
    }

    public double getRabat() {
        return this.procRabata.getVal();
    }

    private void listanje(BigDecimal iznos) {
        if (this.kalkulacija.getArtikalkalkulacijas() == null || this.kalkulacija.getArtikalkalkulacijas().size() == 0) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Prijemnica ne sadr\u017ei stavke.");
            return;
        }
        this.kalkulacija.setIznos(iznos);
        this.kalkulacija.setProdVrednost(this.prodajna.getBigDecimal());
        this.kalkulacija.setRazlUCeni(PzProizvodnjaUtil.getRazlikaUCeni(this.kalkulacija));
        this.kalkulacija.setZaokruzenje(iznos.subtract(this.nabavna.getBigDecimal()));
        this.kalkulacija.setTrosakBezPdv(this.trosakBezPdv.getBigDecimal());
        this.sumirajTroskove(this.kalkulacija, null);
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.kalkulacija);
    }

    public void arhiviraj(boolean value, BigDecimal iznos) {
        if (this.kalkulacija.getArtikalkalkulacijas() == null || this.kalkulacija.getArtikalkalkulacijas().size() == 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne postoji mogu\u0107nost za arhiviranje prijemnice jer nije unet ni jedan artikal.");
            return;
        }
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                this.kalkulacija.setIznos(iznos);
                this.kalkulacija.setArhiviran((short)1);
                this.kalkulacija.setProdVrednost(this.prodajna.getBigDecimal());
                this.kalkulacija.setZaokruzenje(iznos.subtract(this.nabavna.getBigDecimal()));
                this.sumirajTroskove(this.kalkulacija, em);
                this.preraspodeliTroskove(iznos, em);
                this.kalkulacija.setRazlUCeni(PzProizvodnjaUtil.getRazlikaUCeni(this.kalkulacija));
                this.kalkulacija.setNabavnaVrednost(PzProizvodnjaUtil.getNabavnaVrednost(this.kalkulacija));
                if (this.tipDokumenta.getSelectedItem().equals(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA)) {
                    this.kalkulacija.getDokument().setKepu(Short.valueOf((short)1));
                }
                if (this.kalkulacija.getTrosaks() != null || this.kalkulacija.getTrosaks().size() > 0) {
                    for (Trosak tr : this.kalkulacija.getTrosaks()) {
                        tr.setKurs(this.kalkulacija.getKurs());
                        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)tr, false, null);
                    }
                }
                Nivelacija nivelacija = null;
                if (value) {
                    nivelacija = PzEntityUtil.createNivelacija((PzDokument)this.kalkulacija, (boolean)true, (boolean)true, (EntityManager)em);
                }
                this.azurirajStanje(this.kalkulacija, em);
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.kalkulacija, true, null, em);
                if (nivelacija != null) {
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivelacija, true, null, em);
                }
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.kalkulacija);
                if (nivelacija != null) {
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)nivelacija);
                }
                this.tableKalk.removeSelectedEntity(false, false);
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void preraspodeliTroskove(BigDecimal iznos2, EntityManager em) {
        for (Artikalkalkulacija ak : this.kalkulacija.getArtikalkalkulacijas()) {
            ak.setNabCena(ak.calculateNabCena().doubleValue());
            ak.setZavTroskovi(ak.calculateZavTrosak().doubleValue());
        }
    }

    private void azurirajStanje(Kalkulacija kalkulacija, EntityManager em) {
        Stanje s = null;
        for (Artikalkalkulacija ak : kalkulacija.getArtikalkalkulacijas()) {
            StanjePK spk = new StanjePK(ak.getId().getSfrProizvod(), kalkulacija.getRadnajedinica().getId().getOznOgranak(), kalkulacija.getRadnajedinica().getId().getOznRj());
            s = (Stanje)em.find(Stanje.class, (Object)spk);
            if (s == null) {
                s = new Stanje();
                s.setId(spk);
                s.setArtikal(ak.getArtikal());
                s.setRadnajedinica(kalkulacija.getRadnajedinica());
                s.setKolicina(ak.getKolicina());
                s.setProsNabCena(BDConverter.getPrnc((double)ak.getNabCena()));
                s.setZadNabCena(ak.getNabCena());
            } else if (s.getKolicina() <= 0.0) {
                s.setKolicina(s.getKolicina() + ak.getKolicina());
                s.setZadNabCena(ak.getNabCena());
                s.setProsNabCena(BDConverter.getPrnc((double)ak.getNabCena()));
            } else {
                s.setZadNabCena(ak.getNabCena());
                s.setProsNabCena(BDConverter.getPrnc((double)((s.getKolicina() * s.getProsNabCena().doubleValue() + ak.getKolicina() * s.getZadNabCena()) / (s.getKolicina() + ak.getKolicina()))));
                s.setKolicina(s.getKolicina() + ak.getKolicina());
            }
            s.setProdCena(ak.getProdCena().doubleValue());
            s.setDatZadUlaza(kalkulacija.getDatFakture());
            s.setKumUlaza(s.getKumUlaza() + ak.getKolicina());
            ak.setProsNabCena(s.getProsNabCena());
            em.merge((Object)s);
        }
    }

    private void azurirajStanjeKonsignacije(Kalkulacija kalkulacija, EntityManager em) {
        Stanje s = null;
        for (Artikalkalkulacija ak : kalkulacija.getArtikalkalkulacijas()) {
            StanjePK spk = new StanjePK(ak.getId().getSfrProizvod(), this.rjPrenosnica.getId().getOznOgranak(), this.rjPrenosnica.getId().getOznRj());
            s = (Stanje)em.find(Stanje.class, (Object)spk);
            if (s == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Artikal nije pronadjen u tabeli Stanje!");
                return;
            }
            s.setKolicina(s.getKolicina() - ak.getKolicina());
            s.setAlocKolicina(s.getAlocKolicina() - ak.getKolicina());
            em.merge((Object)s);
        }
    }

    private void sumirajTroskove(Kalkulacija kalkulacija, EntityManager em) {
        BigDecimal interni = new BigDecimal(0.0);
        BigDecimal eksterni = new BigDecimal(0.0);
        BigDecimal carina = new BigDecimal(0.0);
        for (Trosak t : kalkulacija.getTrosaks()) {
            if (t.getPodTip().equals(Trosak.TIP_INTERNI)) {
                interni = interni.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            } else if (t.getPodTip().equals(Trosak.TIP_EKSTERNI)) {
                eksterni = eksterni.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            } else if (t.getPodTip().equals(Trosak.TIP_CARINA)) {
                carina = carina.add(t.getOsnovica().add(t.getBezPrava().add(t.getOslobodjeno())));
            }
            t.setArhiviran((short)1);
            if (em == null) continue;
            em.merge((Object)t);
        }
        kalkulacija.setTroskoviCarina(carina);
        kalkulacija.setTroskoviInterni(interni);
        kalkulacija.setTroskoviEksterni(eksterni);
    }

    private BigDecimal sumirajTaksaTrosak(List<Taksakalkulacija> takse) {
        BigDecimal sum = new BigDecimal(0);
        for (Taksakalkulacija t : takse) {
            if (!t.getVrsta().equals("PDV")) continue;
            sum = sum.add(t.getIznos());
        }
        return sum;
    }

    private void nadjiPrenosnicu() {
        this.rjPrenosnica = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"T", "ET"});
        if (this.rjPrenosnica == null) {
            return;
        }
        String upit = null;
        Faktura prenosnica = null;
        upit = "SELECT f FROM Faktura f WHERE f.oznDokumenta= :oznDok AND f.radnajedinica.id= :rjId AND f.tip= :tipDok AND f.arhiviran=1 AND f.storno=0";
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery(upit).setParameter("oznDok", (Object)this.brDokumenta.getVal()).setParameter("rjId", (Object)this.rjPrenosnica.getId()).setParameter("tipDok", (Object)TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE);
        try {
            prenosnica = (Faktura)q.getSingleResult();
        }
        catch (Exception exception) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Ne postoji prenosnica sa ovom oznakom u radnoj jedinici " + this.rjPrenosnica.getPunNaziv()));
            return;
        }
        int i = 0;
        while (i < prenosnica.getArtikalfakturas().size()) {
            this.artdok = new Artikalkalkulacija();
            Stanje s = null;
            s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getArtikal().getSfrProizvod(), this.rj));
            if (s != null) {
                this.artdok.setProdCena(new BigDecimal(Double.toString(s.getProdCena())));
            } else {
                this.artdok.setProdCena(new BigDecimal(Double.toString(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getCena())));
            }
            this.artdok.init(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getArtikal(), (PzDokument)this.kalkulacija);
            this.artdok.setKolicina(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getKolicina());
            this.artdok.setFakturnaCena(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getCena());
            this.artdok.setNaziv(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getNaziv());
            this.artdok.setProcRabata(((Artikalfaktura)prenosnica.getArtikalfakturas().get(i)).getProcRabata());
            this.artdok.setNabCena(PzMathUtility.round((double)(this.artdok.getFakturnaCena() * (1.0 - this.artdok.getProcRabata() / 100.0))));
            this.table.insert((PzEntity)this.artdok, true);
            ++i;
        }
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (PzDialogIzradaPrijemnice.this.komitent.getDomaciKomitent() != 1) {
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    PzDialogIzradaPrijemnice.this.kurs = (Kurs)em.find(Kurs.class, (Object)new KursPK(PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR", (EntityManager)em), PzDialogIzradaPrijemnice.this.datDPO.getVal()));
                    em.close();
                    if (PzDialogIzradaPrijemnice.this.kurs == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogIzradaPrijemnice.this), (String)("Na datum prometa ne postoji kurs valute! Preuzmite kurs za valutu - " + PzDialogIzradaPrijemnice.this.stranaValuta + " na datum prometa kroz opciju: \u0160ifarnici->Kursna lista"));
                        return false;
                    }
                    PzDialogIzradaPrijemnice.this.kursEvra.setVal((Object)PzDialogIzradaPrijemnice.this.kurs.getSrednji());
                }
                return true;
            }
        };
    }
}

