/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.gradjevinarstvo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.proizvodnja.gui.gradjevinarstvo.ArhivaFaktura;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class UnosFaktura
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzDoubleField dfIznosValuta;
    private JLabel lblValuta;
    private PzTextField tfNazivKupca;
    private PzFieldIndikator indSifra;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzTextAreaPanel tfOpis;
    private PzDateField dfDatumFakture;
    private JLabel lblDatumFakture;
    private PzTextField tfTarifnaNaziv;
    private PzFieldIndikator indTarifna;
    private PzTextField tfTarifna;
    private JLabel lblTarifnaGrupa;
    private PzDoubleField dfIznos;
    private JLabel lblIznos;
    private PzPanel pnlKupac;
    private PzDoubleField dfIznosSaPdv;
    private JLabel lblIznosSaPdv;
    private PzDoubleField dfPdv;
    private JLabel lblPDv;
    private PzDoubleField dfIznosBezPDV;
    private PzDoubleField dfTroskovi;
    private JLabel lblIznosBezPdv;
    private JLabel lblTroskovi;
    private PzDoubleField dfMaterijal;
    private JLabel lblMaterijal;
    private PzDoubleField dfRad;
    private JLabel lblRad;
    private PzPanel pnlElementiFakture;
    private PzPanel pnlElementi;
    private PzToolBarIcon icnArhiva;
    private Komitent komitent;
    private Tarifnagrupa tarifnagrupa;
    private final BigDecimal materijalTrebovanja;
    private final BigDecimal direktanRad;
    private final BigDecimal fakturisanMaterijal;
    private final BigDecimal fakturisaniIndTroskovi;
    private final BigDecimal ukupnoFakturisano;
    private final BigDecimal indirektniTroskovi;
    private final BigDecimal direktniTroskovi;
    private final String valuta;
    protected Kurs kurs;
    protected double iznosKursa;

    public UnosFaktura(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.materijalTrebovanja = (BigDecimal)this.getSession().getParameter("materijalTrebovanja");
        this.direktanRad = (BigDecimal)this.getSession().getParameter("direktanRad");
        this.fakturisanMaterijal = (BigDecimal)this.getSession().getParameter("fakturisanMaterijal");
        this.fakturisaniIndTroskovi = (BigDecimal)this.getSession().getParameter("fakturisaniIndTroskovi");
        this.ukupnoFakturisano = (BigDecimal)this.getSession().getParameter("ukupnoFakturisano");
        this.indirektniTroskovi = (BigDecimal)this.getSession().getParameter("indTroskovi");
        this.direktniTroskovi = (BigDecimal)this.getSession().getParameter("direktniTroskovi");
        this.paintPanel();
        this.valuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
        this.lblValuta.setText("Iznos u valuti " + this.valuta);
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Fakturisanje privremene situacije");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{86, 43, 85, 114, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{173, 196, 154, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setOpaque(false);
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/presentation_chart.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("CTRL+W");
            this.pnlElementi = new PzPanel();
            GridBagLayout pnlElementiLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlElementi, (Object)new GridBagConstraints(0, 2, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlElementiLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlElementiLayout.rowHeights = new int[]{20, 20, 24, 25, 25, 74};
            pnlElementiLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlElementiLayout.columnWidths = new int[]{119, 46, 110, 7};
            this.pnlElementi.setLayout((LayoutManager)pnlElementiLayout);
            this.pnlElementi.setBorder((Border)BorderFactory.createTitledBorder("Elementi za fakturisanje"));
            this.pnlElementi.setOpaque(false);
            this.lblIznos = new JLabel();
            this.pnlElementi.add((Component)this.lblIznos, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblIznos.setText("Iznos");
            this.dfIznos = new PzDoubleField();
            this.pnlElementi.add((Component)this.dfIznos, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfIznos.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (UnosFaktura.this.dfIznos.getVal() <= 0.0) {
                        return false;
                    }
                    UnosFaktura.this.dfIznosBezPDV.setVal((Object)UnosFaktura.this.dfIznos.getVal());
                    UnosFaktura.this.dfMaterijal.setVal((Object)UnosFaktura.this.materijalTrebovanja.subtract(UnosFaktura.this.fakturisanMaterijal));
                    UnosFaktura.this.dfTroskovi.setVal((Object)UnosFaktura.this.indirektniTroskovi.subtract(UnosFaktura.this.fakturisaniIndTroskovi));
                    UnosFaktura.this.dfRad.setVal((Object)UnosFaktura.this.dfIznos.getBigDecimal().subtract(UnosFaktura.this.direktniTroskovi.add(UnosFaktura.this.indirektniTroskovi).subtract(UnosFaktura.this.ukupnoFakturisano)));
                    return true;
                }
            });
            this.lblTarifnaGrupa = new JLabel();
            this.pnlElementi.add((Component)this.lblTarifnaGrupa, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblTarifnaGrupa.setText("Tarifna grupa");
            this.tfTarifna = new PzTextField();
            this.pnlElementi.add((Component)this.tfTarifna, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfTarifna.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, null);
            this.tfTarifna.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    BigDecimal stopa = BDConverter.getStopaPDV((double)(UnosFaktura.this.tarifnagrupa.getStopa() / 100.0));
                    BigDecimal iznosPDV = BDConverter.getIznos((BigDecimal)UnosFaktura.this.dfIznos.getBigDecimal().multiply(stopa));
                    UnosFaktura.this.dfPdv.setVal((Object)iznosPDV);
                    UnosFaktura.this.dfIznosSaPdv.setVal((Object)UnosFaktura.this.dfIznosBezPDV.getBigDecimal().add(iznosPDV));
                    return true;
                }
            });
            this.indTarifna = new PzFieldIndikator();
            this.pnlElementi.add((Component)this.indTarifna, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.tfTarifna.setStateIndikator(this.indTarifna);
            this.tfTarifnaNaziv = new PzTextField();
            this.pnlElementi.add((Component)this.tfTarifnaNaziv, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 2, 0), 0, 0));
            this.tfTarifnaNaziv.setFocusable(false);
            this.lblDatumFakture = new JLabel();
            this.pnlElementi.add((Component)this.lblDatumFakture, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblDatumFakture.setText("Datum fakture");
            this.dfDatumFakture = new PzDateField();
            this.pnlElementi.add((Component)this.dfDatumFakture, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfDatumFakture.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (UnosFaktura.this.komitent.getDomaciKomitent() == 0) {
                        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                        UnosFaktura.this.kurs = (Kurs)em.find(Kurs.class, (Object)new KursPK(UnosFaktura.this.valuta, UnosFaktura.this.dfDatumFakture.getVal()));
                        em.close();
                        if (UnosFaktura.this.kurs == null) {
                            PzSwingUtility.showInformationMessage((Component)((Object)UnosFaktura.this), (String)("Na datum fakture ne postoji kurs valute! Preuzmite kurs za valutu - " + UnosFaktura.this.valuta + " na datum fakture kroz opciju: \u0160ifarnici->Kursna lista"));
                            return false;
                        }
                        UnosFaktura.this.iznosKursa = UnosFaktura.this.kurs.getSrednji().doubleValue() / (double)UnosFaktura.this.kurs.getJedinica();
                    }
                    return true;
                }
            });
            this.tfOpis = new PzTextAreaPanel();
            this.pnlElementi.add((Component)this.tfOpis, (Object)new GridBagConstraints(0, 4, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 5), 0, 0));
            this.tfOpis.setBorder((Border)BorderFactory.createTitledBorder("Opis"));
            this.tfOpis.setOpaque(false);
            this.tfOpis.setVal((Object)((RadniNalog)this.getSession().getParameter("radninalog")).getOpis());
            this.lblValuta = new JLabel();
            this.pnlElementi.add((Component)this.lblValuta, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblValuta.setName("lblValuta");
            this.lblValuta.setEnabled(false);
            this.dfIznosValuta = new PzDoubleField();
            this.pnlElementi.add((Component)this.dfIznosValuta, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfIznosValuta.setEnabled(false);
            this.dfIznosValuta.setEditable(false);
            this.dfIznosValuta.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (UnosFaktura.this.dfIznosValuta.getVal() != 0.0) {
                        UnosFaktura.this.dfIznos.setVal((Object)(UnosFaktura.this.dfIznosValuta.getVal() * UnosFaktura.this.iznosKursa));
                    }
                    return true;
                }
            });
            this.pnlElementiFakture = new PzPanel();
            GridBagLayout pnlElementiFaktureLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlElementiFakture, (Object)new GridBagConstraints(2, 2, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.pnlElementiFakture.setBorder((Border)BorderFactory.createTitledBorder("Elementi fakture"));
            pnlElementiFaktureLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlElementiFaktureLayout.rowHeights = new int[]{15, 25, 25, 25, 10, 25, 25, 25, 20};
            pnlElementiFaktureLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlElementiFaktureLayout.columnWidths = new int[]{107, 150, 7};
            this.pnlElementiFakture.setLayout((LayoutManager)pnlElementiFaktureLayout);
            this.pnlElementiFakture.setOpaque(false);
            this.lblRad = new JLabel();
            this.pnlElementiFakture.add((Component)this.lblRad, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblRad.setText("Rad");
            this.dfRad = new PzDoubleField();
            this.pnlElementiFakture.add((Component)this.dfRad, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfRad.setFocusable(false);
            this.lblMaterijal = new JLabel();
            this.pnlElementiFakture.add((Component)this.lblMaterijal, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblMaterijal.setText("Materijal");
            this.dfMaterijal = new PzDoubleField();
            this.pnlElementiFakture.add((Component)this.dfMaterijal, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfMaterijal.setFocusable(false);
            this.lblTroskovi = new JLabel();
            this.pnlElementiFakture.add((Component)this.lblTroskovi, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblTroskovi.setText("Ind. tro\u0161kovi");
            this.lblIznosBezPdv = new JLabel();
            this.pnlElementiFakture.add((Component)this.lblIznosBezPdv, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblIznosBezPdv.setText("Iznos bez PDV-a");
            this.dfIznosBezPDV = new PzDoubleField();
            this.pnlElementiFakture.add((Component)this.dfIznosBezPDV, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfIznosBezPDV.setFocusable(false);
            this.dfTroskovi = new PzDoubleField();
            this.pnlElementiFakture.add((Component)this.dfTroskovi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfTroskovi.setFocusable(false);
            this.lblPDv = new JLabel();
            this.pnlElementiFakture.add((Component)this.lblPDv, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblPDv.setText("PDV");
            this.dfPdv = new PzDoubleField();
            this.pnlElementiFakture.add((Component)this.dfPdv, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfPdv.setFocusable(false);
            this.lblIznosSaPdv = new JLabel();
            this.pnlElementiFakture.add((Component)this.lblIznosSaPdv, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblIznosSaPdv.setText("Iznos sa PDV-om");
            this.dfIznosSaPdv = new PzDoubleField();
            this.pnlElementiFakture.add((Component)this.dfIznosSaPdv, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfIznosSaPdv.setFocusable(false);
            this.pnlKupac = new PzPanel();
            GridBagLayout pnlKupacLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlKupac, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlKupacLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlKupacLayout.rowHeights = new int[]{7, 25, 7};
            pnlKupacLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlKupacLayout.columnWidths = new int[]{78, 147, 7, 7};
            this.pnlKupac.setLayout((LayoutManager)pnlKupacLayout);
            this.pnlKupac.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlKupac.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra kupca");
            this.tfSifra = new PzTextField();
            this.pnlKupac.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (((RadniNalog)this.getSession().getParameter("radninalog")).getKomitent() != null) {
                this.tfSifra.setVal((Object)((RadniNalog)this.getSession().getParameter("radninalog")).getKomitent().getSfrKomitent());
            }
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfSifra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (UnosFaktura.this.komitent.getDomaciKomitent() == 0) {
                        UnosFaktura.this.lblValuta.setEnabled(true);
                        UnosFaktura.this.dfIznosValuta.setEditable(true);
                        UnosFaktura.this.dfIznosValuta.setEnabled(true);
                        UnosFaktura.this.dfIznosValuta.setFocusable(true);
                    }
                    return true;
                }
            });
            this.indSifra = new PzFieldIndikator();
            this.pnlKupac.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivKupca = new PzTextField();
            this.pnlKupac.add((Component)this.tfNazivKupca, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 10), 0, 0));
            this.tfNazivKupca.setFocusable(false);
            if (((RadniNalog)this.getSession().getParameter("radninalog")).getKomitent() != null) {
                this.tfNazivKupca.setVal((Object)((RadniNalog)this.getSession().getParameter("radninalog")).getKomitent().getNaziv());
            }
            this.tfSifra.setStateIndikator(this.indSifra);
            this.setSize(696, 473);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzToolBarIcon icon = (PzToolBarIcon)e.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equalsIgnoreCase("arhiva")) {
            if (!this.pnlElementi.validateForm(true)) {
                return;
            }
            if (this.dfIznos.getVal() <= 0.0) {
                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Iznos mora biti veci od 0.");
                return;
            }
            if (this.tfTarifna.isEmpty()) {
                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Morate uneti tarifnu grupu.");
                return;
            }
            HashMap<String, BigDecimal> elementiFakture = new HashMap<String, BigDecimal>();
            elementiFakture.put("rad", this.dfRad.getBigDecimal());
            elementiFakture.put("materijal", this.dfMaterijal.getBigDecimal());
            elementiFakture.put("indTroskovi", this.dfTroskovi.getBigDecimal());
            elementiFakture.put("iznosBezPDV", this.dfIznosBezPDV.getBigDecimal());
            elementiFakture.put("iznosPDV", this.dfPdv.getBigDecimal());
            elementiFakture.put("iznosSaPDV", this.dfIznosSaPdv.getBigDecimal());
            this.getSession().putParameter("radninalog", this.getSession().getParameter("radninalog"));
            this.getSession().putParameter("elementiFakture", elementiFakture);
            this.getSession().putParameter("datumFakture", (Object)this.dfDatumFakture.getVal());
            this.getSession().putParameter("opis", (Object)this.tfOpis.getVal());
            this.getSession().putParameter("komitent", (Object)this.komitent);
            this.getSession().putParameter("tabelaFak", this.getSession().getParameter("tabelaFaktura"));
            this.getSession().putParameter("tarifnaGrupa", (Object)this.tarifnagrupa);
            this.getSession().putParameter("kurs", (Object)this.iznosKursa);
            this.showDialog(ArhivaFaktura.class);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfSifra.setVal((Object)this.komitent.getSfrKomitent());
            this.tfNazivKupca.setVal((Object)this.komitent.getNaziv());
        } else if (entity instanceof Tarifnagrupa) {
            this.tarifnagrupa = (Tarifnagrupa)entity;
            this.tfTarifna.setVal((Object)this.tarifnagrupa.getOznTarGr());
            this.tfTarifnaNaziv.setVal((Object)this.tarifnagrupa.getStopa());
        }
    }
}

