/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.dostavnica;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.proizvodnja.gui.sastavnice.SastavSklopa;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;

public class Arhiviranje
extends PzDialog {
    private PzPanel mainPanel;
    private PzTextAreaPanel txtAreaKomentar;
    private PzButton btnPotvrdi;
    private PzDateField dfDatumIzrade;
    private JLabel lblDatum;
    private final Interniracun dostavnica;

    public Arhiviranje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.dostavnica = (Interniracun)this.getSession().getParameter("dostavnica");
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("ARHIVIRANJE DOSTAVNICE");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(85, 116));
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{12, 25, 5, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.columnWidths = new int[]{13, 100, 115, 100, 13};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblDatum = new JLabel();
            this.mainPanel.add((Component)this.lblDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 0, 0), 0, 0));
            this.lblDatum.setText("Datum izrade");
            this.dfDatumIzrade = new PzDateField();
            this.mainPanel.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtAreaKomentar = new PzTextAreaPanel();
            this.mainPanel.add((Component)this.txtAreaKomentar, (Object)new GridBagConstraints(1, 3, 3, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtAreaKomentar.setBorder((Border)BorderFactory.createTitledBorder("Komentar"));
            this.txtAreaKomentar.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 80, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(120, 33));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.pack();
            this.setSize(380, 288);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    em.getTransaction().begin();
                    this.dostavnica.setDatArh(this.dfDatumIzrade.getVal());
                    this.dostavnica.setDatum(this.dfDatumIzrade.getVal());
                    this.dostavnica.setPoruka(this.txtAreaKomentar.getVal());
                    this.azurirajStanje(this.dostavnica, em);
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.dostavnica, true, null, em);
                    em.getTransaction().commit();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.dostavnica);
                    ((SastavSklopa)((Object)this.getParent())).dispose();
                    this.dispose();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void azurirajStanje(Interniracun dostavnica, EntityManager em) {
        for (Artikalinterniracun art : dostavnica.getArtikalinterniracuns()) {
            Stanje stanjeI = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getSifra(), dostavnica.getIzlaznaRJ()));
            Stanje stanjeU = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getSifra(), dostavnica.getUlaznaRJ()));
            art.setIzlProsNabCena(stanjeI.getProsNabCena());
            art.setUlProsNabCena(stanjeU == null ? new BigDecimal(0.0) : stanjeU.getProsNabCena());
            if (dostavnica.getIzlaznaRJ().getNacinVodjenja().equals("PRODAJNA")) {
                art.setIzlProdCena(BDConverter.getProdCena((double)stanjeI.getProdCena()));
            } else {
                art.setIzlProdCena(BDConverter.getPlanskaCena((double)stanjeI.getArtikal().getCenaPlanska()));
            }
            if (dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRODAJNA")) {
                if (stanjeU == null) {
                    art.setUlProdCena(BDConverter.getProdCena((double)0.0));
                } else {
                    art.setUlProdCena(BDConverter.getProdCena((double)stanjeU.getProdCena()));
                }
            } else if (stanjeU == null) {
                art.setUlProdCena(BDConverter.getPlanskaCena((double)0.0));
            } else {
                art.setUlProdCena(BDConverter.getPlanskaCena((double)stanjeU.getArtikal().getCenaPlanska()));
            }
            if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                stanjeI.setAlocKolicina(stanjeI.getAlocKolicina() - art.getKolicina());
            }
            stanjeI.setKolicina(stanjeI.getKolicina() - art.getKolicina());
            stanjeI.setProdCena(new Double(stanjeI.getProdCena()) == null ? art.getIzlCena() : stanjeI.getProdCena());
            stanjeI.setDatZadIzlaza(dostavnica.getDatum());
            stanjeI.setKumIzlaza(stanjeI.getKumUlaza() + art.getKolicina());
            if (stanjeU == null) {
                stanjeU = new Stanje();
                stanjeU.setId(new StanjePK(art.getSifra(), dostavnica.getUlaznaRJ()));
                stanjeU.setAlocKolicina(0.0);
                stanjeU.setKolicina(art.getKolicina());
                stanjeU.setProdCena(art.getUlCena());
                stanjeU.setDatZadUlaza(dostavnica.getDatum());
                stanjeU.setKumUlaza(art.getKolicina());
                if (dostavnica.getIzlaznaRJ().getgTip().equals("V") && dostavnica.getUlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC") || dostavnica.getIzlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC") || dostavnica.getIzlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getgTip().equals("V") && dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                    stanjeU.setProsNabCena(new BigDecimal(art.getIzlCena()));
                }
                em.persist((Object)stanjeU);
                continue;
            }
            if (dostavnica.getIzlaznaRJ().getgTip().equals("V") && dostavnica.getUlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC") || dostavnica.getIzlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC") || dostavnica.getIzlaznaRJ().getgTip().equals("S") && dostavnica.getUlaznaRJ().getgTip().equals("V") && dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                if (stanjeU.getKolicina() <= 0.0) {
                    stanjeU.setProsNabCena(BDConverter.getPrnc((double)art.getIzlCena()));
                } else {
                    stanjeU.setProsNabCena(BDConverter.getPrnc((double)((stanjeU.getKolicina() * stanjeU.getProsNabCena().doubleValue() + art.getKolicina() * art.getIzlCena()) / (stanjeU.getKolicina() + art.getKolicina()))));
                }
            }
            stanjeU.setKolicina(stanjeU.getKolicina() + art.getKolicina());
            stanjeU.setProdCena(new Double(stanjeU.getProdCena()) == null ? art.getUlCena() : stanjeU.getProdCena());
            stanjeU.setDatZadUlaza(dostavnica.getDatum());
            stanjeU.setKumUlaza(stanjeU.getKumUlaza() + art.getKolicina());
        }
    }
}

